/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglet;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.AgletStub;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageManager;
import com.ibm.aglet.RequestRefusedException;
import com.ibm.aglet.Ticket;
import com.ibm.aglet.event.AgletEvent;
import com.ibm.aglet.event.AgletEventListener;
import com.ibm.aglet.event.CloneEvent;
import com.ibm.aglet.event.CloneListener;
import com.ibm.aglet.event.MobilityEvent;
import com.ibm.aglet.event.MobilityListener;
import com.ibm.aglet.event.PersistencyEvent;
import com.ibm.aglet.event.PersistencyListener;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.PermissionCollection;

public abstract class Aglet
implements Serializable {
    public static final short MAJOR_VERSION = 1;
    public static final short MINOR_VERSION = 2;
    public static final int ACTIVE = 1;
    public static final int INACTIVE = 2;
    transient AgletStub _stub = null;
    private CloneListener cloneListener = null;
    private MobilityListener mobilityListener = null;
    private PersistencyListener persistencyListener = null;

    protected Aglet() {
    }

    public final synchronized void addCloneListener(CloneListener cloneListener) {
        if (this.cloneListener == null) {
            this.cloneListener = cloneListener;
        } else {
            if (this.cloneListener == cloneListener) {
                return;
            }
            if (this.cloneListener instanceof AgletEventListener) {
                ((AgletEventListener)this.cloneListener).addCloneListener(cloneListener);
            } else if (this.cloneListener instanceof CloneListener) {
                this.cloneListener = new AgletEventListener(this.cloneListener, cloneListener);
            }
        }
    }

    public final synchronized void addMobilityListener(MobilityListener mobilityListener) {
        if (this.mobilityListener == null) {
            this.mobilityListener = mobilityListener;
        } else {
            if (this.mobilityListener == mobilityListener) {
                return;
            }
            if (this.mobilityListener instanceof AgletEventListener) {
                ((AgletEventListener)this.mobilityListener).addMobilityListener(mobilityListener);
            } else if (this.mobilityListener instanceof MobilityListener) {
                this.mobilityListener = new AgletEventListener(this.mobilityListener, mobilityListener);
            }
        }
    }

    public final synchronized void addPersistencyListener(PersistencyListener persistencyListener) {
        if (this.persistencyListener == null) {
            this.persistencyListener = persistencyListener;
        } else {
            if (this.persistencyListener == persistencyListener) {
                return;
            }
            if (this.persistencyListener instanceof AgletEventListener) {
                ((AgletEventListener)this.persistencyListener).addPersistencyListener(persistencyListener);
            } else if (this.persistencyListener instanceof PersistencyListener) {
                this.persistencyListener = new AgletEventListener(this.persistencyListener, persistencyListener);
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        return this._stub.clone();
    }

    public final void deactivate(long l) throws IOException {
        this._stub.deactivate(l);
    }

    public final void dispatch(Ticket ticket) throws IOException, RequestRefusedException {
        this._stub.dispatch(ticket);
    }

    public final void dispatch(URL uRL) throws IOException, RequestRefusedException {
        this._stub.dispatch(uRL);
    }

    public final void dispatchEvent(AgletEvent agletEvent) {
        switch (agletEvent.getID()) {
            case 1100: 
            case 1101: 
            case 1102: {
                this.processCloneEvent((CloneEvent)agletEvent);
                break;
            }
            case 1200: 
            case 1201: 
            case 1202: {
                this.processMobilityEvent((MobilityEvent)agletEvent);
                break;
            }
            case 1300: 
            case 1301: {
                this.processPersistencyEvent((PersistencyEvent)agletEvent);
            }
        }
    }

    public final void dispose() {
        this._stub.dispose();
    }

    public void exitMonitor() {
        this.getMessageManager().exitMonitor();
    }

    public final AgletContext getAgletContext() {
        return this._stub.getAgletContext();
    }

    public final AgletID getAgletID() {
        return this.getAgletInfo().getAgletID();
    }

    public final AgletInfo getAgletInfo() {
        return this._stub.getAgletInfo();
    }

    public final AudioClip getAudioData(URL uRL) throws IOException {
        return this.getAgletContext().getAudioClip(uRL);
    }

    public final URL getCodeBase() {
        return this.getAgletInfo().getCodeBase();
    }

    public final Image getImage(URL uRL) throws IOException {
        return this.getAgletContext().getImage(uRL);
    }

    public final Image getImage(URL uRL, String string) throws IOException {
        return this.getAgletContext().getImage(new URL(uRL, string));
    }

    public final MessageManager getMessageManager() {
        return this._stub.getMessageManager();
    }

    public PermissionCollection getProtections() {
        return this._stub.getProtections();
    }

    public final AgletProxy getProxy() {
        return this._stub.getAgletContext().getAgletProxy(this.getAgletID());
    }

    public final String getText() {
        return this._stub.getText();
    }

    public boolean handleMessage(Message message) {
        return false;
    }

    public void notifyAllMessages() {
        this.getMessageManager().notifyAllMessages();
    }

    public void notifyMessage() {
        this.getMessageManager().notifyMessage();
    }

    public void onCreation(Object object) {
    }

    public void onDisposing() {
    }

    protected void processCloneEvent(CloneEvent cloneEvent) {
        if (this.cloneListener != null) {
            switch (cloneEvent.getID()) {
                case 1100: {
                    this.cloneListener.onCloning(cloneEvent);
                    break;
                }
                case 1101: {
                    this.cloneListener.onClone(cloneEvent);
                    break;
                }
                case 1102: {
                    this.cloneListener.onCloned(cloneEvent);
                }
            }
        }
    }

    protected void processMobilityEvent(MobilityEvent mobilityEvent) {
        if (this.mobilityListener != null) {
            switch (mobilityEvent.getID()) {
                case 1200: {
                    this.mobilityListener.onDispatching(mobilityEvent);
                    break;
                }
                case 1201: {
                    this.mobilityListener.onReverting(mobilityEvent);
                    break;
                }
                case 1202: {
                    this.mobilityListener.onArrival(mobilityEvent);
                }
            }
        }
    }

    protected void processPersistencyEvent(PersistencyEvent persistencyEvent) {
        if (this.persistencyListener != null) {
            switch (persistencyEvent.getID()) {
                case 1300: {
                    this.persistencyListener.onDeactivating(persistencyEvent);
                    break;
                }
                case 1301: {
                    this.persistencyListener.onActivation(persistencyEvent);
                }
            }
        }
    }

    public final synchronized void removeCloneListener(CloneListener cloneListener) {
        if (this.cloneListener == cloneListener) {
            this.cloneListener = null;
        } else if (this.cloneListener instanceof AgletEventListener) {
            ((AgletEventListener)this.cloneListener).removeCloneListener(cloneListener);
            if (((AgletEventListener)this.cloneListener).size() == 0) {
                this.cloneListener = null;
            }
        }
    }

    public final synchronized void removeMobilityListener(MobilityListener mobilityListener) {
        if (this.mobilityListener == mobilityListener) {
            this.mobilityListener = null;
        } else if (this.mobilityListener instanceof AgletEventListener) {
            ((AgletEventListener)this.mobilityListener).removeMobilityListener(mobilityListener);
            if (((AgletEventListener)this.mobilityListener).size() == 0) {
                this.mobilityListener = null;
            }
        }
    }

    public final synchronized void removePersistencyListener(PersistencyListener persistencyListener) {
        if (this.persistencyListener == persistencyListener) {
            this.persistencyListener = null;
        } else if (this.persistencyListener instanceof AgletEventListener) {
            ((AgletEventListener)this.persistencyListener).removePersistencyListener(persistencyListener);
            if (((AgletEventListener)this.persistencyListener).size() == 0) {
                this.persistencyListener = null;
            }
        }
    }

    public void run() {
    }

    public void setProtections(PermissionCollection permissionCollection) {
        this._stub.setProtections(permissionCollection);
    }

    public final synchronized void setStub(AgletStub agletStub) {
        if (this._stub != null) {
            throw new SecurityException();
        }
        agletStub.setAglet(this);
        this._stub = agletStub;
    }

    public final void setText(String string) {
        this._stub.setText(string);
    }

    public final void snapshot() throws IOException {
        this._stub.snapshot();
    }

    public final void subscribeMessage(String string) {
        this._stub.subscribeMessage(string);
    }

    public final void suspend(long l) throws AgletException, IllegalArgumentException {
        this._stub.suspend(l);
    }

    public final void unsubscribeAllMessages() {
        this._stub.unsubscribeAllMessages();
    }

    public final boolean unsubscribeMessage(String string) {
        return this._stub.unsubscribeMessage(string);
    }

    public void waitMessage() {
        this.getMessageManager().waitMessage();
    }

    public void waitMessage(long l) {
        this.getMessageManager().waitMessage(l);
    }
}

