/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglet;

import com.ibm.aglet.AgletID;
import com.ibm.aglets.AgletRuntime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public final class AgletInfo
implements Serializable,
Cloneable {
    static final long serialVersionUID = 5077220171230015552L;
    private AgletID aid;
    private String classname;
    private String origin;
    private long birthtime;
    private short api_major_version;
    private short api_minor_version;
    private String codebase = null;
    private transient Certificate authorityCert = null;
    private byte[] authorityCertEncoded = null;

    public AgletInfo(AgletID agletID, String string, URL uRL, String string2, long l, short s, short s2, Certificate certificate) {
        this.aid = agletID;
        this.classname = string;
        this.codebase = uRL.toExternalForm();
        this.origin = string2;
        this.birthtime = l;
        this.api_major_version = s;
        this.api_minor_version = s2;
        this.authorityCert = certificate;
        try {
            this.authorityCertEncoded = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            certificateEncodingException.printStackTrace();
            this.authorityCertEncoded = null;
        }
    }

    public String getAddress() {
        return "atp://unknown/";
    }

    public String getAgletClassName() {
        return this.classname;
    }

    public AgletID getAgletID() {
        return this.aid;
    }

    public short getAPIMajorVersion() {
        return this.api_major_version;
    }

    public short getAPIMinorVersion() {
        return this.api_minor_version;
    }

    public Certificate getAuthorityCertificate() {
        return this.authorityCert;
    }

    public String getAuthorityName() {
        if (this.authorityCert == null) {
            return "(Unknown)";
        }
        String string = AgletRuntime.getCertificateAlias(this.authorityCert);
        if (string == null) {
            return "(Unknown)";
        }
        return string;
    }

    public URL getCodeBase() {
        try {
            return new URL(this.codebase);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public long getCreationTime() {
        return this.birthtime;
    }

    public String getOrigin() {
        return this.origin;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.authorityCert = AgletRuntime.getCertificate(this.authorityCertEncoded);
        if (this.api_major_version != 1) {
            throw new StreamCorruptedException("API version mismatch : " + this.api_major_version + " shold be " + 1);
        }
        if (this.api_minor_version != 2) {
            System.out.println("API minor version mismatch.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID       : " + this.aid + '\n');
        stringBuffer.append("ClassName: " + this.classname + '\n');
        stringBuffer.append("Origin   : " + this.origin + '\n');
        stringBuffer.append("CodeBase : " + this.codebase + '\n');
        return stringBuffer.toString();
    }
}

