/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglet;

import com.ibm.aglet.FutureReply;
import java.util.Vector;

public final class ReplySet {
    private Vector done = new Vector();
    private Vector unavailable = new Vector();

    public synchronized void addFutureReply(FutureReply futureReply) {
        this.unavailable.addElement(futureReply);
        futureReply.addedTo(this);
    }

    public boolean areAllAvailable() {
        return this.unavailable.size() == 0;
    }

    public int countAvailable() {
        return this.done.size();
    }

    public int countUnavailable() {
        return this.unavailable.size();
    }

    public synchronized void done(FutureReply futureReply) {
        if (!this.unavailable.contains(futureReply) || this.done.contains(futureReply) || !futureReply.isAvailable()) {
            throw new RuntimeException("ReplySet: invalid reply");
        }
        this.unavailable.removeElement(futureReply);
        this.done.addElement(futureReply);
        this.notifyAll();
    }

    public synchronized FutureReply getNextFutureReply() {
        this.waitForNextFutureReply();
        FutureReply futureReply = (FutureReply)this.done.firstElement();
        this.done.removeElementAt(0);
        return futureReply;
    }

    public synchronized boolean hasMoreFutureReplies() {
        return this.unavailable.size() != 0 || this.done.size() != 0;
    }

    public boolean isAnyAvailable() {
        return this.done.size() != 0;
    }

    public synchronized void waitForAllReplies() {
        while (this.unavailable.size() != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void waitForAllReplies(long l) {
        if (l == 0L) {
            this.waitForAllReplies();
        } else {
            long l2;
            long l3 = System.currentTimeMillis() + l;
            while (this.unavailable.size() != 0 && (l2 = l3 - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void waitForNextFutureReply() {
        while (this.done.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void waitForNextFutureReply(long l) {
        if (l == 0L) {
            this.waitForNextFutureReply();
        } else {
            long l2;
            long l3 = System.currentTimeMillis() + l;
            while (this.done.size() == 0 && (l2 = l3 - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

