/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglet;

import com.ibm.aglet.QoC;
import com.ibm.awb.misc.PortPattern;
import com.ibm.awb.misc.URIPattern;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class Ticket
implements Serializable {
    public static final String ATP = "atp";
    public static final String HTTP = "http";
    public static final String RMI = "rmi";
    public static final String IIOP = "iiop";
    public static final String DEFAULTSCHEME = "atp";
    private String _protocol = null;
    private String _host = null;
    private String _file = null;
    private int _port = -1;
    private QoC _qoc = null;
    private static final int DEFAULTATPPORTNO = 4434;
    private static final int DEFAULTHTTPPORTNO = 80;
    private static int defaultPortNo = 4434;

    public Ticket(String string) throws MalformedURLException {
        this(string, null);
    }

    public Ticket(String string, QoC qoC) throws MalformedURLException {
        this.set(string, qoC);
    }

    public Ticket(String string, QoC qoC, String string2, int n) throws MalformedURLException {
        this.set(string, qoC, string2, n);
    }

    public Ticket(URL uRL) {
        this(uRL, null);
    }

    public Ticket(URL uRL, QoC qoC) {
        this.set(uRL, qoC);
    }

    public static int getDefaultPort() {
        return defaultPortNo;
    }

    public URL getDestination() {
        URL uRL = null;
        String string = null;
        string = this._file != null && !this._file.startsWith("/") ? "/" + this._file : this._file;
        try {
            uRL = this.isDefaultPort() ? new URL(this._protocol, this._host, this._file) : new URL(this._protocol, this._host, this._port, this._file);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        return uRL;
    }

    private String getDestinationString() {
        String string = null;
        if (this._file != null && !this._file.startsWith("/")) {
            string = "/" + this._file;
        }
        if (this._protocol != null && this._protocol.equalsIgnoreCase("file")) {
            return this._protocol + ":" + string;
        }
        if (this.isDefaultPort()) {
            return this._protocol + "://" + this._host + string;
        }
        return this._protocol + "://" + this._host + ":" + this._port + string;
    }

    public String getFile() {
        return this._file;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public QoC getQoC() {
        return this._qoc;
    }

    public boolean isDefaultPort() {
        if (this._port == -1) {
            return true;
        }
        return this._port == defaultPortNo;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (uRL != null) {
            System.out.println(uRL.toString());
            System.out.println(uRL.getFile());
            Ticket ticket = new Ticket(uRL);
            if (ticket != null) {
                System.out.println(ticket.getDestination().toString());
                System.out.println(ticket.toString());
            }
        }
    }

    private void set(String string, QoC qoC) throws MalformedURLException {
        this.setDestination(string);
        this.setQoC(qoC);
    }

    private void set(String string, QoC qoC, String string2, int n) throws MalformedURLException {
        this.setDestination(string, string2, n);
        this.setQoC(qoC);
    }

    private void set(URL uRL, QoC qoC) {
        this.setDestination(uRL);
        this.setQoC(qoC);
    }

    public static void setDefaultPort(int n) {
        defaultPortNo = n;
    }

    public void setDestination(String string) throws MalformedURLException {
        URIPattern uRIPattern = new URIPattern(string);
        if (uRIPattern != null) {
            this._protocol = uRIPattern.getProtocol();
            this._host = uRIPattern.getHost();
            this._file = uRIPattern.getFile();
            PortPattern portPattern = uRIPattern.getPortPattern();
            if (portPattern.isSinglePort()) {
                this._port = portPattern.getFromPort();
            }
        }
    }

    public void setDestination(String string, String string2, int n) throws MalformedURLException {
        String string3 = "atp";
        string3 = string2.equalsIgnoreCase("atp") ? "atp" : (string2.equalsIgnoreCase(HTTP) ? HTTP : (string2.equalsIgnoreCase(RMI) ? RMI : (string2.equalsIgnoreCase(IIOP) ? IIOP : string2)));
        URL uRL = null;
        try {
            uRL = new URL(string3, string, n, "");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
            throw malformedURLException;
        }
        this.setDestination(uRL);
    }

    public void setDestination(URL uRL) {
        if (uRL != null) {
            this._protocol = uRL.getProtocol().toLowerCase();
            this._host = uRL.getHost();
            this._file = uRL.getFile();
            this._port = uRL.getPort();
        }
    }

    public void setQoC(QoC qoC) {
        this._qoc = qoC == null ? new QoC() : qoC;
    }

    public String toString() {
        URL uRL = this.getDestination();
        String string = null;
        string = uRL != null ? uRL.toString() : this.getDestinationString();
        String string2 = this._qoc.toString();
        String string3 = string + ", " + string2;
        return string3;
    }
}

