/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglet.system;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;

public abstract class AgletRuntime {
    static final String runtimePackagePrefix = "aglet.runtime.packagePrefix";
    private boolean _secure = true;
    private static AgletRuntime runtime = null;

    public abstract Certificate authenticateOwner(String var1, String var2);

    protected abstract AgletProxy createAglet(String var1, URL var2, String var3, Object var4) throws IOException;

    public abstract AgletContext createAgletContext(String var1);

    public abstract AgletContext getAgletContext(String var1);

    public abstract AgletContext[] getAgletContexts();

    protected abstract AgletProxy[] getAgletProxies(String var1) throws IOException;

    protected abstract AgletProxy getAgletProxy(String var1, AgletID var2) throws IOException;

    public static synchronized AgletRuntime getAgletRuntime() {
        if (runtime == null) {
            AgletRuntime.init(null);
        }
        return runtime;
    }

    public abstract String getAgletsProperty(String var1);

    public abstract String getAgletsProperty(String var1, String var2);

    public abstract Certificate getOwnerCertificate();

    public abstract String getOwnerName();

    public abstract String getProperty(String var1, String var2);

    public abstract String getProperty(String var1, String var2, String var3);

    public abstract String getServerAddress();

    public static synchronized AgletRuntime init(String[] stringArray) {
        return AgletRuntime.init(stringArray, null);
    }

    public static synchronized AgletRuntime init(String[] stringArray, ClassLoader classLoader) {
        if (runtime != null) {
            throw new IllegalAccessError("Already Initialized");
        }
        String string = "com.ibm.aglets";
        try {
            string = System.getProperty(runtimePackagePrefix, "com.ibm.aglets");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string2 = string + ".AgletRuntime";
        try {
            Class<?> clazz = null;
            clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
            Object obj = clazz.newInstance();
            if (obj instanceof AgletRuntime) {
                runtime = (AgletRuntime)obj;
            } else {
                System.out.println("[ \"" + string2 + "\" is not Runtime]");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("[ The class \"" + string2 + "\" not found]");
        }
        catch (Exception exception) {
            System.out.println("[ An instance of \"" + string2 + "\" cannot be created]");
        }
        runtime.initialize(stringArray);
        return runtime;
    }

    protected abstract void initialize(String[] var1);

    public boolean isSecure() {
        return this._secure;
    }

    public abstract void killAglet(AgletProxy var1) throws InvalidAgletException;

    public abstract void removeAgletContext(AgletContext var1);

    public abstract void setAgletsProperty(String var1, String var2);

    public abstract void setProperty(String var1, String var2, String var3);

    protected void setSecure(boolean bl) {
        this._secure = bl;
    }

    public abstract void shutdown();

    public abstract void shutdown(Message var1);
}

