/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglet.util;

import com.ibm.aglet.util.AddressChooser;
import com.ibm.awb.misc.Resource;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class AddressBook
extends Window
implements ActionListener,
ItemListener,
FocusListener {
    transient List _list = new List(10, false);
    transient AddressChooser _chooser = null;
    private Button _add = new Button("Add to AddressBook");
    private Button _delete = new Button("Delete");
    private Button _target = null;
    private GridBagLayout _layout = new GridBagLayout();
    private String _title = "AddressBook";
    private Rectangle _title_bounds;
    int pad = 0;
    int ascent = 0;
    MouseListener mlistener = new MouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!AddressBook.this.getParent().isVisible()) {
                AddressBook.this.setVisible(false);
                AddressBook.this._target = null;
            } else {
                AddressBook.this.adjust();
            }
        }
    };
    WindowListener wlistener = new WindowAdapter(){

        public void windowClosing(WindowEvent windowEvent) {
            AddressBook.this.setVisible(false);
        }
    };

    public AddressBook(Frame frame, AddressChooser addressChooser) {
        super(frame);
        this._chooser = addressChooser;
        this.setLayout(this._layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        this.addCmp(this._add, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.addCmp(this._delete, gridBagConstraints);
        this._delete.setEnabled(this._list.getSelectedItem() != null);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.addCmp(this._list, gridBagConstraints);
        this._list.addActionListener(this);
        this._list.addItemListener(this);
        this._add.setActionCommand("add");
        this._add.addActionListener(this);
        this._delete.setActionCommand("delete");
        this._delete.addActionListener(this);
        this.addWindowListener(this.wlistener);
        this.addMouseListener(this.mlistener);
        this.addFocusListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("add".equals(actionEvent.getActionCommand())) {
            if (this._chooser != null) {
                String string = this._chooser.getAddress();
                int n = this._list.getItemCount();
                int n2 = 0;
                while (n2 < n) {
                    if (string.equals(this._list.getItem(n2))) {
                        return;
                    }
                    ++n2;
                }
                this._list.add(string);
                this.updateAddressBook();
            }
        } else if ("delete".equals(actionEvent.getActionCommand())) {
            int n = this._list.getSelectedIndex();
            if (n >= 0) {
                this._list.remove(n);
            }
            this.updateAddressBook();
        }
        if (this._list == actionEvent.getSource()) {
            this.setVisible(false);
            this._chooser.addressSelected(this._list.getSelectedItem());
        }
    }

    protected void addCmp(Component component, GridBagConstraints gridBagConstraints) {
        this._layout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void addNotify() {
        super.addNotify();
        if (this._title != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.pad = fontMetrics.getHeight();
            this.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
            this._title_bounds = new Rectangle(this.pad * 2, 0, fontMetrics.stringWidth(this._title), fontMetrics.getHeight());
        }
        this.reLayout();
    }

    public void adjust() {
        if (this._target == null) {
            return;
        }
        Point point = this._target.getLocationOnScreen();
        point.y += this._target.getSize().height;
        ((Component)this).setLocation(point.x, point.y);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isVisible()) {
            this.adjust();
            this.toFront();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this._list.getSelectedItem();
        if (string != null) {
            this._delete.setEnabled(true);
            this._chooser.setAddress(string);
        } else {
            this._delete.setEnabled(false);
            this._chooser.setAddress("");
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(((Component)this).getBackground());
        Dimension dimension = this.getSize();
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.draw3DRect(3, 3, dimension.width - 6, dimension.height - 6, false);
        graphics.draw3DRect(4, 4, dimension.width - 8, dimension.height - 8, true);
        if (this._title != null) {
            graphics.fillRect(this._title_bounds.x, this._title_bounds.y, this._title_bounds.width, this._title_bounds.height);
            graphics.setColor(Color.black);
            graphics.drawString(this._title, this.pad * 2, this.ascent);
        }
    }

    public void popup(Button button) {
        this._target = button;
        this._target.setLabel("Close");
        this.adjust();
        if (this._list.getItemCount() > 0) {
            this._list.removeAll();
        }
        Resource resource = Resource.getResourceFor("aglets");
        String[] stringArray = resource.getStringArray("aglets.addressbook", " ");
        int n = 0;
        while (n < stringArray.length) {
            this._list.add(stringArray[n]);
            ++n;
        }
        this.show();
        this.toFront();
    }

    private void reLayout() {
        Insets insets = new Insets(this.pad * 2, this.pad, this.pad, this.pad);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = null;
        gridBagConstraints = this._layout.getConstraints(this._add);
        gridBagConstraints.insets = insets;
        gridBagLayout.setConstraints(this._add, gridBagConstraints);
        gridBagConstraints = this._layout.getConstraints(this._delete);
        gridBagConstraints.insets = insets;
        gridBagLayout.setConstraints(this._delete, gridBagConstraints);
        gridBagConstraints = this._layout.getConstraints(this._list);
        gridBagConstraints.insets = new Insets(0, this.pad, this.pad, this.pad);
        gridBagLayout.setConstraints(this._list, gridBagConstraints);
        this.setLayout(gridBagLayout);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.repaint();
    }

    public void setTitle(String string) {
        this._title = string;
        if (this._title != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.pad = fontMetrics.getHeight();
            this.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
        }
        this.reLayout();
    }

    public void setVisible(boolean bl) {
        if (this._target != null) {
            if (bl) {
                this._target.setLabel("Close");
            } else {
                this._target.setLabel("AddressBook");
            }
        }
        super.setVisible(bl);
    }

    private void updateAddressBook() {
        Resource resource = Resource.getResourceFor("aglets");
        String string = "";
        int n = this._list.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            string = string + this._list.getItem(n2) + " ";
            ++n2;
        }
        resource.setResource("aglets.addressbook", string);
    }
}

