/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglet.util;

import com.ibm.aglet.util.AddressBook;
import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class AddressChooser
extends Panel
implements ActionListener {
    private transient TextField address;
    private transient AddressBook addressbook = null;
    private Button button = new Button("AddressBook");
    private GridBagLayout layout = new GridBagLayout();
    private ActionListener actionListener;
    private String command = "address";

    public AddressChooser() {
        this(10);
    }

    public AddressChooser(int n) {
        this.setLayout(this.layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.addCmp(this.button, gridBagConstraints);
        this.addCmp(new Label("Address:"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.address = new TextField(n);
        this.addCmp(this.address, gridBagConstraints);
        this.button.setActionCommand("toggle");
        this.button.addActionListener(this);
        this.address.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("toggle".equals(string)) {
            if (this.addressbook == null) {
                Container container = this.button.getParent();
                while (!(container instanceof Frame)) {
                    container = container.getParent();
                }
                this.addressbook = new AddressBook((Frame)container, this);
                ((Component)this.addressbook).setSize(200, 200);
                this.addressbook.pack();
            }
            if (!this.addressbook.isVisible()) {
                this.addressbook.popup(this.button);
            } else {
                this.addressbook.setVisible(false);
            }
        } else if (this.address == actionEvent.getSource()) {
            System.out.println("selected = " + this.address.getText());
            ActionEvent actionEvent2 = new ActionEvent(this, 1001, this.command);
            this.processEvent(actionEvent2);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    private void addCmp(Component component, GridBagConstraints gridBagConstraints) {
        this.layout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    void addressSelected(String string) {
        this.address.setText(string);
        this.processActionEvent(new ActionEvent(this, 1001, this.command));
    }

    public String getAddress() {
        return this.address.getText();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1005 && !this.isVisible() && this.addressbook != null) {
            this.addressbook.setVisible(false);
        }
        if (event.id == 1004 || event.id == 1005 || event.id == 504) {
            if (this.addressbook != null && this.addressbook.isVisible()) {
                this.addressbook.adjust();
                this.addressbook.toFront();
            }
            return true;
        }
        return super.handleEvent(event);
    }

    private void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void removeNotify() {
        if (this.addressbook != null) {
            this.addressbook.dispose();
            this.addressbook = null;
        }
        super.removeNotify();
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public void setAddress(String string) {
        this.address.setText(string);
    }
}

