/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.FutureReply;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.ReplySet;
import com.ibm.aglet.ServerNotFoundException;
import com.ibm.aglet.Ticket;
import com.ibm.aglet.system.ContextEvent;
import com.ibm.aglet.system.ContextListener;
import com.ibm.aglet.util.ImageData;
import com.ibm.aglets.AgletAudioClip;
import com.ibm.aglets.AgletImageData;
import com.ibm.aglets.AgletProxyImpl;
import com.ibm.aglets.AgletReader;
import com.ibm.aglets.AgletRef;
import com.ibm.aglets.AgletRuntime;
import com.ibm.aglets.AgletTimer;
import com.ibm.aglets.AgletsSecurityException;
import com.ibm.aglets.ListenerList;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MAF;
import com.ibm.aglets.Persistence;
import com.ibm.aglets.RemoteAgletRef;
import com.ibm.aglets.ResourceManager;
import com.ibm.aglets.ResourceManagerFactory;
import com.ibm.aglets.ShuttingDownException;
import com.ibm.aglets.SubscriberManager;
import com.ibm.aglets.security.ContextPermission;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.AgentNotFound;
import com.ibm.maf.ClassName;
import com.ibm.maf.EntryNotFound;
import com.ibm.maf.FinderNotFound;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MAFFinder;
import com.ibm.maf.MAFUtil;
import com.ibm.maf.Name;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.EOFException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.audio.AudioStream;

public final class AgletContextImpl
implements AgletContext {
    private boolean _secure = true;
    private static ContextPermission START_PERMISSION = null;
    private static ContextPermission SHUTDOWN_PERMISSION = null;
    private static ContextPermission ADD_LISTENER_PERMISSION = null;
    private static ContextPermission REMOVE_LISTENER_PERMISSION = null;
    private URL _hostingURL = null;
    private String _name = "";
    private Persistence _persistence;
    private Hashtable _agletProxies = new Hashtable();
    Properties _contextProperties = new Properties();
    SubscriberManager _subscriberManager = new SubscriberManager();
    private ResourceManagerFactory _rm_factory = null;
    AgletTimer _timer = null;
    private Object creationLock = new Object();
    private int creating = 0;
    private boolean shutting_down = true;
    AgletID context_aid = new AgletID("00");
    ContextListener listeners = null;
    EventRunner erunner = null;
    private Hashtable images = new Hashtable();
    private Hashtable clips = new Hashtable();

    AgletContextImpl(String string) {
        this(string, com.ibm.aglet.system.AgletRuntime.getAgletRuntime().isSecure());
    }

    AgletContextImpl(String string, boolean bl) {
        this._name = string;
        this._timer = new AgletTimer(this);
        this.setSecurity(bl);
    }

    void addAgletProxy(AgletID agletID, AgletProxyImpl agletProxyImpl) throws InvalidAgletException {
        this._agletProxies.put(agletID, agletProxyImpl);
    }

    public synchronized void addContextListener(ContextListener contextListener) {
        if (ADD_LISTENER_PERMISSION == null) {
            ADD_LISTENER_PERMISSION = new ContextPermission("listener", "add");
        }
        this.checkPermission(ADD_LISTENER_PERMISSION);
        if (this.listeners == null) {
            this.listeners = contextListener;
            return;
        }
        ContextListener contextListener2 = this.listeners;
        synchronized (contextListener2) {
            if (this.listeners instanceof ListenerList) {
                ListenerList listenerList = (ListenerList)this.listeners;
                if (!listenerList.contains(contextListener)) {
                    listenerList.addElement(contextListener);
                }
            } else {
                ListenerList listenerList = new ListenerList();
                listenerList.addElement(this.listeners);
                listenerList.addElement(contextListener);
                this.listeners = listenerList;
            }
        }
    }

    void checkPermission(Permission permission) {
        if (!this._secure) {
            return;
        }
        AccessController.checkPermission(permission);
    }

    public void clearCache(URL uRL) {
        this._rm_factory.clearCache(uRL, AgletRuntime.getCurrentCertificate());
    }

    public AgletProxy createAglet(URL uRL, String string, Object object) throws IOException, AgletException, ClassNotFoundException, InstantiationException {
        Certificate certificate = AgletRuntime.getCurrentCertificate();
        return this.createAglet(uRL, string, certificate, object);
    }

    private AgletProxy createAglet(URL uRL, String string, Certificate certificate, Object object) throws IOException, AgletException, ClassNotFoundException, InstantiationException {
        this.startCreation();
        try {
            if (uRL != null && uRL.getRef() != null) {
                this.log("Create", "Fail to create an aglet \"" + string + "\" from " + (uRL == null ? "Local" : uRL.toString()));
                throw new MalformedURLException("MalformedURL in createAglet:" + uRL);
            }
            if (uRL == null && (uRL = this._rm_factory.lookupCodeBaseFor(string)) == null) {
                throw new ClassNotFoundException(string);
            }
            String string2 = String.valueOf(uRL) + "@" + string;
            this.checkPermission(new ContextPermission(string2, "create"));
            Aglet aglet = null;
            LocalAgletRef localAgletRef = new LocalAgletRef(this, this._secure);
            localAgletRef.setName(AgletRuntime.newName(certificate));
            localAgletRef.info = new AgletInfo(MAFUtil.toAgletID(localAgletRef.getName()), string, uRL, this.getHostingURL().toString(), System.currentTimeMillis(), 1, 2, certificate);
            ResourceManager resourceManager = localAgletRef.createResourceManager(null);
            resourceManager.setResourceManagerContext();
            try {
                try {
                    aglet = (Aglet)resourceManager.loadClass(string).newInstance();
                }
                catch (ClassCastException classCastException) {
                    this.log("Create", "Fail to create an aglet \"" + string + "\" from " + uRL);
                    throw new InstantiationException("ClassCastException:" + string + ":" + classCastException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log("Create", "Fail to create an aglet \"" + string + "\" from " + uRL);
                    throw classNotFoundException;
                }
                catch (InstantiationException instantiationException) {
                    this.log("Create", "Fail to create an aglet \"" + string + "\" from " + uRL);
                    throw instantiationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.log("Create", "Fail to create an aglet \"" + string + "\" from " + uRL);
                    throw new InstantiationException("IllegalAccessException:" + string + ":" + illegalAccessException.getMessage());
                }
                Object var14_9 = null;
                resourceManager.unsetResourceManagerContext();
            }
            catch (Throwable throwable) {
                Object var14_10 = null;
                resourceManager.unsetResourceManagerContext();
                throw throwable;
            }
            aglet.setStub(localAgletRef);
            localAgletRef.proxy = new AgletProxyImpl(localAgletRef);
            localAgletRef.startCreatedAglet(this, object);
            this.log("Create", string + " from " + uRL);
            AgletProxyImpl agletProxyImpl = localAgletRef.proxy;
            Object var16_17 = null;
            this.endCreation();
            return agletProxyImpl;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            this.endCreation();
            throw throwable;
        }
    }

    synchronized ResourceManager createResourceManager(URL uRL, Certificate certificate, ClassName[] classNameArray) {
        return this._rm_factory.createResourceManager(uRL, certificate, classNameArray);
    }

    void endCreation() {
        Object object = this.creationLock;
        synchronized (object) {
            --this.creating;
            if (this.shutting_down) {
                this.creationLock.notify();
            }
        }
    }

    public Enumeration getAgletProxies() {
        return this._agletProxies.elements();
    }

    public Enumeration getAgletProxies(int n) {
        Hashtable hashtable = this._agletProxies;
        synchronized (hashtable) {
            Object object;
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this._agletProxies.elements();
            while (enumeration.hasMoreElements()) {
                object = (AgletProxy)enumeration.nextElement();
                if (!object.isState(n)) continue;
                vector.addElement(object);
            }
            object = vector.elements();
            return object;
        }
    }

    public AgletProxy getAgletProxy(AgletID agletID) {
        AgletProxy agletProxy = (AgletProxy)this._agletProxies.get(agletID);
        if (agletProxy != null) {
            return agletProxy;
        }
        try {
            MAFFinder mAFFinder = MAFAgentSystem.getLocalMAFAgentSystem().get_MAFFinder();
            if (mAFFinder != null) {
                String[] stringArray = mAFFinder.lookup_agent(MAFUtil.toName(agletID, null), null);
                agletProxy = this.getAgletProxy(new URL(stringArray[0]), agletID);
            }
        }
        catch (EntryNotFound entryNotFound) {
            agletProxy = null;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            agletProxy = null;
        }
        catch (FinderNotFound finderNotFound) {
            finderNotFound.printStackTrace();
            agletProxy = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            agletProxy = null;
        }
        return agletProxy;
    }

    public AgletProxy getAgletProxy(URL uRL, AgletID agletID) {
        try {
            Ticket ticket = new Ticket(uRL);
            RemoteAgletRef remoteAgletRef = RemoteAgletRef.getAgletRef(ticket, MAFUtil.toName(agletID, null));
            return new AgletProxyImpl(remoteAgletRef);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public AudioClip getAudioClip(URL var1_1) {
        if ("file".equalsIgnoreCase(var1_1.getProtocol())) {
            this.checkPermission(new FilePermission(var1_1.getFile(), "read"));
        } else {
            var2_2 = var1_1.getHost() + ':' + var1_1.getPort();
            this.checkPermission(new SocketPermission((String)var2_2, "connect"));
        }
        var2_2 = (AudioClip)this.clips.get(var1_1);
        if (var2_2 == null) {
            block14: {
                var3_3 = null;
                try {
                    var4_4 = var1_1.openConnection();
                    var4_4.setRequestProperty("user-agent", "Tahiti/Alpha5x");
                    var4_4.setRequestProperty("agent-system", "aglets");
                    var4_4.setAllowUserInteraction(true);
                    var4_4.connect();
                    var3_3 = var4_4.getInputStream();
                    var5_6 = new AudioStream(var3_3).getData();
                    var2_2 = new AgletAudioClip(var1_1, var5_6);
                    var7_8 = null;
                    ** if (var3_3 == null) goto lbl-1000
                }
                catch (Throwable var6_14) {
                    var7_10 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var8_13) {
                            // empty catch block
                        }
                    }
                    throw var6_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var8_11) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                    catch (IOException var4_5) {
                        var4_5.printStackTrace();
                        var5_7 = null;
                        var7_9 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var8_12) {
                                // empty catch block
                            }
                        }
                        return var5_7;
                    }
                }
            }
            this.clips.put(var1_1, var2_2);
        }
        return var2_2;
    }

    public URL getHostingURL() {
        return this._hostingURL;
    }

    public Image getImage(ImageData imageData) {
        ImageData imageData2 = imageData;
        Image image = (Image)this.images.get(imageData2);
        if (image == null) {
            image = Toolkit.getDefaultToolkit().createImage(imageData2.getImageProducer());
            this.images.put(imageData2, image);
        }
        return image;
    }

    public Image getImage(URL uRL) {
        Image image = (Image)this.images.get(uRL);
        if (image == null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.images.put(uRL, image);
        }
        return image;
    }

    public ImageData getImageData(URL uRL) {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("user-agent", "Tahiti/Alpha5x");
            uRLConnection.setRequestProperty("agent-system", "aglets");
            uRLConnection.setAllowUserInteraction(true);
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            String string = uRLConnection.getContentType();
            int n = uRLConnection.getContentLength();
            if (n < 0) {
                n = inputStream.available();
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4 = inputStream.read(byArray, n2 + n3, n - n3);
                if (n4 < 0) {
                    throw new EOFException();
                }
                n3 += n4;
            }
            inputStream.close();
            return new AgletImageData(uRL, byArray, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return this._name;
    }

    public Persistence getPersistence() throws IOException {
        if (this._persistence == null) {
            new IOException("Persistency Service is not supported.");
        }
        return this._persistence;
    }

    public Object getProperty(String string) {
        return this.getProperty(string, null);
    }

    public Object getProperty(String string, Object object) {
        this.checkPermission(new ContextPermission("property." + string, "read"));
        Object v = ((Hashtable)this._contextProperties).get(string);
        return v == null ? object : v;
    }

    public ResourceManagerFactory getResourceManagerFactory() {
        return this._rm_factory;
    }

    boolean getSecurity() {
        return this._secure;
    }

    Object handleMessage(Message message) throws NotHandledException, MessageException {
        if (message.sameKind("createAglet")) {
            Object object = message.getArg("codebase");
            Object object2 = message.getArg("classname");
            Certificate certificate = AgletRuntime.getAnonymousUserCertificate();
            Object object3 = message.getArg("init");
            if ((object == null || object instanceof String) && object2 instanceof String) {
                try {
                    return this.createAglet(object == null ? null : new URL((String)object), (String)object2, certificate, object3);
                }
                catch (Exception exception) {
                    throw new MessageException(exception, "createAglet failed due to: ");
                }
            }
            throw new MessageException(new IllegalArgumentException("createAglet"), "createAglet failed due to: ");
        }
        if (message.sameKind("getAgletProxies")) {
            Hashtable hashtable = this._agletProxies;
            synchronized (hashtable) {
                Object object;
                Vector<Object> vector = new Vector<Object>();
                Enumeration enumeration = this._agletProxies.elements();
                while (enumeration.hasMoreElements()) {
                    object = (AgletProxy)enumeration.nextElement();
                    vector.addElement(object);
                }
                object = vector;
                return object;
            }
        }
        throw new NotHandledException("Message not handled: " + message);
    }

    void log(String string, String string2) {
        this.postEvent(new ContextEvent(1014, this, null, string + " : " + string2), false);
    }

    public ReplySet multicastMessage(Message message) {
        this.checkPermission(new ContextPermission(message.getKind(), "multicast"));
        return this._subscriberManager.multicastMessage(message);
    }

    boolean noResponseAglet(AgletProxy agletProxy) {
        this.postEvent(new ContextEvent(1015, this, agletProxy), true);
        return true;
    }

    public void postEvent(ContextEvent contextEvent, boolean bl) {
        if (bl) {
            if (this.erunner != null) {
                this.erunner.sync();
            }
            this.postEvent0(contextEvent);
        } else {
            if (this.erunner == null) {
                AgletContextImpl agletContextImpl = this;
                synchronized (agletContextImpl) {
                    if (this.erunner == null) {
                        this.erunner = new EventRunner();
                        this.erunner.start();
                    }
                }
            }
            this.erunner.postEvent(contextEvent);
        }
    }

    public void postEvent0(ContextEvent contextEvent) {
        try {
            AgletProxyImpl agletProxyImpl;
            AgletRef agletRef;
            MAFFinder mAFFinder = MAFAgentSystem.getLocalMAFAgentSystem().get_MAFFinder();
            if (mAFFinder != null && (agletRef = (agletProxyImpl = (AgletProxyImpl)contextEvent.getAgletProxy()).getAgletRef()) instanceof LocalAgletRef) {
                LocalAgletRef localAgletRef = (LocalAgletRef)agletProxyImpl.getAgletRef();
                switch (contextEvent.getID()) {
                    case 1002: 
                    case 1003: 
                    case 1007: {
                        try {
                            mAFFinder.register_agent(localAgletRef.getName(), this._hostingURL.toString(), MAF.toAgentProfile(localAgletRef.info));
                            break;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    case 1004: 
                    case 1006: {
                        try {
                            mAFFinder.unregister_agent(localAgletRef.getName());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    case 1005: {
                        try {
                            mAFFinder.register_agent(localAgletRef.getName(), contextEvent.arg.toString(), MAF.toAgentProfile(localAgletRef.info));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (FinderNotFound finderNotFound) {
            // empty catch block
        }
        if (this.listeners == null) {
            return;
        }
        switch (contextEvent.getID()) {
            case 1000: {
                this.listeners.contextStarted(contextEvent);
                break;
            }
            case 1001: {
                this.listeners.contextShutdown(contextEvent);
                break;
            }
            case 1002: {
                this.listeners.agletCreated(contextEvent);
                break;
            }
            case 1003: {
                this.listeners.agletCloned(contextEvent);
                break;
            }
            case 1004: {
                this.listeners.agletDisposed(contextEvent);
                break;
            }
            case 1005: {
                this.listeners.agletDispatched(contextEvent);
                break;
            }
            case 1006: {
                this.listeners.agletReverted(contextEvent);
                break;
            }
            case 1007: {
                this.listeners.agletArrived(contextEvent);
                break;
            }
            case 1008: {
                this.listeners.agletDeactivated(contextEvent);
                break;
            }
            case 1010: {
                this.listeners.agletActivated(contextEvent);
                break;
            }
            case 1012: {
                this.listeners.agletStateChanged(contextEvent);
                break;
            }
            case 1013: {
                this.listeners.showDocument(contextEvent);
                break;
            }
            case 1014: {
                this.listeners.showMessage(contextEvent);
            }
        }
    }

    public void receiveAglet(Name name, ClassName[] classNameArray, String string, byte[] byArray, String string2) throws AgletException, ClassNotFoundException {
        this.startCreation();
        try {
            try {
                String string3 = new String(name.authority);
                this.checkPermission(new ContextPermission(string3, "receive"));
                LocalAgletRef localAgletRef = new LocalAgletRef(this, this._secure);
                localAgletRef.setName(name);
                AgletReader agletReader = new AgletReader(byArray);
                agletReader.readInfo(localAgletRef);
                localAgletRef.createResourceManager(classNameArray);
                agletReader.readAglet(localAgletRef);
                localAgletRef.aglet.setStub(localAgletRef);
                localAgletRef.proxy = new AgletProxyImpl(localAgletRef);
                localAgletRef.startArrivedAglet(this, string2);
                String string4 = "Receive : " + localAgletRef.info.getAgletClassName() + " from " + string2;
                this.postEvent(new ContextEvent(1014, this, null, string4), false);
            }
            catch (NotSerializableException notSerializableException) {
                notSerializableException.printStackTrace();
                throw new AgletException("Incoming aglet is not serializable in this system " + notSerializableException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new AgletException("Failed to receive.. " + iOException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new AgletException("Failed to receive.. " + exception.getMessage());
            }
            Object var11_13 = null;
            this.endCreation();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.endCreation();
            throw throwable;
        }
    }

    void removeAgletProxy(AgletID agletID, AgletProxyImpl agletProxyImpl) {
        Hashtable hashtable = this._agletProxies;
        synchronized (hashtable) {
            if (agletProxyImpl == this._agletProxies.get(agletID)) {
                this._agletProxies.remove(agletID);
            }
        }
    }

    public synchronized void removeContextListener(ContextListener contextListener) {
        if (REMOVE_LISTENER_PERMISSION == null) {
            REMOVE_LISTENER_PERMISSION = new ContextPermission("listener", "remove");
        }
        this.checkPermission(REMOVE_LISTENER_PERMISSION);
        if (this.listeners == null) {
            return;
        }
        ContextListener contextListener2 = this.listeners;
        synchronized (contextListener2) {
            if (this.listeners == contextListener) {
                this.listeners = null;
            } else if (this.listeners != null && this.listeners instanceof ListenerList) {
                ((ListenerList)this.listeners).removeElement(contextListener);
            }
        }
    }

    public AgletProxy retractAglet(Ticket ticket, AgletID agletID) throws IOException, AgletException {
        String string = ticket.getDestination().toString();
        this.checkPermission(new ContextPermission(string, "retract"));
        boolean bl = false;
        try {
            try {
                MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getMAFAgentSystem(ticket);
                if (mAFAgentSystem == null) {
                    throw new ServerNotFoundException(ticket.toString());
                }
                Name name = MAFUtil.toName(agletID, null);
                byte[] byArray = mAFAgentSystem.retract_agent(name);
                AgletReader agletReader = new AgletReader(byArray);
                LocalAgletRef localAgletRef = new LocalAgletRef(this, this._secure);
                agletReader.readInfo(localAgletRef);
                localAgletRef.setName(MAFUtil.toName(localAgletRef.info.getAgletID(), localAgletRef.info.getAuthorityCertificate()));
                localAgletRef.createResourceManager(null);
                agletReader.readAglet(localAgletRef);
                localAgletRef.aglet.setStub(localAgletRef);
                localAgletRef.proxy = new AgletProxyImpl(localAgletRef);
                localAgletRef.startArrivedAglet(this, string);
                bl = true;
                AgletProxyImpl agletProxyImpl = localAgletRef.proxy;
                Object var12_16 = null;
                if (bl) {
                    this.log("Retract", agletID + " from " + ticket);
                } else {
                    this.log("Retract", "Fail to retract " + ticket);
                }
                return agletProxyImpl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AgletException("Fail to retract : " + classNotFoundException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                throw new ServerNotFoundException(ticket.toString());
            }
            catch (IOException iOException) {
                throw new AgletException(ticket.toString());
            }
            catch (AgentNotFound agentNotFound) {
                throw new InvalidAgletException(agentNotFound.getMessage());
            }
            catch (MAFExtendedException mAFExtendedException) {
                throw new AgletException(mAFExtendedException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (bl) {
                this.log("Retract", agletID + " from " + ticket);
            } else {
                this.log("Retract", "Fail to retract " + ticket);
            }
            throw throwable;
        }
    }

    public AgletProxy retractAglet(URL uRL) throws IOException, AgletException {
        return this.retractAglet(new Ticket(uRL), new AgletID(uRL.getRef()));
    }

    public AgletProxy retractAglet(URL uRL, AgletID agletID) throws IOException, AgletException {
        return this.retractAglet(new Ticket(uRL), agletID);
    }

    public void setPersistence(Persistence persistence) throws AgletException {
        if (this._persistence != null) {
            throw new AgletsSecurityException("Persistence already set");
        }
        this._persistence = persistence;
    }

    public void setProperty(String string, Object object) {
        this.checkPermission(new ContextPermission("property." + string, "write"));
        if (object == null) {
            ((Hashtable)this._contextProperties).remove(string);
        } else {
            ((Hashtable)this._contextProperties).put(string, object);
        }
    }

    public void setResourceManagerFactory(ResourceManagerFactory resourceManagerFactory) {
        if (this._rm_factory != null) {
            throw new AgletsSecurityException("Factory already set");
        }
        this._rm_factory = resourceManagerFactory;
    }

    void setSecurity(boolean bl) {
        this._secure = bl;
    }

    public void showDocument(URL uRL) {
        String string = null;
        if (uRL != null) {
            string = uRL.toString();
        }
        this.checkPermission(new ContextPermission("showDocument", string));
        this.postEvent(new ContextEvent(1013, this, null, uRL), false);
    }

    public void shutdown() {
        this.shutdown(new Message("shutdown"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(Message message) {
        Object object;
        Object object2;
        Object object3;
        if (SHUTDOWN_PERMISSION == null) {
            SHUTDOWN_PERMISSION = new ContextPermission("context", "shutdown");
        }
        this.checkPermission(SHUTDOWN_PERMISSION);
        this.shutting_down = true;
        this._timer.destroy();
        System.out.print("[shutting down.");
        Object object4 = this.creationLock;
        synchronized (object4) {
            while (this.creating > 0) {
                try {
                    this.creationLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        System.out.println(".]");
        Enumeration<Object> enumeration = this._agletProxies.elements();
        ReplySet replySet = new ReplySet();
        while (enumeration.hasMoreElements()) {
            object3 = (AgletProxy)enumeration.nextElement();
            try {
                object2 = object3.sendAsyncMessage(message);
                replySet.addFutureReply((FutureReply)object2);
            }
            catch (InvalidAgletException invalidAgletException) {
                // empty catch block
            }
        }
        System.out.println("[waiting for response..]");
        while (replySet.hasMoreFutureReplies()) {
            replySet.waitForNextFutureReply(5000L);
            if (replySet.isAnyAvailable()) {
                replySet.getNextFutureReply();
                continue;
            }
            System.err.println("[some of the aglets didn't respond...]");
            break;
        }
        System.out.println("[terminating aglets.]");
        object3 = null;
        try {
            object3 = MAFAgentSystem.getLocalMAFAgentSystem().get_MAFFinder();
        }
        catch (FinderNotFound finderNotFound) {
            object3 = null;
        }
        if (object3 != null) {
            try {
                object3.unregister_place(this._hostingURL.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        enumeration = this._agletProxies.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (AgletProxyImpl)enumeration.nextElement();
            try {
                if (!((AgletProxyImpl)object2).isActive()) continue;
                ((AgletProxyImpl)object2).dispose();
                if (object3 == null) continue;
                object = (LocalAgletRef)((AgletProxyImpl)object2).getAgletRef();
                if (object3 == null) continue;
                object3.unregister_agent(((LocalAgletRef)object).getName());
            }
            catch (InvalidAgletException invalidAgletException) {
            }
            catch (EntryNotFound entryNotFound) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = Resource.getResourceFor("aglets");
        ((Resource)object2).save("Aglets");
        if (this._persistence != null) {
            try {
                object = (Properties)((Hashtable)this._contextProperties).clone();
                enumeration = ((Hashtable)object).keys();
                while (true) {
                    Object object5;
                    if (!enumeration.hasMoreElements()) {
                        object5 = this._persistence.getEntry("properties-" + this._name);
                        if (object5 == null) {
                            object5 = this._persistence.createEntryWith("properties-" + this._name);
                        }
                        OutputStream outputStream = object5.getOutputStream();
                        this._contextProperties.store(outputStream, "ContextProperty/" + this._name);
                        break;
                    }
                    object5 = (String)enumeration.nextElement();
                    if (((Hashtable)this._contextProperties).get(object5) instanceof String) continue;
                    AgletRuntime.verboseOut("removing property :" + (String)object5);
                    ((Hashtable)this._contextProperties).remove(object5);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.postEvent(new ContextEvent(1001, this, null), true);
    }

    public synchronized void start() {
        this.start(true);
    }

    public synchronized void start(boolean bl) {
        String string;
        Object object;
        Object object2;
        if (START_PERMISSION == null) {
            START_PERMISSION = new ContextPermission("context", "start");
        }
        this.checkPermission(START_PERMISSION);
        if (!this.shutting_down) {
            return;
        }
        this.shutting_down = false;
        String string2 = MAFAgentSystem.getLocalMAFAgentSystem().getAddress();
        try {
            object2 = new URL(string2);
            this._hostingURL = new URL(((URL)object2).getProtocol(), ((URL)object2).getHost(), ((URL)object2).getPort(), '/' + this._name);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (this._rm_factory == null) {
            this._rm_factory = AgletRuntime.getDefaultResourceManagerFactory();
        }
        if (this._persistence == null) {
            this._persistence = AgletRuntime.createPersistenceFor(this);
        }
        if (this._persistence != null) {
            object2 = this._persistence.getEntry("properties-" + this._name);
            if (bl) {
                if (object2 != null) {
                    try {
                        object = object2.getInputStream();
                        try {
                            this._contextProperties.load((InputStream)object);
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            ((InputStream)object).close();
                            throw throwable;
                        }
                        ((InputStream)object).close();
                        {
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                try {
                    this._timer.recoverTimer(this._persistence);
                }
                catch (AgletException agletException) {
                    agletException.printStackTrace();
                }
            } else {
                System.out.println("removing deactivated aglets in the context(" + this._name + ")");
                object = this._persistence.entryKeys();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    if (string.equals("properties-" + this._name)) continue;
                    System.out.println("\t" + string);
                    this._persistence.removeEntry(string);
                }
            }
        }
        this.postEvent(new ContextEvent(1000, this, null), true);
        this._timer.start();
        try {
            object2 = MAFAgentSystem.getLocalMAFAgentSystem();
            object = ((MAFAgentSystem)object2).get_MAFFinder();
            if (object != null) {
                try {
                    string = this._hostingURL.toString();
                    object.register_place(string, this._hostingURL.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (FinderNotFound finderNotFound) {
            // empty catch block
        }
    }

    void startCreation() throws ShuttingDownException {
        Object object = this.creationLock;
        synchronized (object) {
            if (this.shutting_down) {
                throw new ShuttingDownException();
            }
            ++this.creating;
        }
    }

    class EventRunner
    extends Thread {
        Vector events = new Vector();
        boolean sync = false;

        EventRunner() {
            this.setPriority(6);
        }

        public void postEvent(ContextEvent contextEvent) {
            this.events.addElement(contextEvent);
        }

        public void sync() {
            this.sync = true;
            EventRunner eventRunner = this;
            synchronized (eventRunner) {
                while (this.events.size() > 0) {
                    ContextEvent contextEvent = (ContextEvent)this.events.firstElement();
                    this.events.removeElementAt(0);
                    AgletContextImpl.this.postEvent0(contextEvent);
                }
                this.sync = false;
            }
        }

        public void run() {
            while (true) {
                ContextEvent contextEvent;
                EventRunner eventRunner = this;
                synchronized (eventRunner) {
                    while (this.sync || this.events.size() == 0) {
                        try {
                            this.wait(1500L);
                        }
                        catch (Exception exception) {
                            return;
                        }
                    }
                    contextEvent = (ContextEvent)this.events.firstElement();
                    this.events.removeElementAt(0);
                }
                try {
                    AgletContextImpl.this.postEvent0(contextEvent);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

