/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.FutureReply;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.Ticket;
import com.ibm.aglets.AgletRef;
import com.ibm.aglets.SystemMessage;
import com.ibm.awb.weakref.VirtualRef;
import java.io.IOException;
import java.net.URL;

final class AgletProxyImpl
extends VirtualRef
implements AgletProxy {
    static final long serialVersionUID = 4237434474691700860L;

    AgletProxyImpl(AgletRef agletRef) {
        super(agletRef);
    }

    public void activate() throws IOException, AgletException {
        this.getAgletRef().activate();
    }

    public Object clone() throws CloneNotSupportedException {
        SystemMessage systemMessage = new SystemMessage("_clone", null, 8);
        try {
            return this.getAgletRef().sendMessage(systemMessage);
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new CloneNotSupportedException(invalidAgletException.getMessage());
        }
        catch (MessageException messageException) {
            throw new CloneNotSupportedException(messageException.getException().getMessage());
        }
        catch (NotHandledException notHandledException) {
            throw new CloneNotSupportedException(notHandledException.getMessage());
        }
    }

    public void deactivate(long l) throws IOException, InvalidAgletException {
        SystemMessage systemMessage = new SystemMessage("_deactivate", new Long(l), 11);
        try {
            this.getAgletRef().sendMessage(systemMessage);
        }
        catch (MessageException messageException) {
            Throwable throwable = messageException.getException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof InvalidAgletException) {
                throw (InvalidAgletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InvalidAgletException(messageException.getMessage());
        }
        catch (NotHandledException notHandledException) {
            throw new InvalidAgletException(notHandledException.getMessage());
        }
    }

    public void delegateMessage(Message message) throws InvalidAgletException {
        this.getAgletRef().delegateMessage(message);
    }

    public AgletProxy dispatch(Ticket ticket) throws IOException, AgletException {
        SystemMessage systemMessage = new SystemMessage("_dispatch", ticket, 10);
        try {
            return (AgletProxy)this.getAgletRef().sendMessage(systemMessage);
        }
        catch (MessageException messageException) {
            Throwable throwable = messageException.getException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof AgletException) {
                throw (AgletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InvalidAgletException(messageException.getMessage());
        }
        catch (NotHandledException notHandledException) {
            throw new InvalidAgletException(notHandledException.getMessage());
        }
    }

    public AgletProxy dispatch(URL uRL) throws IOException, AgletException {
        return this.dispatch(new Ticket(uRL));
    }

    public void dispose() throws InvalidAgletException {
        SystemMessage systemMessage = new SystemMessage("_dispose", null, 9);
        try {
            this.getAgletRef().sendMessage(systemMessage);
        }
        catch (MessageException messageException) {
            Throwable throwable = messageException.getException();
            if (throwable instanceof InvalidAgletException) {
                throw (InvalidAgletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            messageException.printStackTrace();
            throw new InvalidAgletException(messageException.getMessage());
        }
        catch (NotHandledException notHandledException) {
            throw new InvalidAgletException(notHandledException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AgletProxyImpl) {
            try {
                AgletID agletID = ((AgletProxyImpl)object).getAgletID();
                return this.getAgletID().equals(agletID);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public String getAddress() throws InvalidAgletException {
        return this.getAgletRef().getAddress();
    }

    public Aglet getAglet() throws InvalidAgletException {
        return this.getAgletRef().getAglet();
    }

    public String getAgletClassName() throws InvalidAgletException {
        return this.getAgletInfo().getAgletClassName();
    }

    public AgletID getAgletID() throws InvalidAgletException {
        return this.getAgletInfo().getAgletID();
    }

    public AgletInfo getAgletInfo() throws InvalidAgletException {
        AgletRef agletRef = this.getAgletRef();
        return agletRef.getAgletInfo();
    }

    AgletRef getAgletRef() {
        return (AgletRef)this.getRef();
    }

    public URL getCodeBase() throws InvalidAgletException {
        return this.getAgletInfo().getCodeBase();
    }

    public int hashCode() {
        try {
            return this.getAgletID().hashCode();
        }
        catch (Exception exception) {
            return super.hashCode();
        }
    }

    public boolean isActive() {
        return this.getAgletRef().isActive();
    }

    public boolean isRemote() {
        return this.getAgletRef().isRemote();
    }

    public boolean isState(int n) {
        return this.getAgletRef().isState(n);
    }

    public boolean isValid() {
        return this.getAgletRef().isValid();
    }

    public void resume() throws AgletException {
        this.getAgletRef().resume();
    }

    public synchronized FutureReply sendAsyncMessage(Message message) throws InvalidAgletException {
        return this.getAgletRef().sendFutureMessage(message);
    }

    public synchronized FutureReply sendFutureMessage(Message message) throws InvalidAgletException {
        return this.getAgletRef().sendFutureMessage(message);
    }

    public Object sendMessage(Message message) throws MessageException, InvalidAgletException, NotHandledException {
        return this.getAgletRef().sendMessage(message);
    }

    public synchronized void sendOnewayMessage(Message message) throws InvalidAgletException {
        this.getAgletRef().sendOnewayMessage(message);
    }

    public void suspend(long l) throws InvalidAgletException {
        SystemMessage systemMessage = new SystemMessage("_deactivate", new Long(l), 13);
        try {
            this.getAgletRef().sendMessage(systemMessage);
        }
        catch (MessageException messageException) {
            Throwable throwable = messageException.getException();
            if (throwable instanceof InvalidAgletException) {
                throw (InvalidAgletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InvalidAgletException(messageException.getMessage());
        }
        catch (NotHandledException notHandledException) {
            throw new InvalidAgletException(notHandledException.getMessage());
        }
    }

    public String toString() {
        return "AgletProxyImpl : " + this.getAgletRef();
    }
}

