/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.Ticket;
import com.ibm.aglets.AgletContextImpl;
import com.ibm.aglets.AgletProxyImpl;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MessageBroker;
import com.ibm.aglets.Persistence;
import com.ibm.aglets.PersistenceFactory;
import com.ibm.aglets.RemoteAgletRef;
import com.ibm.aglets.ResourceManagerFactory;
import com.ibm.aglets.security.PolicyImpl;
import com.ibm.aglets.tahiti.AgletsSecurityManager;
import com.ibm.atp.auth.SharedSecrets;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.Opt;
import com.ibm.awb.misc.Resource;
import com.ibm.awb.misc.Version;
import com.ibm.maf.AgentSystemInfo;
import com.ibm.maf.FinderNotFound;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFFinder;
import com.ibm.maf.MAFUtil;
import com.ibm.maf.Name;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.PropertyPermission;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;

public final class AgletRuntime
extends com.ibm.aglet.system.AgletRuntime {
    public static final int AGLET_MAGIC = 692240;
    public static final byte AGLET_STREAM_VERSION = 9;
    private static Version VERSION;
    private static ResourceBundle bundle;
    private static Object[][] contents;
    private static final String DEFAULT_VIEWER = "com.ibm.aglets.tahiti.Tahiti";
    static final Opt[] option_defs;
    static AgletRuntime currentRuntime;
    static Hashtable contexts;
    private static Certificate ANONYMOUS_USER;
    private static boolean verbose;
    private static boolean initialized;
    private static ResourceManagerFactory defaultResourceManagerFactory;
    private static PersistenceFactory persistenceFactory;
    private static Random _randomGenerator;
    private String _ownerAlias = null;
    private Certificate _ownerCertificate = null;
    private static KeyStore _keyStore;
    static /* synthetic */ Class class$com$ibm$aglets$AgletRuntime;

    public AgletRuntime() {
        Class clazz = class$com$ibm$aglets$AgletRuntime == null ? (class$com$ibm$aglets$AgletRuntime = AgletRuntime.class$("com.ibm.aglets.AgletRuntime")) : class$com$ibm$aglets$AgletRuntime;
        synchronized (clazz) {
            if (currentRuntime != null) {
                throw new SecurityException("Runtime cannot be created twice");
            }
            currentRuntime = this;
        }
    }

    public Certificate authenticateOwner(String string, String string2) {
        this._ownerCertificate = AgletRuntime.authenticateUser(string, string2);
        if (this._ownerCertificate == null) {
            this._ownerAlias = null;
        } else {
            this._ownerAlias = string;
            this.startup();
        }
        return this._ownerCertificate;
    }

    public static Certificate authenticateUser(String string, String string2) {
        try {
            char[] cArray = null;
            if (string2 != null && string2.length() > 0) {
                cArray = string2.toCharArray();
            }
            _keyStore.getKey(string, cArray);
            return _keyStore.getCertificate(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void check() {
        if (!initialized) {
            throw new Error("AgletRuntime not initialized");
        }
    }

    void checkPermission(Permission permission) {
        if (!this.isSecure()) {
            return;
        }
        AccessController.checkPermission(permission);
    }

    public static void clearCache() {
        AgletContext[] agletContextArray = com.ibm.aglet.system.AgletRuntime.getAgletRuntime().getAgletContexts();
        int n = 0;
        while (n < agletContextArray.length) {
            AgletContextImpl agletContextImpl = (AgletContextImpl)agletContextArray[n];
            ResourceManagerFactory resourceManagerFactory = agletContextImpl.getResourceManagerFactory();
            if (resourceManagerFactory != null) {
                resourceManagerFactory.clearCache();
            }
            ++n;
        }
    }

    public AgletProxy createAglet(String string, URL uRL, String string2, Object object) throws IOException {
        try {
            Ticket ticket = new Ticket(string);
            Message message = new Message("createAglet");
            if (uRL != null) {
                message.setArg("codebase", uRL.toString());
            }
            message.setArg("classname", string2);
            if (object != null) {
                message.setArg("init", object);
            }
            return (AgletProxy)MessageBroker.sendMessage(ticket, null, message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public AgletContext createAgletContext(String string) {
        Hashtable hashtable = contexts;
        synchronized (hashtable) {
            if (contexts.get(string) == null) {
                AgletContextImpl agletContextImpl = new AgletContextImpl(string);
                contexts.put(string, agletContextImpl);
                AgletContextImpl agletContextImpl2 = agletContextImpl;
                return agletContextImpl2;
            }
            throw new IllegalArgumentException("Context already exists");
        }
    }

    public static Persistence createPersistenceFor(AgletContext agletContext) {
        AgletRuntime.check();
        if (persistenceFactory != null) {
            return persistenceFactory.createPersistenceFor(agletContext);
        }
        return null;
    }

    public AgletContext getAgletContext(String string) {
        return (AgletContext)contexts.get(string);
    }

    public AgletContext[] getAgletContexts() {
        Hashtable hashtable = contexts;
        synchronized (hashtable) {
            AgletContext[] agletContextArray = new AgletContext[contexts.size()];
            Enumeration enumeration = contexts.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                agletContextArray[n++] = (AgletContext)enumeration.nextElement();
            }
            AgletContext[] agletContextArray2 = agletContextArray;
            return agletContextArray2;
        }
    }

    public AgletProxy[] getAgletProxies(String string) throws IOException {
        try {
            Vector vector = (Vector)MessageBroker.sendMessage(new Ticket(string), null, new Message("getAgletProxies"));
            Object[] objectArray = new AgletProxy[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (NotHandledException notHandledException) {
            notHandledException.printStackTrace();
            return null;
        }
        catch (MessageException messageException) {
            messageException.printStackTrace();
            return null;
        }
        catch (InvalidAgletException invalidAgletException) {
            invalidAgletException.printStackTrace();
            return null;
        }
    }

    public AgletProxy getAgletProxy(String string, AgletID agletID) throws IOException {
        Ticket ticket = new Ticket(string);
        return new AgletProxyImpl(RemoteAgletRef.getAgletRef(ticket, MAFUtil.toName(agletID, null)));
    }

    public String getAgletsProperty(String string) {
        return this.getAgletsProperty(string, null);
    }

    public String getAgletsProperty(String string, String string2) {
        return this.getProperty("aglets", string, string2);
    }

    static Certificate getAnonymousUserCertificate() {
        return ANONYMOUS_USER;
    }

    public static Certificate getCertificate(byte[] byArray) {
        Certificate certificate = null;
        try {
            Enumeration<String> enumeration = _keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Certificate certificate2 = _keyStore.getCertificate(string);
                byte[] byArray2 = certificate2.getEncoded();
                if (byArray.length != byArray2.length) continue;
                boolean bl = true;
                int n = 0;
                while (n < byArray.length) {
                    if (byArray[n] != byArray2[n]) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (!bl) continue;
                certificate = certificate2;
                break;
            }
            if (certificate != null) {
                return certificate;
            }
            System.out.println("AgletRuntime is requested to get unknown user's certificate");
            return AgletRuntime.getAnonymousUserCertificate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Certificate getCertificate(String string) {
        Certificate certificate = null;
        try {
            certificate = _keyStore.getCertificate(string);
            if (certificate != null) {
                return certificate;
            }
            System.out.println("AgletRuntime is requested to get unknown user's certificate: " + string);
            return AgletRuntime.getAnonymousUserCertificate();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
    }

    public static String getCertificateAlias(Certificate certificate) {
        try {
            return _keyStore.getCertificateAlias(certificate);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
    }

    static Certificate getCurrentCertificate() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager instanceof AgletsSecurityManager) {
            com.ibm.aglet.system.AgletRuntime agletRuntime;
            AgletsSecurityManager agletsSecurityManager = (AgletsSecurityManager)securityManager;
            Certificate certificate = agletsSecurityManager.getCurrentCertificate();
            if (certificate == null && (agletRuntime = com.ibm.aglet.system.AgletRuntime.getAgletRuntime()) != null) {
                certificate = agletRuntime.getOwnerCertificate();
            }
            return certificate;
        }
        return AgletRuntime.getAnonymousUserCertificate();
    }

    public static ResourceManagerFactory getDefaultResourceManagerFactory() {
        AgletRuntime.check();
        return defaultResourceManagerFactory;
    }

    public Certificate getOwnerCertificate() {
        return this._ownerCertificate;
    }

    public String getOwnerName() {
        return this._ownerAlias;
    }

    public static PrivateKey getPrivateKey(Certificate certificate, char[] cArray) {
        try {
            return (PrivateKey)_keyStore.getKey(AgletRuntime.getCertificateAlias(certificate), cArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getProperty(String string, String string2) {
        return this.getProperty(string, string2, null);
    }

    public String getProperty(String string, String string2, String string3) {
        String string4;
        Object object;
        try {
            object = System.getSecurityManager();
            if (object != null) {
                ((SecurityManager)object).checkPropertyAccess(string2);
            }
        }
        catch (SecurityException securityException) {
            return string3;
        }
        object = Resource.getResourceFor(string);
        if (object == null) {
            string4 = this.getOwnerName();
            if (string4 == null) {
                System.err.println("No user.");
                return string3;
            }
            String string5 = null;
            final String string6 = string4;
            final String string7 = string;
            string5 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return FileUtils.getPropertyFilenameForUser(string6, string7);
                }
            });
            try {
                object = Resource.createResource(string, string5, null);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(malformedURLException.toString());
            }
            System.out.println("reading " + string + " property from " + string5);
        }
        string4 = null;
        if (object != null) {
            string4 = ((Resource)object).getString(string2);
        }
        return string4 == null ? string3 : string4;
    }

    public static Certificate getRegisteredCertificate(String string) {
        Certificate certificate = null;
        try {
            certificate = _keyStore.getCertificate(string);
            if (certificate != null) {
                return certificate;
            }
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
    }

    public String getServerAddress() {
        return MAFAgentSystem.getLocalMAFAgentSystem().getAddress();
    }

    protected synchronized void initialize(String[] stringArray) {
        Object object;
        Object object2;
        String string;
        String string2;
        Resource resource;
        if (initialized) {
            throw new IllegalAccessError("AgletRuntime already initialized");
        }
        Opt.setopt(MAFAgentSystem.option_defs);
        Opt.setopt(option_defs);
        Opt.getopt(stringArray);
        if (!Opt.checkopt(stringArray)) {
            System.exit(1);
        }
        if ((resource = Resource.getResourceFor("system")) != null) {
            verbose = resource.getBoolean("verbose", false);
        }
        if ((string2 = System.getProperty("aglets.keystore.file", null)) == null) {
            string = System.getProperty("user.home");
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string2 = string + ".keystore";
        }
        string = System.getProperty("aglets.keystore.password", null);
        try {
            object2 = new FileInputStream(string2);
            if (_keyStore == null) {
                _keyStore = KeyStore.getInstance("jks");
            }
            object = null;
            if (string != null) {
                object = string.toCharArray();
            }
            _keyStore.load((InputStream)object2, (char[])object);
            String string3 = System.getProperty("aglets.keystore.anonymousAlias", "anonymous");
            ANONYMOUS_USER = _keyStore.getCertificate(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        object2 = new PolicyImpl();
        Policy.setPolicy((Policy)object2);
        object = SharedSecrets.getSharedSecrets();
        initialized = true;
        System.out.println(bundle.getString("aglets.license"));
        System.out.println(bundle.getString("aglets.version"));
    }

    public static final boolean isVerbose() {
        return verbose;
    }

    public void killAglet(AgletProxy agletProxy) throws InvalidAgletException {
        LocalAgletRef localAgletRef = LocalAgletRef.getAgletRef(MAFUtil.toName(agletProxy.getAgletID(), null));
        if (localAgletRef == null) {
            throw new InvalidAgletException("kill: local aglet not found");
        }
        localAgletRef.kill();
    }

    static Name newName(Certificate certificate) {
        byte[] byArray = new byte[8];
        _randomGenerator.nextBytes(byArray);
        try {
            return new Name(certificate.getEncoded(), byArray, 1);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            certificateEncodingException.printStackTrace();
            return null;
        }
    }

    public void removeAgletContext(AgletContext agletContext) {
        Hashtable hashtable = contexts;
        synchronized (hashtable) {
            String string = agletContext.getName();
            contexts.remove(string);
        }
    }

    public void setAgletsProperty(String string, String string2) {
        this.setProperty("aglets", string, string2);
    }

    public static void setDefaultResourceManagerFactory(ResourceManagerFactory resourceManagerFactory) {
        AgletRuntime.check();
        defaultResourceManagerFactory = resourceManagerFactory;
    }

    public static void setPersistenceFactory(PersistenceFactory persistenceFactory) {
        AgletRuntime.check();
        AgletRuntime.persistenceFactory = persistenceFactory;
    }

    public void setProperty(String string, String string2, String string3) {
        this.checkPermission(new PropertyPermission(string2, "write"));
        Resource resource = Resource.getResourceFor(string);
        if (resource == null) {
            String string4 = this.getOwnerName();
            if (string4 == null) {
                System.err.println("No user.");
                return;
            }
            String string5 = null;
            final String string6 = string4;
            final String string7 = string;
            string5 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return FileUtils.getPropertyFilenameForUser(string6, string7);
                }
            });
            try {
                resource = Resource.createResource(string, string5, null);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(malformedURLException.toString());
            }
            System.out.println("reading " + string + " property from " + string5);
        }
        if (resource == null) {
            System.err.println("No resource.");
            return;
        }
        resource.setResource(string2, string3);
        resource.save(string);
    }

    public void shutdown() {
        this.shutdown(new Message("shutdown"));
    }

    public void shutdown(Message message) {
        Object object;
        Hashtable hashtable = contexts;
        synchronized (hashtable) {
            object = contexts.elements();
            while (object.hasMoreElements()) {
                ((AgletContextImpl)object.nextElement()).shutdown(message);
            }
        }
        try {
            object = MAFAgentSystem.getLocalMAFAgentSystem();
            MAFFinder mAFFinder = ((MAFAgentSystem)object).get_MAFFinder();
            if (mAFFinder != null) {
                try {
                    AgentSystemInfo agentSystemInfo = ((MAFAgentSystem)object).get_agent_system_info();
                    mAFFinder.unregister_agent_system(agentSystemInfo.agent_system_name);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (FinderNotFound finderNotFound) {
            // empty catch block
        }
    }

    private void startup() {
        String[] stringArray;
        String string = this.getOwnerName();
        if (string == null) {
            System.err.println("No user.");
            return;
        }
        Resource resource = Resource.getResourceFor("aglets");
        if (resource == null) {
            try {
                stringArray = FileUtils.getPropertyFilenameForUser(string, "aglets");
                resource = Resource.createResource("aglets", (String)stringArray, null);
                System.out.println("reading aglets property from " + (String)stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        resource.importOptionProperties("aglets");
        resource.setResource("aglets.version", VERSION.toString());
        resource.setResource("aglets.stream.version", String.valueOf(9));
        resource.setOptionResource("aglets.copyright", "Licenced Materials - Property of IBM \n(c) Copyright IBM Corp. 1996,1997 All Rights Reserved");
        stringArray = resource.getStringArray("aglets.export.path", File.pathSeparator + ", ");
        if (stringArray.length > 0 && stringArray[0] != null && stringArray[0].length() > 0) {
            resource.setOptionResource("aglets.public.root", stringArray[0]);
        }
        if (stringArray.length > 1) {
            System.out.println(bundle.getString("aglets.error.export_morethan_one"));
        }
        String string2 = resource.getString("aglets.home", null);
        String[][] stringArray2 = new String[][]{{"aglets.public.root", string2 + File.separator + "public"}, {"aglets.viewer", DEFAULT_VIEWER}, {"aglets.addressbook", ""}, {"aglets.agletsList", "examples.simple.DisplayAglet examples.hello.HelloAglet examples.itinerary.CirculateAglet examples.mdispatcher.HelloAglet examples.http.WebServerAglet examples.talk.TalkMaster"}};
        resource.setDefaultResources(stringArray2);
        this.setSecure(resource.getBoolean("aglets.secure", true));
        try {
            String string3 = FileUtils.getSpoolDirectory();
            resource.setDefaultResource("aglets.spool", string3);
            string3 = resource.getString("aglets.spool");
            String string4 = FileUtils.getCacheDirectory();
            resource.setDefaultResource("aglets.cache", string4);
            string4 = resource.getString("aglets.cache");
            FileUtils.ensureDirectory(string3 + File.separator);
            FileUtils.ensureDirectory(string4 + File.separator);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    public static final void verboseOut(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        bundle = null;
        VERSION = new Version("IBM Aglets Class Library", 2, 1, 0);
        contents = new Object[][]{{"aglets.version", "[" + VERSION + "]"}, {"aglets.license", "---------------------------------------------\n Licensed Materials - Property of IBM\n         (c) Copyright IBM Corp.\n 1996, 1998 All rights reserved.\n US Government Users Restricted Rights - \n Use, duplication or disclosure restricted\n by GSA ADP Schedule Contract with IBM Corp.\n---------------------------------------------"}, {"aglets.error.export_morethan_one", "The obsolete AGLET_EXPORT_PATH env var contains more than one directories."}};
        bundle = new ListResourceBundle(){

            public Object[][] getContents() {
                return contents;
            }
        };
        option_defs = new Opt[]{Opt.Entry("-nosecurity", "aglets.secure", "false", "    -nosecurity          disable security manager"), Opt.Entry("-enablebox", "aglets.enableBox", "true", null), Opt.Entry("-nojit")};
        currentRuntime = null;
        contexts = new Hashtable();
        ANONYMOUS_USER = null;
        verbose = false;
        initialized = false;
        defaultResourceManagerFactory = null;
        persistenceFactory = null;
        _randomGenerator = new Random();
        _keyStore = null;
    }
}

