/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.MessageManager;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MessageImpl;
import com.ibm.aglets.MessageManagerImpl;

public final class AgletThread
extends Thread {
    private boolean valid = true;
    private boolean start = false;
    private boolean loop_started = false;
    private MessageManagerImpl manager = null;
    private MessageImpl message = null;
    static int count = 1;

    public AgletThread(ThreadGroup threadGroup, MessageManager messageManager) {
        super(threadGroup, "No." + count++ + ']');
        this.manager = (MessageManagerImpl)messageManager;
        this.setPriority(threadGroup.getMaxPriority());
    }

    static MessageImpl getCurrentMessage() {
        Thread thread = Thread.currentThread();
        if (thread instanceof AgletThread) {
            return ((AgletThread)thread).message;
        }
        return null;
    }

    void handleMessage(MessageImpl messageImpl) {
        if (this.isAlive()) {
            AgletThread agletThread = this;
            synchronized (agletThread) {
                this.message = messageImpl;
                this.start = true;
                this.notifyAll();
            }
        } else {
            this.message = messageImpl;
            this.start = true;
            this.start();
        }
    }

    public synchronized void invalidate() {
        if (this.valid) {
            this.valid = false;
            this.start = true;
            this.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.loop_started) {
            return;
        }
        this.loop_started = true;
        this.start = false;
        LocalAgletRef localAgletRef = this.manager.getAgletRef();
        try {
            block12: while (true) {
                block22: {
                    Object var6_7;
                    if (!this.valid) {
                        Object var9_9 = null;
                        this.manager.removeThread(this);
                        this.message = null;
                        return;
                    }
                    try {
                        try {
                            this.message.handle(localAgletRef);
                            this.message = null;
                        }
                        catch (RuntimeException runtimeException) {
                            this.valid = false;
                            throw runtimeException;
                        }
                        catch (Error error) {
                            this.valid = false;
                            throw error;
                        }
                        catch (InvalidAgletException invalidAgletException) {
                            invalidAgletException.printStackTrace();
                            this.valid = false;
                            this.start = true;
                            var6_7 = null;
                            if (this.valid) {
                                this.manager.pushThreadAndExitMonitorIfOwner(this);
                                break block22;
                            } else {
                                this.manager.exitMonitorIfOwner();
                            }
                            break block22;
                        }
                        var6_7 = null;
                        if (this.valid) {
                            this.manager.pushThreadAndExitMonitorIfOwner(this);
                        } else {
                            this.manager.exitMonitorIfOwner();
                        }
                    }
                    catch (Throwable throwable) {
                        var6_7 = null;
                        if (this.valid) {
                            this.manager.pushThreadAndExitMonitorIfOwner(this);
                            throw throwable;
                        }
                        this.manager.exitMonitorIfOwner();
                        throw throwable;
                    }
                }
                AgletThread agletThread = this;
                synchronized (agletThread) {
                    while (true) {
                        if (this.start || !this.valid) {
                            this.start = false;
                            continue block12;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.manager.removeThread(this);
            this.message = null;
            throw throwable;
        }
    }

    public String toString() {
        MessageImpl messageImpl = this.message;
        if (messageImpl == null) {
            return "AgletThread[" + this.getName() + ", priority = " + this.getPriority() + ", valid = " + this.valid + ", start = " + this.start;
        }
        return "AgletThread[" + this.getName() + "," + messageImpl.toString() + ", priority = " + this.getPriority() + ", valid = " + this.valid + ", start = " + this.start;
    }
}

