/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglets.AgletContextImpl;
import com.ibm.aglets.AgletProxyImpl;
import com.ibm.aglets.AgletReader;
import com.ibm.aglets.DeactivationInfo;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MessageManagerImpl;
import com.ibm.aglets.Persistence;
import com.ibm.aglets.PersistentEntry;
import com.ibm.maf.MAFUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.util.Date;
import java.util.Enumeration;

final class AgletTimer
implements Runnable {
    private AgletContextImpl _context = null;
    private DeactivationInfo top = null;
    Thread handler = null;

    AgletTimer(AgletContextImpl agletContextImpl) {
        this._context = agletContextImpl;
        this.top = new DeactivationInfo(null, 0L, null);
        this.top.wakeup = 0L;
        this.top.next = null;
    }

    synchronized void add(DeactivationInfo deactivationInfo) {
        if (deactivationInfo.wakeup == 0L) {
            return;
        }
        DeactivationInfo deactivationInfo2 = this.top;
        while (deactivationInfo2.next != null && deactivationInfo2.next.wakeup < deactivationInfo.wakeup) {
            deactivationInfo2 = deactivationInfo2.next;
        }
        deactivationInfo.next = deactivationInfo2.next;
        deactivationInfo2.next = deactivationInfo;
        this.notifyAll();
    }

    synchronized void destroy() {
        if (this.handler != null) {
            this.handler.stop();
            this.handler = null;
        }
    }

    public void list(PrintStream printStream) {
        System.out.println("======= Deactivated Aglets ==========");
        DeactivationInfo deactivationInfo = this.top.next;
        while (deactivationInfo != null) {
            System.out.println(deactivationInfo.key + " : " + new Date(deactivationInfo.wakeup));
            deactivationInfo = deactivationInfo.next;
        }
    }

    synchronized DeactivationInfo popInfo() {
        if (this.top.next != null) {
            DeactivationInfo deactivationInfo = this.top.next;
            this.top.next = this.top.next.next;
            return deactivationInfo;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    void recoverTimer(Persistence persistence) throws AgletException {
        Enumeration enumeration = persistence.entryKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PersistentEntry persistentEntry = persistence.getEntry(string);
            ObjectInputStream objectInputStream = null;
            objectInputStream = new ObjectInputStream(persistentEntry.getInputStream());
            DeactivationInfo deactivationInfo = (DeactivationInfo)objectInputStream.readObject();
            MessageManagerImpl messageManagerImpl = (MessageManagerImpl)objectInputStream.readObject();
            messageManagerImpl.setState(3);
            LocalAgletRef localAgletRef = new LocalAgletRef(this._context);
            localAgletRef.setName(deactivationInfo.agent_name);
            localAgletRef.setMessageManager(messageManagerImpl);
            objectInputStream.readObject();
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            AgletReader agletReader = new AgletReader(byArray);
            agletReader.readInfo(localAgletRef);
            if (deactivationInfo.wakeup == 0L) {
                deactivationInfo.wakeup = System.currentTimeMillis();
            }
            localAgletRef.proxy = new AgletProxyImpl(localAgletRef);
            localAgletRef.validate(this._context, 2);
            this.add(deactivationInfo);
            Object var13_15 = null;
            if (objectInputStream == null) continue;
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
            continue;
            {
                catch (StreamCorruptedException streamCorruptedException) {
                    var13_15 = null;
                    if (objectInputStream == null) continue;
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    var13_15 = null;
                    if (objectInputStream == null) continue;
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    var13_15 = null;
                    if (objectInputStream == null) continue;
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var13_15 = null;
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    synchronized void removeInfo(String string) {
        DeactivationInfo deactivationInfo = this.top;
        while (deactivationInfo.next != null) {
            if (deactivationInfo.next.key.equals(string)) {
                deactivationInfo.next = deactivationInfo.next.next;
                return;
            }
            deactivationInfo = deactivationInfo.next;
        }
    }

    public void run() {
        long l = 0L;
        while (true) {
            Object object;
            DeactivationInfo deactivationInfo = this.topInfo();
            l = deactivationInfo.wakeup - System.currentTimeMillis();
            if (l > 0L) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            object = MAFUtil.toAgletID(deactivationInfo.agent_name);
            try {
                AgletProxy agletProxy = this._context.getAgletProxy((AgletID)object);
                if (agletProxy != null) {
                    agletProxy.activate();
                    continue;
                }
                System.out.println("Proxy Not Found");
                this.removeInfo(deactivationInfo.key);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            catch (AgletException agletException) {
                agletException.printStackTrace();
                continue;
            }
            break;
        }
    }

    synchronized void start() {
        if (this.handler == null) {
            this.handler = new Thread(this);
            this.handler.start();
        }
    }

    synchronized DeactivationInfo topInfo() {
        while (this.top.next == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.top.next;
    }
}

