/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.AgletException;
import com.ibm.aglet.FutureReply;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.ReplySet;
import java.util.Enumeration;
import java.util.Vector;

class FutureReplyImpl
extends FutureReply {
    volatile boolean available = false;
    Object result;
    AgletException exception = null;
    Object set = null;

    FutureReplyImpl() {
    }

    protected final synchronized void addedTo(ReplySet replySet) {
        if (this.available) {
            replySet.done(this);
            return;
        }
        if (this.set == null) {
            this.set = replySet;
        } else if (this.set instanceof ReplySet) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(this.set);
            vector.addElement(replySet);
            this.set = vector;
        } else {
            ((Vector)this.set).addElement(replySet);
        }
    }

    synchronized void cancel(String string) {
        if (!this.available) {
            this.available = true;
            this.exception = new NotHandledException(string);
            this.notifyAll();
            this.notifySet();
        }
    }

    public final synchronized Object getReply() throws MessageException, NotHandledException {
        this.waitForReply();
        if (this.exception != null) {
            if (this.exception instanceof NotHandledException) {
                throw (NotHandledException)this.exception;
            }
            if (this.exception instanceof MessageException) {
                throw (MessageException)this.exception;
            }
        }
        return this.result;
    }

    public final boolean isAvailable() {
        return this.available;
    }

    private final void notifySet() {
        if (this.set == null) {
            return;
        }
        if (this.set instanceof ReplySet) {
            ((ReplySet)this.set).done(this);
        } else if (this.set instanceof Vector) {
            Enumeration enumeration = ((Vector)this.set).elements();
            while (enumeration.hasMoreElements()) {
                ReplySet replySet = (ReplySet)enumeration.nextElement();
                replySet.done(this);
            }
        }
        this.set = null;
    }

    final synchronized void sendExceptionIfNeeded(Throwable throwable) {
        if (!this.available) {
            this.setExceptionAndNotify(throwable);
        }
    }

    final synchronized void sendReplyIfNeeded(Object object) {
        if (!this.available) {
            this.setReplyAndNotify(object);
        }
    }

    synchronized void setExceptionAndNotify(Throwable throwable) {
        if (this.available) {
            throw new IllegalAccessError("Reply has been already set");
        }
        this.available = true;
        this.exception = new MessageException(throwable);
        this.notifyAll();
        this.notifySet();
    }

    synchronized void setReplyAndNotify(Object object) {
        if (this.available) {
            throw new IllegalAccessError("Reply has been already set");
        }
        this.result = object;
        this.available = true;
        this.notifyAll();
        this.notifySet();
    }

    public final synchronized void waitForReply() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public final synchronized void waitForReply(long l) {
        if (l == 0L) {
            this.waitForReply();
        } else {
            long l2;
            long l3 = System.currentTimeMillis() + l;
            while (!this.available && (l2 = l3 - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

