/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletNotFoundException;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.AgletStub;
import com.ibm.aglet.FutureReply;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.MessageManager;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.RequestRefusedException;
import com.ibm.aglet.ServerNotFoundException;
import com.ibm.aglet.Ticket;
import com.ibm.aglet.event.AgletEvent;
import com.ibm.aglet.event.CloneEvent;
import com.ibm.aglet.event.MobilityEvent;
import com.ibm.aglet.event.PersistencyEvent;
import com.ibm.aglet.security.AgletProtection;
import com.ibm.aglet.security.MessageProtection;
import com.ibm.aglet.security.Protection;
import com.ibm.aglet.security.Protections;
import com.ibm.aglet.system.ContextEvent;
import com.ibm.aglets.AgletContextImpl;
import com.ibm.aglets.AgletProxyImpl;
import com.ibm.aglets.AgletReader;
import com.ibm.aglets.AgletRef;
import com.ibm.aglets.AgletRuntime;
import com.ibm.aglets.AgletThread;
import com.ibm.aglets.AgletWriter;
import com.ibm.aglets.AgletsSecurityException;
import com.ibm.aglets.DeactivationInfo;
import com.ibm.aglets.EventMessage;
import com.ibm.aglets.FutureReplyImpl;
import com.ibm.aglets.MessageImpl;
import com.ibm.aglets.MessageManagerImpl;
import com.ibm.aglets.Persistence;
import com.ibm.aglets.PersistentEntry;
import com.ibm.aglets.RemoteAgletRef;
import com.ibm.aglets.ResourceManager;
import com.ibm.aglets.ShuttingDownException;
import com.ibm.aglets.SystemMessage;
import com.ibm.aglets.security.AgletPermission;
import com.ibm.aglets.security.AgletsPermissionBase;
import com.ibm.aglets.security.ContextPermission;
import com.ibm.aglets.security.MessagePermission;
import com.ibm.aglets.security.PlainAgletPermission;
import com.ibm.aglets.security.PlainMessagePermission;
import com.ibm.awb.weakref.Ref;
import com.ibm.awb.weakref.VirtualRef;
import com.ibm.maf.AgentProfile;
import com.ibm.maf.ClassName;
import com.ibm.maf.ClassUnknown;
import com.ibm.maf.DeserializationFailed;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MAFUtil;
import com.ibm.maf.Name;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;

public final class LocalAgletRef
extends AgletStub
implements AgletRef {
    static final int NOT_INITIALIZED = 0;
    static final int ACTIVE = 1;
    static final int INACTIVE = 2;
    static final int INVALID = 4;
    static final String CLASS_AGLET_PERMISSION = "com.ibm.aglets.security.AgletPermission";
    static final String CLASS_MESSAGE_PERMISSION = "com.ibm.aglets.security.MessagePermission";
    static final String CLASS_AGLET_PROTECTION = "com.ibm.aglet.security.AgletProtection";
    static final String CLASS_MESSAGE_PROTECTION = "com.ibm.aglet.security.MessageProtection";
    private static final String ACTION_CLONE = "clone";
    private static final String ACTION_DISPOSE = "dispose";
    private static final String ACTION_DISPATCH = "dispatch";
    private static final String ACTION_DEACTIVATE = "deactivate";
    private static final String ACTION_ACTIVATE = "activate";
    private static final String ACTION_RETRACT = "retract";
    private static AgentProfile _agent_profile = null;
    Aglet aglet = null;
    AgletInfo info = null;
    ResourceManager resourceManager = null;
    MessageManagerImpl messageManager = null;
    AgletProxyImpl proxy = null;
    Protections protections = null;
    private Name _name = null;
    private int _state = 0;
    private boolean _hasSnapshot = false;
    private AgletContextImpl _context = null;
    private String _text = null;
    private boolean _secure = true;
    private Certificate _owner = null;
    private int _mode = -1;
    private Object lock = new Object();
    private int num_of_trial_to_dispose = 0;
    static Hashtable local_ref_table;

    LocalAgletRef(AgletContextImpl agletContextImpl) {
        this(agletContextImpl, agletContextImpl.getSecurity());
    }

    LocalAgletRef(AgletContextImpl agletContextImpl, boolean bl) {
        this._context = agletContextImpl;
        this._secure = bl;
    }

    Object _clone() throws CloneNotSupportedException {
        try {
            this._context.startCreation();
        }
        catch (ShuttingDownException shuttingDownException) {
            throw new CloneNotSupportedException("Shutting down");
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                AgletProxyImpl agletProxyImpl;
                try {
                    this.checkValidation();
                    this.checkActive();
                    try {
                        this.dispatchEvent(new CloneEvent(1100, this.proxy));
                    }
                    catch (SecurityException securityException) {
                        throw securityException;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.suspendMessageManager();
                    LocalAgletRef localAgletRef = new LocalAgletRef(this._context, this._secure);
                    Certificate certificate = this._owner;
                    Name name = AgletRuntime.newName(certificate);
                    localAgletRef.setName(name);
                    localAgletRef.info = new AgletInfo(MAFUtil.toAgletID(name), this.info.getAgletClassName(), this.info.getCodeBase(), this._context.getHostingURL().toString(), System.currentTimeMillis(), this.info.getAPIMajorVersion(), this.info.getAPIMinorVersion(), certificate);
                    AgletWriter agletWriter = new AgletWriter();
                    agletWriter.writeAglet(this);
                    localAgletRef.createResourceManager(agletWriter.getClassNames());
                    AgletReader agletReader = new AgletReader(agletWriter.getBytes());
                    agletReader.readAglet(localAgletRef);
                    Aglet aglet = localAgletRef.aglet;
                    localAgletRef.protections = LocalAgletRef.cloneProtections(this.protections);
                    aglet.setStub(localAgletRef);
                    localAgletRef.proxy = new AgletProxyImpl(localAgletRef);
                    localAgletRef.startClonedAglet(this._context, this.proxy);
                    bl = true;
                    agletProxyImpl = localAgletRef.proxy;
                    Object var11_17 = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CloneNotSupportedException("Class Not Found :" + classNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new CloneNotSupportedException("IO Exception :" + iOException.getMessage());
                }
                catch (AgletException agletException) {
                    throw new CloneNotSupportedException("Aglet Exception :" + agletException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                this.resumeMessageManager();
                if (bl) {
                    this._context.log("Clone", this.info.getAgletClassName());
                } else {
                    this._context.log("Clone", "Failed to clone the aglet [" + this.info.getAgletClassName() + "]");
                }
                this.dispatchEvent(new CloneEvent(1102, this.proxy));
                this._context.endCreation();
                return agletProxyImpl;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                this.resumeMessageManager();
                if (bl) {
                    this._context.log("Clone", this.info.getAgletClassName());
                } else {
                    this._context.log("Clone", "Failed to clone the aglet [" + this.info.getAgletClassName() + "]");
                }
                this.dispatchEvent(new CloneEvent(1102, this.proxy));
                this._context.endCreation();
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activate() throws IOException, InvalidAgletException, AgletNotFoundException, ShuttingDownException {
        this._context.startCreation();
        var1_1 = this.lock;
        synchronized (var1_1) {
            block25: {
                this.checkValidation();
                if (this.isActive()) {
                    this._context.endCreation();
                    return;
                }
                var2_2 = this.getPersistenceKey();
                var3_3 = null;
                var4_4 = this._context.getPersistence();
                try {
                    try {
                        if (this._mode == 1) {
                            this.messageManager.state = 0;
                        } else {
                            var5_5 = var4_4.getEntry(var2_2);
                            var3_3 = new ObjectInputStream(var5_5.getInputStream());
                            var6_7 = (DeactivationInfo)var3_3.readObject();
                            this.setMessageManager((MessageManagerImpl)var3_3.readObject());
                            this._hasSnapshot = var6_7.isSnapshot();
                            var7_9 = (ClassName[])var3_3.readObject();
                            var8_11 = new byte[var3_3.readInt()];
                            var3_3.readFully(var8_11);
                            var9_12 = new AgletReader(var8_11);
                            var9_12.readInfo(this);
                            this.createResourceManager(var7_9);
                            var9_12.readAglet(this);
                            this.aglet.setStub(this);
                        }
                        if (this._mode == 1) {
                            this.startResumedAglet();
                        } else {
                            this.startActivatedAglet();
                        }
                        this._context.log("Activated", this.info.getAgletClassName());
                        var11_13 = null;
                    }
                    catch (IOException var5_6) {
                        throw new AgletNotFoundException(var2_2);
                    }
                    catch (ClassNotFoundException var6_8) {
                        throw new AgletNotFoundException(var2_2);
                    }
                    catch (InvalidAgletException var7_10) {
                        var7_10.printStackTrace();
                        throw new AgletNotFoundException(var2_2);
                    }
                }
                catch (Throwable var10_23) {
                    var11_14 = null;
                    try {
                        try {
                            if (var3_3 != null) {
                                var3_3.close();
                            }
                        }
                        catch (IOException var12_16) {
                            // empty catch block
                        }
                        this._context._timer.removeInfo(var2_2);
                        if (!this._hasSnapshot) {
                            var4_4.removeEntry(var2_2);
                        }
                        var14_19 = null;
                        this._context.endCreation();
                        throw var10_23;
                    }
                    catch (Throwable var13_22) {
                        var14_20 = null;
                        this._context.endCreation();
                        throw var13_22;
                    }
                }
                try {}
                catch (Throwable var13_21) {
                    var14_18 = null;
                    this._context.endCreation();
                    throw var13_21;
                }
                ** try [egrp 4[TRYBLOCK] [4 : 274->285)] { 
lbl76:
                // 1 sources

                if (var3_3 != null) {
                    var3_3.close();
                }
                break block25;
lbl79:
                // 1 sources

                catch (IOException var12_15) {
                    // empty catch block
                }
            }
            this._context._timer.removeInfo(var2_2);
            if (!this._hasSnapshot) {
                var4_4.removeEntry(var2_2);
            }
            var14_17 = null;
            this._context.endCreation();
            return;
        }
    }

    private static void addAgletRef(Name name, LocalAgletRef localAgletRef) {
        local_ref_table.put(new RefKey(name), localAgletRef);
    }

    private boolean canSetProtections(PermissionCollection permissionCollection) {
        return permissionCollection != null;
    }

    void checkActive() {
        if (!this.isActive()) {
            throw new AgletsSecurityException("");
        }
    }

    private void checkAgletPermission(String string) {
        this.checkPermission(new AgletPermission(AgletRuntime.getCertificateAlias(this._owner), string));
    }

    private void checkAgletPermissionAndProtection(String string) {
        this.checkAgletPermission(string);
        this.checkAgletProtection(string);
    }

    private void checkAgletProtection(String string) {
        Certificate certificate = AgletRuntime.getCurrentCertificate();
        if (certificate != null) {
            this.checkProtection(new AgletProtection(AgletRuntime.getCertificateAlias(certificate), string));
        }
    }

    private void checkMessagePermission(MessageImpl messageImpl) {
        Permission permission = messageImpl.getPermission(AgletRuntime.getCertificateAlias(this._owner));
        this.checkPermission(permission);
    }

    private void checkMessagePermission(String string) {
        this.checkPermission(new MessagePermission(AgletRuntime.getCertificateAlias(this._owner), string));
    }

    private void checkMessagePermissionAndProtection(MessageImpl messageImpl) {
        this.checkMessagePermission(messageImpl);
        this.checkMessageProtection(messageImpl);
    }

    private void checkMessagePermissionAndProtection(String string) {
        this.checkMessagePermission(string);
        this.checkMessageProtection(string);
    }

    private void checkMessageProtection(MessageImpl messageImpl) {
        Certificate certificate = AgletRuntime.getCurrentCertificate();
        if (certificate != null) {
            Permission permission = messageImpl.getProtection(AgletRuntime.getCertificateAlias(certificate));
            this.checkProtection(permission);
        }
    }

    private void checkMessageProtection(String string) {
        Certificate certificate = AgletRuntime.getCurrentCertificate();
        if (certificate != null) {
            this.checkProtection(new MessageProtection(AgletRuntime.getCertificateAlias(certificate), string));
        }
    }

    private void checkPermission(Permission permission) {
        if (this._context != null) {
            this._context.checkPermission(permission);
        }
    }

    private void checkProtection(Permission permission) {
        if (!this._secure) {
            return;
        }
        System.out.println("protections=" + String.valueOf(this.protections));
        System.out.println("permission=" + String.valueOf(permission));
        if (this.protections != null && !this.protections.implies(permission)) {
            SecurityException securityException = new SecurityException(permission.toString());
            securityException.printStackTrace();
            throw securityException;
        }
    }

    public void checkValidation() throws InvalidAgletException {
        if (!this.isValid()) {
            throw new InvalidAgletException("Aglet is not valid");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        this.checkAgletPermissionAndProtection(ACTION_CLONE);
        return this._clone();
    }

    private MessageImpl cloneMessageAndCheck(Message message, int n) {
        MessageImpl messageImpl = message instanceof SystemMessage ? (MessageImpl)message : new MessageImpl(message, null, n, System.currentTimeMillis());
        this.checkMessagePermissionAndProtection(messageImpl);
        return messageImpl;
    }

    private static Protections cloneProtections(Protections protections) {
        if (protections == null) {
            return null;
        }
        Enumeration enumeration = protections.elements();
        Protections protections2 = new Protections();
        while (enumeration.hasMoreElements()) {
            AgletsPermissionBase agletsPermissionBase;
            String string;
            String string2;
            AgletsPermissionBase agletsPermissionBase2;
            Object e = enumeration.nextElement();
            if (e instanceof AgletProtection) {
                agletsPermissionBase2 = (AgletProtection)e;
                string2 = agletsPermissionBase2.getName();
                string = ((PlainAgletPermission)agletsPermissionBase2).getActions();
                agletsPermissionBase = new AgletProtection(string2, string);
                protections2.add(agletsPermissionBase);
                continue;
            }
            if (!(e instanceof MessageProtection)) continue;
            agletsPermissionBase2 = (MessageProtection)e;
            string2 = agletsPermissionBase2.getName();
            string = ((PlainMessagePermission)agletsPermissionBase2).getActions();
            agletsPermissionBase = new MessageProtection(string2, string);
            protections2.add(agletsPermissionBase2);
        }
        return protections2;
    }

    ResourceManager createResourceManager(ClassName[] classNameArray) {
        this.resourceManager = this._context.createResourceManager(this.info.getCodeBase(), this._owner, classNameArray);
        if (this.resourceManager == null) {
            System.out.println("invalid codebase:" + this.info.getCodeBase());
        }
        return this.resourceManager;
    }

    protected void deactivate(long l) throws IOException {
        try {
            this.checkActive();
            this.checkAgletPermissionAndProtection(ACTION_DEACTIVATE);
            this.deactivate(AgletThread.getCurrentMessage(), l);
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new AgletsSecurityException("deactivate : " + invalidAgletException);
        }
        catch (RequestRefusedException requestRefusedException) {
            throw new AgletsSecurityException("deactivate : " + requestRefusedException);
        }
    }

    void deactivate(MessageImpl messageImpl, long l) throws IOException, InvalidAgletException, RequestRefusedException {
        Object object = this.lock;
        synchronized (object) {
            String string;
            ObjectOutputStream objectOutputStream;
            block24: {
                this.checkValidation();
                if (l < 0L) {
                    throw new IllegalArgumentException("minutes must be positive");
                }
                Persistence persistence = this._context.getPersistence();
                if (persistence == null) {
                    this._context.log("Deactivation", "Deactivation not implemneted in this environment");
                    return;
                }
                try {
                    this.dispatchEvent(new PersistencyEvent(1300, this.proxy, l));
                }
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                objectOutputStream = null;
                this.suspendMessageManager();
                boolean bl = false;
                string = this.getPersistenceKey();
                try {
                    long l2 = l == 0L ? 0L : System.currentTimeMillis() + l;
                    PersistentEntry persistentEntry = persistence.createEntryWith(string);
                    objectOutputStream = new ObjectOutputStream(persistentEntry.getOutputStream());
                    DeactivationInfo deactivationInfo = new DeactivationInfo(this._name, l2, string, 0);
                    this.writeDeactivatedAglet(objectOutputStream, deactivationInfo);
                    this._context._timer.add(deactivationInfo);
                    bl = true;
                    Object var14_13 = null;
                    if (bl) break block24;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    if (!bl) {
                        try {
                            persistence.removeEntry(string);
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        this.resumeMessageManager();
                        this._context.log("Deactivate", "Fail to save aglet [" + string + "]");
                    }
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.flush();
                            objectOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    persistence.removeEntry(string);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.resumeMessageManager();
                this._context.log("Deactivate", "Fail to save aglet [" + string + "]");
            }
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            this._state = 2;
            this._mode = 0;
            if (messageImpl != null && messageImpl.future != null) {
                messageImpl.future.sendReplyIfNeeded(null);
            }
            this.messageManager.deactivate();
            this.terminateThreads();
            this._hasSnapshot = false;
            this.aglet = null;
            try {
                this._context.log("Deactivate", string);
                this._context.postEvent(new ContextEvent(1008, this._context, this.proxy), true);
                Object var18_22 = null;
                this.resourceManager.disposeAllResources();
                this.resourceManager.stopThreadGroup();
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                this.resourceManager.disposeAllResources();
                this.resourceManager.stopThreadGroup();
                throw throwable;
            }
        }
    }

    public void delegateMessage(Message message) throws InvalidAgletException {
        Message message2 = message;
        synchronized (message2) {
            if (!(message instanceof MessageImpl) || !((MessageImpl)message).isDelegatable()) {
                throw new IllegalArgumentException("The message cannot be delegated " + message);
            }
            MessageManagerImpl messageManagerImpl = this.messageManager;
            this.checkValidation();
            MessageImpl messageImpl = (MessageImpl)message;
            MessageImpl messageImpl2 = (MessageImpl)messageImpl.clone();
            this.checkMessagePermissionAndProtection(messageImpl2);
            if (messageManagerImpl != null) {
                messageImpl.disable();
                messageManagerImpl.postMessage(messageImpl2);
            } else {
                messageImpl.cancel("Message Manager not found " + (this._state == 2 ? "[inactive]" : ""));
            }
        }
    }

    void destroyMessageManager() {
        this.messageManager.destroy();
    }

    protected void dispatch(Ticket ticket) throws IOException, RequestRefusedException {
        try {
            this.checkActive();
            this.checkAgletPermissionAndProtection(ACTION_DISPATCH);
            this.dispatch(AgletThread.getCurrentMessage(), ticket);
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new AgletsSecurityException("dispatch : " + invalidAgletException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatch(MessageImpl messageImpl, Ticket ticket) throws IOException, RequestRefusedException, InvalidAgletException {
        URL uRL = ticket.getDestination();
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Object object3;
            block17: {
                this.checkValidation();
                if (uRL.getRef() != null && !"".equals(uRL.getRef())) {
                    throw new MalformedURLException("MalformedURL in dispatchAglet:" + ticket);
                }
                try {
                    this.dispatchEvent(new MobilityEvent(1200, (AgletProxy)this.proxy, ticket));
                }
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.suspendMessageManager();
                boolean bl = false;
                try {
                    try {
                        object3 = MAFAgentSystem.getMAFAgentSystem(ticket);
                        if (object3 == null) {
                            throw new ServerNotFoundException(ticket.toString());
                        }
                        LocalAgletRef.removeAgletRef(this._name, this);
                        object2 = new AgletWriter();
                        ((AgletWriter)object2).writeInfo(this);
                        ((AgletWriter)object2).writeAglet(this);
                        byte[] byArray = ((AgletWriter)object2).getBytes();
                        String string = uRL.getFile();
                        if (string.startsWith("/")) {
                            string = string.substring(1);
                        }
                        ClassName[] classNameArray = ((AgletWriter)object2).getClassNames();
                        String string2 = this.info.getCodeBase().toString();
                        MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getLocalMAFAgentSystem();
                        ((MAFAgentSystem)object3).receive_agent(this._name, _agent_profile, byArray, string, classNameArray, string2, mAFAgentSystem);
                        bl = true;
                    }
                    catch (ClassUnknown classUnknown) {
                        classUnknown.printStackTrace();
                        throw new RequestRefusedException(ticket + " " + this.info.getAgletClassName());
                    }
                    catch (DeserializationFailed deserializationFailed) {
                        throw new RequestRefusedException(ticket + " " + this.info.getAgletClassName());
                    }
                    catch (MAFExtendedException mAFExtendedException) {
                        mAFExtendedException.printStackTrace();
                        throw new RequestRefusedException(ticket + " " + this.info.getAgletClassName());
                    }
                    Object var14_18 = null;
                    if (bl) break block17;
                    this.resumeMessageManager();
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    if (bl) throw throwable;
                    this.resumeMessageManager();
                    LocalAgletRef.addAgletRef(this._name, this);
                    this._context.log("Dispatch", "Fail to dispatch " + this.info.getAgletClassName() + " to " + ticket);
                    throw throwable;
                }
                LocalAgletRef.addAgletRef(this._name, this);
                this._context.log("Dispatch", "Fail to dispatch " + this.info.getAgletClassName() + " to " + ticket);
            }
            this.invalidateReference();
            object3 = RemoteAgletRef.getAgletRef(ticket, this._name);
            ((RemoteAgletRef)object3).setAgletInfo(this.info);
            object2 = new AgletProxyImpl((AgletRef)object3);
            if (messageImpl != null && messageImpl.future != null) {
                messageImpl.future.sendReplyIfNeeded(object2);
            }
            this.removeSnapshot();
            this.terminateThreads();
            this.destroyMessageManager();
            try {
                this._context.log("Dispatch", this.info.getAgletClassName() + " to " + ticket.getDestination());
                this._context.postEvent(new ContextEvent(1005, this._context, (AgletProxy)object2, ticket.getDestination()), true);
                Object var16_21 = null;
                this.releaseResource();
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                this.releaseResource();
                throw throwable;
            }
            return;
        }
    }

    protected void dispatch(URL uRL) throws IOException, RequestRefusedException {
        this.dispatch(new Ticket(uRL));
    }

    public void dispatchEvent(AgletEvent agletEvent) {
        this.aglet.dispatchEvent(agletEvent);
    }

    protected void dispose() {
        try {
            this.checkActive();
            this.checkAgletPermissionAndProtection(ACTION_DISPOSE);
            this.dispose(AgletThread.getCurrentMessage());
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new AgletsSecurityException("dispose : " + invalidAgletException);
        }
        catch (RequestRefusedException requestRefusedException) {
            throw new AgletsSecurityException("dispose : " + requestRefusedException);
        }
    }

    void dispose(MessageImpl messageImpl) throws InvalidAgletException, RequestRefusedException {
        if (this.num_of_trial_to_dispose > 2 && this.isValid()) {
            this.disposeAnyway(messageImpl);
            return;
        }
        ++this.num_of_trial_to_dispose;
        Object object = this.lock;
        synchronized (object) {
            this.checkValidation();
            try {
                this.aglet.onDisposing();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.disposeAnyway(messageImpl);
                throw throwable;
            }
            this.disposeAnyway(messageImpl);
        }
    }

    private void disposeAnyway(MessageImpl messageImpl) throws RequestRefusedException {
        this.suspendMessageManager();
        this.invalidateReference();
        if (messageImpl != null && messageImpl.future != null) {
            messageImpl.future.sendReplyIfNeeded(null);
        }
        this.removeSnapshot();
        this.terminateThreads();
        this.destroyMessageManager();
        try {
            this._context.log("Dispose", this.info.getAgletClassName());
            this._context.postEvent(new ContextEvent(1004, this._context, this.proxy), true);
            Object var3_2 = null;
            this.releaseResource();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseResource();
            throw throwable;
        }
    }

    public String getAddress() throws InvalidAgletException {
        AgletContextImpl agletContextImpl = this._context;
        this.checkValidation();
        return agletContextImpl.getHostingURL().toString();
    }

    public Aglet getAglet() throws InvalidAgletException {
        this.checkValidation();
        this.checkMessagePermissionAndProtection("access");
        return this.aglet;
    }

    protected AgletContext getAgletContext() {
        this.checkActive();
        return this._context;
    }

    public AgletInfo getAgletInfo() {
        return this.info;
    }

    static LocalAgletRef getAgletRef(Name name) {
        return (LocalAgletRef)local_ref_table.get(new RefKey(name));
    }

    public Certificate getCertificate() throws InvalidAgletException {
        this.checkValidation();
        return this._owner;
    }

    protected MessageManager getMessageManager() {
        this.checkActive();
        return this.messageManager;
    }

    public Name getName() {
        return this._name;
    }

    private String getPersistenceKey() {
        return this.info.getAgletID().toString();
    }

    protected PermissionCollection getProtections() {
        return this.protections;
    }

    public Ref getRef(VirtualRef virtualRef) {
        return this;
    }

    public String getRefClassName() {
        return "com.ibm.aglets.RemoteAgletRef";
    }

    boolean getSecurity() {
        return this._secure;
    }

    String getStateAsString() {
        switch (this._state) {
            case 4: {
                return "INVALID";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "INACTIVE";
            }
        }
        return "DEFAULT";
    }

    public String getText() {
        this.checkActive();
        return this._text == null ? "" : this._text;
    }

    void invalidateReference() {
        this.unsubscribeAllMessages();
        this._state = 4;
        this._context.removeAgletProxy(this.info.getAgletID(), this.proxy);
        LocalAgletRef.removeAgletRef(this._name, this);
    }

    public boolean isActive() {
        return this._state == 1;
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isState(int n) {
        return (this._state & n) != 0;
    }

    public boolean isValid() {
        return this._state == 1 || this._state == 2;
    }

    protected void kill() {
        this.suspendMessageManager();
        switch (this._state) {
            case 1: {
                this.aglet = null;
                break;
            }
            case 2: {
                String string = this.getPersistenceKey();
                this._context._timer.removeInfo(string);
                try {
                    this._context.getPersistence().removeEntry(string);
                }
                catch (Exception exception) {}
                break;
            }
        }
        this.invalidateReference();
        this.removeSnapshot();
        this.terminateThreads();
        this.destroyMessageManager();
        try {
            this._context.log("Dispose", this.info.getAgletClassName());
            this._context.postEvent(new ContextEvent(1004, this._context, this.proxy), true);
            Object var4_3 = null;
            this.releaseResource();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseResource();
            throw throwable;
        }
    }

    public void referenced() {
    }

    void releaseResource() {
        this._context = null;
        this.aglet = null;
        this.messageManager = null;
        this.resourceManager.disposeAllResources();
        this.resourceManager.stopThreadGroup();
    }

    private static void removeAgletRef(Name name, LocalAgletRef localAgletRef) {
        if (local_ref_table.contains(localAgletRef)) {
            local_ref_table.remove(new RefKey(name));
        }
    }

    void removeSnapshot() {
        if (this._hasSnapshot) {
            this._hasSnapshot = false;
            try {
                this._context.getPersistence().removeEntry(this.getPersistenceKey());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resume() throws AgletNotFoundException, InvalidAgletException, ShuttingDownException {
        this._context.startCreation();
        var1_1 = this.lock;
        synchronized (var1_1) {
            block13: {
                this.checkValidation();
                if (this.isActive()) {
                    this._context.endCreation();
                    return;
                }
                if (this._mode != 1) {
                    throw new AgletNotFoundException("Cannot resume the deactivated aglet");
                }
                var2_2 = this.getPersistenceKey();
                try {
                    try {
                        this.messageManager.state = 0;
                        this.startResumedAglet();
                        this._context.log("Activated", this.info.getAgletClassName());
                        var5_3 = null;
                    }
                    catch (InvalidAgletException var3_9) {
                        var3_9.printStackTrace();
                        throw new AgletNotFoundException(var2_2);
                    }
                }
                catch (Throwable var4_10) {
                    var5_4 = null;
                    try {
                        this._context._timer.removeInfo(var2_2);
                        v0 = null;
                    }
                    catch (Throwable var6_6) {
                        v0 = null;
                    }
                    var7_8 = v0;
                    this._context.endCreation();
                    throw var4_10;
                }
                ** try [egrp 3[TRYBLOCK] [2 : 117->134)] { 
lbl37:
                // 1 sources

                this._context._timer.removeInfo(var2_2);
                v1 = null;
                break block13;
lbl40:
                // 1 sources

                catch (Throwable var6_5) {
                    v1 = null;
                }
            }
            var7_7 = v1;
            this._context.endCreation();
            return;
        }
    }

    void resumeMessageManager() {
        this.messageManager.resume();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] retract() throws MAFExtendedException {
        boolean bl = false;
        String string = this.info.getAgletClassName();
        try {
            byte[] byArray;
            block12: {
                try {
                    this.checkAgletPermissionAndProtection(ACTION_RETRACT);
                    SystemMessage systemMessage = new SystemMessage("_revert", null, 12);
                    FutureReply futureReply = this.sendFutureMessage(systemMessage);
                    futureReply.waitForReply(50000L);
                    if (futureReply.isAvailable()) {
                        try {
                            futureReply.getReply();
                        }
                        catch (MessageException messageException) {
                            if (messageException.getException() instanceof SecurityException) {
                                throw (SecurityException)messageException.getException();
                            }
                            messageException.printStackTrace();
                        }
                        catch (NotHandledException notHandledException) {
                            // empty catch block
                        }
                    }
                    this.checkValidation();
                    AgletWriter agletWriter = new AgletWriter();
                    agletWriter.writeInfo(this);
                    agletWriter.writeAglet(this);
                    byte[] byArray2 = agletWriter.getBytes();
                    this.invalidateReference();
                    this.removeSnapshot();
                    this.terminateThreads();
                    this.destroyMessageManager();
                    bl = true;
                    this._context.postEvent(new ContextEvent(1006, this, this.proxy, null), true);
                    byArray = byArray2;
                    Object var9_13 = null;
                    if (!bl) break block12;
                }
                catch (SecurityException securityException) {
                    throw new MAFExtendedException(LocalAgletRef.toMessage(securityException));
                }
                catch (IOException iOException) {
                    throw new MAFExtendedException(LocalAgletRef.toMessage(iOException));
                }
                catch (InvalidAgletException invalidAgletException) {
                    throw new MAFExtendedException(LocalAgletRef.toMessage(invalidAgletException));
                }
                this._context.log("Reverted", string);
                this.releaseResource();
                return byArray;
            }
            this._context.log("Reverted", "Failed to revert " + string);
            this.resumeMessageManager();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (bl) {
                this._context.log("Reverted", string);
                this.releaseResource();
                throw throwable;
            }
            this._context.log("Reverted", "Failed to revert " + string);
            this.resumeMessageManager();
            throw throwable;
        }
    }

    public FutureReply sendFutureMessage(Message message) throws InvalidAgletException {
        FutureReplyImpl futureReplyImpl = new FutureReplyImpl();
        this.sendFutureMessage(message, futureReplyImpl);
        return futureReplyImpl;
    }

    void sendFutureMessage(Message message, FutureReplyImpl futureReplyImpl) throws InvalidAgletException {
        MessageManagerImpl messageManagerImpl = this.messageManager;
        this.checkValidation();
        MessageImpl messageImpl = this.cloneMessageAndCheck(message, 1);
        messageImpl.future = futureReplyImpl;
        messageManagerImpl.postMessage(messageImpl);
    }

    public Object sendMessage(Message message) throws MessageException, InvalidAgletException, NotHandledException {
        MessageManagerImpl messageManagerImpl = this.messageManager;
        this.checkValidation();
        FutureReplyImpl futureReplyImpl = new FutureReplyImpl();
        MessageImpl messageImpl = this.cloneMessageAndCheck(message, 0);
        messageImpl.future = futureReplyImpl;
        messageManagerImpl.postMessage(messageImpl);
        return futureReplyImpl.getReply();
    }

    public void sendOnewayMessage(Message message) throws InvalidAgletException {
        MessageManagerImpl messageManagerImpl = this.messageManager;
        this.checkValidation();
        FutureReplyImpl futureReplyImpl = new FutureReplyImpl();
        MessageImpl messageImpl = this.cloneMessageAndCheck(message, 2);
        messageImpl.future = futureReplyImpl;
        messageManagerImpl.pushMessage(messageImpl);
    }

    protected void setAglet(Aglet aglet) {
        PermissionCollection permissionCollection;
        if (aglet != null) {
            new IllegalAccessError("Aglet canont be set twice");
        }
        this.aglet = aglet;
        final Class<?> clazz = this.aglet.getClass();
        ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getProtectionDomain();
            }
        });
        if (protectionDomain != null && this.protections == null && (permissionCollection = protectionDomain.getPermissions()) != null) {
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = enumeration.nextElement();
                if (!(permission instanceof Protection)) continue;
                if (this.protections == null) {
                    this.protections = new Protections();
                }
                this.protections.add(permission);
            }
        }
    }

    void setMessageManager(MessageManagerImpl messageManagerImpl) {
        this.messageManager = messageManagerImpl;
        this.messageManager.setAgletRef(this);
    }

    void setName(Name name) {
        this._name = name;
        this._owner = AgletRuntime.getCertificate(this._name.authority);
    }

    protected void setProtections(PermissionCollection permissionCollection) {
        Protections protections;
        if (this.canSetProtections(permissionCollection)) {
            protections = new Protections();
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = enumeration.nextElement();
                protections.add(permission);
            }
        } else {
            throw new IllegalArgumentException("cannot moderate protection");
        }
        this.protections = protections;
    }

    public void setRef(VirtualRef virtualRef, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new RuntimeException("Should Not Called");
    }

    void setSecurity(boolean bl) {
        this._secure = bl;
    }

    protected void setText(String string) {
        this.checkActive();
        this._text = string;
        this._context.postEvent(new ContextEvent(1012, this._context, this.proxy, string), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void snapshot() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkActive();
            ObjectOutputStream objectOutputStream = null;
            Persistence persistence = this._context.getPersistence();
            this.suspendMessageManager();
            String string = this.getPersistenceKey();
            boolean bl = false;
            try {
                try {
                    PersistentEntry persistentEntry = persistence.createEntryWith(string);
                    objectOutputStream = new ObjectOutputStream(persistentEntry.getOutputStream());
                    this.writeDeactivatedAglet(objectOutputStream, new DeactivationInfo(this._name, -1L, string, 0));
                    this._hasSnapshot = true;
                    bl = true;
                }
                catch (IOException iOException) {
                    try {
                        persistence.removeEntry(string);
                        throw iOException;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    try {
                        persistence.removeEntry(string);
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw runtimeException;
                }
                Object var10_8 = null;
                this.resumeMessageManager();
                if (bl) {
                    this._context.log("Snapshot", string);
                } else {
                    this._context.log("Snapshot", "Fail to save snapshot for aglet [" + string + "]");
                }
                if (objectOutputStream == null) return;
                {
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                this.resumeMessageManager();
                if (bl) {
                    this._context.log("Snapshot", string);
                } else {
                    this._context.log("Snapshot", "Fail to save snapshot for aglet [" + string + "]");
                }
                if (objectOutputStream == null) throw throwable;
                try {
                    objectOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            objectOutputStream.close();
            return;
        }
    }

    void startActivatedAglet() throws InvalidAgletException {
        this._state = 1;
        this.messageManager.postMessage(new EventMessage(new PersistencyEvent(1301, this.proxy, 0L)));
        this.messageManager.postMessage(new SystemMessage(7, null));
        this._context.postEvent(new ContextEvent(1010, this._context, this.proxy), true);
        this.resumeMessageManager();
    }

    void startArrivedAglet(AgletContextImpl agletContextImpl, String string) throws InvalidAgletException {
        this.validate(agletContextImpl, 1);
        this.messageManager.postMessage(new EventMessage(new MobilityEvent(1202, (AgletProxy)this.proxy, this._context.getHostingURL())));
        this.messageManager.postMessage(new SystemMessage(7, null));
        this._context.postEvent(new ContextEvent(1007, agletContextImpl, this.proxy, string), true);
        this.resumeMessageManager();
    }

    void startClonedAglet(AgletContextImpl agletContextImpl, AgletProxyImpl agletProxyImpl) throws InvalidAgletException {
        this.validate(agletContextImpl, 1);
        this.messageManager.postMessage(new EventMessage(new CloneEvent(1101, this.proxy)));
        this.messageManager.postMessage(new SystemMessage(7, null));
        this._context.postEvent(new ContextEvent(1003, agletContextImpl, this.proxy, agletProxyImpl), true);
        this.resumeMessageManager();
    }

    void startCreatedAglet(AgletContextImpl agletContextImpl, Object object) throws InvalidAgletException {
        this.validate(agletContextImpl, 1);
        this.messageManager = new MessageManagerImpl(this);
        this.messageManager.postMessage(new SystemMessage(2, object));
        this.messageManager.postMessage(new SystemMessage(7, null));
        this._context.postEvent(new ContextEvent(1002, agletContextImpl, this.proxy), true);
        this.startMessageManager();
    }

    void startMessageManager() {
        this.messageManager.start();
    }

    void startResumedAglet() throws InvalidAgletException {
        this._state = 1;
        this.messageManager.postMessage(new SystemMessage(7, null));
        this._context.postEvent(new ContextEvent(1011, this._context, this.proxy), true);
        this.resumeMessageManager();
    }

    protected void subscribeMessage(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.checkActive();
            this.checkPermission(new ContextPermission(string, "subscribe"));
            this._context._subscriberManager.subscribe(this, string);
        }
    }

    protected void suspend(long l) throws InvalidAgletException {
        try {
            this.checkActive();
            this.checkAgletPermissionAndProtection(ACTION_DEACTIVATE);
            this.suspend(AgletThread.getCurrentMessage(), l);
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new AgletsSecurityException("deactivate : " + invalidAgletException);
        }
        catch (RequestRefusedException requestRefusedException) {
            throw new AgletsSecurityException("deactivate : " + requestRefusedException);
        }
    }

    void suspend(MessageImpl messageImpl, long l) throws InvalidAgletException, RequestRefusedException {
        Object object = this.lock;
        synchronized (object) {
            this.checkValidation();
            if (l < 0L) {
                throw new IllegalArgumentException("minutes must be positive");
            }
            this.suspendMessageManager();
            String string = this.getPersistenceKey();
            long l2 = l == 0L ? 0L : System.currentTimeMillis() + l;
            DeactivationInfo deactivationInfo = new DeactivationInfo(this._name, l2, string, 1);
            this._context._timer.add(deactivationInfo);
            this._state = 2;
            this._mode = 1;
            if (messageImpl != null && messageImpl.future != null) {
                messageImpl.future.sendReplyIfNeeded(null);
            }
            this.messageManager.deactivate();
            this.terminateThreads();
            try {
                this._context.log("Suspend", string);
                this._context.postEvent(new ContextEvent(1009, this._context, this.proxy), true);
                Object var10_7 = null;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                throw throwable;
            }
        }
    }

    void suspendForRetraction(Ticket ticket) throws InvalidAgletException {
        Object object = this.lock;
        synchronized (object) {
            this.checkValidation();
            try {
                this.dispatchEvent(new MobilityEvent(1201, (AgletProxy)this.proxy, ticket));
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.suspendMessageManager();
        }
    }

    void suspendMessageManager() {
        this.messageManager.suspend();
    }

    void terminateThreads() {
        this.resourceManager.stopAllThreads();
    }

    static String toMessage(Exception exception) {
        return exception.getClass().getName() + ':' + exception.getMessage();
    }

    public String toString() {
        if (!this.isValid()) {
            return "Aglet [ invalid ]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._state == 1) {
            stringBuffer.append("Aglet [active]\n");
        } else if (this._state == 2) {
            stringBuffer.append("Aglet [inactive]\n");
        }
        String string = this._owner == null ? "ANONYMOUS" : ((X509Certificate)this._owner).getSubjectDN().getName();
        stringBuffer.append("      ClassName [" + this.info.getAgletClassName() + "]\n");
        stringBuffer.append("      Identifier[" + this.info.getAgletID() + "]\n");
        stringBuffer.append("      Owner[" + string + "]\n");
        stringBuffer.append("      CodeBase[" + this.info.getCodeBase() + "]\n");
        stringBuffer.append(this.resourceManager.toString());
        return stringBuffer.toString();
    }

    public void unreferenced() {
    }

    protected void unsubscribeAllMessages() {
        Object object = this.lock;
        synchronized (object) {
            this.checkActive();
            this._context._subscriberManager.unsubscribeAll(this);
        }
    }

    protected boolean unsubscribeMessage(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.checkActive();
            boolean bl = this._context._subscriberManager.unsubscribe(this, string);
            return bl;
        }
    }

    void validate(AgletContextImpl agletContextImpl, int n) throws InvalidAgletException {
        if (this.isValid()) {
            throw new IllegalAccessError("Aglet is already validated");
        }
        this._state = n;
        this._context = agletContextImpl;
        this._context.addAgletProxy(this.info.getAgletID(), this.proxy);
        LocalAgletRef.addAgletRef(this._name, this);
    }

    private void writeDeactivatedAglet(ObjectOutputStream objectOutputStream, DeactivationInfo deactivationInfo) throws IOException {
        objectOutputStream.writeObject(deactivationInfo);
        objectOutputStream.writeObject(this.messageManager);
        AgletWriter agletWriter = new AgletWriter();
        agletWriter.writeInfo(this);
        agletWriter.writeAglet(this);
        objectOutputStream.writeObject(agletWriter.getClassNames());
        byte[] byArray = agletWriter.getBytes();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
    }

    public void writeInfo(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this._name);
        objectOutputStream.writeObject(this._context.getHostingURL().toString());
    }

    static {
        _agent_profile = new AgentProfile(1, 1, "Aglets", 0, 2, 1, null);
        local_ref_table = new Hashtable();
    }

    static class RefKey {
        Name name;
        int hash = 0;

        RefKey(Name name) {
            this.name = name;
            int n = 0;
            while (n < name.identity.length) {
                this.hash += this.hash * 37 + name.identity[n];
                ++n;
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof RefKey) {
                return RefKey.equals(((RefKey)object).name, this.name);
            }
            return false;
        }

        public static boolean equals(Name name, Name name2) {
            if (name.identity.length == name2.identity.length && name.agent_system_type == name2.agent_system_type) {
                int n = name.identity.length;
                int n2 = 0;
                while (n2 < n) {
                    if (name.identity[n2] != name2.identity[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }
    }
}

