/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglets.AgletContextImpl;
import com.ibm.aglets.FutureReplyImpl;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MAF;
import com.ibm.aglets.MessageBroker;
import com.ibm.aglets.MessageInputStream;
import com.ibm.aglets.MessageOutputStream;
import com.ibm.aglets.RemoteFutureReplyImpl;
import com.ibm.aglets.ResourceManager;
import com.ibm.aglets.ResourceManagerFactory;
import com.ibm.awb.misc.CGIMessage;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.AgentIsRunning;
import com.ibm.maf.AgentIsSuspended;
import com.ibm.maf.AgentNotFound;
import com.ibm.maf.AgentProfile;
import com.ibm.maf.AgentStatus;
import com.ibm.maf.AgentSystemInfo;
import com.ibm.maf.ArgumentInvalid;
import com.ibm.maf.AuthInfo;
import com.ibm.maf.ClassName;
import com.ibm.maf.ClassUnknown;
import com.ibm.maf.DeserializationFailed;
import com.ibm.maf.EntryNotFound;
import com.ibm.maf.FinderNotFound;
import com.ibm.maf.LanguageMap;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MAFFinder;
import com.ibm.maf.MessageEx;
import com.ibm.maf.Name;
import com.ibm.maf.NotHandled;
import com.ibm.maf.ResumeFailed;
import com.ibm.maf.SuspendFailed;
import com.ibm.maf.TerminateFailed;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OptionalDataException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class MAFAgentSystem_AgletsImpl
extends MAFAgentSystem {
    static final short AGLETS = 1;
    static final short JAVA = 1;
    static final short JAVA_SERIALIZATION = 1;
    private static LanguageMap[] map = new LanguageMap[1];
    private static String agletsPublicRoot;
    private static String[][] agletsPublicAliases;
    private static final String ALIASES_SEP = " -> ";
    private static String _finder_host;
    private static String _finder_port;
    private static String _finder_name;
    private static MAFFinder _finder;
    private AgletRuntime _runtime = null;
    private AgentSystemInfo _agent_system_info = null;
    private String _address;
    String export_dir = "";

    public MAFAgentSystem_AgletsImpl(AgletRuntime agletRuntime) {
        Name name = MAF.toAgentSystemName(this, agletRuntime.getOwnerCertificate());
        this._agent_system_info = new AgentSystemInfo(name, 1, map, "Aglets Server beta2", 0, 2, null);
        this._runtime = agletRuntime;
    }

    private void checkProfile(AgentProfile agentProfile) throws MAFExtendedException {
        if (this._agent_system_info.agent_system_type == agentProfile.agent_system_type) {
            int n = 0;
            while (n < map.length) {
                if (MAFAgentSystem_AgletsImpl.map[n].language_id == agentProfile.language_id) {
                    int n2 = 0;
                    while (n2 < MAFAgentSystem_AgletsImpl.map[n].serializations.length) {
                        if (MAFAgentSystem_AgletsImpl.map[n].serializations[n2] == agentProfile.serialization) {
                            return;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        throw new MAFExtendedException("AgentProfile doesn't match");
    }

    public Name create_agent(Name name, AgentProfile agentProfile, byte[] byArray, String string, Object[] objectArray, ClassName[] classNameArray, String string2, MAFAgentSystem mAFAgentSystem) throws ClassUnknown, ArgumentInvalid, DeserializationFailed, MAFExtendedException {
        this.checkProfile(agentProfile);
        AgletContext agletContext = this._runtime.getAgletContext(string);
        if (agletContext == null) {
            throw new MAFExtendedException("Context Not Found:" + string);
        }
        try {
            URL uRL = string2 == null ? null : new URL(string2);
            AgletProxy agletProxy = agletContext.createAglet(uRL, classNameArray[0].name, objectArray[0]);
            return new Name(name.authority, agletProxy.getAgletID().toByteArray(), name.agent_system_type);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MAFExtendedException("Invalid CodeBase:" + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassUnknown("Class Not Found:" + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new MAFExtendedException("IO Failed:" + iOException.getMessage());
        }
        catch (AgletException agletException) {
            agletException.printStackTrace();
            throw new MAFExtendedException("Aglet Exception:" + agletException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new MAFExtendedException("Instantiation Failed:" + instantiationException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public byte[][] fetch_class(ClassName[] classNameArray, String string, AgentProfile agentProfile) throws ClassUnknown, MAFExtendedException {
        this.checkProfile(agentProfile);
        try {
            String string2 = this.getLocalFile(string);
            String string3 = this.getFileName(string2);
            if (classNameArray != null) {
                if (classNameArray.length != 1) {
                    throw new MAFExtendedException("Multiple classes not supported");
                }
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                string3 = string3 + classNameArray[0];
            }
            byte[][] byArrayArray = new byte[][]{this.readData(string3)};
            return byArrayArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ClassUnknown("Codebase Invalid:" + string);
        }
    }

    public String find_nearby_agent_system_of_profile(AgentProfile agentProfile) throws EntryNotFound {
        try {
            this.checkProfile(agentProfile);
        }
        catch (MAFExtendedException mAFExtendedException) {
            throw new EntryNotFound("MAFExtendedException ex");
        }
        return "";
    }

    public AgentStatus get_agent_status(Name name) throws AgentNotFound {
        return null;
    }

    public AgentSystemInfo get_agent_system_info() {
        return this._agent_system_info;
    }

    public AuthInfo get_authinfo(Name name) throws AgentNotFound {
        return null;
    }

    public MAFFinder get_MAFFinder() throws FinderNotFound {
        if (_finder == null && _finder_host != null) {
            try {
                _finder = (MAFFinder)Naming.lookup("rmi://" + _finder_host + ":" + _finder_port + "/" + _finder_name);
            }
            catch (Exception exception) {
                throw new FinderNotFound();
            }
        }
        return _finder;
    }

    public String getAddress() {
        return this._address;
    }

    private AgletContextImpl getAgletContext(Name name) {
        if (name == null) {
            return null;
        }
        byte[] byArray = name.authority;
        if (byArray != null && byArray.length > 0) {
            return null;
        }
        String string = null;
        try {
            byte[] byArray2 = name.identity;
            string = new String(byArray2);
        }
        catch (Exception exception) {
            return null;
        }
        return (AgletContextImpl)this._runtime.getAgletContext(string);
    }

    private String getFileName(String string) {
        String string2 = this.getResolvedName(string);
        return string2.replace('/', File.separatorChar);
    }

    private LocalAgletRef getLocalAgletRef(Name name) throws AgentNotFound {
        LocalAgletRef localAgletRef = LocalAgletRef.getAgletRef(name);
        if (localAgletRef == null) {
            throw new AgentNotFound("NotFound");
        }
        return localAgletRef;
    }

    private String getLocalFile(String string) throws ClassUnknown {
        try {
            return new URL(string).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassUnknown("Codebase Invalid:" + string);
        }
    }

    private String getResolvedName(String string) {
        if (agletsPublicAliases != null) {
            int n = 0;
            while (n < agletsPublicAliases.length) {
                String string2 = agletsPublicAliases[n][0];
                String string3 = agletsPublicAliases[n][1];
                if (string.startsWith(string2)) {
                    string = string.substring(string2.length());
                    return string3 + string;
                }
                ++n;
            }
        }
        return agletsPublicRoot + string;
    }

    public Name[] list_all_agents() {
        return null;
    }

    public Name[] list_all_agents_of_authority(byte[] byArray) {
        return null;
    }

    public String[] list_all_places() {
        AgletContext[] agletContextArray = this._runtime.getAgletContexts();
        String[] stringArray = new String[agletContextArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = agletContextArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    private byte[] readData(String string) throws IOException {
        final String string2 = string;
        final File file = new File(string);
        try {
            return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (!file.exists()) {
                        throw new IOException("FileNotFound: " + file);
                    }
                    if (!file.canRead()) {
                        throw new IOException("FileNotReadable: " + file);
                    }
                    int n = (int)file.length();
                    byte[] byArray = new byte[n];
                    FileInputStream fileInputStream = new FileInputStream(string2);
                    int n2 = 0;
                    while (n > 0) {
                        int n3 = fileInputStream.read(byArray, n2, n);
                        n2 += n3;
                        n -= n3;
                    }
                    fileInputStream.close();
                    return byArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void receive_agent(Name name, AgentProfile agentProfile, byte[] byArray, String string, ClassName[] classNameArray, String string2, MAFAgentSystem mAFAgentSystem) throws ClassUnknown, DeserializationFailed, MAFExtendedException {
        block4: {
            this.checkProfile(agentProfile);
            final AgletContextImpl agletContextImpl = (AgletContextImpl)this._runtime.getAgletContext(string);
            if (agletContextImpl == null) {
                System.out.println("Place not found " + string);
                throw new MAFExtendedException("Place not found");
            }
            final Name name2 = name;
            final ClassName[] classNameArray2 = classNameArray;
            final String string3 = string2;
            final byte[] byArray2 = byArray;
            final String string4 = mAFAgentSystem.getAddress();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        agletContextImpl.receiveAglet(name2, classNameArray2, string3, byArray2, string4);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw new ClassUnknown("Class Not Found:" + exception.getMessage());
                }
                if (!(exception instanceof AgletException)) break block4;
                throw new MAFExtendedException("");
            }
        }
    }

    public long receive_future_message(Name name, byte[] byArray, MAFAgentSystem mAFAgentSystem) throws AgentNotFound, ClassUnknown, DeserializationFailed, MAFExtendedException {
        LocalAgletRef localAgletRef = this.getLocalAgletRef(name);
        long l = System.currentTimeMillis();
        try {
            Message message = (Message)MessageInputStream.toObject(localAgletRef.resourceManager, byArray);
            RemoteFutureReplyImpl remoteFutureReplyImpl = new RemoteFutureReplyImpl(mAFAgentSystem, localAgletRef.resourceManager, l);
            localAgletRef.sendFutureMessage(message, remoteFutureReplyImpl);
        }
        catch (OptionalDataException optionalDataException) {
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(optionalDataException));
        }
        catch (IOException iOException) {
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassUnknown(MAFAgentSystem_AgletsImpl.toMessage(classNotFoundException));
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new AgentNotFound(MAFAgentSystem_AgletsImpl.toMessage(invalidAgletException));
        }
        return l;
    }

    public void receive_future_reply(long l, byte[] byArray) throws EntryNotFound, ClassUnknown, DeserializationFailed, MAFExtendedException {
        Long l2 = new Long(l);
        ResourceManager resourceManager = MessageBroker.getResourceManager(l2);
        if (resourceManager == null) {
            throw new EntryNotFound("Invalid return id");
        }
        FutureReplyImpl futureReplyImpl = MessageBroker.getFutureReply(l2);
        try {
            Object[] objectArray = (Object[])MessageInputStream.toObject(resourceManager, byArray);
            switch ((Integer)objectArray[0]) {
                case 0: {
                    futureReplyImpl.sendReplyIfNeeded(objectArray[1]);
                    break;
                }
                case 1: {
                    MessageException messageException = (MessageException)objectArray[1];
                    futureReplyImpl.sendExceptionIfNeeded(messageException.getException());
                    break;
                }
                case 2: {
                    futureReplyImpl.cancel((String)objectArray[1]);
                }
            }
        }
        catch (OptionalDataException optionalDataException) {
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(optionalDataException));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassUnknown(MAFAgentSystem_AgletsImpl.toMessage(classNotFoundException));
        }
    }

    public byte[] receive_message(Name name, byte[] byArray) throws AgentNotFound, NotHandled, MessageEx, ClassUnknown, DeserializationFailed, MAFExtendedException {
        try {
            AgletContextImpl agletContextImpl = this.getAgletContext(name);
            if (agletContextImpl != null) {
                ResourceManagerFactory resourceManagerFactory = agletContextImpl.getResourceManagerFactory();
                ResourceManager resourceManager = resourceManagerFactory.getCurrentResourceManager();
                Message message = (Message)MessageInputStream.toObject(resourceManager, byArray);
                Object object = agletContextImpl.handleMessage(message);
                return MessageOutputStream.toByteArray(resourceManager, object);
            }
            LocalAgletRef localAgletRef = this.getLocalAgletRef(name);
            Message message = (Message)MessageInputStream.toObject(localAgletRef.resourceManager, byArray);
            if (message instanceof CGIMessage) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                message.setArg("cgi-response", byteArrayOutputStream);
                Object object = localAgletRef.sendMessage(message);
                return byteArrayOutputStream.toByteArray();
            }
            Object object = message.sameKind("_getAgletInfo") ? localAgletRef.getAgletInfo() : localAgletRef.sendMessage(message);
            return MessageOutputStream.toByteArray(localAgletRef.resourceManager, object);
        }
        catch (MessageException messageException) {
            throw new MessageEx(messageException.getMessage(), messageException.getException());
        }
        catch (NotHandledException notHandledException) {
            throw new NotHandled(MAFAgentSystem_AgletsImpl.toMessage(notHandledException));
        }
        catch (OptionalDataException optionalDataException) {
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(optionalDataException));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassUnknown(MAFAgentSystem_AgletsImpl.toMessage(classNotFoundException));
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new AgentNotFound(MAFAgentSystem_AgletsImpl.toMessage(invalidAgletException));
        }
    }

    public void receive_oneway_message(Name name, byte[] byArray) throws AgentNotFound, ClassUnknown, DeserializationFailed, MAFExtendedException {
        LocalAgletRef localAgletRef = this.getLocalAgletRef(name);
        try {
            Message message = (Message)MessageInputStream.toObject(localAgletRef.resourceManager, byArray);
            localAgletRef.sendOnewayMessage(message);
        }
        catch (OptionalDataException optionalDataException) {
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(optionalDataException));
        }
        catch (IOException iOException) {
            throw new DeserializationFailed(MAFAgentSystem_AgletsImpl.toMessage(iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassUnknown(MAFAgentSystem_AgletsImpl.toMessage(classNotFoundException));
        }
        catch (InvalidAgletException invalidAgletException) {
            throw new AgentNotFound(MAFAgentSystem_AgletsImpl.toMessage(invalidAgletException));
        }
    }

    public void resume_agent(Name name) throws AgentNotFound, ResumeFailed, AgentIsRunning {
    }

    public byte[] retract_agent(Name name) throws AgentNotFound, MAFExtendedException {
        LocalAgletRef localAgletRef = this.getLocalAgletRef(name);
        if (localAgletRef == null) {
            throw new AgentNotFound("NotFound");
        }
        return localAgletRef.retract();
    }

    public synchronized void setAddress(String string) {
        if (this._address != null) {
            throw new IllegalArgumentException("Address already set");
        }
        this._address = string;
    }

    public void suspend_agent(Name name) throws AgentNotFound, SuspendFailed, AgentIsSuspended {
    }

    public void terminate_agent(Name name) throws AgentNotFound, TerminateFailed {
    }

    static String toMessage(Exception exception) {
        return exception.getClass().getName() + ':' + exception.getMessage();
    }

    static {
        _finder_host = null;
        _finder_port = null;
        _finder_name = null;
        _finder = null;
        try {
            Resource resource = Resource.getResourceFor("aglets");
            short[] sArray = new short[]{1};
            MAFAgentSystem_AgletsImpl.map[0] = new LanguageMap(1, sArray);
            String string = resource.getString("aglets.public.root");
            if (string != null) {
                agletsPublicRoot = string;
            }
            agletsPublicAliases = null;
            String[] stringArray = resource.getStringArray("aglets.public.aliases", ",");
            if (stringArray != null && stringArray.length > 0) {
                agletsPublicAliases = new String[stringArray.length][];
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = stringArray[n].indexOf(ALIASES_SEP);
                    String string2 = stringArray[n].substring(0, n2);
                    String string3 = stringArray[n].substring(n2 + ALIASES_SEP.length());
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    if (!string3.endsWith(File.separator)) {
                        string3 = string3 + File.separator;
                    }
                    MAFAgentSystem_AgletsImpl.agletsPublicAliases[n] = new String[2];
                    MAFAgentSystem_AgletsImpl.agletsPublicAliases[n][0] = string2;
                    MAFAgentSystem_AgletsImpl.agletsPublicAliases[n][1] = string3;
                    ++n;
                }
            }
            Properties properties = System.getProperties();
            _finder_host = properties.getProperty("maf.finder.host", null);
            _finder_port = properties.getProperty("maf.finder.port", Integer.toString(4435));
            _finder_name = properties.getProperty("maf.finder.name", "MAFFinder");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

