/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.Ticket;
import com.ibm.aglets.AgletRuntime;
import com.ibm.aglets.FutureReplyImpl;
import com.ibm.aglets.MessageImpl;
import com.ibm.aglets.MessageInputStream;
import com.ibm.aglets.MessageOutputStream;
import com.ibm.aglets.ResourceManager;
import com.ibm.aglets.ResourceManagerFactory;
import com.ibm.maf.AgentNotFound;
import com.ibm.maf.ClassUnknown;
import com.ibm.maf.DeserializationFailed;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MessageEx;
import com.ibm.maf.Name;
import com.ibm.maf.NotHandled;
import java.io.IOException;
import java.io.OptionalDataException;
import java.net.UnknownHostException;
import java.util.Hashtable;

final class MessageBroker {
    static Hashtable replies = new Hashtable();
    static Hashtable rms = new Hashtable();
    static /* synthetic */ Class class$com$ibm$aglets$MessageBroker;

    MessageBroker() {
    }

    static void delegateMessage(Ticket ticket, Name name, Message message) throws InvalidAgletException {
        try {
            MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getMAFAgentSystem(ticket);
            ResourceManager resourceManager = MessageBroker.getCurrentResourceManager();
            Message message2 = message;
            synchronized (message2) {
                if (!(message instanceof MessageImpl) || !((MessageImpl)message).isDelegatable()) {
                    throw new IllegalArgumentException("The message cannot be delegated");
                }
                MessageImpl messageImpl = (MessageImpl)message;
                MessageImpl messageImpl2 = (MessageImpl)messageImpl.clone();
                FutureReplyImpl futureReplyImpl = messageImpl.future;
                byte[] byArray = MessageOutputStream.toByteArray(resourceManager, message);
                MAFAgentSystem mAFAgentSystem2 = MAFAgentSystem.getLocalMAFAgentSystem();
                long l = mAFAgentSystem.receive_future_message(name, byArray, mAFAgentSystem2);
                MessageBroker.waitFutureReply(futureReplyImpl, resourceManager, new Long(l));
                messageImpl.disable();
            }
        }
        catch (AgentNotFound agentNotFound) {
            throw new InvalidAgletException(MessageBroker.toMessage(agentNotFound));
        }
        catch (ClassUnknown classUnknown) {
            throw new InvalidAgletException(MessageBroker.toMessage(classUnknown));
        }
        catch (DeserializationFailed deserializationFailed) {
            throw new InvalidAgletException(MessageBroker.toMessage(deserializationFailed));
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidAgletException(MessageBroker.toMessage(unknownHostException));
        }
        catch (IOException iOException) {
            throw new InvalidAgletException(MessageBroker.toMessage(iOException));
        }
        catch (MAFExtendedException mAFExtendedException) {
            throw new InvalidAgletException(MessageBroker.toMessage(mAFExtendedException));
        }
    }

    private static String getContextName(Ticket ticket) {
        int n;
        if (ticket == null) {
            return null;
        }
        String string = ticket.getFile();
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.startsWith("/servlet")) {
            n = (string = string.substring(9)).indexOf(47, 1);
            if (n > 0) {
                string = string.substring(n);
            } else {
                return "";
            }
        }
        if (string.startsWith("/aglets")) {
            string = string.substring(7);
        }
        if ((string = (n = string.indexOf(47, 1)) > 0 ? string.substring(string.charAt(0) == '/' ? 1 : 0, n) : string.substring(string.charAt(0) == '/' ? 1 : 0)).equals("default") || string.equals("cxt")) {
            string = "";
        }
        return string;
    }

    private static ResourceManager getCurrentResourceManager() {
        ResourceManagerFactory resourceManagerFactory = AgletRuntime.getDefaultResourceManagerFactory();
        return resourceManagerFactory.getCurrentResourceManager();
    }

    static FutureReplyImpl getFutureReply(Long l) {
        return (FutureReplyImpl)replies.get(l);
    }

    static ResourceManager getResourceManager(Long l) {
        ResourceManager resourceManager;
        Class clazz = class$com$ibm$aglets$MessageBroker == null ? (class$com$ibm$aglets$MessageBroker = MessageBroker.class$("com.ibm.aglets.MessageBroker")) : class$com$ibm$aglets$MessageBroker;
        synchronized (clazz) {
            while ((resourceManager = (ResourceManager)rms.get(l)) == null) {
                try {
                    (class$com$ibm$aglets$MessageBroker == null ? MessageBroker.class$("com.ibm.aglets.MessageBroker") : class$com$ibm$aglets$MessageBroker).wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    ResourceManager resourceManager2 = null;
                    return resourceManager2;
                }
            }
        }
        return resourceManager;
    }

    static FutureReplyImpl sendFutureMessage(Ticket ticket, Name name, Message message) throws InvalidAgletException {
        try {
            MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getMAFAgentSystem(ticket);
            ResourceManager resourceManager = MessageBroker.getCurrentResourceManager();
            byte[] byArray = MessageOutputStream.toByteArray(resourceManager, message);
            MAFAgentSystem mAFAgentSystem2 = MAFAgentSystem.getLocalMAFAgentSystem();
            long l = mAFAgentSystem.receive_future_message(name, byArray, mAFAgentSystem2);
            FutureReplyImpl futureReplyImpl = new FutureReplyImpl();
            MessageBroker.waitFutureReply(futureReplyImpl, resourceManager, new Long(l));
            return futureReplyImpl;
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidAgletException(MessageBroker.toMessage(unknownHostException));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InvalidAgletException(MessageBroker.toMessage(iOException));
        }
        catch (AgentNotFound agentNotFound) {
            throw new InvalidAgletException(MessageBroker.toMessage(agentNotFound));
        }
        catch (ClassUnknown classUnknown) {
            throw new InvalidAgletException(MessageBroker.toMessage(classUnknown));
        }
        catch (DeserializationFailed deserializationFailed) {
            throw new InvalidAgletException(MessageBroker.toMessage(deserializationFailed));
        }
        catch (MAFExtendedException mAFExtendedException) {
            throw new InvalidAgletException(MessageBroker.toMessage(mAFExtendedException));
        }
    }

    static Object sendMessage(Ticket ticket, Name name, Message message) throws InvalidAgletException, MessageException, NotHandledException {
        try {
            Object object;
            MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getMAFAgentSystem(ticket);
            ResourceManager resourceManager = MessageBroker.getCurrentResourceManager();
            if (name == null) {
                object = MessageBroker.getContextName(ticket);
                name = new Name("".getBytes(), ((String)object).getBytes(), 1);
            }
            object = MessageOutputStream.toByteArray(resourceManager, message);
            byte[] byArray = mAFAgentSystem.receive_message(name, (byte[])object);
            return MessageInputStream.toObject(resourceManager, byArray);
        }
        catch (OptionalDataException optionalDataException) {
            optionalDataException.printStackTrace();
            throw new NotHandledException(MessageBroker.toMessage(optionalDataException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new NotHandledException(MessageBroker.toMessage(classNotFoundException));
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidAgletException(MessageBroker.toMessage(unknownHostException));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new NotHandledException(MessageBroker.toMessage(iOException));
        }
        catch (AgentNotFound agentNotFound) {
            throw new InvalidAgletException(MessageBroker.toMessage(agentNotFound));
        }
        catch (NotHandled notHandled) {
            throw new NotHandledException(MessageBroker.toMessage(notHandled));
        }
        catch (MessageEx messageEx) {
            throw new MessageException(messageEx.getException(), messageEx.getMessage());
        }
        catch (ClassUnknown classUnknown) {
            throw new NotHandledException(MessageBroker.toMessage(classUnknown));
        }
        catch (DeserializationFailed deserializationFailed) {
            throw new NotHandledException(MessageBroker.toMessage(deserializationFailed));
        }
        catch (MAFExtendedException mAFExtendedException) {
            throw new NotHandledException(MessageBroker.toMessage(mAFExtendedException));
        }
    }

    static void sendOnewayMessage(Ticket ticket, Name name, Message message) throws InvalidAgletException {
        try {
            MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getMAFAgentSystem(ticket);
            ResourceManager resourceManager = MessageBroker.getCurrentResourceManager();
            byte[] byArray = MessageOutputStream.toByteArray(resourceManager, message);
            mAFAgentSystem.receive_oneway_message(name, byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidAgletException(MessageBroker.toMessage(unknownHostException));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InvalidAgletException(MessageBroker.toMessage(iOException));
        }
        catch (AgentNotFound agentNotFound) {
            throw new InvalidAgletException(MessageBroker.toMessage(agentNotFound));
        }
        catch (ClassUnknown classUnknown) {
            throw new InvalidAgletException(MessageBroker.toMessage(classUnknown));
        }
        catch (DeserializationFailed deserializationFailed) {
            throw new InvalidAgletException(MessageBroker.toMessage(deserializationFailed));
        }
        catch (MAFExtendedException mAFExtendedException) {
            throw new InvalidAgletException(MessageBroker.toMessage(mAFExtendedException));
        }
    }

    static String toMessage(Exception exception) {
        return exception.getClass().getName() + ':' + exception.getMessage();
    }

    public static void waitFutureReply(FutureReplyImpl futureReplyImpl, ResourceManager resourceManager, Long l) {
        Class clazz = class$com$ibm$aglets$MessageBroker == null ? (class$com$ibm$aglets$MessageBroker = MessageBroker.class$("com.ibm.aglets.MessageBroker")) : class$com$ibm$aglets$MessageBroker;
        synchronized (clazz) {
            replies.put(l, futureReplyImpl);
            rms.put(l, resourceManager);
            (class$com$ibm$aglets$MessageBroker == null ? (class$com$ibm$aglets$MessageBroker = MessageBroker.class$("com.ibm.aglets.MessageBroker")) : class$com$ibm$aglets$MessageBroker).notify();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

