/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.security.MessageProtection;
import com.ibm.aglets.AgletThread;
import com.ibm.aglets.FutureReplyImpl;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MessageManagerImpl;
import com.ibm.aglets.security.MessagePermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

class MessageImpl
extends Message
implements Cloneable {
    transient FutureReplyImpl future = null;
    transient MessageImpl next = null;
    protected int priority = 5;
    private int msg_type;
    private boolean defered = false;
    protected transient boolean delegatable = false;
    transient AgletThread thread = null;
    boolean waiting = false;

    protected MessageImpl() {
        super(null, null);
        this.msg_type = 0;
        this.timestamp = System.currentTimeMillis();
    }

    public MessageImpl(Message message, FutureReplyImpl futureReplyImpl, int n, long l) {
        super(message.getKind(), message.getArg());
        this.future = futureReplyImpl;
        this.msg_type = n;
        this.timestamp = l;
    }

    protected MessageImpl(Object object) {
        super(null, object);
        this.msg_type = 0;
        this.timestamp = System.currentTimeMillis();
    }

    final void activate(MessageManagerImpl messageManagerImpl) {
        if (this.thread == null) {
            this.thread = messageManagerImpl.popThread();
            this.thread.handleMessage(this);
        } else {
            MessageImpl messageImpl = this;
            synchronized (messageImpl) {
                this.waiting = false;
                this.notifyAll();
            }
        }
    }

    final synchronized void cancel(String string) {
        if (this.future != null) {
            this.future.cancel(string);
        }
    }

    public Object clone() {
        MessageImpl messageImpl = new MessageImpl(this, this.future, this.msg_type, this.timestamp);
        messageImpl.priority = this.priority;
        return messageImpl;
    }

    final synchronized void destroy() {
        if (this.thread == Thread.currentThread()) {
            System.err.println("waring: tring to destroy itself");
        }
        if (this.waiting) {
            this.waiting = false;
            this.notifyAll();
            final AgletThread agletThread = this.thread;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    agletThread.stop();
                    agletThread.resume();
                    return null;
                }
            });
        }
        this.thread = null;
    }

    final void disable() {
        this.future = null;
        this.delegatable = false;
    }

    final synchronized void doWait() {
        while (this.waiting) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    final synchronized void doWait(long l) {
        if (l == 0L) {
            this.doWait();
        } else {
            long l2;
            long l3 = System.currentTimeMillis() + l;
            while (this.waiting && (l2 = l3 - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public final void enableDeferedReply(boolean bl) {
        this.defered = bl;
    }

    final void enableDelegation() {
        this.delegatable = true;
    }

    public final int getMessageType() {
        return this.msg_type;
    }

    Permission getPermission(String string) {
        return new MessagePermission(string, this.getKind());
    }

    Permission getProtection(String string) {
        return new MessageProtection(string, this.getKind());
    }

    void handle(LocalAgletRef localAgletRef) throws InvalidAgletException {
        block22: {
            FutureReplyImpl futureReplyImpl = this.future;
            Aglet aglet = localAgletRef.aglet;
            Object var4_4 = null;
            boolean bl = false;
            try {
                try {
                    bl = aglet.handleMessage(this);
                }
                catch (RuntimeException runtimeException) {
                    futureReplyImpl.sendExceptionIfNeeded(runtimeException);
                    runtimeException.printStackTrace();
                    Object var10_7 = null;
                    if (!this.delegatable) {
                        if (bl) {
                            if (!this.defered) {
                                futureReplyImpl.sendReplyIfNeeded(null);
                            }
                        } else {
                            futureReplyImpl.cancel(this.toString());
                        }
                    }
                    break block22;
                }
                catch (ThreadDeath threadDeath) {
                    futureReplyImpl.sendExceptionIfNeeded(threadDeath);
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    futureReplyImpl.sendExceptionIfNeeded(throwable);
                    throwable.printStackTrace();
                    Object var10_8 = null;
                    if (!this.delegatable) {
                        if (bl) {
                            if (!this.defered) {
                                futureReplyImpl.sendReplyIfNeeded(null);
                            }
                        } else {
                            futureReplyImpl.cancel(this.toString());
                        }
                    }
                }
                Object var10_6 = null;
                if (!this.delegatable) {
                    if (bl) {
                        if (!this.defered) {
                            futureReplyImpl.sendReplyIfNeeded(null);
                        }
                    } else {
                        futureReplyImpl.cancel(this.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (!this.delegatable) {
                    if (bl) {
                        if (!this.defered) {
                            futureReplyImpl.sendReplyIfNeeded(null);
                        }
                    } else {
                        futureReplyImpl.cancel(this.toString());
                    }
                }
                throw throwable;
            }
        }
    }

    boolean isDelegatable() {
        return this.delegatable && this.future != null && !this.future.available;
    }

    final boolean isWaiting() {
        return this.waiting;
    }

    public final void sendException(Exception exception) {
        this.future.setExceptionAndNotify(exception);
    }

    public final void sendReply() {
        this.future.setReplyAndNotify(null);
    }

    public final void sendReply(Object object) {
        this.future.setReplyAndNotify(object);
    }

    final void setWaiting() {
        this.waiting = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Message : kind = " + this.kind + ": arg = " + String.valueOf(this.arg) + ": priority = " + this.priority);
        if (this.waiting) {
            stringBuffer.append(" :waiting ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

