/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.MessageManager;
import com.ibm.aglets.AgletThread;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MessageImpl;
import com.ibm.aglets.MessageQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

final class MessageManagerImpl
implements MessageManager,
Serializable {
    public static final int REENTRANT_PRIORITY = 12;
    public static final int SYSTEM_PRIORITY = 11;
    public static final int REQUEST_PRIORITY = 10;
    static final int UNINITIALIZED = 0;
    static final int RUNNING = 1;
    static final int SUSPENDED = 2;
    static final int DEACTIVATED = 3;
    static final int DESTROYED = 4;
    private static String[] state_string = new String[]{"UNINITIALIZED", "RUNNING", "SUSPENDED", "DEACTIVATED", "DESTRYOED"};
    private transient MessageQueue message_queue = new MessageQueue();
    private transient MessageQueue waiting_queue = new MessageQueue();
    private static Hashtable defaultPriorityTable = null;
    private transient MessageImpl owner = null;
    private transient Stack threadSpool = new Stack();
    private transient LocalAgletRef ref;
    private Hashtable priorityTable = (Hashtable)defaultPriorityTable.clone();
    private Vector activationTable = null;
    int state = 0;

    MessageManagerImpl(LocalAgletRef localAgletRef) {
        this.ref = localAgletRef;
    }

    void cancelMessagesInMessageQueue() {
        MessageImpl messageImpl = this.message_queue.peek();
        while (messageImpl != null) {
            if (this.owner != messageImpl) {
                messageImpl.cancel("handler destroyed : message = " + messageImpl.toString());
                messageImpl.destroy();
            }
            messageImpl = messageImpl.next;
        }
        this.message_queue.removeAll();
    }

    void cancelMessagesInWaitingQueue() {
        MessageImpl messageImpl = this.waiting_queue.peek();
        while (messageImpl != null) {
            messageImpl.cancel("handler destroyed : message = " + messageImpl.toString());
            messageImpl.destroy();
            messageImpl = messageImpl.next;
        }
        this.waiting_queue.removeAll();
    }

    void cancelOwnerMessage() {
        if (this.owner != null && !this.isOwner()) {
            this.owner.cancel("handler destroyed : message = " + this.owner.toString());
            this.owner.destroy();
            this.owner = null;
        }
    }

    void deactivate() {
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (!this.isSuspended()) {
                throw new IllegalArgumentException("Cannot deactivate");
            }
            this.setState(3);
            this.cancelOwnerMessage();
            this.cancelMessagesInWaitingQueue();
        }
        this.cancelMessagesInMessageQueue();
        this.invalidateSpooledThreads();
    }

    public void destroy() {
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (this.isDestroyed()) {
                return;
            }
            this.setState(4);
            this.ref = null;
            this.cancelOwnerMessage();
            this.cancelMessagesInWaitingQueue();
        }
        this.cancelMessagesInMessageQueue();
        this.invalidateSpooledThreads();
    }

    public void exitMonitor() {
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (!this.isOwner()) {
                throw new IllegalMonitorStateException("Current thread is not owner " + Thread.currentThread() + " != " + this.owner);
            }
            this.processNextMessage();
        }
    }

    void exitMonitorIfOwner() {
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (this.isOwner()) {
                this.processNextMessage();
            }
        }
    }

    LocalAgletRef getAgletRef() {
        return this.ref;
    }

    private void invalidateSpooledThreads() {
        while (!this.threadSpool.empty()) {
            ((AgletThread)this.threadSpool.pop()).invalidate();
        }
    }

    public boolean isDeactivated() {
        return this.state == 3;
    }

    public boolean isDestroyed() {
        return this.state == 4;
    }

    boolean isOwner() {
        return this.owner != null && this.owner.thread == Thread.currentThread();
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    public boolean isSuspended() {
        return this.state == 2;
    }

    public boolean isUninitialized() {
        return this.state == 0;
    }

    void kill() {
        this.setState(4);
        this.ref = null;
        while (!this.threadSpool.empty()) {
            ((AgletThread)this.threadSpool.pop()).stop();
        }
    }

    public void notifyAllMessages() {
        MessageImpl messageImpl = null;
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (!this.isOwner()) {
                throw new IllegalMonitorStateException("Current thread is not owner");
            }
            messageImpl = this.owner;
            if (this.waiting_queue.peek() != null) {
                this.message_queue.insertAtTop(messageImpl);
                this.message_queue.insertAtTop(this.waiting_queue);
                this.waiting_queue.removeAll();
                messageImpl.setWaiting();
                this.processNextMessage();
            }
        }
        messageImpl.doWait();
    }

    public void notifyMessage() {
        MessageImpl messageImpl = null;
        MessageImpl messageImpl2 = null;
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (!this.isOwner()) {
                throw new IllegalMonitorStateException("Current thread is not owner");
            }
            messageImpl = this.owner;
            messageImpl2 = this.waiting_queue.pop();
            if (messageImpl2 != null) {
                this.message_queue.insertAtTop(messageImpl);
                this.message_queue.insertAtTop(messageImpl2);
                messageImpl.setWaiting();
                this.processNextMessage();
            }
        }
        messageImpl.doWait();
    }

    AgletThread popThread() {
        if (this.isDestroyed()) {
            System.out.println("should not happen");
            return null;
        }
        Stack stack = this.threadSpool;
        synchronized (stack) {
            if (this.threadSpool.empty()) {
                AgletThread agletThread = this.ref.resourceManager.newAgletThread(this);
                return agletThread;
            }
            AgletThread agletThread = (AgletThread)this.threadSpool.pop();
            return agletThread;
        }
    }

    void postMessage(MessageImpl messageImpl) {
        this.postMessage(messageImpl, false);
    }

    private void postMessage(MessageImpl messageImpl, boolean bl) {
        int n = 5;
        MessageImpl messageImpl2 = null;
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (this.isDestroyed()) {
                messageImpl.cancel("MessageManager destroyed : message = " + messageImpl.toString());
                return;
            }
            if (this.isDeactivated()) {
                if (this.activationTable != null && this.activationTable.contains(messageImpl.getKind())) {
                    try {
                        this.ref.activate();
                        messageImpl.enableDelegation();
                        this.ref.delegateMessage(messageImpl);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        messageImpl.cancel("MessageManager cannot activate aglet : message = " + messageImpl.toString());
                        return;
                    }
                } else {
                    messageImpl.cancel("MessageManager deactivated : message = " + messageImpl.toString());
                }
                return;
            }
            if (messageImpl.getKind() != null) {
                Object v = this.priorityTable.get(messageImpl.getKind());
                if (v instanceof Integer) {
                    n = (Integer)v;
                }
            } else {
                n = messageImpl.priority;
            }
            if (n < 0) {
                messageImpl.activate(this);
                return;
            }
            if (this.isOwner() && !bl) {
                messageImpl2 = this.owner;
                n = messageImpl2.priority;
                messageImpl2.priority = 12;
                this.message_queue.insertAtTop(messageImpl2);
                messageImpl.priority = 12;
                this.message_queue.insertAtTop(messageImpl);
                messageImpl2.setWaiting();
                this.processNextMessage();
            } else {
                messageImpl.priority = n;
                this.message_queue.insert(messageImpl);
                this.processNextMessageIfEmpty();
            }
        }
        if (messageImpl2 != null) {
            messageImpl2.doWait();
            messageImpl2.priority = n;
        }
    }

    private void processNextMessage() {
        if (!this.isRunning()) {
            return;
        }
        if (this.message_queue.peek() != null) {
            this.owner = this.message_queue.pop();
            this.owner.activate(this);
        } else {
            this.owner = null;
        }
    }

    private void processNextMessageIfEmpty() {
        if (this.owner == null) {
            this.processNextMessage();
        }
    }

    void pushMessage(MessageImpl messageImpl) {
        this.postMessage(messageImpl, true);
    }

    void pushThread(AgletThread agletThread) {
        Stack stack = this.threadSpool;
        synchronized (stack) {
            if (this.isDestroyed()) {
                agletThread.invalidate();
                return;
            }
            this.threadSpool.push(agletThread);
        }
    }

    void pushThreadAndExitMonitorIfOwner(AgletThread agletThread) {
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            this.pushThread(agletThread);
            if (this.isOwner()) {
                this.processNextMessage();
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.threadSpool = new Stack();
        this.message_queue = new MessageQueue();
        this.waiting_queue = new MessageQueue();
    }

    void removeThread(AgletThread agletThread) {
        this.threadSpool.removeElement(agletThread);
    }

    public void resume() {
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (this.isRunning() || this.isDestroyed()) {
                return;
            }
            this.setState(1);
            this.ref.resourceManager.resumeAllThreads();
            this.processNextMessage();
        }
    }

    void setAgletRef(LocalAgletRef localAgletRef) {
        this.ref = localAgletRef;
    }

    public void setPriority(String string, int n) {
        if ((n & 0x10) == 16) {
            if (this.activationTable == null) {
                this.activationTable = new Vector();
            }
            if (!this.activationTable.contains(string)) {
                this.activationTable.addElement(string);
            }
            if ((n &= 0xF) == 0) {
                return;
            }
        }
        if (n != 11 && (n < 1 || n > 10)) {
            throw new IllegalArgumentException("illegal priority");
        }
        this.priorityTable.put(string, new Integer(n));
    }

    void setState(int n) {
        switch (this.state) {
            case 0: {
                if (n != 1 && n != 3) break;
                this.state = n;
                return;
            }
            case 1: {
                if (n != 2) break;
                this.state = n;
                return;
            }
            case 2: {
                if (n != 4 && n != 1 && n != 3) break;
                this.state = n;
                return;
            }
            case 3: {
                if (n != 1) break;
                this.state = n;
                return;
            }
        }
        throw new IllegalArgumentException("Cannot proceed from " + state_string[this.state] + " to " + state_string[n]);
    }

    void start() {
        if (!this.isUninitialized()) {
            throw new IllegalMonitorStateException("MessageManager not valid");
        }
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            this.setState(1);
            this.processNextMessageIfEmpty();
        }
    }

    public void suspend() {
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (this.isSuspended() || this.isDestroyed()) {
                return;
            }
            this.setState(2);
            this.ref.resourceManager.suspendAllThreads();
        }
    }

    public String toString() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("Active queue\n");
        MessageImpl messageImpl = this.message_queue.peek();
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            n = 1;
            while (messageImpl != null) {
                stringBuffer.append(String.valueOf(n++));
                stringBuffer.append(":");
                stringBuffer.append(messageImpl.toString());
                stringBuffer.append("\n");
                messageImpl = messageImpl.next;
            }
            messageImpl = this.waiting_queue.peek();
            stringBuffer.append("Waiting queue\n");
            n = 1;
            while (messageImpl != null) {
                stringBuffer.append(String.valueOf(n++));
                stringBuffer.append(":");
                stringBuffer.append(messageImpl.toString());
                stringBuffer.append("\n");
                messageImpl = messageImpl.next;
            }
        }
        return stringBuffer.toString();
    }

    public void waitMessage() {
        this.waitMessage(0L);
    }

    public void waitMessage(long l) {
        MessageImpl messageImpl = null;
        MessageQueue messageQueue = this.message_queue;
        synchronized (messageQueue) {
            if (!this.isOwner()) {
                throw new IllegalMonitorStateException("Current thread is not owner");
            }
            messageImpl = this.owner;
            this.waiting_queue.append(messageImpl);
            messageImpl.setWaiting();
            this.processNextMessage();
        }
        if (l == 0L) {
            messageImpl.doWait();
        } else {
            messageImpl.doWait(l);
            MessageQueue messageQueue2 = this.message_queue;
            synchronized (messageQueue2) {
                if (messageImpl.isWaiting()) {
                    this.waiting_queue.remove(messageImpl);
                    this.message_queue.insertAtTop(messageImpl);
                    this.processNextMessageIfEmpty();
                }
            }
            messageImpl.doWait();
        }
    }

    static {
        defaultPriorityTable = new Hashtable();
        defaultPriorityTable.put("_clone", new Integer(10));
        defaultPriorityTable.put("_dispose", new Integer(10));
        defaultPriorityTable.put("_dispatch", new Integer(10));
        defaultPriorityTable.put("_deactivate", new Integer(10));
        defaultPriorityTable.put("_revert", new Integer(10));
    }
}

