/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglets.MessageImpl;

final class MessageQueue {
    private MessageImpl head;
    private MessageImpl tail;

    MessageQueue() {
        this.tail = this.head = new MessageImpl();
    }

    void append(MessageImpl messageImpl) {
        messageImpl.next = null;
        this.tail.next = messageImpl;
        this.tail = messageImpl;
    }

    void insert(MessageImpl messageImpl) {
        MessageImpl messageImpl2 = this.head;
        while (messageImpl2.next != null && messageImpl2.next.priority >= messageImpl.priority) {
            messageImpl2 = messageImpl2.next;
        }
        messageImpl.next = messageImpl2.next;
        messageImpl2.next = messageImpl;
    }

    void insertAtTop(MessageImpl messageImpl) {
        messageImpl.next = this.head.next;
        this.head.next = messageImpl;
    }

    void insertAtTop(MessageQueue messageQueue) {
        if (messageQueue.head.next != null) {
            messageQueue.tail.next = this.head.next;
            this.head.next = messageQueue.head.next;
        }
    }

    MessageImpl peek() {
        return this.head.next;
    }

    MessageImpl pop() {
        if (this.head.next != null) {
            MessageImpl messageImpl = this.head.next;
            this.head.next = messageImpl.next;
            messageImpl.next = null;
            if (this.tail == messageImpl) {
                this.tail = this.head;
            }
            return messageImpl;
        }
        return null;
    }

    void remove(MessageImpl messageImpl) {
        MessageImpl messageImpl2 = this.head;
        while (messageImpl2.next != null && messageImpl2.next != messageImpl) {
            messageImpl2 = messageImpl2.next;
        }
        if (messageImpl2.next == messageImpl) {
            messageImpl2.next = messageImpl.next;
        }
        messageImpl.next = null;
    }

    void removeAll() {
        this.head.next = null;
        this.tail = this.head;
    }

    public String toString() {
        MessageImpl messageImpl = this.head.next;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (messageImpl != null) {
            stringBuffer.append(String.valueOf(n++));
            stringBuffer.append(":");
            stringBuffer.append(messageImpl.toString());
            stringBuffer.append("\n");
            messageImpl = messageImpl.next;
        }
        return stringBuffer.toString();
    }
}

