/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.FutureReply;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.Ticket;
import com.ibm.aglets.AgletRef;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MessageBroker;
import com.ibm.awb.weakref.Ref;
import com.ibm.awb.weakref.WeakRef;
import com.ibm.awb.weakref.WeakRefTable;
import com.ibm.maf.Name;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URL;

public final class RemoteAgletRef
extends WeakRef
implements AgletRef {
    private static RemoteRefTable _table = new RemoteRefTable();
    private Ticket _ticket = null;
    private AgletInfo _info = null;
    private Name _name;
    static Message _get_info_message = new Message("_getAgletInfo");

    public RemoteAgletRef() {
        super(_table);
    }

    RemoteAgletRef(Ticket ticket, Name name) {
        super(_table);
        this._ticket = ticket;
        this._name = name;
    }

    public void activate() throws IOException, AgletException {
        throw new IllegalAccessError("Cannot activate remote Aglet (for now)");
    }

    public void checkValidation() throws InvalidAgletException {
        if (this._info == null) {
            this.getInfo();
        }
    }

    public synchronized void delegateMessage(Message message) throws InvalidAgletException {
        MessageBroker.delegateMessage(this._ticket, this._name, message);
    }

    protected Ref findRef() {
        return LocalAgletRef.getAgletRef(this._name);
    }

    protected Ref findRef(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Name name = (Name)objectInputStream.readObject();
        String string = (String)objectInputStream.readObject();
        LocalAgletRef localAgletRef = LocalAgletRef.getAgletRef(name);
        if (localAgletRef != null) {
            return localAgletRef;
        }
        return RemoteAgletRef.getAgletRef(new Ticket(string), name);
    }

    public String getAddress() throws InvalidAgletException {
        if (this._info == null) {
            this.getInfo();
        }
        return this._ticket.getDestination().toString();
    }

    public Aglet getAglet() throws InvalidAgletException {
        throw new InvalidAgletException("Remote Reference doens't have aglet");
    }

    public AgletInfo getAgletInfo() {
        if (this._info == null) {
            try {
                this.getInfo();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._info;
    }

    public static RemoteAgletRef getAgletRef(Ticket ticket, Name name) {
        return _table.getRef(ticket, name);
    }

    private void getInfo() throws InvalidAgletException {
        try {
            this._info = (AgletInfo)this.sendMessage(_get_info_message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Ticket = " + this._ticket);
            System.out.println("name = " + this._name.toString());
            throw new InvalidAgletException("Not Found");
        }
    }

    public String getRefClassName() {
        return "com.ibm.aglets.RemoteAgletRef";
    }

    protected Object getRefID() {
        return RemoteAgletRef.getRefID(this._ticket.getDestination(), this._name);
    }

    static Object getRefID(URL uRL, Name name) {
        return new RefKey(uRL.toString(), name);
    }

    public boolean isActive() {
        return false;
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isState(int n) {
        return false;
    }

    public boolean isValid() {
        return false;
    }

    public void resume() throws AgletException {
        throw new IllegalAccessError("Cannot resume remote Aglet (for now)");
    }

    public synchronized FutureReply sendFutureMessage(Message message) throws InvalidAgletException {
        return MessageBroker.sendFutureMessage(this._ticket, this._name, message);
    }

    public Object sendMessage(Message message) throws MessageException, InvalidAgletException, NotHandledException {
        return MessageBroker.sendMessage(this._ticket, this._name, message);
    }

    public synchronized void sendOnewayMessage(Message message) throws InvalidAgletException {
        MessageBroker.sendOnewayMessage(this._ticket, this._name, message);
    }

    void setAgletInfo(AgletInfo agletInfo) {
        this._info = agletInfo;
    }

    public static void showRefTable(PrintStream printStream) {
        printStream.println(_table.toString());
    }

    public String toString() {
        return "RemoteAgletRef : " + String.valueOf(this._info) + " .. " + super.toString();
    }

    public void writeInfo(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeObject(this._name);
            objectOutputStream.writeObject(this._ticket.getDestination().toString());
        }
        catch (Exception exception) {
            objectOutputStream.writeObject(null);
            objectOutputStream.writeObject(null);
        }
    }

    static class RemoteRefTable
    extends WeakRefTable {
        RemoteRefTable() {
        }

        public synchronized RemoteAgletRef getRef(Ticket ticket, Name name) {
            Object object = RemoteAgletRef.getRefID(ticket.getDestination(), name);
            RemoteAgletRef remoteAgletRef = (RemoteAgletRef)this.getWeakRef(object);
            if (remoteAgletRef == null) {
                remoteAgletRef = new RemoteAgletRef(ticket, name);
                super.add(remoteAgletRef);
            }
            remoteAgletRef.referenced();
            return remoteAgletRef;
        }
    }

    static final class RefKey {
        String address;
        Name name;
        int hash = 0;

        RefKey(String string, Name name) {
            this.address = string;
            this.name = name;
            int n = 0;
            while (n < name.identity.length) {
                this.hash += this.hash * 37 + name.identity[n];
                ++n;
            }
            this.hash += string.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof RefKey) {
                RefKey refKey = (RefKey)object;
                return this.address.equals(refKey.address) && RefKey.equals(refKey.name, this.name);
            }
            return false;
        }

        public static boolean equals(Name name, Name name2) {
            if (name.authority.length == name2.authority.length && name.identity.length == name2.identity.length && name.agent_system_type == name2.agent_system_type) {
                int n = name.authority.length;
                int n2 = 0;
                while (n2 < n) {
                    if (name.authority[n2] != name2.authority[n2]) {
                        return false;
                    }
                    ++n2;
                }
                n = name.identity.length;
                int n3 = 0;
                while (n3 < n) {
                    if (name.identity[n3] != name2.identity[n3]) {
                        return false;
                    }
                    ++n3;
                }
                return true;
            }
            return false;
        }
    }
}

