/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.RequestRefusedException;
import com.ibm.aglet.Ticket;
import com.ibm.aglet.security.AgletProtection;
import com.ibm.aglets.FutureReplyImpl;
import com.ibm.aglets.LocalAgletRef;
import com.ibm.aglets.MessageImpl;
import com.ibm.aglets.security.AgletPermission;
import java.io.IOException;
import java.security.Permission;

final class SystemMessage
extends MessageImpl {
    static final int CREATE = 2;
    static final int RUN = 7;
    static final int CLONE_REQUEST = 8;
    static final int DISPOSE_REQUEST = 9;
    static final int DISPATCH_REQUEST = 10;
    static final int DEACTIVATE_REQUEST = 11;
    static final int RETRACT_REQUEST = 12;
    static final int SUSPEND_REQUEST = 13;
    int type;

    SystemMessage(int n, Object object) {
        super(object);
        this.future = new FutureReplyImpl();
        this.type = n;
        if (n != 7) {
            this.priority = 11;
        }
        this.delegatable = false;
    }

    SystemMessage(String string, Object object, int n) {
        super(object);
        this.kind = string;
        this.type = n;
        this.priority = 11;
        this.delegatable = false;
    }

    Permission getPermission(String string) {
        switch (this.type) {
            case 8: {
                return new AgletPermission(string, "clone");
            }
            case 9: {
                return new AgletPermission(string, "dispose");
            }
            case 10: {
                return new AgletPermission(string, "dispatch");
            }
            case 11: 
            case 13: {
                return new AgletPermission(string, "deactivate");
            }
            case 12: {
                return new AgletPermission(string, "retract");
            }
        }
        return null;
    }

    Permission getProtection(String string) {
        switch (this.type) {
            case 8: {
                return new AgletProtection(string, "clone");
            }
            case 9: {
                return new AgletProtection(string, "dispose");
            }
            case 10: {
                return new AgletProtection(string, "dispatch");
            }
            case 11: 
            case 13: {
                return new AgletProtection(string, "deactivate");
            }
            case 12: {
                return new AgletProtection(string, "retract");
            }
        }
        return null;
    }

    void handle(LocalAgletRef localAgletRef) throws InvalidAgletException {
        FutureReplyImpl futureReplyImpl = this.future;
        Aglet aglet = localAgletRef.aglet;
        switch (this.type) {
            case 7: {
                aglet.run();
                break;
            }
            case 2: {
                aglet.onCreation(this.arg);
                break;
            }
            case 8: {
                try {
                    try {
                        futureReplyImpl.setReplyAndNotify(localAgletRef._clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        futureReplyImpl.sendExceptionIfNeeded(cloneNotSupportedException);
                        Object var9_5 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (SecurityException securityException) {
                        futureReplyImpl.sendExceptionIfNeeded(securityException);
                        Object var9_6 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        futureReplyImpl.sendExceptionIfNeeded(runtimeException);
                        Object var9_7 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (Error error) {
                        futureReplyImpl.sendExceptionIfNeeded(error);
                        throw error;
                    }
                    Object var9_4 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    break;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    throw throwable;
                }
            }
            case 9: {
                try {
                    try {
                        localAgletRef.dispose(this);
                    }
                    catch (InvalidAgletException invalidAgletException) {
                        futureReplyImpl.sendExceptionIfNeeded(invalidAgletException);
                        throw invalidAgletException;
                    }
                    catch (SecurityException securityException) {
                        futureReplyImpl.sendExceptionIfNeeded(securityException);
                        Object var11_41 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        futureReplyImpl.sendExceptionIfNeeded(runtimeException);
                        Object var11_42 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RequestRefusedException requestRefusedException) {
                        futureReplyImpl.sendExceptionIfNeeded(requestRefusedException);
                        Object var11_43 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (Error error) {
                        futureReplyImpl.sendExceptionIfNeeded(error);
                        throw error;
                    }
                    Object var11_40 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    break;
                }
                catch (Throwable throwable) {
                    Object var11_44 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    throw throwable;
                }
            }
            case 10: {
                try {
                    try {
                        localAgletRef.dispatch(this, (Ticket)this.arg);
                    }
                    catch (InvalidAgletException invalidAgletException) {
                        futureReplyImpl.cancel("In dispatch : " + invalidAgletException.getMessage());
                        throw invalidAgletException;
                    }
                    catch (RequestRefusedException requestRefusedException) {
                        futureReplyImpl.sendExceptionIfNeeded(requestRefusedException);
                        Object var13_47 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (IOException iOException) {
                        futureReplyImpl.sendExceptionIfNeeded(iOException);
                        Object var13_48 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (SecurityException securityException) {
                        futureReplyImpl.sendExceptionIfNeeded(securityException);
                        Object var13_49 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        futureReplyImpl.sendExceptionIfNeeded(runtimeException);
                        Object var13_50 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (Error error) {
                        futureReplyImpl.sendExceptionIfNeeded(error);
                        throw error;
                    }
                    Object var13_46 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    break;
                }
                catch (Throwable throwable) {
                    Object var13_51 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    throw throwable;
                }
            }
            case 11: {
                try {
                    try {
                        localAgletRef.deactivate(this, (Long)this.arg);
                    }
                    catch (InvalidAgletException invalidAgletException) {
                        futureReplyImpl.cancel("In deactivate : " + invalidAgletException.getMessage());
                        throw invalidAgletException;
                    }
                    catch (IOException iOException) {
                        futureReplyImpl.sendExceptionIfNeeded(iOException);
                        Object var15_54 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (SecurityException securityException) {
                        futureReplyImpl.sendExceptionIfNeeded(securityException);
                        Object var15_55 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        futureReplyImpl.sendExceptionIfNeeded(runtimeException);
                        Object var15_56 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RequestRefusedException requestRefusedException) {
                        futureReplyImpl.sendExceptionIfNeeded(requestRefusedException);
                        Object var15_57 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (Error error) {
                        futureReplyImpl.sendExceptionIfNeeded(error);
                        throw error;
                    }
                    Object var15_53 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    break;
                }
                catch (Throwable throwable) {
                    Object var15_58 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    throw throwable;
                }
            }
            case 13: {
                try {
                    try {
                        localAgletRef.suspend(this, (Long)this.arg);
                    }
                    catch (InvalidAgletException invalidAgletException) {
                        futureReplyImpl.cancel("In deactivate : " + invalidAgletException.getMessage());
                        throw invalidAgletException;
                    }
                    catch (SecurityException securityException) {
                        futureReplyImpl.sendExceptionIfNeeded(securityException);
                        Object var17_61 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        futureReplyImpl.sendExceptionIfNeeded(runtimeException);
                        Object var17_62 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RequestRefusedException requestRefusedException) {
                        futureReplyImpl.sendExceptionIfNeeded(requestRefusedException);
                        Object var17_63 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (Error error) {
                        futureReplyImpl.sendExceptionIfNeeded(error);
                        throw error;
                    }
                    Object var17_60 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    break;
                }
                catch (Throwable throwable) {
                    Object var17_64 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    throw throwable;
                }
            }
            case 12: {
                try {
                    try {
                        localAgletRef.suspendForRetraction((Ticket)this.arg);
                    }
                    catch (InvalidAgletException invalidAgletException) {
                        futureReplyImpl.cancel("In Retraction " + invalidAgletException.getMessage());
                        Object var19_67 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (SecurityException securityException) {
                        futureReplyImpl.sendExceptionIfNeeded(securityException);
                        Object var19_68 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        futureReplyImpl.sendExceptionIfNeeded(runtimeException);
                        Object var19_69 = null;
                        futureReplyImpl.sendReplyIfNeeded(null);
                        break;
                    }
                    catch (Error error) {
                        futureReplyImpl.sendExceptionIfNeeded(error);
                        throw error;
                    }
                    Object var19_66 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    break;
                }
                catch (Throwable throwable) {
                    Object var19_70 = null;
                    futureReplyImpl.sendReplyIfNeeded(null);
                    throw throwable;
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 7: {
                stringBuffer.append("[Run ");
                break;
            }
            case 2: {
                stringBuffer.append("[Create ");
                break;
            }
            case 8: {
                stringBuffer.append("[Clone ");
                break;
            }
            case 9: {
                stringBuffer.append("[Dispose ");
                break;
            }
            case 10: {
                stringBuffer.append("[Dispatch : url = " + String.valueOf(this.arg));
                break;
            }
            case 11: {
                stringBuffer.append("[Deactivate : duration = " + String.valueOf(this.arg));
                break;
            }
            case 13: {
                stringBuffer.append("[Suspend : duration = " + String.valueOf(this.arg));
                break;
            }
            case 12: {
                stringBuffer.append("[Retract : by = " + String.valueOf(this.arg));
                break;
            }
            default: {
                return "[Message: None]";
            }
        }
        stringBuffer.append(": prority = " + this.priority);
        if (this.waiting) {
            stringBuffer.append(" :waiting ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

