/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import com.ibm.aglets.security.DateString;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public final class Lifetime
implements Serializable,
Cloneable {
    public static final Date UNLIMITED = null;
    public static final String UNLIMITED_LABEL = "unlimited";
    private static final String FORMAT_DATE = "yyyy.MM.dd-HH:mm:ss.SSS(z)";
    private static final String RELATIVE = "+";
    private boolean _relative = true;
    private long _life = 0L;
    private Date _limit = null;

    public Lifetime() {
        this(UNLIMITED);
    }

    public Lifetime(Lifetime lifetime) {
        this.setLifetime(lifetime);
    }

    public Lifetime(String string) throws NumberFormatException {
        this.setLifetime(string);
    }

    public Lifetime(Date date) {
        this.setAbsoluteLifetime(date);
    }

    public Object clone() throws CloneNotSupportedException {
        return new Lifetime(this);
    }

    public static Date currentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Lifetime) {
            Lifetime lifetime = (Lifetime)object;
            boolean bl = this.isLimited();
            boolean bl2 = lifetime.isLimited();
            if (bl && bl2) {
                return this._limit.equals(lifetime.getLimit());
            }
            return !bl && !bl2;
        }
        return false;
    }

    public Date getLimit() {
        return this._limit;
    }

    public boolean isAbsolute() {
        return !this.isRelative();
    }

    public boolean isGreaterThan(long l) {
        if (!this.isLimited()) {
            return true;
        }
        return this._limit.getTime() > l;
    }

    public boolean isGreaterThan(Lifetime lifetime) {
        if (lifetime == null) {
            return true;
        }
        if (!this.isLimited()) {
            return true;
        }
        return this._limit.after(lifetime.getLimit());
    }

    public boolean isGreaterThan(Date date) {
        if (date == null) {
            return true;
        }
        if (!this.isLimited()) {
            return true;
        }
        return this._limit.after(date);
    }

    public boolean isLimited() {
        return Lifetime.isLimited(this._limit);
    }

    public static boolean isLimited(Lifetime lifetime) {
        return Lifetime.isLimited(lifetime.getLimit());
    }

    public static boolean isLimited(String string) {
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase(UNLIMITED_LABEL);
    }

    public static boolean isLimited(Date date) {
        return date != UNLIMITED;
    }

    public boolean isOver() {
        return Lifetime.isOver(this._limit);
    }

    public static boolean isOver(Date date) {
        if (!Lifetime.isLimited(date)) {
            return false;
        }
        return Lifetime.currentDate().after(date);
    }

    public boolean isRelative() {
        return this._relative;
    }

    public void limit(long l) {
        if (this.isGreaterThan(l)) {
            if (this.isRelative()) {
                this.subtractLifetime(this._limit.getTime() - l);
            } else {
                this.setAbsoluteLifetime(l);
            }
        }
    }

    public void limit(Lifetime lifetime) {
        if (lifetime == null) {
            return;
        }
        this.limit(lifetime.getLimit());
    }

    public void limit(Date date) {
        if (date == null) {
            return;
        }
        if (this.isGreaterThan(date)) {
            if (this.isRelative()) {
                this.subtractLifetime(this._limit.getTime() - date.getTime());
            } else {
                this.setAbsoluteLifetime(date);
            }
        }
    }

    public static void main(String[] stringArray) {
        Lifetime lifetime = new Lifetime("+36000000");
        System.out.println("Life : " + lifetime.toString());
        int n = 0;
        while (n < stringArray.length) {
            Lifetime lifetime2 = new Lifetime(stringArray[n]);
            System.out.println(stringArray[n] + " : " + lifetime2.toString());
            lifetime.limit(lifetime2);
            System.out.println("Life : " + lifetime.toString());
            ++n;
        }
    }

    private void setAbsoluteLifetime(long l) {
        this.setAbsoluteLifetime(new Date(l));
    }

    private void setAbsoluteLifetime(Date date) {
        this._relative = false;
        this._life = 0L;
        this.setLimit(date);
    }

    public void setLifetime(Lifetime lifetime) {
        if (lifetime != null) {
            this._relative = lifetime._relative;
            this._life = lifetime._life;
            this._limit = lifetime._limit;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLifetime(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("Lifetime description is null.");
        }
        if (!Lifetime.isLimited(string)) {
            this.setAbsoluteLifetime(UNLIMITED);
            return;
        } else if (string.startsWith(RELATIVE)) {
            long l = Long.parseLong(string.substring(1));
            if (l <= 0L) throw new NumberFormatException("invalid lifetime description : " + string);
            this.setRelativeLifetime(l);
            return;
        } else {
            Date date = DateString.string2date(string, FORMAT_DATE);
            if (date != null) {
                this.setAbsoluteLifetime(date);
                return;
            } else {
                long l = Long.parseLong(string);
                if (l <= 0L) throw new NumberFormatException("invalid lifetime description : " + string);
                this.setAbsoluteLifetime(l);
            }
        }
    }

    public void setLifetime(Date date) {
        if (date != null) {
            this.setAbsoluteLifetime(date);
        }
    }

    private void setLimit(Date date) {
        this._limit = Lifetime.isLimited(date) ? date : UNLIMITED;
    }

    private void setRelativeLifetime(long l) {
        this._relative = true;
        this._life = l;
        this.setLimit(new Date(Lifetime.currentDate().getTime() + l));
    }

    public void subtractLifetime(long l) {
        if (l > 0L && this.isLimited()) {
            long l2 = l;
            if (this.isRelative()) {
                if (this._life < l) {
                    l2 = this._life;
                }
                this._life -= l2;
            }
            this.setLimit(new Date(this._limit.getTime() - l2));
        }
    }

    public String toString() {
        return this.toString(this.isRelative());
    }

    public String toString(boolean bl) {
        return this.toString(bl, FORMAT_DATE);
    }

    public String toString(boolean bl, String string) {
        if (!this.isLimited()) {
            return UNLIMITED_LABEL;
        }
        if (bl) {
            return RELATIVE + this._life;
        }
        if (string != null) {
            return DateString.date2string(this._limit, string);
        }
        return this._limit.toString();
    }
}

