/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import com.ibm.aglets.security.AgletsPermissionBase;
import java.io.Serializable;
import java.security.Permission;

public class PlainAgletPermission
extends AgletsPermissionBase
implements Serializable {
    private static final String ACTION_DISPOSE = "dispose";
    private static final String ACTION_CLONE = "clone";
    private static final String ACTION_DISPATCH = "dispatch";
    private static final String ACTION_RETRACT = "retract";
    private static final String ACTION_DEACTIVATE = "deactivate";
    private static final String ACTION_ACTIVATE = "activate";
    private static final String[] ACTIONS = new String[]{"dispose", "clone", "dispatch", "retract", "deactivate", "activate"};
    private static final int INDEX_DISPOSE = 0;
    private static final int INDEX_CLONE = 1;
    private static final int INDEX_DISPATCH = 2;
    private static final int INDEX_RETRACT = 3;
    private static final int INDEX_DEACTIVATE = 4;
    private static final int INDEX_ACTIVATE = 5;
    private static final int NUMBER_OF_ACTIONS = 6;
    private String _actions = null;
    private boolean[] _actionFlag = new boolean[6];

    public PlainAgletPermission(String string, String string2) {
        super(string);
        String[] stringArray = AgletsPermissionBase.split(string2.toLowerCase(), " ,\t\n\r");
        int n = 0;
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(ACTION_DISPOSE)) {
                this._actionFlag[0] = true;
            } else if (stringArray[n].equals(ACTION_CLONE)) {
                this._actionFlag[1] = true;
            } else if (stringArray[n].equals(ACTION_DISPATCH)) {
                this._actionFlag[2] = true;
            } else if (stringArray[n].equals(ACTION_RETRACT)) {
                this._actionFlag[3] = true;
            } else if (stringArray[n].equals(ACTION_DEACTIVATE)) {
                this._actionFlag[4] = true;
            } else if (stringArray[n].equals(ACTION_ACTIVATE)) {
                this._actionFlag[5] = true;
            }
            ++n;
        }
        this._actions = AgletsPermissionBase.select(ACTIONS, this._actionFlag);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlainAgletPermission)) {
            return false;
        }
        PlainAgletPermission plainAgletPermission = (PlainAgletPermission)object;
        return this.getName().equals(plainAgletPermission.getName()) && this._actions.equals(plainAgletPermission._actions);
    }

    public String getActions() {
        return this._actions;
    }

    public int hashCode() {
        return this.getName().hashCode() + this._actions.hashCode();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PlainAgletPermission)) {
            return false;
        }
        PlainAgletPermission plainAgletPermission = (PlainAgletPermission)permission;
        if (AgletsPermissionBase.checkAglet(this.getName(), plainAgletPermission.getName())) {
            return AgletsPermissionBase.matches(this._actionFlag, plainAgletPermission._actionFlag);
        }
        return true;
    }
}

