/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import com.ibm.aglets.security.PolicyGrant;
import com.ibm.awb.misc.URIPattern;
import java.io.File;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;

public class PolicyDB {
    private URL _system_codebase = null;
    private String _public_root = null;
    private Vector _grants = new Vector();
    private static final String CODEBASE = "codebase";
    private static final String PROTOCOL_FILE = "file";
    private static final String WILDCARD_ANYDIR = "-";
    private static final String PORT_LEADER = ":";

    public void addGrant(PolicyGrant policyGrant) {
        this._grants.addElement(policyGrant);
    }

    public Enumeration getGrants() {
        return this._grants.elements();
    }

    private static final String getHostPart(String string) {
        String string2 = string;
        int n = string.indexOf(PORT_LEADER);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public Permissions getPermissions(CodeSource codeSource) {
        return this.getPermissions(codeSource, true);
    }

    public Permissions getPermissions(CodeSource codeSource, boolean bl) {
        Permissions permissions = null;
        int n = this._grants.size();
        int n2 = 0;
        while (n2 < n) {
            PolicyGrant policyGrant = (PolicyGrant)this._grants.elementAt(n2);
            Permissions permissions2 = policyGrant.getPermissions(codeSource);
            if (permissions2 != null) {
                if (permissions == null) {
                    permissions = new Permissions();
                }
                Enumeration<Permission> enumeration = permissions2.elements();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    if (bl) {
                        Object object2;
                        Object object3;
                        Permission permission;
                        if (object instanceof FilePermission) {
                            permission = (FilePermission)object;
                            if (CODEBASE.equalsIgnoreCase(permission.getName()) && (object3 = codeSource.getLocation()) != null && (object2 = (Permission)AccessController.doPrivileged(new PrivilegedAction((URL)object3, (FilePermission)permission){
                                private final /* synthetic */ URL val$cb;
                                private final /* synthetic */ FilePermission val$filep;
                                {
                                    this.val$cb = uRL;
                                    this.val$filep = filePermission;
                                }

                                public Object run() {
                                    if (PolicyDB.PROTOCOL_FILE.equalsIgnoreCase(this.val$cb.getProtocol())) {
                                        String string = URIPattern.canonicalFilename(this.val$cb.getFile());
                                        string = string + File.separator + PolicyDB.WILDCARD_ANYDIR;
                                        return new FilePermission(string, this.val$filep.getActions());
                                    }
                                    if (this.val$cb.equals(PolicyDB.this._system_codebase)) {
                                        String string = PolicyDB.this._public_root;
                                        if (string.charAt(string.length() - 1) != File.separatorChar) {
                                            string = string + File.separator;
                                        }
                                        string = string + PolicyDB.WILDCARD_ANYDIR;
                                        return new FilePermission(string, this.val$filep.getActions());
                                    }
                                    return null;
                                }
                            })) != null) {
                                object = object2;
                            }
                        } else if (object instanceof SocketPermission) {
                            permission = (SocketPermission)object;
                            object3 = permission.getName();
                            object2 = PolicyDB.getHostPart((String)object3);
                            String string = PolicyDB.getPortPart((String)object3);
                            if (CODEBASE.equalsIgnoreCase((String)object2)) {
                                URL uRL = codeSource.getLocation();
                                if (uRL != null) {
                                    object2 = uRL.getHost();
                                }
                                Object object4 = null;
                                object4 = string != null ? (String)object2 + PORT_LEADER + string : object2;
                                object = new SocketPermission((String)object4, ((SocketPermission)permission).getActions());
                            }
                        }
                    }
                    permissions.add((Permission)object);
                }
            }
            ++n2;
        }
        return permissions;
    }

    private static final String getPortPart(String string) {
        String string2 = null;
        int n = string.indexOf(PORT_LEADER);
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    void setPublicRoot(String string) {
        this._public_root = string;
    }

    void setSystemCodeBase(String string) {
        try {
            this.setSystemCodeBase(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    void setSystemCodeBase(URL uRL) {
        this._system_codebase = uRL;
    }

    public String toString() {
        int n = this._grants.size();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            Object e = this._grants.elementAt(n2);
            if (e != null) {
                string = string + e.toString();
            }
            ++n2;
        }
        return string;
    }

    public Vector toVector() {
        int n = this._grants.size();
        Vector vector = new Vector();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            Object e = this._grants.elementAt(n2);
            if (e != null && e instanceof PolicyGrant) {
                PolicyGrant policyGrant = (PolicyGrant)e;
                Vector vector2 = policyGrant.toVector();
                int n3 = vector2.size();
                int n4 = 0;
                n4 = 0;
                while (n4 < n3) {
                    vector.addElement(vector2.elementAt(n4));
                    ++n4;
                }
            }
            ++n2;
        }
        return vector;
    }
}

