/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import com.ibm.aglets.security.PolicyDB;
import com.ibm.aglets.security.PolicyFileParsingException;
import com.ibm.aglets.security.PolicyGrant;
import com.ibm.aglets.security.PolicyImpl;
import com.ibm.aglets.security.PolicyPermission;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.MalformedURIPatternException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PolicyFileReader {
    private static final String PROPERTY_JAVAHOME = "java.home";
    private static final String PROPERTY_POLICYFILE = "java.policy";
    private static final String FILENAME_JAVAPOLICY = "java.policy";
    private static final String SEP = File.separator;
    static final String CRLF = "\r\n";
    static final int TT_EOF = -1;
    static final int TT_EOL = 10;
    static final int TT_WORD = -3;
    static final int TT_NUMBER = -2;
    static final char CHAR_A_LOWERCASE = 'a';
    static final char CHAR_Z_LOWERCASE = 'z';
    static final char CHAR_A_UPPERCASE = 'A';
    static final char CHAR_Z_UPPERCASE = 'Z';
    static final char CHAR_START = '\u0000';
    static final char CHAR_SPACE = ' ';
    static final char CHAR_8BITS_START = '\u00a0';
    static final char CHAR_8BITS_END = '\u00ff';
    static final char CHAR_BACKSLASH = '\\';
    static final char CHAR_SINGLE_QUOTE = '\'';
    static final char CHAR_DOUBLE_QUOTE = '\"';
    static final char CHAR_CROSSHATCH = '#';
    static final int TT_CROSSHATCH = 35;
    static final char CHAR_COMMENT = '#';
    static final int TT_COMMENT = 35;
    static final char CHAR_COMMA = ',';
    static final int TT_COMMA = 44;
    static final char CHAR_STRING_QUOTE = '\"';
    static final int TT_QUOTED_STRING = 34;
    static final char CHAR_SEMICOLON = ';';
    static final int TT_SEMICOLON = 59;
    static final char CHAR_TERMINATOR = ';';
    static final int TT_TERMINATOR = 59;
    static final char CHAR_OPEN_BRACKET = '{';
    static final int TT_OPEN_BRACKET = 123;
    static final char CHAR_BEGIN_BLOCK = '{';
    static final int TT_BEGIN_BLOCK = 123;
    static final char CHAR_CLOSE_BRACKET = '}';
    static final int TT_CLOSE_BRACKET = 125;
    static final char CHAR_END_BLOCK = '}';
    static final int TT_END_BLOCK = 125;
    static final char CHAR_UNDERSCORE = '_';
    static final int TT_UNDERSCORE = 95;
    static final String WORD_GRANT = "grant";
    static final String WORD_SIGNEDBY = "signedBy";
    static final String WORD_CODEBASE = "codeBase";
    static final String WORD_OWNEDBY = "ownedBy";
    static final String WORD_PERMISSION = "permission";
    static final String WORD_PROTECTION = "protection";
    private String _filename = null;
    private StreamTokenizer _st = null;
    private PolicyDB _db = null;

    public PolicyFileReader(String string) {
        try {
            this.readPolicyFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static synchronized PolicyDB getAllPolicyDB() {
        return PolicyFileReader.getAllPolicyDB(PolicyFileReader.getUserPolicyFilename());
    }

    public static synchronized PolicyDB getAllPolicyDB(String string) {
        return PolicyFileReader.getAllPolicyDB(PolicyFileReader.getSystemPolicyFilename(), string);
    }

    protected static synchronized PolicyDB getAllPolicyDB(String string, String string2) {
        PolicyFileReader policyFileReader = new PolicyFileReader(string);
        try {
            policyFileReader.readPolicyFile(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return policyFileReader.getPolicyDB();
    }

    PolicyFileParsingException getParsingException(String string) {
        return new PolicyFileParsingException(this._filename + "(" + this.lineno() + ") " + string);
    }

    public PolicyDB getPolicyDB() {
        return this._db;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized PolicyPermission getPolicyPermission() throws PolicyFileParsingException {
        PolicyPermission policyPermission;
        if (!this.isPolicyPermission()) {
            throw this.getParsingException("The reserved word 'permission' or 'protection' is expected, not '" + this.token() + "'.");
        }
        String string = this.string();
        this.nextToken();
        if (!this.isWord()) throw this.getParsingException("Not permission class name '" + this.token() + "'.");
        try {
            policyPermission = new PolicyPermission(this, string, this.string());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.getParsingException(classNotFoundException.toString());
        }
        this.nextToken();
        if (this.isQuotedString()) {
            policyPermission.setTargetName(this.string());
            this.nextToken();
        }
        boolean bl = false;
        if (this.isComma()) {
            bl = true;
            this.nextToken();
            if (this.isQuotedString()) {
                policyPermission.setActions(this.string());
                bl = false;
                this.nextToken();
                if (this.isComma()) {
                    this.nextToken();
                    if (!this.isSignedBy()) throw this.getParsingException("The reserved word '" + this.token() + "'.");
                    bl = true;
                }
            } else {
                if (!this.isSignedBy()) throw this.getParsingException("Unknown token '" + this.token() + "'.");
                bl = true;
            }
        }
        if (this.isSignedBy()) {
            if (!bl) {
                throw this.getParsingException("A character ',' is needed before 'signedBy' in permission clause.");
            }
            this.nextToken();
            if (!this.isQuotedString()) throw this.getParsingException("Signer name(s) should be a quoted string. '" + this.token() + "'.");
            try {
                policyPermission.setSignerNames(this.string());
            }
            catch (SecurityException securityException) {
                throw this.getParsingException(securityException.toString());
            }
            this.nextToken();
        }
        if (!this.isTerminator()) {
            throw this.getParsingException("Unknown token '" + this.token() + "'.");
        }
        policyPermission.create();
        this.nextToken();
        return policyPermission;
    }

    public static String getSystemPolicyFilename() {
        String string = PolicyImpl.getSystemProperty(PROPERTY_JAVAHOME);
        if (string == null) {
            return null;
        }
        return string + SEP + "lib" + SEP + "security" + SEP + "java.policy";
    }

    public static String getUserPolicyFilename() {
        String string = PolicyImpl.getSystemProperty("java.policy");
        if (string != null) {
            return string;
        }
        String string2 = FileUtils.getUserHome();
        if (string2 == null) {
            return null;
        }
        string = string2 + SEP + "." + "java.policy";
        return string;
    }

    protected void initialize() {
        if (this._st == null) {
            return;
        }
        this._st.resetSyntax();
        this._st.wordChars(97, 122);
        this._st.wordChars(65, 90);
        this._st.wordChars(160, 255);
        this._st.whitespaceChars(0, 32);
        this._st.quoteChar(34);
        this._st.parseNumbers();
        this._st.wordChars(95, 95);
        this._st.slashStarComments(true);
        this._st.slashSlashComments(true);
        this._st.lowerCaseMode(false);
    }

    private boolean isBeginBlock() {
        return PolicyFileReader.isBeginBlock(this.tokenType());
    }

    private static boolean isBeginBlock(int n) {
        return n == 123;
    }

    private boolean isCodeBase() {
        return this.isWord() && this.string().equals(WORD_CODEBASE);
    }

    private boolean isComma() {
        return PolicyFileReader.isComma(this.tokenType());
    }

    private static boolean isComma(int n) {
        return n == 44;
    }

    private boolean isEndBlock() {
        return PolicyFileReader.isEndBlock(this.tokenType());
    }

    private static boolean isEndBlock(int n) {
        return n == 125;
    }

    private boolean isEndOfFile() {
        return PolicyFileReader.isEndOfFile(this.tokenType());
    }

    private static boolean isEndOfFile(int n) {
        return n == -1;
    }

    private boolean isEndOfLine() {
        return PolicyFileReader.isEndOfLine(this.tokenType());
    }

    private static boolean isEndOfLine(int n) {
        return n == 10;
    }

    private boolean isGrant() {
        return this.isWord() && this.string().equals(WORD_GRANT);
    }

    private boolean isNumber() {
        return PolicyFileReader.isNumber(this.tokenType());
    }

    private static boolean isNumber(int n) {
        return n == -2;
    }

    private boolean isOwnedBy() {
        return this.isWord() && this.string().equals(WORD_OWNEDBY);
    }

    private boolean isPermission() {
        return this.isWord() && this.isPermission(this.string());
    }

    private boolean isPermission(String string) {
        return WORD_PERMISSION.equals(string);
    }

    private boolean isPolicyPermission() {
        return this.isPermission() || this.isProtection();
    }

    private boolean isProtection() {
        return this.isWord() && this.isProtection(this.string());
    }

    private boolean isProtection(String string) {
        return WORD_PROTECTION.equals(string);
    }

    private boolean isQuotedString() {
        return PolicyFileReader.isQuotedString(this.tokenType());
    }

    private static boolean isQuotedString(int n) {
        return n == 34;
    }

    private boolean isSignedBy() {
        return this.isWord() && this.string().equals(WORD_SIGNEDBY);
    }

    private boolean isTerminator() {
        return PolicyFileReader.isTerminator(this.tokenType());
    }

    private static boolean isTerminator(int n) {
        return n == 59;
    }

    private boolean isWord() {
        return PolicyFileReader.isWord(this.tokenType());
    }

    private static boolean isWord(int n) {
        return n == -3;
    }

    private int lineno() {
        return this._st.lineno();
    }

    public static void main(String[] stringArray) {
        PolicyDB policyDB = null;
        if (stringArray.length == 0) {
            policyDB = PolicyFileReader.getAllPolicyDB();
        } else {
            PolicyFileReader policyFileReader = new PolicyFileReader(stringArray[0]);
            policyDB = policyFileReader.getPolicyDB();
        }
        if (policyDB != null) {
            System.out.print(policyDB.toString());
        } else {
            System.out.println("Policy file does not exist.");
        }
    }

    private int nextToken() throws PolicyFileParsingException {
        int n;
        try {
            n = this._st.nextToken();
        }
        catch (IOException iOException) {
            throw this.getParsingException(iOException.toString());
        }
        return n;
    }

    private double number() {
        return this._st.nval;
    }

    protected synchronized void readPolicyDB() throws PolicyFileParsingException {
        this.nextToken();
        if (!this.isGrant()) {
            throw this.getParsingException("The reserved word 'grant' is expected, not '" + this.token() + "'.");
        }
        if (this._db == null) {
            this._db = new PolicyDB();
        }
        while (this.isGrant()) {
            this.readPolicyGrant();
        }
        if (!this.isEndOfFile()) {
            throw this.getParsingException("The reserved word 'grant' is expected, not '" + this.token() + "'.");
        }
    }

    protected synchronized void readPolicyFile(String string) throws FileNotFoundException {
        System.out.print("[Reading security policy file: " + string + "...");
        if (string == null) {
            throw new FileNotFoundException("Policy filename is null.");
        }
        this._filename = string;
        FileReader fileReader = new FileReader(string);
        this._st = new StreamTokenizer(new BufferedReader(fileReader));
        this.initialize();
        try {
            this.readPolicyDB();
            fileReader.close();
            System.out.println(" done.]");
        }
        catch (PolicyFileParsingException policyFileParsingException) {
            System.err.println(policyFileParsingException);
            System.out.println(" ERROR.]");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.out.println(" ERROR.]");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void readPolicyGrant() throws PolicyFileParsingException {
        if (!this.isGrant()) {
            throw this.getParsingException("The reserved word 'grant' is expected, not '" + this.token() + "'.");
        }
        this.nextToken();
        var1_1 = new PolicyGrant();
        var2_2 = false;
        var3_3 = false;
        var4_4 = false;
        while (!this.isBeginBlock()) {
            if (this.isSignedBy()) {
                if (var2_2) {
                    throw this.getParsingException("signedBy phrase duplicated.");
                }
                var2_2 = true;
                this.nextToken();
                if (this.isQuotedString()) {
                    var1_1.setSignerNames(this.string());
                    this.nextToken();
                    if (this.isBeginBlock()) continue;
                    if (this.isComma()) {
                        this.nextToken();
                        continue;
                    }
                    throw this.getParsingException("A character ',' is expected before '" + this.token() + "'.");
                }
                throw this.getParsingException("Signer name(s) should be a quoted string. '" + this.token() + "'.");
            }
            if (this.isCodeBase()) {
                if (var3_3) {
                    throw this.getParsingException("codeBase phrase duplicated.");
                }
                var3_3 = true;
                this.nextToken();
                if (this.isQuotedString()) {
                    try {
                        var1_1.setCodeBase(this.string());
                    }
                    catch (MalformedURIPatternException var5_5) {
                        throw this.getParsingException(var5_5.toString());
                    }
                    this.nextToken();
                    if (this.isBeginBlock()) continue;
                    if (this.isComma()) {
                        this.nextToken();
                        continue;
                    }
                    throw this.getParsingException("A character ',' is expected before '" + this.token() + "'.");
                }
                throw this.getParsingException("An URI pattern as code base should be a quoted string. '" + this.token() + "'.");
            }
            if (this.isOwnedBy()) {
                if (var4_4) {
                    throw this.getParsingException("ownedBy phrase duplicated.");
                }
                var4_4 = true;
                this.nextToken();
                if (this.isQuotedString()) {
                    var1_1.setOwnerNames(this.string());
                    this.nextToken();
                    if (this.isBeginBlock()) continue;
                    if (this.isComma()) {
                        this.nextToken();
                        continue;
                    }
                    throw this.getParsingException("Begin block character '{' is expected, not '" + this.token() + "'.");
                }
                throw this.getParsingException("An owner name should be a quoted string. '" + this.token() + "'.");
            }
            throw this.getParsingException("Begin block character '{' is expected, not '" + this.token() + "'.");
        }
        if (!this.isBeginBlock()) ** GOTO lbl80
        this.nextToken();
        if (this.isPolicyPermission()) ** GOTO lbl72
        throw this.getParsingException("The reserved word 'permission' or 'protection' is expected, not '" + this.token() + "'.");
lbl-1000:
        // 1 sources

        {
            var1_1.addPermission(this.getPolicyPermission());
lbl72:
            // 2 sources

            ** while (this.isPolicyPermission())
        }
lbl73:
        // 1 sources

        if (this.isEndBlock()) {
            this.nextToken();
            if (!this.isTerminator()) {
                throw this.getParsingException("The termination character ';' is expected, not '" + this.token() + "'.");
            }
        } else {
            throw this.getParsingException("End block character '}' is expected, not '" + this.token() + "'.");
lbl80:
            // 1 sources

            throw this.getParsingException("Begin block character '{' is expected, not '" + this.token() + "'.");
        }
        this.nextToken();
        this._db.addGrant(var1_1);
    }

    private String string() {
        return this._st.sval;
    }

    private String token() {
        String string;
        int n = this.tokenType();
        switch (n) {
            case -3: 
            case 34: {
                string = this.string();
                break;
            }
            case -2: {
                string = Double.toString(this.number());
                break;
            }
            default: {
                string = String.valueOf((char)n);
            }
        }
        return string;
    }

    private int tokenType() {
        return this._st.ttype;
    }
}

