/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import com.ibm.aglets.AgletRuntime;
import com.ibm.aglets.security.PolicyImpl;
import com.ibm.aglets.security.PolicyPermission;
import com.ibm.awb.misc.MalformedURIPatternException;
import com.ibm.awb.misc.URIPattern;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolicyGrant {
    private static final String QUOTE = String.valueOf('\"');
    private static final String COMMA = String.valueOf(',');
    private static final String BEGIN_BLOCK = String.valueOf('{');
    private static final String END_BLOCK = String.valueOf('}');
    private static final String TERMINATOR = String.valueOf(';');
    private static final String NAME_SEPARATOR = COMMA;
    private String _signerNames = null;
    private Vector _signers = null;
    private URIPattern _codeBase = null;
    private String _ownerNames = null;
    private Vector _owners = null;
    private Vector _permissions = new Vector();
    private static final String ANYBODY = "*";
    private static final String PROPERTY_CRLF = "line.separator";
    private static final String DEFAULT_CRLF = "\r\n";
    private static String crlf = null;

    public void addPermission(PolicyPermission policyPermission) {
        this._permissions.addElement(policyPermission);
    }

    public boolean equals(Vector vector, URIPattern uRIPattern, Vector vector2) {
        if (!PolicyPermission.equalsSigners(vector, this._signers)) {
            return false;
        }
        if (uRIPattern != null && !uRIPattern.equals(this._codeBase)) {
            return false;
        }
        return PolicyPermission.equalsSigners(vector2, this._owners);
    }

    public URIPattern getCodeBase() {
        return this._codeBase;
    }

    public String getOwnerNames() {
        return this._ownerNames;
    }

    public Enumeration getOwners() {
        if (this._owners != null) {
            return this._owners.elements();
        }
        return null;
    }

    public Enumeration getPermissions() {
        return this._permissions.elements();
    }

    public Enumeration getPermissions(String string) {
        Vector<PolicyPermission> vector = new Vector<PolicyPermission>();
        int n = this._permissions.size();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            PolicyPermission policyPermission;
            Object e = this._permissions.elementAt(n2);
            if (e instanceof PolicyPermission && (policyPermission = (PolicyPermission)e).equalsClassName(string)) {
                vector.addElement(policyPermission);
            }
            ++n2;
        }
        return vector.elements();
    }

    public Permissions getPermissions(CodeSource codeSource) {
        if (codeSource != null) {
            URL uRL = codeSource.getLocation();
            Certificate[] certificateArray = codeSource.getCertificates();
            if (this.isCodeBase(uRL) && this.isOwnedByAndSignedBy(certificateArray)) {
                int n = this._permissions.size();
                if (n == 0) {
                    return null;
                }
                Permissions permissions = new Permissions();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this._permissions.elementAt(n2);
                    if (e instanceof PolicyPermission) {
                        PolicyPermission policyPermission = (PolicyPermission)e;
                        permissions.add(policyPermission.getPermission());
                    }
                    ++n2;
                }
                return permissions;
            }
            return null;
        }
        return null;
    }

    public String getSignerNames() {
        return this._signerNames;
    }

    public Enumeration getSigners() {
        if (this._signers != null) {
            return this._signers.elements();
        }
        return null;
    }

    private final String getUsername(Certificate certificate) {
        String string = null;
        try {
            final Certificate certificate2 = certificate;
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AgletRuntime.getCertificateAlias(certificate2);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected boolean isCodeBase(URL uRL) {
        final URIPattern uRIPattern = this._codeBase;
        final URL uRL2 = uRL;
        if (this._codeBase == null) {
            return true;
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (uRIPattern == null) {
                    return new Boolean(true);
                }
                return new Boolean(uRIPattern.isMatch(uRL2));
            }
        });
        return bl;
    }

    protected boolean isOwnedBy(Certificate certificate) {
        if (this._owners == null || this._owners.size() == 0) {
            return true;
        }
        if (certificate == null) {
            return false;
        }
        String string = this.getUsername(certificate);
        if (string == null || string.equals("")) {
            return false;
        }
        int n = this._owners.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            Object e = this._owners.elementAt(n2);
            if (e instanceof String && string.equals(string2 = (String)e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isOwnedByAndSignedBy(Certificate[] certificateArray) {
        Certificate certificate = null;
        if (certificateArray != null) {
            certificate = certificateArray[0];
        }
        return this.isOwnedBy(certificate);
    }

    private final boolean isRegisteredUser(String string) {
        Certificate certificate = AgletRuntime.getRegisteredCertificate(string);
        return certificate != null;
    }

    protected boolean isSignedBy(Certificate[] certificateArray) {
        if (this._signers == null || this._signers.size() == 0) {
            return true;
        }
        if (certificateArray == null || certificateArray.length == 0) {
            return false;
        }
        int n = this._signers.size();
        int n2 = 0;
        while (n2 < n) {
            String string;
            Object e = this._signers.elementAt(n2);
            if (e instanceof String && !this.isSignedBy(string = (String)e, certificateArray)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isSignedBy(String string, Certificate[] certificateArray) {
        if (string == null || string.equals("")) {
            return true;
        }
        if (certificateArray == null || certificateArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < certificateArray.length) {
            String string2 = this.getUsername(certificateArray[n]);
            if (string.equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setCodeBase(String string) throws MalformedURIPatternException {
        this._codeBase = new URIPattern(string);
    }

    public void setCodeBase(URL uRL) throws MalformedURIPatternException {
        this._codeBase = new URIPattern(uRL);
    }

    public void setOwnerNames(String string) {
        Vector<String> vector = null;
        StringBuffer stringBuffer = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, NAME_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if ("".equals(string2) || ANYBODY.equals(string2)) {
                    this._owners = null;
                    this._ownerNames = ANYBODY;
                    return;
                }
                if (!this.isRegisteredUser(string2)) {
                    System.err.println("Unknown owner name '" + string2 + "' is specified in aglets policy file. Ignore the owner name.");
                    continue;
                }
                if (vector == null) {
                    vector = new Vector<String>();
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(NAME_SEPARATOR);
                }
                vector.addElement(string2);
                stringBuffer.append(string2);
            }
        }
        this._owners = vector;
        this._ownerNames = stringBuffer == null ? null : stringBuffer.toString();
    }

    public void setSignerNames(String string) {
        Vector<String> vector = null;
        StringBuffer stringBuffer = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, NAME_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if ("".equals(string2) || ANYBODY.equals(string2)) {
                    this._signers = null;
                    this._signerNames = ANYBODY;
                    return;
                }
                if (!this.isRegisteredUser(string2)) {
                    System.err.println("Unknown signer name '" + string2 + "' is specified in aglets policy file. Ignore the signer name.");
                    continue;
                }
                if (vector == null) {
                    vector = new Vector<String>();
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(NAME_SEPARATOR);
                }
                vector.addElement(string2);
                stringBuffer.append(string2);
            }
        }
        this._signers = vector;
        this._signerNames = stringBuffer == null ? null : stringBuffer.toString();
    }

    public String toString() {
        Vector vector = this.toVector();
        String string = "";
        int n = vector.size();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            string = string + string2 + crlf;
            ++n2;
        }
        return string;
    }

    public Vector toVector() {
        Vector<String> vector = new Vector<String>();
        String string = "grant";
        if (this._signerNames != null && !this._signerNames.equals("")) {
            string = string + " signedBy " + QUOTE + this._signerNames + QUOTE;
        }
        if (this._codeBase != null) {
            if (this._signerNames != null) {
                string = string + COMMA;
            }
            string = string + " codeBase " + QUOTE + this._codeBase.toString() + QUOTE;
        }
        if (this._ownerNames != null && !this._ownerNames.equals("")) {
            if (this._signerNames != null || this._codeBase != null) {
                string = string + COMMA;
            }
            string = string + " ownedBy " + QUOTE + this._ownerNames + QUOTE;
        }
        string = string + " " + BEGIN_BLOCK;
        vector.addElement(string);
        int n = this._permissions.size();
        int n2 = 0;
        while (n2 < n) {
            string = "  " + this._permissions.elementAt(n2).toString();
            vector.addElement(string);
            ++n2;
        }
        string = END_BLOCK + TERMINATOR;
        vector.addElement(string);
        return vector;
    }

    static {
        crlf = PolicyImpl.getSystemProperty(PROPERTY_CRLF, DEFAULT_CRLF);
    }
}

