/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import com.ibm.aglets.security.PolicyDB;
import com.ibm.aglets.security.PolicyFileReader;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.URIPattern;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolicyImpl
extends Policy {
    private static final String PROPERTY_JAVA_CLASS_PATH = "java.class.path";
    private static final String PROPERTY_AGLETS_CLASS_PATH = "aglets.class.path";
    private static final String PROPERTY_USER_DIRECTORY = "user.dir";
    private static final String PROPERTY_AGLETS_HOME = "aglets.home";
    private static final String PROPERTY_JAVA_HOME = "java.home";
    private static final String JAVA_CLASS_PATH = PolicyImpl.getSystemProperty("java.class.path", "");
    private static final String AGLETS_CLASS_PATH = PolicyImpl.getSystemProperty("aglets.class.path", "");
    private static final String USER_DIRECTORY = PolicyImpl.getSystemProperty("user.dir");
    private static final String AGLETS_HOME = PolicyImpl.getSystemProperty("aglets.home");
    private static final String JAVA_HOME = PolicyImpl.getSystemProperty("java.home");
    private static final String SEP = File.separator;
    private static final char SEPCHAR = File.separatorChar;
    private Permissions _systemPermissions = null;
    private Permissions _appPermissions = null;
    private Permissions _untrustedPermissions = new Permissions();
    private PolicyDB _policyDB = null;
    private static final String PATH_SEPARATORS = " " + File.pathSeparator;
    private static final char CHAR_DOT = '.';
    private static final String STRING_DOT;
    private static final String CURRENT_DIRECTORY;
    private static final String[] defaultAgletsPolicy;

    public PolicyImpl() {
        this.refresh();
    }

    private void addAppClassPath() {
        this.addClassPath(JAVA_CLASS_PATH);
        this.addClassPath(AGLETS_CLASS_PATH);
    }

    private void addAppPermission(Permission permission) {
        if (this._appPermissions == null) {
            this._appPermissions = new Permissions();
        }
        this._appPermissions.add(permission);
    }

    private void addClassPath(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = URIPattern.canonicalFilename(stringArray[n]);
            if (new File(string).isDirectory()) {
                string = string.charAt(string.length() - 1) != SEPCHAR ? string + SEP + "-" : string + "-";
            }
            this.addAppPermission(new FilePermission(string, "read"));
            ++n;
        }
    }

    private void addClassPath(String string) {
        if (string == null) {
            return;
        }
        this.addClassPath(PolicyImpl.strToPathList(string));
    }

    /*
     * Unable to fully structure code
     */
    private void addClassPath(Enumeration var1_1) {
        if (var1_1 != null) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (String)var1_1.nextElement();
            if (PolicyImpl.CURRENT_DIRECTORY.equals(var2_2)) {
                var2_2 = PolicyImpl.USER_DIRECTORY;
            }
            if (new File(var3_3 = URIPattern.canonicalFilename(var2_2)).isDirectory()) {
                var3_3 = var3_3.charAt(var3_3.length() - 1) != PolicyImpl.SEPCHAR ? var3_3 + PolicyImpl.SEP + "-" : var3_3 + "-";
            }
            this.addAppPermission(new FilePermission(var3_3, "read"));
lbl9:
            // 2 sources

            ** while (var1_1.hasMoreElements())
        }
lbl10:
        // 1 sources

    }

    private void addSystemPermission(Permission permission) {
        if (this._systemPermissions == null) {
            this._systemPermissions = new Permissions();
        }
        this._systemPermissions.add(permission);
    }

    private void checkAgletsPolicyFile() {
        this.checkAgletsPolicyFile(PolicyFileReader.getUserPolicyFilename());
    }

    private void checkAgletsPolicyFile(String string) {
        String string2;
        File file;
        File file2 = new File(string);
        if (file2 == null || !file2.exists()) {
            System.out.println("Aglets Policy File does not exist.");
            this.makeDefaultAgletsPolicyFile(string);
            System.out.println("Aglets Policy File is created.");
        }
        int n = string.lastIndexOf(SEP);
        String string3 = "";
        if (n >= 0) {
            string3 = string.substring(0, n);
        }
        if ((file = new File(string2 = string3 + SEP + "sample.policy")) == null || !file.exists()) {
            this.makeDefaultAgletsPolicyFile(string2);
        }
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (this._policyDB == null) {
            return this._untrustedPermissions;
        }
        return this._policyDB.getPermissions(codeSource);
    }

    static final String getSystemProperty(String string) {
        String string2 = null;
        try {
            final String string3 = string;
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string3);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    static final String getSystemProperty(String string, String string2) {
        String string3 = null;
        try {
            final String string4 = string;
            final String string5 = string2;
            string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string4, string5);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    private void initAppPermissions() {
        this._appPermissions = new Permissions();
        this.addAppPermission(new AllPermission());
    }

    private void initSystemPermissions() {
        this._systemPermissions = new Permissions();
        this.addSystemPermission(new AllPermission());
    }

    private void makeAgletsPolicyFile(FileWriter fileWriter, String[] stringArray) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        int n = 0;
        while (n < stringArray.length) {
            this.writeLine(bufferedWriter, stringArray[n]);
            ++n;
        }
        bufferedWriter.close();
    }

    private void makeDefaultAgletsPolicyFile(FileWriter fileWriter) throws IOException {
        this.makeAgletsPolicyFile(fileWriter, defaultAgletsPolicy);
    }

    private void makeDefaultAgletsPolicyFile(String string) {
        try {
            if (!FileUtils.ensureDirectory(string)) {
                System.out.println("Aglets Policy File initialization failed.");
                return;
            }
            this.makeDefaultAgletsPolicyFile(new FileWriter(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void refresh() {
        this.initSystemPermissions();
        this.initAppPermissions();
        this.checkAgletsPolicyFile();
        this._policyDB = PolicyFileReader.getAllPolicyDB();
    }

    public void setPublicRoot(String string) {
        this._policyDB.setPublicRoot(string);
    }

    public void setSystemCodeBase(String string) {
        this._policyDB.setSystemCodeBase(string);
    }

    public void setSystemCodeBase(URL uRL) {
        this._policyDB.setSystemCodeBase(uRL);
    }

    private static final String[] strToPathList(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_SEPARATORS);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (CURRENT_DIRECTORY.equals(string2)) {
                string2 = USER_DIRECTORY;
            }
            if (string2 == null || string2.equals("")) continue;
            vector.addElement(string2);
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object e = vector.elementAt(n3);
            if (e instanceof String) {
                String string3;
                stringArray[n2] = string3 = (String)e;
                ++n2;
            }
            ++n3;
        }
        return stringArray;
    }

    private void writeLine(BufferedWriter bufferedWriter, String string) throws IOException {
        if (bufferedWriter == null) {
            throw new IOException("no BufferedWriter");
        }
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    static {
        CURRENT_DIRECTORY = STRING_DOT = String.valueOf('.');
        defaultAgletsPolicy = new String[]{"//", "// Aglets Security Policy File", "//", "// This file should be placed on", "//      {user.home}/.aglets/security/aglets.policy", "//", "// ------------------------------------------------------------", "// If you wish to specify a backslash character ('\\'),", "// in the policy file (e.g. \"C:\\tmp\\ASDK\")", "// use double backslashes \"\\\\\".", "// For example,", "//   permission java.io.FilePermission \"C:\\\\tmp\\\\ASDK\", \"read\";", "// But you can substitute a slash character ('/') for backslash like this:", "//   permission java.io.FilePermission \"C:/tmp/ASDK\", \"read\";", "// ------------------------------------------------------------", "//", "//", "// ------------------------------------------------------------", "// sample", "// ------------------------------------------------------------", "//", "grant", " // codeBase \"atp://host.foo.bar:4434/-\"", " // codeBase \"atp://*.ibm.com:>=1024/\"", " // codeBase \"atp://*.ibm.com:2000-3000/\"", " // codeBase \"*://*:*/\"", " codeBase \"atp://*:*/\"", " // , signedBy \"onono,moshima\" /* code is signed by onono and moshima */", " // , ownedBy \"kosaka,mima\" /* the aglet is created by kosaka or mima */", "{", "  // aglet protections", "  protection com.ibm.aglet.security.AgletProtection", "    \"*\", \"dispatch,dispose,deactivate,activate,clone,retract\";", "", "  // message protections", "  protection com.ibm.aglet.security.MessageProtection", "    \"*\", \"*\";", "", "  // aglet", "  permission com.ibm.aglets.security.AgletPermission", "    \"*\", \"dispatch,dispose,deactivate,activate,clone,retract\";", "", "  // messages", "  permission com.ibm.aglets.security.MessagePermission", "    \"*\", \"*\";", "", "  // aglet context", "  permission com.ibm.aglets.security.ContextPermission", "    \"*\", \"multicast,subscribe\";", "  permission com.ibm.aglets.security.ContextPermission", "    \"*\", \"create,receive,retract\";", "  permission com.ibm.aglets.security.ContextPermission", "    \"property.*\", \"read,write\";", "", "  // runtime", "  permission java.lang.RuntimePermission", "    \"createClassLoader\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.java.*\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.com.ibm.aglets.util.*\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.com.ibm.aglets.AgletProxyImpl\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.com.ibm.aglet.*\";", "  permission java.lang.RuntimePermission", "    \"loadLibrary.JdbcOdbc\";         // for JDBC/ODBC", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.sun.jdbc.odbc\"; // for JDBC/ODBC", "", "  // window", "  permission java.awt.AWTPermission \"showWindowWithoutWarningBanner\";", "", "  // property", "  permission java.util.PropertyPermission \"awt.*\", \"read\";", "  permission java.util.PropertyPermission \"hotjava.*\", \"read\";", "  permission java.util.PropertyPermission \"apple.*\", \"read\";", "  permission java.util.PropertyPermission \"file.*\", \"read\";", "  permission java.util.PropertyPermission \"line.separator\", \"read\";", "  permission java.util.PropertyPermission \"path.separator\", \"read\";", "  permission java.util.PropertyPermission \"http.maxConnections\", \"read\";", "  permission java.util.PropertyPermission \"user.timezone\", \"read\";", "  permission java.util.PropertyPermission \"socksProxyHost\", \"read\";", "  permission java.util.PropertyPermission \"socksProxyPort\", \"read\";", "  // for JDBC/ODBC", "  permission java.util.PropertyPermission \"browser\", \"read\";", "  // for RMI", "  permission java.util.PropertyPermission \"java.rmi.*\", \"read\";", "  permission java.util.PropertyPermission \"sun.rmi.*\", \"read\";", "  permission java.util.PropertyPermission \"http.proxyHost\", \"read\";", "  permission java.util.PropertyPermission \"proxyHost\", \"read\";", "  // for examples.patterns.Finger, examples.patterns.Writer", "  permission java.util.PropertyPermission \"user.*\", \"read\";", "  permission java.util.PropertyPermission \"os.*\", \"read\";", "  permission java.util.PropertyPermission \"java.*\", \"read\";", "", "  // socket", "  permission java.net.SocketPermission \"localhost:*\", \"listen,resolve\";", "  permission java.net.SocketPermission \"codebase:*\", \"connect\";", "", "  // file", "  permission java.io.FilePermission \"codebase\", \"read\";", "};", "", "grant", " codeBase \"http://*:*/\"", "{", "  // aglet protections", "  protection com.ibm.aglet.security.AgletProtection", "    \"*\", \"dispatch,dispose,deactivate,activate,clone,retract\";", "", "  // message protections", "  protection com.ibm.aglet.security.MessageProtection", "    \"*\", \"*\";", "", "  // aglet", "  permission com.ibm.aglets.security.AgletPermission", "    \"*\", \"dispatch,dispose,deactivate,activate,clone,retract\";", "", "  // messages", "  permission com.ibm.aglets.security.MessagePermission", "    \"*\", \"*\";", "", "  // aglet context", "  permission com.ibm.aglets.security.ContextPermission", "    \"*\", \"multicast,subscribe\";", "  permission com.ibm.aglets.security.ContextPermission", "    \"*\", \"create,receive,retract\";", "  permission com.ibm.aglets.security.ContextPermission", "    \"property.*\", \"read,write\";", "", "  // runtime", "  permission java.lang.RuntimePermission", "    \"createClassLoader\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.java.*\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.com.ibm.aglets.util.*\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.com.ibm.aglets.AgletProxyImpl\";", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.com.ibm.aglet.*\";", "  permission java.lang.RuntimePermission", "    \"loadLibrary.JdbcOdbc\";         // for JDBC/ODBC", "  permission java.lang.RuntimePermission", "    \"accessClassInPackage.sun.jdbc.odbc\"; // for JDBC/ODBC", "", "  // window", "  permission java.awt.AWTPermission \"showWindowWithoutWarningBanner\";", "", "  // property", "  permission java.util.PropertyPermission \"awt.*\", \"read\";", "  permission java.util.PropertyPermission \"hotjava.*\", \"read\";", "  permission java.util.PropertyPermission \"apple.*\", \"read\";", "  permission java.util.PropertyPermission \"file.*\", \"read\";", "  permission java.util.PropertyPermission \"line.separator\", \"read\";", "  permission java.util.PropertyPermission \"path.separator\", \"read\";", "  permission java.util.PropertyPermission \"http.maxConnections\", \"read\";", "  permission java.util.PropertyPermission \"user.timezone\", \"read\";", "  permission java.util.PropertyPermission \"socksProxyHost\", \"read\";", "  permission java.util.PropertyPermission \"socksProxyPort\", \"read\";", "  // for JDBC/ODBC", "  permission java.util.PropertyPermission \"browser\", \"read\";", "  // for RMI", "  permission java.util.PropertyPermission \"java.rmi.*\", \"read\";", "  permission java.util.PropertyPermission \"sun.rmi.*\", \"read\";", "  permission java.util.PropertyPermission \"http.proxyHost\", \"read\";", "  permission java.util.PropertyPermission \"proxyHost\", \"read\";", "  // for examples.patterns.Finger, examples.patterns.Writer", "  permission java.util.PropertyPermission \"user.*\", \"read\";", "  permission java.util.PropertyPermission \"os.*\", \"read\";", "  permission java.util.PropertyPermission \"java.*\", \"read\";", "", "  // socket", "  permission java.net.SocketPermission \"localhost:*\", \"listen,resolve\";", "  permission java.net.SocketPermission \"codebase:*\", \"connect\";", "", "  // file", "  permission java.io.FilePermission \"codebase\", \"read\";", "};", "", "grant", " codeBase \"file:///-/\"", "{", "  // aglet protections", "  protection com.ibm.aglet.security.AgletProtection", "    \"*\", \"dispatch,dispose,deactivate,activate,clone,retract\";", "", "  // message protections", "  protection com.ibm.aglet.security.MessageProtection", "    \"*\", \"*\";", "", "  // can do anything", "  permission java.security.AllPermission \"*\", \"*\";", "};"};
    }
}

