/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import com.ibm.aglet.security.Protection;
import com.ibm.aglets.security.PolicyFileParsingException;
import com.ibm.aglets.security.PolicyFileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolicyPermission {
    private static final String CLASSNAME_PERMISSION = "java.security.Permission";
    private static final String CLASSNAME_BASIC_PERMISSION = "java.security.BasicPermission";
    private static final String CLASSNAME_FILE_PERMISSION = "java.io.FilePermission";
    private static final String CLASSNAME_SOCKET_PERMISSION = "java.net.SocketPermission";
    private static final String CLASSNAME_AWT_PERMISSION = "java.awt.AWTPermission";
    private static final String CLASSNAME_NET_PERMISSION = "java.net.NetPermission";
    private static final String CLASSNAME_PROPERTY_PERMISSION = "java.util.PropertyPermission";
    private static final String CLASSNAME_REFLECT_PERMISSION = "java.lang.reflect.ReflectPermission";
    private static final String CLASSNAME_RUNTIME_PERMISSION = "java.lang.RuntimePermission";
    private static final String CLASSNAME_SECURITY_PERMISSION = "java.security.SecurityPermission";
    private static final String CLASSNAME_SERIALIZABLE_PERMISSION = "java.io.SerializablePermission";
    private static final String CLASSNAME_UNRESOLVED_PERMISSION = "java.security.UnresolvedPermission";
    private static final String CLASSNAME_ALL_PERMISSION = "java.security.AllPermission";
    private static final String CLASSNAME_AGLET_PERMISSION = "com.ibm.aglets.security.AgletPermission";
    private static final String CLASSNAME_MESSAGE_PERMISSION = "com.ibm.aglets.security.MessagePermission";
    private static final String CLASSNAME_CONTEXT_PERMISSION = "com.ibm.aglets.security.ContextPermission";
    private static final String CLASSNAME_ACTIVITY_PERMISSION = "com.ibm.aglets.security.ActivityPermission";
    private static final String CLASSNAME_AGLET_PROTECTION = "com.ibm.aglet.security.AgletProtection";
    private static final String CLASSNAME_MESSAGE_PROTECTION = "com.ibm.aglet.security.MessageProtection";
    private static final String CLASSNAME_PERMISSION_TMP = "java.security.Permission";
    private static final String CLASSNAME_BASIC_PERMISSION_TMP = "java.security.BasicPermission";
    private static final String CLASSNAME_FILE_PERMISSION_TMP = "java.io.FilePermission";
    private static final String CLASSNAME_SOCKET_PERMISSION_TMP = "java.net.SocketPermission";
    private static final String CLASSNAME_AWT_PERMISSION_TMP = "java.awt.AWTPermission";
    private static final String CLASSNAME_NET_PERMISSION_TMP = "java.net.NetPermission";
    private static final String CLASSNAME_PROPERTY_PERMISSION_TMP = "java.util.PropertyPermission";
    private static final String CLASSNAME_REFLECT_PERMISSION_TMP = "java.lang.reflect.ReflectPermission";
    private static final String CLASSNAME_RUNTIME_PERMISSION_TMP = "java.lang.RuntimePermission";
    private static final String CLASSNAME_SECURITY_PERMISSION_TMP = "java.security.SecurityPermission";
    private static final String CLASSNAME_SERIALIZABLE_PERMISSION_TMP = "java.io.SerializablePermission";
    private static final String CLASSNAME_UNRESOLVED_PERMISSION_TMP = "java.security.UnresolvedPermission";
    private static final String CLASSNAME_ALL_PERMISSION_TMP = "java.security.AllPermission";
    private String _originalClassName = null;
    private String _className = null;
    private Class _class = null;
    private String _targetName = null;
    private String _actions = null;
    private String _signerNames = null;
    private static final String QUOTE = String.valueOf('\"');
    private static final String COMMA = String.valueOf(',');
    private static final String TERMINATOR = String.valueOf(';');
    private static final String NAME_SEPARATOR = COMMA;
    private static final char CHAR_SLASH = '/';
    private static final char CHAR_BACKSLASH = '\\';
    private static final char CHAR_ESCAPE = '\\';
    private static final int NO_TYPE = 0;
    private static final int TYPE_PERMISSION = 1;
    private static final int TYPE_PROTECTION = 2;
    private int _type = 0;
    private Vector _signers = null;
    private Permission _permission = null;
    private PolicyFileReader _reader = null;

    public PolicyPermission(PolicyFileReader policyFileReader, String string, String string2) throws ClassNotFoundException {
        this._reader = policyFileReader;
        this.setType(string);
        this.setClassName(string2);
    }

    public PolicyPermission(String string) throws ClassNotFoundException {
        this.setType(PolicyPermission.getType(string));
        this.setClassName(string);
    }

    protected void checkSigner(String string) throws SecurityException {
        if (!this.isSignedBy(string)) {
            throw new SecurityException("The permission class '" + this._class.getName() + "' is not signed by '" + string + "'.");
        }
    }

    protected void checkSigners(Vector vector) throws SecurityException {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e instanceof String) {
                String string = (String)e;
                this.checkSigner(string);
            }
            ++n2;
        }
    }

    private static String convertClassName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string.equals("java.security.Permission")) {
            string2 = "java.security.Permission";
        } else if (string.equals("java.security.BasicPermission")) {
            string2 = "java.security.BasicPermission";
        } else if (string.equals("java.io.FilePermission")) {
            string2 = "java.io.FilePermission";
        } else if (string.equals("java.net.SocketPermission")) {
            string2 = "java.net.SocketPermission";
        } else if (string.equals("java.awt.AWTPermission")) {
            string2 = "java.awt.AWTPermission";
        } else if (string.equals("java.net.NetPermission")) {
            string2 = "java.net.NetPermission";
        } else if (string.equals("java.util.PropertyPermission")) {
            string2 = "java.util.PropertyPermission";
        } else if (string.equals("java.lang.reflect.ReflectPermission")) {
            string2 = "java.lang.reflect.ReflectPermission";
        } else if (string.equals("java.lang.RuntimePermission")) {
            string2 = "java.lang.RuntimePermission";
        } else if (string.equals("java.security.SecurityPermission")) {
            string2 = "java.security.SecurityPermission";
        } else if (string.equals("java.io.SerializablePermission")) {
            string2 = "java.io.SerializablePermission";
        } else if (string.equals("java.security.UnresolvedPermission")) {
            string2 = "java.security.UnresolvedPermission";
        } else if (string.equals("java.security.AllPermission")) {
            string2 = "java.security.AllPermission";
        }
        return string2;
    }

    public Permission create() throws PolicyFileParsingException, SecurityException {
        Object t;
        Constructor constructor;
        if (this._class == null) {
            throw this.getParsingException("No permission class.");
        }
        int n = 0;
        if (this._targetName != null) {
            ++n;
        }
        if (this._actions != null) {
            ++n;
        }
        Class[] classArray = new Class[n];
        int n2 = 0;
        try {
            if (this._targetName != null) {
                classArray[n2] = Class.forName("java.lang.String");
                ++n2;
            }
            if (this._actions != null) {
                classArray[n2] = Class.forName("java.lang.String");
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.getParsingException(classNotFoundException.toString());
        }
        try {
            constructor = this._class.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.getParsingException(noSuchMethodException.toString() + " : " + this._class.getName());
        }
        if (constructor == null) {
            throw this.getParsingException("No constructor.");
        }
        Object[] objectArray = new String[n];
        n2 = 0;
        if (this._targetName != null) {
            objectArray[n2] = this._targetName;
            ++n2;
        }
        if (this._actions != null) {
            objectArray[n2] = this._actions;
            ++n2;
        }
        try {
            t = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw this.getParsingException(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.getParsingException(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.getParsingException(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.getParsingException(invocationTargetException.getTargetException().toString());
        }
        if (!(t instanceof Permission)) {
            this._permission = null;
            throw this.getParsingException("Non-permission class cannot be specified.");
        }
        if (this._type == 2 && !(t instanceof Protection)) {
            this._permission = null;
            throw this.getParsingException("Protection class is excepted.");
        }
        this._permission = (Permission)t;
        return this._permission;
    }

    public boolean equals(PolicyPermission policyPermission) {
        if (policyPermission == null) {
            return false;
        }
        if (!this.equalsClassName(policyPermission.getClassName())) {
            return false;
        }
        if (!this.equalsSigners(policyPermission._signers)) {
            return false;
        }
        if (!this.equalsTargetName(policyPermission.getTargetName())) {
            return false;
        }
        return this.equalsActions(policyPermission.getActions());
    }

    public boolean equals(Object object) {
        if (object instanceof PolicyPermission) {
            PolicyPermission policyPermission = (PolicyPermission)object;
            return this.equals(policyPermission);
        }
        return false;
    }

    public boolean equalsActions(String string) {
        if (this._actions == null || string == null) {
            return false;
        }
        return this._actions.equals(string);
    }

    public boolean equalsClassName(String string) {
        if (string == null) {
            return false;
        }
        return this._className.equals(string);
    }

    public boolean equalsSigners(Vector vector) {
        return PolicyPermission.equalsSigners(vector, this._signers);
    }

    public static boolean equalsSigners(Vector vector, Vector vector2) {
        return PolicyPermission.includesSigners(vector, vector2) && PolicyPermission.includesSigners(vector2, vector);
    }

    public boolean equalsTargetName(String string) {
        if (this._targetName == null || string == null) {
            return false;
        }
        return this._targetName.equals(string);
    }

    private static final String escapeBackslash(String string) {
        return PolicyPermission.escapeChar(string, '\\');
    }

    private static final String escapeChar(String string, char c) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            if (stringBuffer.charAt(n2) == c) {
                stringBuffer.insert(n2, '\\');
                ++n2;
                n = stringBuffer.length();
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getActions() {
        return this._actions;
    }

    public String getClassName() {
        return this._className;
    }

    private PolicyFileParsingException getParsingException(String string) {
        if (this._reader != null) {
            return this._reader.getParsingException(string);
        }
        return new PolicyFileParsingException(string);
    }

    public Permission getPermission() {
        return this._permission;
    }

    public String getSignerNames() {
        return this._signerNames;
    }

    public Enumeration getSigners() {
        if (this._signers != null) {
            return this._signers.elements();
        }
        return null;
    }

    public String getTargetName() {
        return this._targetName;
    }

    private String getType() {
        String string = null;
        switch (this._type) {
            case 1: {
                string = "permission";
                break;
            }
            case 2: {
                string = "protection";
            }
        }
        return string;
    }

    private static String getType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.equals("java.security.Permission") || string.equals("java.security.BasicPermission") || string.equals("java.io.FilePermission") || string.equals("java.net.SocketPermission") || string.equals("java.awt.AWTPermission") || string.equals("java.net.NetPermission") || string.equals("java.util.PropertyPermission") || string.equals("java.lang.reflect.ReflectPermission") || string.equals("java.lang.RuntimePermission") || string.equals("java.security.SecurityPermission") || string.equals("java.io.SerializablePermission") || string.equals("java.security.UnresolvedPermission") || string.equals("java.security.AllPermission") || string.equals(CLASSNAME_AGLET_PERMISSION) || string.equals(CLASSNAME_MESSAGE_PERMISSION) || string.equals(CLASSNAME_CONTEXT_PERMISSION)) {
            string2 = "permission";
        } else if (string.equals(CLASSNAME_AGLET_PROTECTION) || string.equals(CLASSNAME_MESSAGE_PROTECTION)) {
            string2 = "protection";
        }
        return string2;
    }

    protected static boolean includesSigners(Vector vector, Vector vector2) {
        if (vector == null) {
            return true;
        }
        if (vector2 == null) {
            return false;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string;
            Object e = vector.elementAt(n2);
            if (e instanceof String && !PolicyPermission.isSigner(string = (String)e, vector2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isSignedBy(String string) {
        if (string.equals("*")) {
            return true;
        }
        return true;
    }

    protected boolean isSignedBy(Vector vector) {
        if (vector == null) {
            return true;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string;
            Object e = vector.elementAt(n2);
            if (e instanceof String && !this.isSignedBy(string = (String)e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected static boolean isSigner(String string, Vector vector) {
        if (string == null) {
            return true;
        }
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            Object e = vector.elementAt(n2);
            if (e instanceof String && string.equals(string2 = (String)e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setActions(String string) {
        this._actions = string;
    }

    protected void setClassName(String string) throws ClassNotFoundException {
        String string2 = string;
        this._class = Class.forName(string2);
        this._originalClassName = string;
        this._className = string2;
    }

    public void setSignerNames(String string) throws SecurityException {
        Vector<String> vector = null;
        if (string != null) {
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, NAME_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken().trim());
            }
        }
        this.checkSigners(vector);
        this._signers = vector;
        this._signerNames = string;
    }

    public void setTargetName(String string) {
        this._targetName = string;
    }

    private void setType(String string) {
        if (string == null) {
            this._type = 0;
            return;
        }
        this._type = string.equals("permission") ? 1 : (string.equals("protection") ? 2 : 0);
    }

    public String toString() {
        int n;
        String string = this.getType();
        if (this._class != null) {
            string = string + " " + this._originalClassName;
        }
        if (this._targetName != null) {
            string = string + " " + QUOTE + PolicyPermission.escapeBackslash(this._targetName) + QUOTE;
        }
        if (this._actions != null) {
            string = string + COMMA + " " + QUOTE + PolicyPermission.escapeBackslash(this._actions) + QUOTE;
        }
        if (this._signers != null && (n = this._signers.size()) > 0) {
            String string2 = QUOTE;
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    string2 = string2 + NAME_SEPARATOR;
                }
                string2 = string2 + this._signers.elementAt(n2).toString();
                ++n2;
            }
            string2 = string2 + QUOTE;
            string = string + COMMA + " " + "signedBy" + " " + string2;
        }
        string = string + TERMINATOR;
        return string;
    }
}

