/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;

public class Randoms {
    private static Hashtable _secureTable = new Hashtable();
    private static Hashtable _pseudoTable = new Hashtable();
    private static boolean _useSecureRandomSeed = true;

    public static byte[] getPseudoSeed(int n) {
        byte[] byArray = new byte[n];
        Object[] objectArray = new Object[(int)(System.currentTimeMillis() & 0xFFL)];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(System.currentTimeMillis() * 3L);
            long l = (long)new Object().hashCode() + System.currentTimeMillis() & 0xFFL;
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
        return byArray;
    }

    public static synchronized void getRandom(int n, byte[] byArray) {
        SecureRandom secureRandom = Randoms.getRandomGenerator(n);
        if (secureRandom != null) {
            secureRandom.nextBytes(byArray);
        }
    }

    public static synchronized SecureRandom getRandomGenerator(int n) {
        return Randoms.getRandomGenerator(n, _useSecureRandomSeed);
    }

    public static synchronized SecureRandom getRandomGenerator(int n, boolean bl) {
        Integer n2 = new Integer(n);
        SecureRandom secureRandom = null;
        Hashtable hashtable = null;
        hashtable = bl ? _secureTable : _pseudoTable;
        Object v = hashtable.get(n2);
        if (v != null && v instanceof SecureRandom) {
            secureRandom = (SecureRandom)v;
        } else {
            secureRandom = new SecureRandom(Randoms.getSeed(n, bl));
            hashtable.put(n2, secureRandom);
        }
        return secureRandom;
    }

    private static byte[] getSeed(int n) {
        return Randoms.getSeed(n, _useSecureRandomSeed);
    }

    private static byte[] getSeed(int n, boolean bl) {
        if (!bl) {
            System.out.print("(Using Pseudo Seed)");
            return Randoms.getPseudoSeed(n);
        }
        try {
            System.out.print("(Using Secure Seed - SHA1PRNG)");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            return secureRandom.generateSeed(n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.print("[FAILED, use pseudo seed]");
            return Randoms.getPseudoSeed(n);
        }
    }

    public static boolean getUseSecureRandomSeed() {
        return _useSecureRandomSeed;
    }

    public static void setUseSecureRandomSeed(boolean bl) {
        _useSecureRandomSeed = bl;
    }
}

