/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.MessageManager;
import com.ibm.aglets.AgletRuntime;
import com.ibm.aglets.AgletThread;
import com.ibm.aglets.ResourceManager;
import com.ibm.aglets.tahiti.CacheManager;
import com.ibm.aglets.tahiti.DigestTable;
import com.ibm.awb.misc.Archive;
import com.ibm.awb.misc.Hexadecimal;
import com.ibm.maf.AgentProfile;
import com.ibm.maf.ClassName;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class AgletClassLoader
extends ClassLoader
implements ResourceManager {
    protected static CacheManager _cache = null;
    static AgentProfile _agent_profile = null;
    private URL _codeBase = null;
    private Certificate _ownerCert = null;
    protected DigestTable _digest_table = new DigestTable();
    private Hashtable _resolvedClassCache = new Hashtable();
    private Vector _resources = new Vector();

    protected AgletClassLoader(URL uRL, Certificate certificate) {
        this._codeBase = uRL;
        this._ownerCert = certificate;
    }

    public void addResource(Object object) {
        Vector vector = this._resources;
        synchronized (vector) {
            if (!this._resources.contains(object)) {
                this._resources.addElement(object);
            }
        }
    }

    public void cacheResolvedClass(Class clazz) {
        this._resolvedClassCache.put(clazz.getName(), clazz);
    }

    public boolean contains(Class clazz) {
        return this._resolvedClassCache.contains(clazz);
    }

    public void disposeAllResources() {
        Vector vector = this._resources;
        synchronized (vector) {
            Enumeration enumeration = this._resources.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof Window)) continue;
                ((Window)e).dispose();
            }
            this._resources = null;
        }
    }

    private static void dumpBytes(byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                System.out.print(Hexadecimal.valueOf(byArray[n]));
                if (n % 16 == 15) {
                    System.out.println();
                } else {
                    System.out.print(" ");
                }
                ++n;
            }
            if (byArray.length % 16 != 0) {
                System.out.println();
            }
        }
    }

    public void finalize() {
        AgletClassLoader.verboseOut("Class Loader: Garbage Collected");
        this.disposeAllResources();
        this.releaseCacheEntries();
    }

    private byte[] findByteCode(String string) {
        return this.getResourceAsByteArray(string.replace('.', '/') + ".class");
    }

    protected byte[] findByteCodeInCache(String string) {
        long l = this._digest_table.getDigest(string);
        return _cache.getData(string, l);
    }

    private Class findClassInternal(String string) throws ClassNotFoundException {
        Class clazz = null;
        try {
            clazz = this.findSystemClass(string);
            if (clazz != null) {
                AgletClassLoader.verboseOut("Loading " + string + " from System");
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            AgletClassLoader.verboseOut("Using class " + string + " in cache");
            return clazz;
        }
        clazz = this.loadClassFromCodeBase(string);
        if (clazz != null) {
            AgletClassLoader.verboseOut("Loading class " + string + " from CodeBase");
        }
        return clazz;
    }

    private Class findResolvedClass(String string) {
        return (Class)this._resolvedClassCache.get(string);
    }

    public Archive getArchive(ClassName[] classNameArray) {
        int n = classNameArray.length;
        if (this.match(classNameArray)) {
            Archive archive = new Archive();
            int n2 = 0;
            while (n2 < n) {
                String string = classNameArray[n2].name;
                byte[] byArray = this.findByteCodeInCache(string);
                if (byArray != null) {
                    long l = this._digest_table.getDigest(string);
                    AgletClassLoader.verboseOut("putResource(" + string + "," + l + "," + byArray.length + ") into archive");
                    archive.putResource(string, l, byArray);
                }
                ++n2;
            }
            return archive;
        }
        System.err.println("getArchive: doesn't match");
        return null;
    }

    public synchronized ClassName[] getClassNames(Class[] classArray) {
        return this._digest_table.getClassNames(classArray);
    }

    public URL getCodeBase() {
        return this._codeBase;
    }

    public Certificate getOwnerCertificate() {
        return this._ownerCert;
    }

    protected synchronized byte[] getResourceAsByteArray(String string) {
        long l = this._digest_table.getDigest(string);
        byte[] byArray = null;
        if (l != 0L) {
            byArray = _cache.getData(string, l);
            AgletClassLoader.verboseOut("get '" + string + "' from cache by getData(" + string + "," + l + ")");
        }
        if (byArray == null) {
            try {
                final String string2 = string;
                byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        byte[] byArray = AgletClassLoader.this.loadResourceFromCodeBase(string2);
                        AgletClassLoader.verboseOut("get '" + string2 + "' from codebase");
                        return byArray;
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (byArray != null) {
            this.putResource(string, byArray);
        }
        return byArray;
    }

    public InputStream getResourceAsStream(String string) {
        byte[] byArray = this.getResourceAsByteArray(string);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public void importArchive(Archive archive) {
        Archive.Entry[] entryArray = archive.entries();
        AgletClassLoader.verboseOut("importArchive()");
        int n = 0;
        while (n < entryArray.length) {
            AgletClassLoader.verboseOut("archive[" + n + "].name()=" + entryArray[n].name());
            AgletClassLoader.verboseOut("archive[" + n + "].digest()=" + entryArray[n].digest());
            AgletClassLoader.verboseOut("archive[" + n + "].data().length=" + entryArray[n].data().length);
            this.putResource(entryArray[n].name(), archive.getResourceAsByteArray(entryArray[n].name()));
            ++n;
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            Class clazz = this.findResolvedClass(string);
            if (clazz != null) {
                AgletClassLoader.verboseOut("Using class " + string + " in resolved cache");
                return clazz;
            }
            clazz = this.findClassInternal(string);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            String string2 = clazz.getName();
            if (!string2.equals(string)) {
                throw new ClassNotFoundException(string);
            }
            if (bl) {
                if (this._resolvedClassCache.contains(clazz)) {
                    AgletClassLoader.verboseOut(string + " was resolved before.");
                    return clazz;
                }
                AgletClassLoader.verboseOut("resolving.. " + string);
                boolean bl2 = false;
                try {
                    try {
                        this.resolveClass(clazz);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        throw new ClassNotFoundException("Resolve class: " + exception.toString());
                    }
                    Object var8_7 = null;
                    if (bl2) {
                        this.cacheResolvedClass(clazz);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (bl2) {
                        this.cacheResolvedClass(clazz);
                    }
                    throw throwable;
                }
            }
            return clazz;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            Thread.dumpStack();
            throw securityException;
        }
    }

    private Class loadClassFromCodeBase(String string) throws ClassNotFoundException {
        AgletClassLoader.verboseOut("loadClassFromCodeBase(" + string + ")");
        byte[] byArray = this.findByteCode(string);
        if (byArray == null) {
            throw new ClassNotFoundException(string);
        }
        AgletClassLoader.verboseOut("findByteCode(" + string + ") returns bytecode (" + byArray.length + "bytes)");
        try {
            CodeSource codeSource;
            ProtectionDomain protectionDomain;
            Class<?> clazz;
            AgletClassLoader.verboseOut("define class " + string);
            Object var3_3 = null;
            Certificate[] certificateArray = null;
            if (this._ownerCert != null) {
                certificateArray = new Certificate[]{this._ownerCert};
            }
            if (!(clazz = this.defineClass(string, byArray, 0, byArray.length, protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(codeSource = new CodeSource(this._codeBase, certificateArray)){
                private final /* synthetic */ CodeSource val$cs;
                {
                    this.val$cs = codeSource;
                }

                public Object run() {
                    Policy policy = Policy.getPolicy();
                    PermissionCollection permissionCollection = policy.getPermissions(this.val$cs);
                    return new ProtectionDomain(this.val$cs, permissionCollection);
                }
            }))).getName().equals(string)) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }
        catch (ClassFormatError classFormatError) {
            classFormatError.printStackTrace();
            System.err.println("When loading " + string + " from " + this._codeBase + " : " + classFormatError.getClass().getName() + classFormatError.getMessage());
            throw new ClassNotFoundException("When loading " + string + " from " + this._codeBase + " : " + classFormatError.getClass().getName() + classFormatError.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadResourceFromCodeBase(String var1_1) {
        block15: {
            block14: {
                var3_2 = null;
                try {
                    try {
                        var4_3 = new URL(this._codeBase, var1_1);
                        var5_5 = -1;
                        var6_7 = var4_3.openConnection();
                        var6_7.setRequestProperty("user-agent", "Aglets/1.1");
                        var6_7.setRequestProperty("agent-system", "aglets");
                        var6_7.setRequestProperty("agent-language", "java");
                        var6_7.setDoInput(true);
                        var6_7.setUseCaches(false);
                        var6_7.connect();
                        var3_2 = var6_7.getInputStream();
                        var5_5 = var6_7.getContentLength();
                        if (var5_5 < 0) {
                            var5_5 = var3_2.available();
                        }
                        if (var5_5 == 0) {
                            var7_8 = null;
                            var10_10 = null;
                            if (var3_2 == null) return var7_8;
                            break block14;
                        }
                        var2_18 = new byte[var5_5];
                        var7_9 = 0;
                        while (true) {
                            if (var5_5 <= 0) {
                                var3_2.close();
                                break block15;
                            }
                            var8_19 = var3_2.read(var2_18, var7_9, var5_5);
                            var7_9 += var8_19;
                            var5_5 -= var8_19;
                        }
                    }
                    catch (IOException var4_4) {
                        var4_4.printStackTrace();
                        var5_6 = null;
                        var10_12 = null;
                        if (var3_2 == null) return var5_6;
                        try {
                            var3_2.close();
                            return var5_6;
                        }
                        catch (Exception var11_16) {
                            // empty catch block
                        }
                        return var5_6;
                    }
                }
                catch (Throwable var9_20) {
                    var10_13 = null;
                    if (var3_2 == null) throw var9_20;
                    ** try [egrp 2[TRYBLOCK] [2 : 189->196)] { 
lbl50:
                    // 1 sources

                    var3_2.close();
                    throw var9_20;
lbl52:
                    // 1 sources

                    catch (Exception var11_17) {
                        // empty catch block
                    }
                    throw var9_20;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 189->196)] { 
lbl57:
            // 1 sources

            var3_2.close();
            return var7_8;
lbl59:
            // 1 sources

            catch (Exception var11_14) {
                // empty catch block
            }
            return var7_8;
        }
        var10_11 = null;
        if (var3_2 == null) return var2_18;
        try {}
        catch (Exception var11_15) {}
        var3_2.close();
        return var2_18;
        return var2_18;
    }

    public synchronized boolean match(ClassName[] classNameArray) {
        return this._digest_table.match(classNameArray, false);
    }

    public synchronized boolean matchAndImport(ClassName[] classNameArray) {
        return this._digest_table.match(classNameArray, true);
    }

    public AgletThread newAgletThread(MessageManager messageManager) {
        return null;
    }

    private void putResource(String string, byte[] byArray) {
        long l = this._digest_table.getDigest(string);
        if (l == 0L) {
            l = this._digest_table.setData(string, byArray);
            AgletClassLoader.verboseOut("digest of " + string + " = " + l);
            _cache.putData(string, l, byArray, true);
        } else {
            _cache.putData(string, l, byArray, false);
        }
    }

    private void releaseCacheEntries() {
        DigestTable digestTable = this._digest_table;
        synchronized (digestTable) {
            int n = 0;
            while (n < this._digest_table.size()) {
                String string = this._digest_table.getName(n);
                long l = this._digest_table.getDigest(n);
                _cache.releaseData(string, l);
                ++n;
            }
        }
    }

    public void resumeAllThreads() {
    }

    public void setResourceManagerContext() {
    }

    public void stopAllThreads() {
    }

    public void stopThreadGroup() {
    }

    public void suspendAllThreads() {
    }

    public String toString() {
        String string = null;
        string = this._codeBase == null ? "NOWHERE" : this._codeBase.toString();
        String string2 = null;
        string2 = this._ownerCert == null ? "NOBODY" : this._ownerCert.toString();
        return "[AgletClassLoader codebase = " + string + " owner = " + string2 + "]";
    }

    public void unsetResourceManagerContext() {
    }

    private static void verboseOut(String string) {
        AgletRuntime.verboseOut(string);
    }

    static {
        AgletClassLoader.verboseOut("creating cache manager");
        _cache = CacheManager.getCacheManager();
        _agent_profile = new AgentProfile(1, 1, "Aglets", 0, 2, 1, null);
    }
}

