/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglets.tahiti.AgletClassLoader;
import com.ibm.aglets.tahiti.ResourceManagerImpl;
import java.security.Permission;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;

public class AgletsSecurityManager
extends SecurityManager {
    public void checkPermission(Permission permission) {
        if (AgletRuntime.getAgletRuntime().isSecure()) {
            super.checkPermission(permission);
        }
    }

    public boolean checkTopLevelWindow(Object object) {
        boolean bl = super.checkTopLevelWindow(object);
        ResourceManagerImpl resourceManagerImpl = ResourceManagerImpl.getResourceManagerContext();
        if (resourceManagerImpl != null) {
            resourceManagerImpl.addResource(object);
        }
        return true;
    }

    public Certificate getCurrentCertificate() {
        ClassLoader classLoader = this.getCurrentNonSecureClassLoader();
        if (classLoader != null && classLoader instanceof AgletClassLoader) {
            return ((AgletClassLoader)classLoader).getOwnerCertificate();
        }
        return null;
    }

    public ClassLoader getCurrentNonSecureClassLoader() {
        Class<?>[] classArray = this.getClassContext();
        int n = 1;
        while (n < classArray.length) {
            ClassLoader classLoader = classArray[n].getClassLoader();
            if (!(classLoader instanceof SecureClassLoader) && classLoader != null) {
                return classLoader;
            }
            ++n;
        }
        return null;
    }

    public ThreadGroup getThreadGroup() {
        ResourceManagerImpl resourceManagerImpl = ResourceManagerImpl.getResourceManagerContext();
        if (resourceManagerImpl == null) {
            return Thread.currentThread().getThreadGroup();
        }
        return resourceManagerImpl.getThreadGroup();
    }
}

