/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.system.AgletRuntime;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.Resource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Vector;

public class CacheManager {
    private static CacheManager _singleton = null;
    private long _cache_size = 0L;
    String _pool_dir = "";
    int _pool_index = 0;
    private LinkedList _cache = null;
    private Hashtable _pool = null;

    public CacheManager() throws IOException {
        Object object;
        Resource resource = Resource.getResourceFor("aglets");
        try {
            object = AgletRuntime.getAgletRuntime().getServerAddress();
            URL uRL = new URL((String)object);
            this._pool_dir = resource.getString("aglets.cache") + File.separator + uRL.getHost() + '@' + uRL.getPort();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Could not get host info.");
        }
        this.debugln("pool_dir = " + this._pool_dir);
        object = new File(this._pool_dir);
        boolean bl = false;
        boolean bl2 = false;
        try {
            Boolean[] booleanArray = (Boolean[])AccessController.doPrivileged(new PrivilegedAction((File)object){
                private final /* synthetic */ File val$dir;
                {
                    this.val$dir = file;
                }

                public Object run() {
                    Boolean[] booleanArray = new Boolean[]{new Boolean(this.val$dir.exists()), new Boolean(this.val$dir.isDirectory())};
                    return booleanArray;
                }
            });
            bl = booleanArray[0];
            bl2 = booleanArray[1];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl && !bl2) {
            throw new IOException(this._pool_dir + " is not a directory.");
        }
        if (!bl) {
            this.debugln("Creating pool dir " + this._pool_dir);
            if (!FileUtils.ensureDirectory(this._pool_dir + File.separator)) {
                throw new IOException("Failed to create new cache directory : " + this._pool_dir);
            }
        }
        this._cache_size = resource.getInteger("aglets.cache.size", 524288);
        this._cache = new LinkedList(this._cache_size);
        this._pool = new Hashtable();
        try {
            this.readPool();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CacheManager(String string, long l) {
        this._pool_dir = string;
        this._cache_size = l;
        this._cache = new LinkedList(l);
        this._pool = new Hashtable();
        this.readPool();
    }

    void debug(String string) {
    }

    void debugln(String string) {
    }

    private void decRefCount(Entry entry) {
        Entry entry2 = entry;
        synchronized (entry2) {
            this.debugln("refCount--[" + (entry.refCount - 1) + "]: " + entry.toString());
            if (--entry.refCount <= 0) {
                this._cache.remove(entry);
                this._pool.remove(entry);
                entry.remove();
                this.debugln("refCount--: removed " + entry.toString());
            }
        }
    }

    public static CacheManager getCacheManager() {
        if (_singleton == null) {
            try {
                _singleton = new CacheManager();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                _singleton = null;
            }
        }
        return _singleton;
    }

    public synchronized byte[] getData(String string) {
        return this.getData(string, 0L);
    }

    public synchronized byte[] getData(String string, long l) {
        Entry entry = new Entry(string, l, null);
        Entry entry2 = this.getFromCache(entry);
        return entry2 == null ? null : entry2.data;
    }

    synchronized Entry getFromCache(Entry entry) {
        Entry entry2 = this._cache.get(entry);
        if (entry2 == null && (entry2 = (Entry)this._pool.get(entry)) == null) {
            return null;
        }
        this.putIntoCache(entry2);
        Entry entry3 = this._cache.getFirst();
        return entry3;
    }

    private void incRefCount(Entry entry) {
        Entry entry2 = entry;
        synchronized (entry2) {
            ++entry.refCount;
            this.debugln("refCount++[" + entry.refCount + "]: " + entry.toString());
        }
    }

    public synchronized void putData(String string, long l, byte[] byArray) {
        Entry entry = new Entry(string, l, byArray);
        this.putIntoCache(entry);
    }

    public synchronized void putData(String string, long l, byte[] byArray, boolean bl) {
        Entry entry = new Entry(string, l, byArray);
        this.putIntoCache(entry);
        if (bl) {
            this.incRefCount(this._cache.getFirst());
        }
    }

    synchronized void putIntoCache(Entry entry) {
        Entry[] entryArray = this._cache.putAtFirst(entry);
        if (entryArray != null) {
            int n = entryArray.length - 1;
            while (n >= 0) {
                this.debugln("memcache purge: " + entryArray[n].name);
                if (!this._pool.contains(entryArray[n])) {
                    try {
                        entryArray[n].save();
                        this._pool.put(entryArray[n], entryArray[n]);
                    }
                    catch (IOException iOException) {
                        System.out.println("Failed to write a bytecode cache entry to disk: " + entryArray[n].toString());
                    }
                }
                --n;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPool() {
        this.debugln("<readPool: " + this._pool_dir);
        var1_1 = new File(this._pool_dir);
        var2_2 = null;
        try {
            var2_2 = (String[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return var1_1.list();
                }
            });
        }
        catch (Exception var3_3) {
            var3_3.printStackTrace();
        }
        if (var2_2 != null) {
            this.debugln("<Reading Pool..." + var2_2.length);
        }
        var3_4 = 0;
        while (true) {
            block20: {
                block22: {
                    block21: {
                        block19: {
                            if (var2_2 == null || var3_4 >= var2_2.length) {
                                this.debugln("done>");
                                return;
                            }
                            try {
                                var4_6 = Integer.parseInt(var2_2[var3_4].substring(2));
                                if (this._pool_index >= var4_6) break block19;
                                this._pool_index = var4_6;
                            }
                            catch (Exception var4_7) {
                                break block20;
                            }
                        }
                        var4_5 = this._pool_dir + File.separator + var2_2[var3_4];
                        this.debugln("  Reading Cache file: " + var4_5);
                        var5_8 = null;
                        try {
                            try {
                                var5_8 = new DataInputStream(new FileInputStream(var4_5));
                                var6_9 = var5_8.readUTF();
                                var7_11 = var5_8.readLong();
                                var9_12 = var5_8.readInt();
                                if (var5_8.available() != var9_12) {
                                    System.out.println("Cache size mismatch.!");
                                    try {
                                        var10_13 = var4_5;
                                        AccessController.doPrivileged(new PrivilegedAction((String)var10_13){
                                            private final /* synthetic */ String val$fFileName;
                                            {
                                                this.val$fFileName = string;
                                            }

                                            public Object run() {
                                                new File(this.val$fFileName).delete();
                                                return null;
                                            }
                                        });
                                    }
                                    catch (Exception var10_14) {
                                        var10_14.printStackTrace();
                                    }
                                    var12_15 = null;
                                    break block21;
                                }
                                var10_13 = new Entry(var6_9, var7_11, null);
                                var10_13.filename = var4_5;
                                var10_13.fillInData();
                                this.putIntoCache((Entry)var10_13);
                                break block22;
                            }
                            catch (IOException var6_10) {
                                var6_10.printStackTrace();
                                var12_15 = null;
                                try {
                                    var5_8.close();
                                }
                                catch (Exception var13_16) {}
                                break block20;
                            }
                        }
                        catch (Throwable var11_17) {
                            var12_15 = null;
                            ** try [egrp 5[TRYBLOCK] [5 : 343->351)] { 
lbl63:
                            // 1 sources

                            var5_8.close();
                            throw var11_17;
lbl65:
                            // 1 sources

                            catch (Exception var13_16) {
                                // empty catch block
                            }
                            throw var11_17;
                        }
                    }
                    try {}
                    catch (Exception var13_16) {}
                    var5_8.close();
                    break block20;
                }
                var12_15 = null;
                try {}
                catch (Exception var13_16) {}
                var5_8.close();
            }
            ++var3_4;
        }
    }

    public synchronized void releaseData(String string, long l) {
        Entry entry = new Entry(string, l, null);
        Entry entry2 = this.getFromCache(entry);
        this.decRefCount(entry2);
    }

    private final class Entry
    implements Serializable {
        String name;
        long version;
        String filename;
        byte[] data;
        int refCount;
        int hash;

        Entry(String string, long l, byte[] byArray) {
            this.name = string;
            this.version = l;
            this.data = byArray;
            this.refCount = 0;
            this.hash = this.name.hashCode();
        }

        int getSize() {
            return this.name.length() * 2 + 8 + 4 + (this.data != null ? this.data.length : 0);
        }

        void delete() {
            if (this.filename != null) {
                try {
                    String string = this.filename;
                    AccessController.doPrivileged(new PrivilegedExceptionAction(this, string){
                        private final /* synthetic */ String val$fn;
                        private final /* synthetic */ Entry this$1;
                        {
                            this.this$1 = entry;
                            this.val$fn = string;
                        }

                        public Object run() throws IOException {
                            new File(this.val$fn).delete();
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    System.out.println("Failed to delete a cache entry: " + this.filename);
                    exception.printStackTrace();
                }
            }
        }

        void fillInData() throws IOException {
            if (this.data != null) {
                return;
            }
            CacheManager.this.debug("<Reading cache from disk...'" + this.name + "'");
            File file = new File(this.filename);
            try {
                this.data = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(this, file){
                    private final /* synthetic */ File val$fFile;
                    private final /* synthetic */ Entry this$1;
                    {
                        this.this$1 = entry;
                        this.val$fFile = file;
                    }

                    public Object run() throws IOException {
                        boolean bl = false;
                        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.val$fFile));
                        dataInputStream.readUTF();
                        long l = dataInputStream.readLong();
                        byte[] byArray = null;
                        int n = dataInputStream.readInt();
                        if (n >= 0) {
                            byArray = new byte[n];
                            dataInputStream.readFully(byArray);
                        }
                        if (byArray != null && byArray.length == 0) {
                            byArray = null;
                        }
                        return byArray;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                privilegedActionException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            CacheManager.this.debugln("done>");
        }

        public void save() throws IOException {
            if (this.filename != null) {
                return;
            }
            ++CacheManager.this._pool_index;
            this.filename = CacheManager.this._pool_dir + File.separator + "c@" + CacheManager.this._pool_index;
            CacheManager.this.debug("<Saving cache for '" + this.name + "'... ");
            try {
                String string = this.filename;
                String string2 = this.name;
                long l = this.version;
                byte[] byArray = this.data;
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, string, string2, l, byArray){
                    private final /* synthetic */ String val$fFileName;
                    private final /* synthetic */ String val$fName;
                    private final /* synthetic */ long val$fVersion;
                    private final /* synthetic */ byte[] val$fData;
                    private final /* synthetic */ Entry this$1;
                    {
                        this.this$1 = entry;
                        this.val$fFileName = string;
                        this.val$fName = string2;
                        this.val$fVersion = l;
                        this.val$fData = byArray;
                    }

                    public Object run() throws IOException {
                        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.val$fFileName));
                        dataOutputStream.writeUTF(this.val$fName);
                        dataOutputStream.writeLong(this.val$fVersion);
                        if (this.val$fData == null) {
                            dataOutputStream.writeInt(-1);
                        } else {
                            dataOutputStream.writeInt(this.val$fData.length);
                            dataOutputStream.write(this.val$fData);
                        }
                        dataOutputStream.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                privilegedActionException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            CacheManager.this.debugln("done>");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Entry) {
                long l = ((Entry)object).version;
                return this.name.equals(((Entry)object).name) && (this.version == 0L || l == 0L || this.version == l);
            }
            return false;
        }

        void remove() {
            if (this.filename == null) {
                return;
            }
            File file = new File(this.filename);
            try {
                AccessController.doPrivileged(new PrivilegedAction(this, file){
                    private final /* synthetic */ File val$f;
                    private final /* synthetic */ Entry this$1;
                    {
                        this.this$1 = entry;
                        this.val$f = file;
                    }

                    public Object run() {
                        this.val$f.delete();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                System.out.println("CacheManager: couldn't delete a file " + this.filename);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            if (this.data != null) {
                return "Entry:[" + this.name + '.' + this.version + '.' + this.data.length + ']';
            }
            return "Entry:[" + this.name + '.' + this.version + '.' + null + ']';
        }
    }

    private final class LinkedList {
        Hashtable tab = new Hashtable();
        ListElem first = null;
        long size = 0L;
        long maxSize;

        LinkedList(long l) {
            this.maxSize = l;
        }

        void printOut() {
            int n = 0;
            ListElem listElem = this.first;
            System.out.println("LinkedList: size=" + this.size + ", maxSize=" + this.maxSize + ", tabSize=" + this.tab.size());
            while (listElem != null && listElem.next != this.first) {
                System.out.println("Queue[" + n + "]=" + listElem.entry);
                ++n;
                listElem = listElem.next;
            }
        }

        boolean contains(Entry entry) {
            return this.tab.contains(entry);
        }

        synchronized Entry getFirst() {
            return this.first == null ? null : this.first.entry;
        }

        synchronized Entry get(Entry entry) {
            ListElem listElem = (ListElem)this.tab.get(entry);
            if (listElem == null) {
                return null;
            }
            return listElem.entry;
        }

        synchronized Entry[] putAtFirst(Entry entry) {
            if (this.maxSize == 0L || entry == null) {
                return null;
            }
            Object[] objectArray = null;
            ListElem listElem = (ListElem)this.tab.get(entry);
            if (listElem != null) {
                if (listElem != this.first) {
                    ListElem listElem2 = listElem.prev;
                    ListElem listElem3 = listElem.next;
                    listElem3.prev = listElem2;
                    listElem2.next = listElem3;
                    listElem.next = this.first;
                    listElem.prev = this.first.prev;
                    this.first.prev.next = listElem;
                    this.first.prev = listElem;
                    this.first = listElem;
                }
            } else {
                if (this.first == null) {
                    this.first.prev = this.first = new ListElem(entry);
                    this.first.next = this.first;
                    this.tab.put(entry, this.first);
                    this.size += (long)entry.getSize();
                    return objectArray;
                }
                Vector<Entry> vector = new Vector<Entry>();
                while (this.size > 0L && this.size + (long)entry.getSize() > this.maxSize) {
                    ListElem listElem4 = this.first.prev;
                    Entry entry2 = listElem4.entry;
                    vector.addElement(entry2);
                    this.tab.remove(entry2);
                    this.size -= (long)entry2.getSize();
                    if (listElem4 == this.first) {
                        this.first = null;
                        continue;
                    }
                    this.first.prev = listElem4.prev;
                    listElem4.prev.next = this.first;
                    listElem4.entry = null;
                    listElem4.prev = null;
                    listElem4.next = null;
                }
                if (vector.size() > 0) {
                    objectArray = new Entry[vector.size()];
                    vector.copyInto(objectArray);
                }
                if (this.first != null) {
                    this.first.prev.next = listElem = new ListElem(entry, this.first.prev, this.first);
                    this.first.prev = listElem;
                } else {
                    listElem.prev = listElem = new ListElem(entry);
                    listElem.next = listElem;
                }
                this.first = listElem;
                this.tab.put(entry, listElem);
                this.size += (long)entry.getSize();
            }
            return objectArray;
        }

        synchronized Entry remove(Entry entry) {
            ListElem listElem = (ListElem)this.tab.remove(entry);
            if (listElem == null) {
                return null;
            }
            ListElem listElem2 = listElem.prev;
            ListElem listElem3 = listElem.next;
            listElem3.prev = listElem2;
            listElem2.next = listElem3;
            if (listElem == this.first) {
                this.first = listElem.next == listElem ? null : this.first.next;
            }
            this.size -= (long)listElem.entry.getSize();
            Entry entry2 = listElem.entry;
            listElem.entry = null;
            listElem.prev = null;
            listElem.next = null;
            return entry2;
        }

        private final class ListElem {
            Entry entry;
            ListElem prev;
            ListElem next;

            ListElem(Entry entry) {
                this.entry = entry;
                this.prev = null;
                this.next = null;
            }

            ListElem(Entry entry, ListElem listElem) {
                this.entry = entry;
                this.prev = null;
                this.next = listElem;
            }

            ListElem(Entry entry, ListElem listElem, ListElem listElem2) {
                this.entry = entry;
                this.prev = listElem;
                this.next = listElem2;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof Entry) {
                    return this.entry.equals((Entry)object);
                }
                if (object instanceof ListElem) {
                    if (this.entry == null) {
                        return ((ListElem)object).entry == null;
                    }
                    return this.entry.equals(((ListElem)object).entry);
                }
                return false;
            }

            public int hashCode() {
                if (this.entry == null) {
                    return 0;
                }
                return this.entry.hashCode();
            }
        }
    }
}

