/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglet.system.ContextEvent;
import com.ibm.aglet.system.ContextListener;
import com.ibm.aglets.tahiti.CommandLineUserManager;
import com.ibm.aglets.tahiti.Item;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.UserManager;
import com.ibm.awb.misc.Debug;
import com.ibm.awb.misc.Resource;
import java.io.DataInputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class CommandLine
implements ContextListener,
Runnable {
    private static UserManager _userManager = new CommandLineUserManager();
    private static String helpMsg = "help                    Display this message. \nshutdown                Shutdown the server. \nreboot                  Reboot the server. \nlist                    List all aglets in the server. \nprompt                  Display or changes the prompt. \nmsg on|off              Message printing on/off. \ncreate [codeBase] name  Create new aglet. \n<aglet> dispatch URL    Dispatch the aglet to the URL. \n<aglet> clone           Clone the aglet. \n<aglet> dispose         Dispose the aglet. \n<aglet> dialog          Request a dialog to interact with.\n<aglet> property        Display properties of the aglet.\nNote: <aglet> is a left most string listed in the result of list command. ";
    private static int serial = 0;
    private Hashtable aglets = new Hashtable();
    private String prompt = ">";
    private AgletContext context = null;
    private boolean message = true;

    private synchronized void added(AgletProxy agletProxy) {
        this.aglets.put("aglet" + serial++, new Item(agletProxy));
    }

    public void agletActivated(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Activated " + contextEvent.getAgletProxy());
        }
    }

    public void agletArrived(ContextEvent contextEvent) {
        this.added(contextEvent.getAgletProxy());
    }

    public void agletCloned(ContextEvent contextEvent) {
        this.added(contextEvent.getAgletProxy());
    }

    public void agletCreated(ContextEvent contextEvent) {
        this.added(contextEvent.getAgletProxy());
    }

    public void agletDeactivated(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Deactivated " + contextEvent.getAgletProxy());
        }
    }

    public void agletDispatched(ContextEvent contextEvent) {
    }

    public void agletDisposed(ContextEvent contextEvent) {
        this.removed(contextEvent.getAgletProxy());
    }

    public void agletResumed(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Resumed " + contextEvent.getAgletProxy());
        }
    }

    public void agletReverted(ContextEvent contextEvent) {
        this.removed(contextEvent.getAgletProxy());
    }

    public void agletStateChanged(ContextEvent contextEvent) {
        Hashtable hashtable = this.aglets;
        synchronized (hashtable) {
            Enumeration enumeration = this.aglets.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Item item = (Item)this.aglets.get(k);
                if (!item.equals(contextEvent.getAgletProxy())) continue;
                item.setText((String)contextEvent.arg);
                if (!this.message) continue;
                System.out.println(k.toString() + " : " + contextEvent.arg);
            }
        }
    }

    public void agletSuspended(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Suspended " + contextEvent.getAgletProxy());
        }
    }

    void command(String string) throws Exception {
        Item item = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("shutdown".equalsIgnoreCase(string2)) {
                AgletRuntime.getAgletRuntime().shutdown();
                System.exit(1);
            } else if ("reboot".equalsIgnoreCase(string2)) {
                AgletRuntime.getAgletRuntime().shutdown();
                System.exit(0);
            } else if ("list".equalsIgnoreCase(string2)) {
                this.list(System.out);
            } else if ("threads".equalsIgnoreCase(string2)) {
                MainWindow.showThreads();
            } else if ("debug".equalsIgnoreCase(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    if ("on".equalsIgnoreCase(stringTokenizer.nextToken())) {
                        Debug.debug(true);
                    } else {
                        Debug.debug(false);
                    }
                } else {
                    Debug.list(System.err);
                }
            } else if ("msg".equalsIgnoreCase(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.message = "on".equalsIgnoreCase(stringTokenizer.nextToken());
                } else {
                    System.out.println(this.message ? "message on" : "message off");
                }
            } else if ("prompt".equalsIgnoreCase(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.prompt = stringTokenizer.nextToken();
                } else {
                    System.out.println("prompt : " + this.prompt);
                }
            } else if ("help".equalsIgnoreCase(string2)) {
                System.out.println(helpMsg);
            } else if ("create".equalsIgnoreCase(string2)) {
                URL uRL = null;
                String string3 = "";
                if (stringTokenizer.countTokens() == 2) {
                    uRL = new URL(stringTokenizer.nextToken());
                    string3 = stringTokenizer.nextToken();
                } else if (stringTokenizer.countTokens() == 1) {
                    string3 = stringTokenizer.nextToken();
                } else {
                    System.out.println("create [URL] name");
                    return;
                }
                this.context.createAglet(uRL, string3, null);
            } else {
                item = (Item)this.aglets.get(string2);
                if (item != null) {
                    if (stringTokenizer.hasMoreTokens()) {
                        item.command(stringTokenizer.nextToken(), stringTokenizer);
                        if (!item.isValid()) {
                            this.removed(item);
                            System.out.println("Removed : " + string2);
                        }
                    } else {
                        System.out.println(item);
                    }
                } else {
                    System.out.println("unknown command : " + string2);
                }
            }
        }
    }

    public void contextShutdown(ContextEvent contextEvent) {
    }

    public void contextStarted(ContextEvent contextEvent) {
        this.context = contextEvent.getAgletContext();
        Resource resource = Resource.getResourceFor("aglets");
        if (!resource.getBoolean("aglets.registered", false)) {
            // empty if block
        }
        new Thread(this).start();
    }

    public static final UserManager getUserManager() {
        return _userManager;
    }

    void list(PrintStream printStream) throws Exception {
        Enumeration enumeration = this.aglets.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Item item = (Item)this.aglets.get(string);
            printStream.println(string + " [" + item.proxy.getAgletClassName() + "] " + item.text);
        }
    }

    private synchronized void removed(AgletProxy agletProxy) {
        Enumeration enumeration = this.aglets.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!this.aglets.get(k).equals(agletProxy)) continue;
            this.aglets.remove(k);
        }
    }

    private synchronized void removed(Item item) {
        this.removed(item.proxy);
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        DataInputStream dataInputStream = new DataInputStream(System.in);
        while (true) {
            try {
                while (true) {
                    System.out.print(this.prompt + " ");
                    System.out.flush();
                    String string = dataInputStream.readLine();
                    this.command(string);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void showDocument(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("hyper link required :" + contextEvent.arg);
        }
    }

    public void showMessage(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println((String)contextEvent.arg);
        }
    }
}

