/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.aglets.tahiti.Util;
import com.ibm.awb.misc.Resource;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;

final class CreateAgletDialog
extends TahitiDialog
implements ActionListener,
ItemListener {
    private static CreateAgletDialog _instance = null;
    private TextField _classField = new TextField(20);
    private TextField _urlField = new TextField(20);
    private List _selectionList = new List(10, false);
    private Button _add = new Button("Add to List");
    private Button _remove = new Button("Remove");

    private CreateAgletDialog(MainWindow mainWindow) {
        super(mainWindow, "Create Aglet", false);
        this.add("Center", this.makePanel());
        this.addButton("Create", this);
        this.addCloseButton("Cancel");
        this.addButton("Reload Class and Create", this);
        this._selectionList.addActionListener(this);
        this._selectionList.addItemListener(this);
        Util.setFixedFont(this._selectionList);
        this._selectionList.setBackground(Color.white);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("add".equals(string)) {
            this.add();
        } else if ("remove".equals(string)) {
            this.remove();
        } else if ("Reload Class and Create".equals(string)) {
            this.createAglet(true);
            ((Component)this).setVisible(false);
        } else {
            this.createAglet(false);
            ((Component)this).setVisible(false);
        }
    }

    void add() {
        String string = this._urlField.getText().trim();
        if (string.length() > 0 && string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        if ((string = string + this._classField.getText().trim()).length() == 0) {
            return;
        }
        int n = this._selectionList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (this._selectionList.getItem(n2).equals(string)) {
                return;
            }
            ++n2;
        }
        this._selectionList.add(string);
        this.updateProperty();
    }

    public void closeButtonPressed() {
        if (this._selectionList.getSelectedIndex() != -1) {
            this._selectionList.deselect(this._selectionList.getSelectedIndex());
        }
    }

    synchronized void createAglet(boolean bl) {
        if (this._selectionList.getSelectedIndex() != -1) {
            this._selectionList.deselect(this._selectionList.getSelectedIndex());
        }
        this.disabling();
        String string = this._classField.getText().trim();
        String string2 = this._urlField.getText().trim();
        this.getMainWindow().createAglet(string2, string, bl);
    }

    private void disabling() {
        this._remove.setEnabled(this._selectionList.getSelectedIndex() != -1);
    }

    static CreateAgletDialog getInstance(MainWindow mainWindow) {
        if (_instance == null) {
            _instance = new CreateAgletDialog(mainWindow);
        }
        _instance.updateList();
        return _instance;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.disabling();
        String string = this._selectionList.getSelectedItem();
        if (string.toLowerCase().startsWith("http://") || string.toLowerCase().startsWith("https://") || string.toLowerCase().startsWith("atps://") || string.toLowerCase().startsWith("atp://") || string.toLowerCase().startsWith("file://")) {
            int n = string.lastIndexOf(47);
            this._classField.setText(string.substring(n + 1));
            this._urlField.setText(string.substring(0, n));
        } else {
            this._classField.setText(string);
            this._urlField.setText("");
        }
    }

    protected GridBagPanel makePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagPanel.setConstraints(gridBagConstraints);
        this._classField.addActionListener(this);
        this._urlField.addActionListener(this);
        gridBagPanel.addLabeled("Aglet name", this._classField);
        gridBagPanel.addLabeled("Source URL", this._urlField);
        gridBagPanel.add(new Label("Aglets List"), 17, 0, 1);
        gridBagPanel.add(this._add, 13, 0, 1);
        gridBagPanel.add((Component)this._remove, 0);
        this._add.setActionCommand("add");
        this._add.addActionListener(this);
        this._remove.setActionCommand("remove");
        this._remove.addActionListener(this);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagPanel.add((Component)this._selectionList, gridBagConstraints);
        this.disabling();
        return gridBagPanel;
    }

    void remove() {
        if (this._selectionList.getSelectedIndex() != -1) {
            this._selectionList.remove(this._selectionList.getSelectedIndex());
            this._classField.setText("");
            this._urlField.setText("");
            this.updateProperty();
        }
        this.disabling();
    }

    private void updateList() {
        Resource resource = Resource.getResourceFor("aglets");
        String string = resource.getString("aglets.agletsList");
        this._selectionList.removeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        while (stringTokenizer.hasMoreTokens()) {
            this._selectionList.add(stringTokenizer.nextToken());
        }
    }

    private void updateProperty() {
        List list = this._selectionList;
        synchronized (list) {
            int n = this._selectionList.getItemCount();
            String string = "";
            int n2 = 0;
            while (n2 < n) {
                string = string + this._selectionList.getItem(n2) + " ";
                ++n2;
            }
            Resource resource = Resource.getResourceFor("aglets");
            resource.setResource("aglets.agletsList", string);
            resource.save("Tahiti");
        }
    }

    public boolean windowClosing(WindowEvent windowEvent) {
        this.closeButtonPressed();
        return false;
    }
}

