/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.atp.auth.SharedSecret;
import com.ibm.atp.auth.SharedSecrets;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class CreateSharedSecretDialog
extends TahitiDialog
implements ActionListener {
    private static final String DIALOG_TITLE = "Create a new shared secret";
    private static final String ACTION_OK = "OK";
    private TextField domain;
    private TextField creatorAlias = null;
    private TextField creatorPassword = null;

    CreateSharedSecretDialog(Frame frame) {
        super(frame, DIALOG_TITLE, true);
        this.add("North", new Label(DIALOG_TITLE, 1));
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.add(gridBagPanel);
        this.domain = new TextField(20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagPanel.setConstraints(gridBagConstraints);
        gridBagPanel.addLabeled("Domain name", this.domain);
        this.domain.addActionListener(this);
        this.creatorAlias = new TextField(20);
        gridBagPanel.addLabeled("Creator's key alias", this.creatorAlias);
        this.creatorPassword = new TextField(20);
        gridBagPanel.addLabeled("Creator's key password", this.creatorPassword);
        this.addButton(ACTION_OK, this);
        this.addCloseButton("Cancel");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.domain.getText();
        String string2 = this.creatorAlias.getText();
        String string3 = this.creatorPassword.getText();
        if (string == null || string.equals("")) {
            TahitiDialog.alert(this.getMainWindow(), "Specify domain name").popupAtCenterOfParent();
            return;
        }
        if (string2 == null || string2.equals("")) {
            TahitiDialog.alert(this.getMainWindow(), "Specify creator's key alias").popupAtCenterOfParent();
            return;
        }
        SharedSecrets sharedSecrets = SharedSecrets.getSharedSecrets();
        SharedSecret sharedSecret = sharedSecrets.getSharedSecret(string);
        if (sharedSecret != null) {
            TahitiDialog.alert(this.getMainWindow(), "Already exists").popupAtCenterOfParent();
            return;
        }
        sharedSecret = SharedSecret.createNewSharedSecret(string, string2, string3);
        if (sharedSecret == null) {
            TahitiDialog.alert(this.getMainWindow(), "Shared secret is not created").popupAtCenterOfParent();
        } else {
            sharedSecrets.addSharedSecret(sharedSecret);
            sharedSecrets.save();
            TahitiDialog.message(this.getMainWindow(), "Created", "Shared secret of domain '" + string + "' is created").popupAtCenterOfParent();
        }
        this.dispose();
    }
}

