/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.maf.ClassName;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestTable {
    int num = 0;
    int max = 0;
    String[] names = null;
    long[] digests = null;
    private static MessageDigest digestGen;

    public DigestTable() {
        this(20);
    }

    public DigestTable(int n) {
        this.max = n;
        this.names = new String[n];
        this.digests = new long[n];
    }

    static final int _hashcode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += n * 37 + byArray[n2];
            ++n2;
        }
        return n;
    }

    private static void debug(String string) {
    }

    public ClassName[] getClassNames(Class[] classArray) {
        Object object;
        ClassName[] classNameArray = new ClassName[classArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < classArray.length) {
            object = classArray[n2].getName().replace('.', '/') + ".class";
            long l = this.getDigest((String)object);
            if (l != 0L) {
                classNameArray[n++] = new ClassName((String)object, DigestTable.toByteArray(l));
            }
            ++n2;
        }
        object = new ClassName[n];
        System.arraycopy(classNameArray, 0, object, 0, n);
        return object;
    }

    public long getDigest(int n) {
        return this.digests[n];
    }

    public long getDigest(String string) {
        if (string == null) {
            return 0L;
        }
        int n = 0;
        while (n < this.num) {
            if (string.equals(this.names[n])) {
                return this.digests[n];
            }
            ++n;
        }
        return 0L;
    }

    public byte[] getDigestAsByte(String string) {
        long l = this.getDigest(string);
        if (l == 0L) {
            return DigestTable.toByteArray(l);
        }
        return null;
    }

    public String getName(int n) {
        return this.names[n];
    }

    private void grow(int n) {
        int n2 = this.max;
        this.max = n;
        String[] stringArray = this.names;
        long[] lArray = this.digests;
        this.names = new String[this.max];
        this.digests = new long[this.max];
        System.arraycopy(stringArray, 0, this.names, 0, n2);
        System.arraycopy(lArray, 0, this.digests, 0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean match(ClassName[] classNameArray, boolean bl) {
        int n = classNameArray.length;
        DigestTable digestTable = new DigestTable(n);
        int n2 = 0;
        while (n2 < n) {
            String string = classNameArray[n2].name;
            long l = DigestTable.toLong(classNameArray[n2].descriminator);
            long l2 = this.getDigest(string);
            if (l2 == 0L) {
                if (!bl) return false;
                digestTable.setDigest(string, l);
            } else if (l != l2) {
                DigestTable.debug(string + " has different versions");
                return false;
            }
            ++n2;
        }
        if (!bl) return true;
        this.simpleMerge(digestTable);
        return true;
    }

    public synchronized long setData(String string, byte[] byArray) {
        long l = DigestTable._hashcode(digestGen.digest(byArray));
        this.setDigest(string, l);
        return l;
    }

    public synchronized void setDigest(String string, long l) {
        if (this.num >= this.max) {
            this.grow(this.max * 2);
        }
        int n = 0;
        while (n < this.num) {
            if (this.names[n].equals(string)) {
                if (this.digests[n] == l) {
                    return;
                }
                Thread.dumpStack();
                System.out.println(this);
                throw new RuntimeException("digest conflist occur! : " + string + "," + l);
            }
            ++n;
        }
        this.names[this.num] = string;
        this.digests[this.num++] = l;
    }

    private void simpleMerge(DigestTable digestTable) {
        if (this.num + digestTable.num >= this.max) {
            this.grow((this.num + digestTable.num) * 2);
        }
        try {
            System.arraycopy(digestTable.names, 0, this.names, this.num, digestTable.num);
            System.arraycopy(digestTable.digests, 0, this.digests, this.num, digestTable.num);
            this.num += digestTable.num;
        }
        catch (Exception exception) {
            System.out.println("error in mergig digest table.");
            System.out.println("---table to be added---");
            System.out.println(digestTable);
            System.out.println("---current---");
            System.out.println(this);
        }
    }

    public int size() {
        return this.num;
    }

    public static byte[] toByteArray(long l) {
        byte[] byArray = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 0 & 0xFFL)};
        return byArray;
    }

    public static long toLong(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
        int n6 = byArray[4] & 0xFF;
        int n7 = byArray[5] & 0xFF;
        int n8 = byArray[6] & 0xFF;
        int n9 = byArray[7] & 0xFF;
        int n10 = (n6 << 24) + (n7 << 16) + (n8 << 8) + (n9 << 0);
        long l = ((long)n5 << 32) + ((long)n10 & 0xFFFFFFFFL);
        return l;
    }

    public String toString() {
        return this.toString("DigestTable");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string + "(" + this.num + ")\n");
        int n = 0;
        while (n < this.num) {
            stringBuffer.append("[" + n + "] " + this.names[n] + " = " + this.digests[n] + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        try {
            digestGen = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }
}

