/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.aglets.tahiti.Util;
import com.ibm.awb.misc.Resource;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

final class DispatchAgletDialog
extends TahitiDialog
implements ActionListener,
ItemListener {
    private AgletProxy proxy = null;
    private TextField _arlSelection = new TextField(40);
    private List _arlList = new List(10, false);
    private Button _add = new Button("Add to AddressBook");
    private Button _remove = new Button("Remove");

    DispatchAgletDialog(MainWindow mainWindow, AgletProxy agletProxy) {
        super(mainWindow, "Dispatch", false);
        this.proxy = agletProxy;
        this.add("Center", this.makePanel());
        this.addButton("Dispatch", this);
        this.addCloseButton("Cancel");
        this.updateList();
        this.disabling();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("add".equals(string)) {
            this.add();
            return;
        }
        if ("remove".equals(string)) {
            this.remove();
            return;
        }
        if (this.proxy == null) {
            return;
        }
        if (!"".equals(this._arlSelection.getText())) {
            ((Component)this).setVisible(false);
            this.dispose();
            String string2 = this._arlSelection.getText();
            this.getMainWindow().dispatchAglet(this.proxy, string2);
            return;
        }
        this.beep();
    }

    void add() {
        String string = this._arlSelection.getText().trim();
        if (string.length() == 0) {
            return;
        }
        int n = this._arlList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (this._arlList.getItem(n2).equals(string)) {
                return;
            }
            ++n2;
        }
        this._arlList.add(string);
        this.updateProperty();
    }

    private void disabling() {
        this._remove.setEnabled(this._arlList.getSelectedIndex() != -1);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.disabling();
        this._arlSelection.setText(this._arlList.getSelectedItem());
    }

    protected GridBagPanel makePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagPanel.setConstraints(gridBagConstraints);
        String string = "Invalid Aglet";
        try {
            string = this.proxy == null ? "No Aglet" : this.proxy.getAgletClassName();
        }
        catch (InvalidAgletException invalidAgletException) {
            // empty catch block
        }
        gridBagPanel.add(new Label(string, 1));
        gridBagPanel.add((Component)new Label("Destination URL"), 1, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagPanel.add(this._arlSelection);
        this._arlSelection.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagPanel.add(new Label("AddressBook"));
        gridBagConstraints.anchor = 13;
        gridBagPanel.add(this._add);
        this._add.setActionCommand("add");
        this._add.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagPanel.add(this._remove);
        this._remove.setActionCommand("remove");
        this._remove.addActionListener(this);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this._arlList.addActionListener(this);
        this._arlList.addItemListener(this);
        gridBagPanel.add(this._arlList);
        Util.setFixedFont(this._arlList);
        this._arlList.setBackground(Color.white);
        return gridBagPanel;
    }

    void remove() {
        if (this._arlList.getSelectedIndex() != -1) {
            this._arlList.remove(this._arlList.getSelectedIndex());
            this.updateProperty();
        }
        this.disabling();
    }

    private void updateList() {
        Resource resource = Resource.getResourceFor("aglets");
        String[] stringArray = resource.getStringArray("aglets.addressbook", " ");
        this._arlList.removeAll();
        int n = 0;
        while (n < stringArray.length) {
            this._arlList.add(stringArray[n]);
            ++n;
        }
    }

    private void updateProperty() {
        List list = this._arlList;
        synchronized (list) {
            int n = this._arlList.getItemCount();
            String string = "";
            int n2 = 0;
            while (n2 < n) {
                string = string + this._arlList.getItem(n2) + " ";
                ++n2;
            }
            Resource resource = Resource.getResourceFor("aglets");
            resource.setResource("aglets.addressbook", string);
            resource.save("Tahiti");
        }
    }
}

