/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.tahiti.Editor;
import com.ibm.aglets.tahiti.EditorPanel;
import com.ibm.aglets.tahiti.GridBagPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

class EditListPanel
extends GridBagPanel
implements ItemListener,
ActionListener {
    private static final String LABEL_ADD = "add";
    private static final String LABEL_REMOVE = "remove";
    private Button _add = new Button("add");
    private Button _remove = new Button("remove");
    private List _list;
    private Editor _editor;

    EditListPanel(String string, List list, Editor editor) {
        this._list = list;
        this._editor = editor;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.ipadx = 2;
        this.setConstraints(gridBagConstraints);
        if (string != null && !string.equals("")) {
            this.add((Component)new Label(string), 1, 0.0);
        }
        this.add((Component)this._add, 1, 0.0);
        this.add((Component)this._remove, 0, 1.0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.add((Component)this._list, 0, 1.0);
        this._add.setActionCommand(LABEL_ADD);
        this._add.addActionListener(this);
        this._remove.setActionCommand(LABEL_REMOVE);
        this._remove.addActionListener(this);
        this._list.addItemListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (LABEL_ADD.equals(string)) {
            this.addItemFromEditorIntoList();
        } else if (LABEL_REMOVE.equals(string) && this._list.getSelectedIndex() >= 0) {
            this.removeItemFromList();
        }
    }

    private void addItemFromEditorIntoList() {
        this.addItemIntoList(this._editor.getText().trim());
    }

    protected void addItemIntoList(String string) {
        if (!this.hasItem(string)) {
            this._list.add(string);
            this.selectItem(string);
        }
    }

    void addItemIntoList(Vector vector) {
        this.addItemIntoList(EditorPanel.toText(vector));
    }

    protected int getSelectedIndex() {
        return this._list.getSelectedIndex();
    }

    protected String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this._list.getItem(n);
    }

    private boolean hasItem(String string) {
        String[] stringArray = this._list.getItems();
        int n = 0;
        n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._list.getSelectedIndex() >= 0) {
            this._remove.setEnabled(true);
            this._editor.setText(this._list.getSelectedItem());
        } else {
            this._remove.setEnabled(false);
            this._editor.setText("");
        }
    }

    protected void removeItemFromList() {
        this._list.remove(this._list.getSelectedIndex());
    }

    public void selectItem(String string) {
        String[] stringArray = this._list.getItems();
        int n = 0;
        n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                this._list.select(n);
                this._remove.setEnabled(true);
                this._editor.setText(this._list.getSelectedItem());
                return;
            }
            ++n;
        }
    }
}

