/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.AgletRuntime;
import com.ibm.aglets.tahiti.BorderPanel;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.aglets.tahiti.TahitiItem;
import com.ibm.aglets.tahiti.Util;
import com.ibm.awb.misc.Resource;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

final class GeneralConfigDialog
extends TahitiDialog
implements ActionListener,
ItemListener {
    static final String STARTUP_AGLET = "com.ibm.aglets.samples.Writer";
    private Choice _fontChoice = new Choice();
    private Choice _fontSizeChoice = new Choice();
    private Choice _fontStyleChoice = new Choice();
    private Choice _fixedFontChoice = new Choice();
    private Choice _fixedFontSizeChoice = new Choice();
    private Choice _fixedFontStyleChoice = new Choice();
    private Choice _viewKeyItemChoice = new Choice();
    private Choice _viewOrderChoice = new Choice();
    private Choice _viewPrecisionChoice = new Choice();
    private Button _clearCache = new Button("Clear Class Cache Now");
    private Checkbox _startup = new Checkbox("Launch Startup Aglet");
    private TextField _startupAglet = new TextField(20);
    private String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private String[] styleList = new String[]{"plain", "bold", "italic", "bolditalic"};
    private String[] sizeList = new String[]{"6", "8", "10", "12", "14", "15", "16", "18", "20", "22", "24", "26", "28", "30"};
    private String[] keyItemList = new String[]{"event order", "creation time", "class name"};
    private String[] orderList = new String[]{"ascent", "descent"};
    private String[] precisionList = new String[]{"complete", "compact"};
    private static GeneralConfigDialog _instance = null;
    static final String ACTION_OK = "OK";
    static final String ACTION_CLEAR_CACHE = "Clear Cache";
    static final String ACTION_RESTORE_DEFAULTS = "Restore Defaults";
    static final String ACTION_CHANGE_PROFILE = "Change Profile";
    static final String ACTION_CHANGE_PASSWORD = "Change Password";
    static final String ACTION_CREATE_USER = "Create User";
    static final String ACTION_REMOVE_USER = "Remove User";
    static final String ACTION_IMPORT_USER = "Import User";
    static final String ACTION_EXPORT_USER = "Export User";

    private GeneralConfigDialog(MainWindow mainWindow) {
        super(mainWindow, "General Preferences", true);
        this.makePanel();
        this.addButton(ACTION_OK, this);
        this.addCloseButton(null);
        this.addButton(ACTION_RESTORE_DEFAULTS, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (ACTION_RESTORE_DEFAULTS.equals(string)) {
            this.restoreDefaults();
        } else if (ACTION_CLEAR_CACHE.equals(string)) {
            AgletRuntime.clearCache();
        } else if (ACTION_OK.equals(string)) {
            this.save();
            this.dispose();
        }
    }

    void disabling() {
        this._startupAglet.setEditable(this._startup.getState());
    }

    static GeneralConfigDialog getInstance(MainWindow mainWindow) {
        if (_instance == null) {
            _instance = new GeneralConfigDialog(mainWindow);
        } else {
            _instance.updateValues();
        }
        return _instance;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.disabling();
    }

    protected void makePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.add("Center", gridBagPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        gridBagPanel.setConstraints(gridBagConstraints);
        BorderPanel borderPanel = new BorderPanel("Font");
        gridBagPanel.add((Component)borderPanel, 0);
        BorderPanel borderPanel2 = new BorderPanel("List View");
        gridBagPanel.add((Component)borderPanel2, 0);
        BorderPanel borderPanel3 = new BorderPanel("Startup");
        gridBagPanel.add((Component)borderPanel3, 0);
        BorderPanel borderPanel4 = new BorderPanel("Cache Control");
        gridBagPanel.add((Component)borderPanel4, 0);
        this.setupFontPanel(borderPanel);
        this.setupViewPanel(borderPanel2);
        this.setupCachePanel(borderPanel4);
        this.setupStartupPanel(borderPanel3);
        this.updateValues();
    }

    void restoreDefaults() {
        this._fontChoice.select("TimesRoman");
        this._fontChoice.select("plain");
        this._fontSizeChoice.select("12");
        this._fixedFontChoice.select("Courier");
        this._fixedFontChoice.select("plain");
        this._fixedFontSizeChoice.select("12");
        this._viewKeyItemChoice.select("event order");
        this._viewOrderChoice.select("ascent");
        this._viewPrecisionChoice.select("complete");
        this._startup.setState(true);
        this._startupAglet.setText(STARTUP_AGLET);
        this.disabling();
    }

    void save() {
        Resource resource = Resource.getResourceFor("tahiti");
        Resource resource2 = Resource.getResourceFor("aglets");
        String string = this._fontChoice.getSelectedItem();
        String string2 = this._fontStyleChoice.getSelectedItem();
        int n = Integer.parseInt(this._fontSizeChoice.getSelectedItem());
        resource.setResource("tahiti.font", string + '-' + string2 + '-' + n);
        string = this._fixedFontChoice.getSelectedItem();
        string2 = this._fixedFontStyleChoice.getSelectedItem();
        n = Integer.parseInt(this._fixedFontSizeChoice.getSelectedItem());
        resource.setResource("tahiti.fixedFont", string + '-' + string2 + '-' + n);
        resource.setResource("tahiti.startup", String.valueOf(this._startup.getState()));
        resource.setResource("tahiti.startupAglets", this._startupAglet.getText().trim());
        String string3 = this._viewKeyItemChoice.getSelectedItem();
        if (string3.equals("event order")) {
            TahitiItem.setKeyItem(0);
        } else if (string3.equals("creation time")) {
            TahitiItem.setKeyItem(1);
        } else if (string3.equals("class name")) {
            TahitiItem.setKeyItem(2);
        }
        resource.setResource("tahiti.itemkey", string3);
        String string4 = this._viewOrderChoice.getSelectedItem();
        if (string4.equals("ascent")) {
            TahitiItem.setAscentOrder();
        } else if (string4.equals("descent")) {
            TahitiItem.setDescentOrder();
        }
        resource.setResource("tahiti.itemorder", string4);
        String string5 = this._viewPrecisionChoice.getSelectedItem();
        if (string5.equals("complete")) {
            TahitiItem.setPrecision(true);
        } else if (string5.equals("compact")) {
            TahitiItem.setPrecision(false);
        }
        resource.setResource("tahiti.itemprecision", string5);
        resource.save("Tahiti");
        resource2.save("Tahiti");
        Font font = resource.getFont("tahiti.font", null);
        Util.reset();
        Util.update();
    }

    private void setupCachePanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        gridBagConstraints.fill = 0;
        borderPanel.add((Component)this._clearCache, 0, 0.5);
        this._clearCache.setActionCommand(ACTION_CLEAR_CACHE);
        this._clearCache.addActionListener(this);
    }

    private void setupFontPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        borderPanel.add((Component)new Label("Proportional Font:"), 1, 0.1);
        this._fontChoice.addItem("serif");
        this._fontChoice.addItem("sanserif");
        this._fontChoice.addItem("monospaced");
        int n = 0;
        while (n < this.fontList.length) {
            this._fontChoice.addItem(this.fontList[n]);
            ++n;
        }
        borderPanel.add((Component)this._fontChoice, 1, 1.0);
        int n2 = 0;
        while (n2 < this.styleList.length) {
            this._fontStyleChoice.addItem(this.styleList[n2]);
            ++n2;
        }
        borderPanel.add((Component)this._fontStyleChoice, 1, 0.4);
        borderPanel.add((Component)this._fontSizeChoice, 0, 1.0);
        int n3 = 0;
        while (n3 < this.sizeList.length) {
            this._fontSizeChoice.addItem(this.sizeList[n3]);
            ++n3;
        }
        gridBagConstraints.insets = borderPanel.bottomInsets();
        borderPanel.add((Component)new Label("Fixed Font:"), 1);
        this._fixedFontChoice.addItem("serif");
        this._fixedFontChoice.addItem("sanserif");
        this._fixedFontChoice.addItem("monospaced");
        int n4 = 0;
        while (n4 < this.fontList.length) {
            this._fixedFontChoice.addItem(this.fontList[n4]);
            ++n4;
        }
        borderPanel.add((Component)this._fixedFontChoice, 1, 1.0);
        int n5 = 0;
        while (n5 < this.styleList.length) {
            this._fixedFontStyleChoice.addItem(this.styleList[n5]);
            ++n5;
        }
        borderPanel.add((Component)this._fixedFontStyleChoice, 1, 0.4);
        gridBagConstraints.weightx = 1.0;
        borderPanel.add((Component)this._fixedFontSizeChoice, 0);
        int n6 = 0;
        while (n6 < this.sizeList.length) {
            this._fixedFontSizeChoice.addItem(this.sizeList[n6]);
            ++n6;
        }
    }

    private void setupStartupPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        borderPanel.add((Component)new Label("On Startup:"), 1, 0.0);
        borderPanel.add((Component)this._startup, 0, 1.0);
        gridBagConstraints.insets = borderPanel.bottomInsets();
        borderPanel.add((Component)this._startupAglet, 0, 0.5);
        this._startup.addItemListener(this);
    }

    private void setupViewPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        borderPanel.add((Component)new Label("Order Key:"), 1, 0.4);
        int n = 0;
        while (n < this.keyItemList.length) {
            this._viewKeyItemChoice.addItem(this.keyItemList[n]);
            ++n;
        }
        borderPanel.add((Component)this._viewKeyItemChoice, 0, 1.0);
        borderPanel.add((Component)new Label("Sort Order:"), 1, 0.4);
        int n2 = 0;
        while (n2 < this.orderList.length) {
            this._viewOrderChoice.addItem(this.orderList[n2]);
            ++n2;
        }
        borderPanel.add((Component)this._viewOrderChoice, 0, 1.0);
        borderPanel.add((Component)new Label("Display Precision:"), 1, 0.4);
        borderPanel.add((Component)this._viewPrecisionChoice, 0, 1.0);
        int n3 = 0;
        while (n3 < this.precisionList.length) {
            this._viewPrecisionChoice.addItem(this.precisionList[n3]);
            ++n3;
        }
        gridBagConstraints.insets = borderPanel.bottomInsets();
    }

    private void updateValues() {
        Resource resource = Resource.getResourceFor("tahiti");
        Resource resource2 = Resource.getResourceFor("aglets");
        Font font = resource.getFont("tahiti.font", null);
        this._fontChoice.select(font.getName());
        this._fontStyleChoice.select(this.styleList[font.getStyle()]);
        this._fontSizeChoice.select(String.valueOf(font.getSize()));
        font = resource.getFont("tahiti.fixedFont", null);
        this._fixedFontChoice.select(font.getName());
        this._fixedFontStyleChoice.select(this.styleList[font.getStyle()]);
        this._fixedFontSizeChoice.select(String.valueOf(font.getSize()));
        String string = resource.getString("tahiti.itemkey", "event order");
        this._viewKeyItemChoice.select(string);
        String string2 = resource.getString("tahiti.itemorder", "ascent");
        this._viewOrderChoice.select(string2);
        String string3 = resource.getString("tahiti.itemprecision", "complete");
        this._viewPrecisionChoice.select(string3);
        if (string.equals("event order")) {
            TahitiItem.setKeyItem(0);
        } else if (string.equals("creation time")) {
            TahitiItem.setKeyItem(1);
        } else if (string.equals("class name")) {
            TahitiItem.setKeyItem(2);
        }
        if (string2.equals("ascent")) {
            TahitiItem.setAscentOrder();
        } else if (string2.equals("descent")) {
            TahitiItem.setDescentOrder();
        }
        if (string3.equals("complete")) {
            TahitiItem.setPrecision(true);
        } else if (string3.equals("compact")) {
            TahitiItem.setPrecision(false);
        }
        this._startup.setState(resource.getBoolean("tahiti.startup", false));
        this._startupAglet.setText(resource.getString("tahiti.startupAglets"));
        this.disabling();
    }

    public boolean windowClosing(WindowEvent windowEvent) {
        return false;
    }
}

