/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.StringTokenizer;

class Item {
    AgletProxy proxy;
    String text = "";

    Item(AgletProxy agletProxy) {
        this.proxy = agletProxy;
    }

    public void command(String string, StringTokenizer stringTokenizer) throws Exception {
        int n = stringTokenizer.countTokens();
        if ("clone".equalsIgnoreCase(string)) {
            this.proxy.clone();
        } else if ("dispatch".equalsIgnoreCase(string)) {
            if (stringTokenizer.hasMoreTokens()) {
                this.proxy.dispatch(new URL(stringTokenizer.nextToken()));
            } else {
                new Error("aglet dispatch URL");
            }
        } else if ("dialog".equalsIgnoreCase(string)) {
            this.proxy.sendAsyncMessage(new Message("dialog"));
        } else if ("dispose".equalsIgnoreCase(string)) {
            this.proxy.dispose();
        } else if ("activate".equalsIgnoreCase(string)) {
            this.proxy.activate();
        } else if ("deactivate".equalsIgnoreCase(string)) {
            if (stringTokenizer.hasMoreTokens()) {
                this.proxy.deactivate(Long.parseLong(stringTokenizer.nextToken()));
            } else {
                this.proxy.deactivate(0L);
            }
        } else if ("property".equalsIgnoreCase(string)) {
            System.out.println(this.toString());
        } else {
            System.out.println("unknown method " + string);
        }
    }

    public boolean equals(Object object) {
        return this.proxy == object;
    }

    public boolean isValid() {
        return this.proxy.isValid();
    }

    void setText(String string) {
        this.text = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            AgletInfo agletInfo = this.proxy.getAgletInfo();
            stringBuffer.append(" Aglet\n");
            stringBuffer.append(agletInfo.getAgletID() + "\n");
            X509Certificate x509Certificate = (X509Certificate)agletInfo.getAuthorityCertificate();
            stringBuffer.append(x509Certificate.getSubjectDN().getName() + "\n");
            stringBuffer.append(new Date(agletInfo.getCreationTime()));
            stringBuffer.append("\n" + agletInfo.getAgletClassName() + "\n");
            stringBuffer.append(agletInfo.getCodeBase() == null ? "Local host" : agletInfo.getCodeBase().toString() + "\n");
            stringBuffer.append(agletInfo.getAPIMajorVersion() + 46 + agletInfo.getAPIMinorVersion());
        }
        catch (InvalidAgletException invalidAgletException) {
            stringBuffer.append("Unavailable");
        }
        return stringBuffer.toString();
    }
}

