/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.tahiti.AgletClassLoader;
import com.ibm.aglets.tahiti.DigestTable;
import com.ibm.awb.misc.Archive;
import com.ibm.awb.misc.JarArchive;
import com.ibm.maf.ClassName;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;

class JarAgletClassLoader
extends AgletClassLoader {
    JarArchive _jar = null;

    JarAgletClassLoader(String string, Certificate certificate) throws IOException {
        this(new URL(string), certificate);
    }

    JarAgletClassLoader(URL uRL, Certificate certificate) throws IOException {
        super(JarAgletClassLoader.checkAndTrim(uRL), certificate);
        this._jar = new JarArchive(uRL.openStream());
        Archive.Entry[] entryArray = this._jar.entries();
        this._digest_table = new DigestTable(entryArray.length);
        int n = 0;
        while (n < entryArray.length) {
            this._digest_table.setDigest(entryArray[n].name(), entryArray[n].digest());
            ++n;
        }
    }

    private static URL checkAndTrim(URL uRL) throws IOException {
        String string = uRL.getFile();
        if (string != null && string.toLowerCase().endsWith(".jar")) {
            System.out.println(string);
            string = string.substring(0, string.lastIndexOf(47) + 1);
            System.out.println(string);
            return new URL(uRL, string);
        }
        return uRL;
    }

    public Archive getArchive(ClassName[] classNameArray) {
        if (this.match(classNameArray)) {
            return this._jar;
        }
        return null;
    }

    protected synchronized byte[] getResourceAsByteArray(String string) {
        return this._jar.getResourceAsByteArray(string);
    }

    public void importArchive(Archive archive) {
        Archive.Entry[] entryArray = archive.entries();
        int n = 0;
        while (n < entryArray.length) {
            long l = this._digest_table.getDigest(entryArray[n].name());
            if (l == 0L) {
                throw new RuntimeException("Cannot Add JarArchive!");
            }
            ++n;
        }
    }

    static boolean isJarFile(URL uRL) {
        String string = uRL.getFile();
        return string != null && string.toLowerCase().endsWith(".jar");
    }
}

