/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.tahiti.Util;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

final class LogWindow
extends Frame
implements ActionListener {
    private TextArea _logList = new TextArea();
    GridBagLayout grid = new GridBagLayout();
    private int lastPos = 0;
    static final int MAX_LEN = 16000;

    LogWindow() {
        super("Log Information");
        Util.setBackground(this);
        Util.setFixedFont(this._logList);
        this._logList.setBackground(Color.white);
        this._logList.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(this.grid);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.addCmp(this._logList, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.addCmp(this.makeButtonPanel(), gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)LogWindow.this).setVisible(false);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("close".equals(string)) {
            ((Component)this).setVisible(false);
        } else if ("clear".equals(string)) {
            this.clearLog();
        }
    }

    private void addCmp(Component component, GridBagConstraints gridBagConstraints) {
        this.grid.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void appendText(String string) {
        string = string + '\n';
        this._logList.insert(string, this.lastPos);
        this.lastPos += string.length();
        if (this.lastPos > 16000) {
            int n = this.lastPos / 2;
            String string2 = this._logList.getText();
            int n2 = n;
            while (n2 < this.lastPos) {
                if (string2.charAt(n) == '\n') break;
                ++n2;
            }
            this._logList.replaceRange("", 0, n);
            this.lastPos = this._logList.getText().length();
        }
    }

    public void clearLog() {
        TextArea textArea = this._logList;
        synchronized (textArea) {
            this.lastPos = 0;
            this._logList.setText("");
        }
    }

    private void closeLog() {
        ((Component)this).setVisible(false);
    }

    private Panel makeButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        Button button = new Button("Close");
        button.setActionCommand("close");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Clear Log");
        button.setActionCommand("clear");
        button.addActionListener(this);
        panel.add(button);
        return panel;
    }
}

