/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglets.tahiti.ActionAndKeyListener;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.LoginDialog;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.aglets.tahiti.TahitiWindow;
import com.ibm.aglets.tahiti.UserManager;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.security.cert.Certificate;

public class LoginDialog
extends TahitiWindow
implements ActionListener {
    String _username = null;
    Certificate _certificate = null;
    TextField _account = new TextField(12);
    TextField _password = new TextField(12);
    private Button _LoginButton = null;
    private boolean auth = false;
    Object lock = new Object();

    public LoginDialog() {
        super("Login");
        this._username = UserManager.getDefaultUsername();
        this._account.setText(this._username);
        this._password.setEchoChar('*');
        this._password.setText("");
        GridBagPanel gridBagPanel = new GridBagPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagPanel.setConstraints(gridBagConstraints);
        gridBagPanel.addLabeled("Name:", this._account);
        gridBagPanel.addLabeled("Password:", this._password);
        this.add("North", new Label("Aglets Login", 1));
        this.add("Center", gridBagPanel);
        this.addLoginButton("Login");
        this.addCloseButton("Cancel");
        this._password.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.checkPassword();
    }

    protected void addLoginButton(String string) {
        if (string == null) {
            string = "Login";
        }
        class LoginListener
        extends ActionAndKeyListener {
            LoginDialog loginDialog;
            private final /* synthetic */ LoginDialog this$0;

            LoginListener(LoginDialog loginDialog, LoginDialog loginDialog2) {
                this.this$0 = loginDialog;
                this.loginDialog = null;
                this.loginDialog = loginDialog2;
            }

            protected void doAction() {
                this.loginDialog.checkPassword();
            }
        }
        LoginListener loginListener = new LoginListener(this, this);
        this._LoginButton = this.addButton(string, loginListener, loginListener);
    }

    public void checkPassword() {
        this._username = this._account.getText();
        String string = this._password.getText();
        AgletRuntime agletRuntime = AgletRuntime.getAgletRuntime();
        if (agletRuntime == null) {
            return;
        }
        this._certificate = agletRuntime.authenticateOwner(this._username, string);
        if (this._certificate != null) {
            this.auth = true;
            this.dispose();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        } else {
            TahitiDialog tahitiDialog = TahitiDialog.alert(this, "Login Failed");
            tahitiDialog.popupAtCenterOfParent();
            this._password.setText("");
        }
    }

    public void closeButtonPressed() {
        System.exit(1);
    }

    public Certificate getCertificate() {
        return this._certificate;
    }

    public String getUsername() {
        return this._username;
    }

    public boolean isAuthenticated() {
        return this.auth;
    }

    private void requestFocusOnInputText() {
        if (this._username == null || this._username.equals("")) {
            this._account.requestFocus();
        } else {
            this._password.requestFocus();
        }
    }

    public void waitForAuthentication() {
        Object object = this.lock;
        synchronized (object) {
            this.requestFocusOnInputText();
            while (!this.auth) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean windowClosing(WindowEvent windowEvent) {
        System.exit(1);
        return false;
    }
}

