/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglets.RemoteAgletRef;
import com.ibm.aglets.tahiti.CloneAgletDialog;
import com.ibm.aglets.tahiti.CreateAgletDialog;
import com.ibm.aglets.tahiti.DeactivateAgletDialog;
import com.ibm.aglets.tahiti.DispatchAgletDialog;
import com.ibm.aglets.tahiti.DisposeAgletDialog;
import com.ibm.aglets.tahiti.GeneralConfigDialog;
import com.ibm.aglets.tahiti.LogWindow;
import com.ibm.aglets.tahiti.MemoryUsageDialog;
import com.ibm.aglets.tahiti.NetworkConfigDialog;
import com.ibm.aglets.tahiti.PropertiesDialog;
import com.ibm.aglets.tahiti.RetractAgletDialog;
import com.ibm.aglets.tahiti.SecurityConfigDialog;
import com.ibm.aglets.tahiti.ServerPrefsDialog;
import com.ibm.aglets.tahiti.ShutdownDialog;
import com.ibm.aglets.tahiti.Tahiti;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.aglets.tahiti.TahitiItem;
import com.ibm.aglets.tahiti.Util;
import com.ibm.awb.launcher.Agletsd;
import com.ibm.awb.misc.Debug;
import com.ibm.awb.misc.Resource;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

final class MainWindow
extends Frame
implements ItemListener,
ActionListener {
    static ResourceBundle bundle = null;
    private MenuItem _dialogMenuItem = new MenuItem();
    private MenuItem _disposeMenuItem = new MenuItem();
    private MenuItem _cloneMenuItem = new MenuItem();
    private MenuItem _infoMenuItem = new MenuItem();
    private MenuItem _killMenuItem = new MenuItem();
    private Button _disposeButton = new Button();
    private Button _dialogButton = new Button();
    private Button _cloneButton = new Button();
    private Button _infoButton = new Button();
    private MenuItem _dispatchMenuItem = new MenuItem();
    private Button _dispatchButton = new Button();
    private MenuItem _deactivateMenuItem = new MenuItem();
    private MenuItem _activateMenuItem = new MenuItem();
    private MenuItem _javaConsoleMenuItem = new MenuItem();
    private Tahiti _tahiti = null;
    private Vector _itemList = new Vector();
    Hashtable text = new Hashtable();
    Panel _buttonPanel = new Panel();
    List _agletList = new List(0, false);
    boolean shrink = false;
    static final int ORDER_CREATIONTIME = 0;
    static final int ORDER_CLASSNAME = 1;
    private int viewOrder = 0;
    private boolean isAscent = true;
    private boolean isCompact = false;
    LogWindow logWindow = new LogWindow();
    static final int TAHITI_EVENT = 10000;
    static final int CLONE = 10001;
    static final int CREATE = 10002;
    static final int DISPOSE = 10003;
    static final int DISPATCH = 10004;
    static final int RETRACT = 10005;
    static final int KILL = 10006;
    static final int DEACTIVATE = 10007;
    static final int ACTIVATE = 10008;
    static final int DIALOG = 10009;
    static final int GET_AGLETS = 10010;
    static final int EXIT = 10015;
    static final int SHUTDOWN = 10016;
    static final int REBOOT = 10017;
    static final int AGLET_INFO = 10020;
    static final int SHOW_LOG = 10021;
    static final int MEMORY_USAGE = 10022;
    static final int GC = 10023;
    static final int SHOW_THREADS = 10024;
    static final int SHOW_DEBUG = 10025;
    static final int SHOW_REFTABLE = 10026;
    static final int SHOW_JAVACON = 10027;
    static final int PREFERENCE1 = 10030;
    static final int PREFERENCE2 = 10031;
    static final int PREFERENCE3 = 10032;
    static final int PREFERENCE4 = 10033;
    static final int ABOUT_AGLETS = 10035;
    static final int ABOUT_TAHITI = 10036;
    static final int SHRINK = 10040;
    static final int TAHITI_LAST_EVENT = 10041;
    private int _messageLineSize = 60;
    private TextField _messageLine = new TextField(this._messageLineSize);

    MainWindow(Tahiti tahiti) {
        this._tahiti = tahiti;
        Util.setFont(this);
        Util.setBackground(this);
        Util.setFixedFont(this._agletList);
        TahitiItem.init();
        this._agletList.setBackground(Color.white);
        this.setMenuBar(this.makeMenuBar());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Panel panel = this.makeButtonPanel();
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this._agletList, gridBagConstraints);
        this.addListeners();
        this.add(this._agletList);
        Resource resource = Resource.getResourceFor("tahiti");
        this.shrink = resource.getBoolean("tahiti.window.shrinked", false);
        if (this.shrink) {
            this._agletList.setVisible(false);
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this._messageLine, gridBagConstraints);
        this.add(this._messageLine);
        this._messageLine.setText("Tahiti - The Aglet Viewer is Running...");
        this._messageLine.setBackground(Color.lightGray);
        this._messageLine.setEditable(false);
        this.updateGUIState();
        AgletRuntime agletRuntime = AgletRuntime.getAgletRuntime();
        String string = agletRuntime.getServerAddress();
        String string2 = agletRuntime.getOwnerName();
        if (string2 == null) {
            string2 = "NO USER";
        }
        Resource resource2 = Resource.getResourceFor("aglets");
        boolean bl = resource2.getBoolean("aglets.secure", true);
        Resource resource3 = Resource.getResourceFor("atp");
        boolean bl2 = true;
        if (resource3 != null) {
            bl2 = resource3.getBoolean("atp.server", false);
        }
        this.setTitle("Tahiti: The Aglet Viewer [" + string + " (" + string2 + ")" + (bl2 ? "" : " : NOT RUNNING") + " ]" + (bl ? "" : " - << UNSECURE MODE >>"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this._agletList.getSelectedIndexes();
        int n = 0;
        while (n < nArray.length) {
            AgletProxy agletProxy = ((TahitiItem)this._itemList.elementAt(nArray[n])).getAgletProxy();
            if (agletProxy.isState(2)) {
                this.activateAglet(agletProxy);
            } else if (agletProxy.isState(1)) {
                this.dialog(agletProxy);
            }
            ++n;
        }
    }

    public void activateAglet(AgletProxy agletProxy) {
        new Thread(new TahitiEventHandler(10008, agletProxy)).start();
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ShutdownDialog shutdownDialog = ShutdownDialog.getInstance(MainWindow.this);
                shutdownDialog.popupAtCenterOfParent();
            }
        });
        this._agletList.addItemListener(this);
        this._agletList.addActionListener(this);
    }

    private void clearMessage() {
        this._messageLine.setText("");
    }

    public void cloneAglet(AgletProxy agletProxy) {
        new Thread(new TahitiEventHandler(10001, agletProxy)).start();
    }

    public void createAglet(String string, String string2, boolean bl) {
        new Thread(new TahitiEventHandler(string, string2, bl)).start();
    }

    public void deactivateAglet(AgletProxy agletProxy, long l) {
        new Thread(new TahitiEventHandler(agletProxy, l)).start();
    }

    void dialog(AgletProxy agletProxy) {
        try {
            agletProxy.sendAsyncMessage(new Message("dialog"));
        }
        catch (InvalidAgletException invalidAgletException) {
            this.setMessage(invalidAgletException.getMessage());
        }
    }

    public void dispatchAglet(AgletProxy agletProxy, String string) {
        new Thread(new TahitiEventHandler(agletProxy, string)).start();
    }

    public void disposeAglet(AgletProxy agletProxy) {
        new Thread(new TahitiEventHandler(10003, agletProxy)).start();
    }

    void getAglets() {
    }

    private String getItemText(TahitiItem tahitiItem) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(tahitiItem.getText());
        AgletProxy agletProxy = tahitiItem.getAgletProxy();
        String string = (String)this.text.get(agletProxy);
        stringBuffer.append(" " + (string == null ? " " : string));
        return stringBuffer.toString();
    }

    public Dimension getPreferredSize() {
        Resource resource = Resource.getResourceFor("tahiti");
        if (!this.shrink) {
            return new Dimension(resource.getInteger("tahiti.window.width", 545), resource.getInteger("tahiti.window.height", 350));
        }
        return new Dimension(resource.getInteger("tahiti.window.s_width", 545), resource.getInteger("tahiti.window.s_height", 350));
    }

    AgletProxy[] getSelectedProxies() {
        int[] nArray = this._agletList.getSelectedIndexes();
        AgletProxy[] agletProxyArray = new AgletProxy[nArray.length];
        int n = 0;
        while (n < agletProxyArray.length) {
            agletProxyArray[n] = ((TahitiItem)this._itemList.elementAt(nArray[n])).getAgletProxy();
            ++n;
        }
        return agletProxyArray;
    }

    AgletProxy getSelectedProxy() {
        int n = this._agletList.getSelectedIndex();
        if (n != -1) {
            return ((TahitiItem)this._itemList.elementAt(n)).getAgletProxy();
        }
        return null;
    }

    void hideButtons() {
        this._dialogButton.setVisible(false);
        this._infoButton.setVisible(false);
        this._disposeButton.setVisible(false);
        this._cloneButton.setVisible(false);
        this._dispatchButton.setVisible(false);
    }

    synchronized void insertProxyToList(AgletProxy agletProxy) {
        if (this.shrink) {
            return;
        }
        TahitiItem tahitiItem = new TahitiItem(agletProxy);
        int n = -1;
        int n2 = 0;
        while (n2 < this._itemList.size()) {
            if (tahitiItem.compareTo((TahitiItem)this._itemList.elementAt(n2)) <= 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            this._itemList.insertElementAt(tahitiItem, n);
            this._agletList.add(this.getItemText(tahitiItem), n);
        } else {
            this._itemList.addElement(tahitiItem);
            this._agletList.add(this.getItemText(tahitiItem));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateGUIState();
        if (TahitiItem.isNeedUpdate()) {
            this.updateProxyList();
        }
    }

    private Panel makeButtonPanel() {
        this._buttonPanel = new Panel();
        this._buttonPanel.setLayout(new FlowLayout(0));
        Button button = new Button("><");
        button.addActionListener(new EventIssuer(10040));
        this._buttonPanel.add(button);
        button = new Button(bundle.getString("button.create"));
        button.addActionListener(new DialogOpener(10002));
        this._buttonPanel.add(button);
        this._dialogButton.setLabel(bundle.getString("button.dialog"));
        this._dialogButton.addActionListener(new EventIssuer(10009));
        this._buttonPanel.add(this._dialogButton);
        this._infoButton.setLabel(bundle.getString("button.info"));
        this._infoButton.addActionListener(new DialogOpener(10020));
        this._buttonPanel.add(this._infoButton);
        this._disposeButton.setLabel(bundle.getString("button.dispose"));
        this._disposeButton.addActionListener(new DialogOpener(10003));
        this._buttonPanel.add(this._disposeButton);
        this._cloneButton.setLabel(bundle.getString("button.clone"));
        this._cloneButton.addActionListener(new DialogOpener(10001));
        this._buttonPanel.add(this._cloneButton);
        this._dispatchButton.setLabel(bundle.getString("button.dispatch"));
        this._dispatchButton.addActionListener(new DialogOpener(10004));
        this._buttonPanel.add(this._dispatchButton);
        button = new Button(bundle.getString("button.retract"));
        button.addActionListener(new DialogOpener(10005));
        this._buttonPanel.add(button);
        return this._buttonPanel;
    }

    private MenuBar makeMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu(bundle.getString("menu.aglet"));
        MenuItem menuItem = new MenuItem(bundle.getString("menuitem.create"));
        menuItem.addActionListener(new DialogOpener(10002));
        menu.add(menuItem);
        this._dialogMenuItem.setLabel(bundle.getString("menuitem.dialog"));
        this._dialogMenuItem.addActionListener(new EventIssuer(10009));
        menu.add(this._dialogMenuItem);
        this._disposeMenuItem.setLabel(bundle.getString("menuitem.dispose"));
        this._disposeMenuItem.addActionListener(new DialogOpener(10003));
        menu.add(this._disposeMenuItem);
        this._cloneMenuItem.setLabel(bundle.getString("menuitem.clone"));
        this._cloneMenuItem.addActionListener(new DialogOpener(10001));
        menu.add(this._cloneMenuItem);
        this._infoMenuItem.setLabel(bundle.getString("menuitem.info"));
        this._infoMenuItem.addActionListener(new DialogOpener(10020));
        menu.add(this._infoMenuItem);
        menu.addSeparator();
        this._killMenuItem.setLabel(bundle.getString("menuitem.kill"));
        this._killMenuItem.addActionListener(new EventIssuer(10006));
        menu.add(this._killMenuItem);
        menu.addSeparator();
        menuItem = new MenuItem(bundle.getString("menuitem.exit"));
        menuItem.addActionListener(new DialogOpener(10015));
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu(bundle.getString("menu.mobility"));
        this._dispatchMenuItem.setLabel(bundle.getString("menuitem.dispatch"));
        this._dispatchMenuItem.addActionListener(new DialogOpener(10004));
        menu.add(this._dispatchMenuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.retract"));
        menuItem.addActionListener(new DialogOpener(10005));
        menu.add(menuItem);
        this._deactivateMenuItem.setLabel(bundle.getString("menuitem.deactivate"));
        this._deactivateMenuItem.addActionListener(new DialogOpener(10007));
        menu.add(this._deactivateMenuItem);
        this._activateMenuItem.setLabel(bundle.getString("menuitem.activate"));
        this._activateMenuItem.addActionListener(new EventIssuer(10008));
        menu.add(this._activateMenuItem);
        menuBar.add(menu);
        menu = new Menu(bundle.getString("menu.view"));
        menuItem = new MenuItem(bundle.getString("menuitem.memoryusage"));
        menuItem.addActionListener(new DialogOpener(10022));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.log"));
        menuItem.addActionListener(new DialogOpener(10021));
        menu.add(menuItem);
        this._javaConsoleMenuItem = new MenuItem(bundle.getString("menuitem.javaconsole"));
        this._javaConsoleMenuItem.addActionListener(new DialogOpener(10027));
        if (Agletsd.console != null) {
            this._javaConsoleMenuItem.setEnabled(true);
        } else {
            this._javaConsoleMenuItem.setEnabled(false);
        }
        menu.add(this._javaConsoleMenuItem);
        menuBar.add(menu);
        menu = new Menu(bundle.getString("menu.options"));
        menuItem = new MenuItem(bundle.getString("menuitem.general"));
        menuItem.addActionListener(new DialogOpener(10030));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.network"));
        menuItem.addActionListener(new DialogOpener(10031));
        menu.add(menuItem);
        Resource resource = Resource.getResourceFor("aglets");
        if (resource.getBoolean("aglets.secure", true)) {
            menuItem = new MenuItem(bundle.getString("menuitem.security"));
            menuItem.addActionListener(new DialogOpener(10032));
            menu.add(menuItem);
        }
        menuItem = new MenuItem(bundle.getString("menuitem.server"));
        menuItem.addActionListener(new DialogOpener(10033));
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu(bundle.getString("menu.tools"));
        menuItem = new MenuItem(bundle.getString("menuitem.gc"));
        menuItem.addActionListener(new EventIssuer(10023));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.threads"));
        menuItem.addActionListener(new EventIssuer(10024));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.debug"));
        menuItem.addActionListener(new EventIssuer(10025));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.reftable"));
        menuItem.addActionListener(new EventIssuer(10026));
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu(bundle.getString("menu.help"));
        menuItem = new MenuItem(bundle.getString("menuitem.about_tahiti"));
        menuItem.addActionListener(new DialogOpener(10036));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.about_aglets"));
        menuItem.addActionListener(new DialogOpener(10035));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.release_notes"));
        menuItem.addActionListener(new URLOpener(bundle.getString("http.release_notes")));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.aglets_home_page"));
        menuItem.addActionListener(new URLOpener(bundle.getString("http.aglets_home")));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.feedback"));
        menuItem.addActionListener(new URLOpener(bundle.getString("http.feedback")));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.bug_report"));
        menuItem.addActionListener(new URLOpener(bundle.getString("http.bug_report")));
        menu.add(menuItem);
        menuItem = new MenuItem(bundle.getString("menuitem.faq"));
        menuItem.addActionListener(new URLOpener(bundle.getString("http.faq")));
        menu.add(menuItem);
        menuBar.setHelpMenu(menu);
        return menuBar;
    }

    public void reboot() {
        this._tahiti.reboot();
    }

    synchronized void removeProxyFromList(AgletProxy agletProxy) {
        AgletProxy agletProxy2 = null;
        try {
            this.text.remove(agletProxy);
            if (this.shrink) {
                return;
            }
            int n = this._itemList.size() - 1;
            while (n >= 0) {
                agletProxy2 = ((TahitiItem)this._itemList.elementAt(n)).getAgletProxy();
                if (!agletProxy2.isValid()) {
                    this._itemList.removeElementAt(n);
                    this._agletList.remove(n);
                }
                --n;
            }
            this.updateGUIState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void restoreSize() {
        Resource resource = Resource.getResourceFor("tahiti");
        ((Component)this).setSize(resource.getInteger("tahiti.window.width", 100), resource.getInteger("tahiti.window.height", 100));
    }

    public void retractAglet(AgletProxy agletProxy) {
        new Thread(new TahitiEventHandler(10005, agletProxy)).start();
    }

    void saveSize() {
        Rectangle rectangle = this.getBounds();
        Resource resource = Resource.getResourceFor("tahiti");
        resource.setResource("tahiti.window.x", String.valueOf(rectangle.x));
        resource.setResource("tahiti.window.y", String.valueOf(rectangle.y));
        if (!this.shrink) {
            resource.setResource("tahiti.window.width", String.valueOf(rectangle.width));
            resource.setResource("tahiti.window.height", String.valueOf(rectangle.height));
            resource.setResource("tahiti.window.shrinked", "false");
        } else {
            resource.setResource("tahiti.window.shrinked", "true");
            resource.setResource("tahiti.window.s_width", String.valueOf(rectangle.width));
            resource.setResource("tahiti.window.s_height", String.valueOf(rectangle.height));
        }
    }

    public void setFont(Font font) {
        MenuBar menuBar = this.getMenuBar();
        if (menuBar != null) {
            menuBar.setFont(font);
            int n = menuBar.getMenuCount();
            int n2 = 0;
            while (n2 < n) {
                Menu menu = menuBar.getMenu(n2);
                menu.setFont(font);
                ++n2;
            }
        }
        super.setFont(font);
        this.doLayout();
    }

    void setMessage(String string) {
        this._messageLine.setText(string);
    }

    void showButtons() {
        this._dialogButton.setVisible(true);
        this._infoButton.setVisible(true);
        this._disposeButton.setVisible(true);
        this._cloneButton.setVisible(true);
        this._dispatchButton.setVisible(true);
    }

    private static void showThreadGroup(ThreadGroup threadGroup, int n) {
        int n2;
        Object[] objectArray;
        String string = "                                 ".substring(0, n);
        System.out.println(string + "{" + threadGroup.toString() + "}");
        int n3 = threadGroup.activeCount();
        if (n3 > 0) {
            System.out.println(string + " + Threads");
            objectArray = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate((Thread[])objectArray);
            n2 = 0;
            while (n2 < objectArray.length) {
                if (threadGroup == ((Thread)objectArray[n2]).getThreadGroup()) {
                    System.out.println(string + "  - " + ((Thread)objectArray[n2]).toString() + (((Thread)objectArray[n2]).isAlive() ? " alive" : " dead"));
                }
                ++n2;
            }
        }
        if ((n3 = threadGroup.activeGroupCount()) > 0) {
            System.out.println(string + " + ThreadGroups");
            objectArray = new ThreadGroup[n3];
            threadGroup.enumerate((ThreadGroup[])objectArray);
            n2 = 0;
            while (n2 < objectArray.length) {
                if (threadGroup == ((ThreadGroup)objectArray[n2]).getParent()) {
                    MainWindow.showThreadGroup((ThreadGroup)objectArray[n2], n + 4);
                }
                ++n2;
            }
        }
    }

    static void showThreads() {
        ThreadGroup threadGroup = null;
        threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        MainWindow.showThreadGroup(threadGroup, 0);
    }

    void showURL(String string) {
        Resource resource = Resource.getResourceFor("tahiti");
        String string2 = resource.getString("tahiti.browser_command", null);
        if (string2 != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                final String[] stringArray = new String[stringTokenizer.countTokens() + 1];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
                stringArray[n] = string;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Runtime.getRuntime().exec(stringArray);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void showWindow(Window window) {
    }

    public void shutdown() {
        this._tahiti.exit();
    }

    void updateGUIState() {
        int[] nArray = this._agletList.getSelectedIndexes();
        boolean bl = nArray.length == 1;
        boolean bl2 = nArray.length >= 1;
        this._dialogMenuItem.setEnabled(bl);
        this._dialogButton.setEnabled(bl);
        this._disposeMenuItem.setEnabled(bl2);
        this._disposeButton.setEnabled(bl2);
        this._killMenuItem.setEnabled(bl);
        this._cloneMenuItem.setEnabled(bl);
        this._cloneButton.setEnabled(bl);
        this._infoMenuItem.setEnabled(bl);
        this._infoButton.setEnabled(bl);
        this._dispatchMenuItem.setEnabled(bl);
        this._dispatchButton.setEnabled(bl);
        this._deactivateMenuItem.setEnabled(bl);
        this._activateMenuItem.setEnabled(bl);
    }

    synchronized void updateProxyInList(AgletProxy agletProxy) {
        TahitiItem tahitiItem = null;
        if (this.shrink) {
            return;
        }
        int n = this._agletList.getSelectedIndex();
        int n2 = -1;
        int n3 = 0;
        while (n3 < this._itemList.size()) {
            tahitiItem = (TahitiItem)this._itemList.elementAt(n3);
            if (tahitiItem.checkProxy(agletProxy)) {
                this._agletList.replaceItem(this.getItemText(tahitiItem), n3);
                n2 = n3;
                if (n2 == n) {
                    this._agletList.select(n2);
                }
            }
            ++n3;
        }
        this.updateGUIState();
    }

    public synchronized void updateProxyList() {
        this._agletList.removeAll();
        this._itemList.setSize(0);
        Enumeration enumeration = Tahiti.CONTEXT.getAgletProxies();
        while (enumeration.hasMoreElements()) {
            this.insertProxyToList((AgletProxy)enumeration.nextElement());
        }
    }

    static {
        bundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle("tahiti");
            }
        });
    }

    public class TahitiEventHandler
    implements Runnable {
        int _type;
        AgletProxy _proxy;
        long _time;
        String _remoteURL;
        String _codebase;
        String _name;
        boolean _reload;

        TahitiEventHandler(int n, AgletProxy agletProxy) {
            this._type = n;
            this._proxy = agletProxy;
        }

        TahitiEventHandler(AgletProxy agletProxy, long l) {
            this._type = 10007;
            this._proxy = agletProxy;
            this._time = l;
        }

        TahitiEventHandler(AgletProxy agletProxy, String string) {
            this._type = 10004;
            this._proxy = agletProxy;
            this._remoteURL = string;
        }

        TahitiEventHandler(String string, String string2, boolean bl) {
            this._type = 10002;
            this._codebase = string;
            this._name = string2;
            this._reload = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Debug.start();
            Debug.check();
            try {
                try {
                    this.perform();
                }
                catch (Error error) {
                    error.printStackTrace();
                    TahitiDialog.message(MainWindow.this, "Error", error.getClass().getName() + "\n" + error.getMessage()).popupAtCenterOfParent();
                    Object var4_2 = null;
                    Debug.end();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    TahitiDialog.message(MainWindow.this, "Exception", exception.getClass().getName() + "\n" + exception.getMessage()).popupAtCenterOfParent();
                    Object var4_3 = null;
                    Debug.end();
                    return;
                }
                Object var4_1 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Debug.end();
                throw throwable;
            }
            Debug.end();
        }

        private void perform() throws Exception {
            switch (this._type) {
                case 10001: {
                    this._proxy.clone();
                    break;
                }
                case 10003: {
                    this._proxy.dispose();
                    break;
                }
                case 10002: {
                    URL uRL;
                    if (!"".equals(this._codebase)) {
                        while (this._codebase.toLowerCase().startsWith("http://") && this._codebase.endsWith("/")) {
                            this._codebase = this._codebase.substring(0, this._codebase.length() - 1);
                        }
                    }
                    URL uRL2 = uRL = !this._codebase.equals("") ? new URL(this._codebase) : null;
                    if (this._reload) {
                        Tahiti.CONTEXT.clearCache(null);
                    }
                    Tahiti.CONTEXT.createAglet(uRL, this._name, null);
                    break;
                }
                case 10004: {
                    this._proxy.dispatch(new URL(this._remoteURL));
                    break;
                }
                case 10005: {
                    AgletInfo agletInfo = this._proxy.getAgletInfo();
                    Tahiti.CONTEXT.retractAglet(new URL(this._proxy.getAddress()), agletInfo.getAgletID());
                    break;
                }
                case 10007: {
                    this._proxy.deactivate(this._time * 1000L);
                    break;
                }
                case 10008: {
                    if (this._proxy == null || !this._proxy.isValid() || this._proxy.isActive()) break;
                    this._proxy.activate();
                    break;
                }
            }
        }
    }

    class DialogOpener
    implements ActionListener {
        private int _type = 0;

        DialogOpener(int n) {
            this._type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgletProxy agletProxy = MainWindow.this.getSelectedProxy();
            AccessController.doPrivileged(new PrivilegedAction(this, agletProxy){
                private final /* synthetic */ AgletProxy val$p;
                private final /* synthetic */ DialogOpener this$1;
                {
                    this.this$1 = dialogOpener;
                    this.val$p = agletProxy;
                }

                public Object run() {
                    TahitiDialog tahitiDialog = null;
                    switch (DialogOpener.access$000(this.this$1)) {
                        case 10002: {
                            tahitiDialog = CreateAgletDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10005: {
                            tahitiDialog = RetractAgletDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10003: {
                            AgletProxy[] agletProxyArray = new AgletProxy[]{this.val$p};
                            tahitiDialog = new DisposeAgletDialog(DialogOpener.access$100(this.this$1), agletProxyArray);
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10001: {
                            tahitiDialog = new CloneAgletDialog(DialogOpener.access$100(this.this$1), this.val$p);
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10004: {
                            tahitiDialog = new DispatchAgletDialog(DialogOpener.access$100(this.this$1), this.val$p);
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10007: {
                            tahitiDialog = new DeactivateAgletDialog(DialogOpener.access$100(this.this$1), this.val$p);
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10020: {
                            tahitiDialog = new PropertiesDialog(DialogOpener.access$100(this.this$1), DialogOpener.access$100(this.this$1).getSelectedProxy());
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10022: {
                            tahitiDialog = MemoryUsageDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10021: {
                            DialogOpener.access$100((DialogOpener)this.this$1).logWindow.pack();
                            if (DialogOpener.access$100((DialogOpener)this.this$1).logWindow.getLocation().x == 0 && DialogOpener.access$100((DialogOpener)this.this$1).logWindow.getLocation().y == 0) {
                                Dimension dimension = DialogOpener.access$100(this.this$1).getToolkit().getScreenSize();
                                Dimension dimension2 = DialogOpener.access$100((DialogOpener)this.this$1).logWindow.getSize();
                                ((Component)DialogOpener.access$100((DialogOpener)this.this$1).logWindow).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
                            }
                            DialogOpener.access$100((DialogOpener)this.this$1).logWindow.show();
                            break;
                        }
                        case 10027: {
                            if (Agletsd.console == null) break;
                            Agletsd.console.show();
                            break;
                        }
                        case 10030: {
                            tahitiDialog = GeneralConfigDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10031: {
                            tahitiDialog = NetworkConfigDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10032: {
                            tahitiDialog = SecurityConfigDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10033: {
                            tahitiDialog = ServerPrefsDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10036: {
                            Resource resource = Resource.getResourceFor("tahiti");
                            ResourceBundle resourceBundle = null;
                            resourceBundle = ResourceBundle.getBundle("tahiti");
                            tahitiDialog = TahitiDialog.message(DialogOpener.access$100(this.this$1), resourceBundle.getString("title.about_tahiti"), resource.getString("tahiti.version") + "\n" + resourceBundle.getString("message.copyright"));
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10035: {
                            Resource resource = Resource.getResourceFor("aglets");
                            String string = "Aglets Version : " + resource.getString("aglets.version") + "\n" + "Aglets API : " + 1 + "." + 2 + "\n" + "Aglet Transfer Format : " + resource.getString("aglets.stream.version") + "\n" + "\n" + resource.getString("aglets.copyright");
                            tahitiDialog = TahitiDialog.message(DialogOpener.access$100(this.this$1), "About Aglets", string);
                            tahitiDialog.popupAtCenterOfParent();
                            break;
                        }
                        case 10015: {
                            tahitiDialog = ShutdownDialog.getInstance(DialogOpener.access$100(this.this$1));
                            tahitiDialog.popupAtCenterOfParent();
                        }
                    }
                    return null;
                }
            });
        }

        static /* synthetic */ int access$000(DialogOpener dialogOpener) {
            return dialogOpener._type;
        }

        static /* synthetic */ MainWindow access$100(DialogOpener dialogOpener) {
            return dialogOpener.MainWindow.this;
        }
    }

    class EventIssuer
    implements ActionListener {
        private int _type = 0;

        EventIssuer(int n) {
            this._type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this._type) {
                case 10040: {
                    Button button = (Button)actionEvent.getSource();
                    if (MainWindow.this.shrink) {
                        MainWindow.this.shrink = false;
                        button.setLabel("><");
                        MainWindow.this.showButtons();
                        MainWindow.this.updateProxyList();
                        MainWindow.this._agletList.setVisible(true);
                        MainWindow.this.restoreSize();
                        MainWindow.this.doLayout();
                        MainWindow.this._buttonPanel.doLayout();
                        break;
                    }
                    button.setLabel("<>");
                    MainWindow.this.saveSize();
                    MainWindow.this.hideButtons();
                    MainWindow.this._agletList.setVisible(false);
                    ((Component)MainWindow.this).setSize(350, MainWindow.this.getBounds().height - MainWindow.this._agletList.getBounds().height);
                    MainWindow.this.doLayout();
                    MainWindow.this._buttonPanel.doLayout();
                    MainWindow.this.shrink = true;
                    break;
                }
                case 10023: {
                    System.gc();
                    break;
                }
                case 10009: {
                    MainWindow.this.dialog(MainWindow.this.getSelectedProxy());
                    break;
                }
                case 10024: {
                    MainWindow.showThreads();
                    break;
                }
                case 10025: {
                    Debug.list(System.err);
                }
                case 10026: {
                    RemoteAgletRef.showRefTable(System.err);
                    break;
                }
                case 10010: {
                    MainWindow.this.getAglets();
                    break;
                }
                case 10008: {
                    MainWindow.this.activateAglet(MainWindow.this.getSelectedProxy());
                    break;
                }
                case 10006: {
                    AgletProxy agletProxy = MainWindow.this.getSelectedProxy();
                    if (agletProxy == null) break;
                    try {
                        AgletRuntime.getAgletRuntime().killAglet(agletProxy);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    class URLOpener
    implements ActionListener {
        private String url;

        URLOpener(String string) {
            this.url = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainWindow.this.showURL(this.url);
        }
    }
}

