/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglets.tahiti.BorderPanel;
import com.ibm.aglets.tahiti.CreateSharedSecretDialog;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.NetworkConfigDialog;
import com.ibm.aglets.tahiti.ShutdownDialog;
import com.ibm.aglets.tahiti.Tahiti;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.atp.auth.SharedSecret;
import com.ibm.atp.auth.SharedSecrets;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.Resource;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

final class NetworkConfigDialog
extends TahitiDialog
implements ActionListener,
ItemListener {
    private static final String ACTION_RESTORE_DEFAULTS = "Restore Defaults";
    private Checkbox _useProxy = new Checkbox("Use HTTP Proxy");
    private TextField _proxyHost = new TextField(30);
    private TextField _proxyPort = new TextField(5);
    private TextField _noProxy = new TextField(35);
    private Checkbox _httpTunneling = new Checkbox("Accept HTTP Tunneling Request");
    private Checkbox _httpMessaging = new Checkbox("Accept HTTP Request as a Message");
    private static final int UNDEFINED = 0;
    private static final int YES = 1;
    private static final int NO = 2;
    private static final String ACTION_OK = "OK";
    private static final String ACTION_SUBSCRIBE = "subscribe";
    private static final String ACTION_UNSUBSCRIBE = "unsubscribe";
    protected Button _subscribe = new Button("Subscribe");
    protected Button _unsubscribe = new Button("Unsubscribe");
    private TextField _boxHost = new TextField(35);
    private TextField _boxUserid = new TextField(35);
    private TextField _boxPasswd = new TextField(35);
    private Choice _updateChoice = new Choice();
    private int _boxSubscribe = 0;
    private Checkbox _authenticationMode = new Checkbox("Do Authentication on ATP Connection");
    private Checkbox _secureRandomSeed = new Checkbox("Use Secure Random Seed");
    private static final String CREATE_SHARED_SECRET = "Create a new shared secret";
    private Button _createSharedSecret = new Button("Create a new shared secret");
    private static final String REMOVE_SHARED_SECRET = "Remove a shared secret";
    private Button _removeSharedSecret = new Button("Remove a shared secret");
    private static final String IMPORT_SHARED_SECRET = "Import a shared secret";
    private Button _importSharedSecret = new Button("Import a shared secret");
    private static final String EXPORT_SHARED_SECRET = "Export a shared secret";
    private Button _exportSharedSecret = new Button("Export a shared secret");
    private static NetworkConfigDialog _instance = null;
    private int[] boxUpdateValues = new int[]{0, 15, 30, 60, 300, 900, 3600};

    private NetworkConfigDialog(MainWindow mainWindow) {
        super(mainWindow, "Network Preferences", true);
        this.makePanel();
        this.addButton(ACTION_OK, this);
        this.addCloseButton(null);
        this.addButton(ACTION_RESTORE_DEFAULTS, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (ACTION_SUBSCRIBE.equals(string)) {
            this.subscribe();
        } else if (ACTION_UNSUBSCRIBE.equals(string)) {
            this.unsubscribe();
        } else if (CREATE_SHARED_SECRET.equals(string)) {
            this.createSharedSecret();
        } else if (REMOVE_SHARED_SECRET.equals(string)) {
            this.removeSharedSecret();
        } else if (IMPORT_SHARED_SECRET.equals(string)) {
            this.importSharedSecret();
        } else if (EXPORT_SHARED_SECRET.equals(string)) {
            this.exportSharedSecret();
        } else if (ACTION_RESTORE_DEFAULTS.equals(string)) {
            this.restoreDefaults();
        } else if (ACTION_OK.equals(string)) {
            this.dispose();
            if (this.save()) {
                ShutdownDialog shutdownDialog = new ShutdownDialog((MainWindow)this.getParent(), "To be effective, you need reboot the server.");
                shutdownDialog.popupAtCenterOfParent();
            }
            this.inform();
        }
    }

    private void createSharedSecret() {
        CreateSharedSecretDialog createSharedSecretDialog = new CreateSharedSecretDialog(this.getMainWindow());
        createSharedSecretDialog.popupAtCenterOfParent();
    }

    private void exportSharedSecret() {
        SharedSecrets sharedSecrets = SharedSecrets.getSharedSecrets();
        if (sharedSecrets == null) {
            TahitiDialog.alert(this.getMainWindow(), "No shared secrets").popupAtCenterOfParent();
            return;
        }
        class ExportSharedSecret
        extends TahitiDialog
        implements ActionListener,
        ItemListener {
            List list;
            TextField filename;
            SharedSecrets secrets;
            private final /* synthetic */ NetworkConfigDialog this$0;

            ExportSharedSecret(NetworkConfigDialog networkConfigDialog, Frame frame, SharedSecrets sharedSecrets) {
                super(frame, "Export a shared secret", true);
                this.this$0 = networkConfigDialog;
                this.secrets = sharedSecrets;
                this.add("North", new Label("Export a shared secret", 1));
                GridBagPanel gridBagPanel = new GridBagPanel();
                this.add(gridBagPanel);
                this.list = new List(5, false);
                this.filename = new TextField(20);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 0;
                gridBagPanel.setConstraints(gridBagConstraints);
                gridBagPanel.addLabeled("Domain name list", this.list);
                gridBagPanel.addLabeled("Filename", this.filename);
                this.list.addItemListener(this);
                this.list.addActionListener(this);
                Enumeration enumeration = this.secrets.getDomainNames();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        this.list.add(string);
                    }
                }
                this.filename.addActionListener(this);
                this.addButton("OK", this);
                this.addCloseButton("Cancel");
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                String string;
                if (itemEvent.getStateChange() == 1 && (string = this.list.getSelectedItem()) != null && !string.equals("")) {
                    String string2 = string.toLowerCase().replace(' ', '_') + ".sec";
                    this.filename.setText(string2);
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.list.getSelectedItem();
                if (string == null || string.equals("")) {
                    TahitiDialog.alert(this.getMainWindow(), "Select a domain name in list").popupAtCenterOfParent();
                    return;
                }
                String string2 = this.filename.getText();
                if (string2 == null || string2.equals("")) {
                    TahitiDialog.alert(this.getMainWindow(), "Specify filename").popupAtCenterOfParent();
                    return;
                }
                String string3 = NetworkConfigDialog.access$000();
                String string4 = FileUtils.getWorkDirectoryForUser(string3);
                String string5 = string4 + File.separator + string2;
                SharedSecret sharedSecret = this.secrets.getSharedSecret(string);
                if (sharedSecret == null) {
                    TahitiDialog.alert(this.getMainWindow(), "The shared secret does not exist").popupAtCenterOfParent();
                    return;
                }
                try {
                    sharedSecret.save(string5);
                }
                catch (IOException iOException) {
                    TahitiDialog.alert(this.getMainWindow(), "Cannot save").popupAtCenterOfParent();
                    return;
                }
                TahitiDialog.message(this.getMainWindow(), "Exported", "The shared secret of domain '" + string + "' is exported into a file '" + string5 + "'").popupAtCenterOfParent();
                this.dispose();
            }
        }
        ExportSharedSecret exportSharedSecret = new ExportSharedSecret(this, this.getMainWindow(), sharedSecrets);
        exportSharedSecret.popupAtCenterOfParent();
    }

    static NetworkConfigDialog getInstance(MainWindow mainWindow) {
        if (_instance == null) {
            _instance = new NetworkConfigDialog(mainWindow);
        } else {
            _instance.updateValues();
        }
        return _instance;
    }

    private static String getOwnerName() {
        AgletRuntime agletRuntime = AgletRuntime.getAgletRuntime();
        if (agletRuntime == null) {
            return null;
        }
        return agletRuntime.getOwnerName();
    }

    private int getStatusCode(Hashtable hashtable) {
        int n = -1;
        try {
            String string = (String)hashtable.get("status-code");
            return string == null ? n : Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private int getSubscribeStatus(String string) {
        if (string.equalsIgnoreCase("yes")) {
            return 1;
        }
        if (string.equalsIgnoreCase("no")) {
            return 2;
        }
        if (string.equalsIgnoreCase("undefined")) {
            return 0;
        }
        return 0;
    }

    private void importSharedSecret() {
        class ImportSharedSecret
        extends TahitiDialog
        implements ActionListener {
            TextField filename;
            private final /* synthetic */ NetworkConfigDialog this$0;

            ImportSharedSecret(NetworkConfigDialog networkConfigDialog, Frame frame) {
                super(frame, "Import a shared secret", true);
                this.this$0 = networkConfigDialog;
                this.add("North", new Label("Import a shared secret", 1));
                GridBagPanel gridBagPanel = new GridBagPanel();
                this.add(gridBagPanel);
                this.filename = new TextField(20);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 0;
                gridBagPanel.setConstraints(gridBagConstraints);
                gridBagPanel.addLabeled("Filename", this.filename);
                this.filename.addActionListener(this);
                this.addButton("OK", this);
                this.addCloseButton("Cancel");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.filename.getText();
                if (string == null || string.equals("")) {
                    TahitiDialog.alert(this.getMainWindow(), "Specify filename").popupAtCenterOfParent();
                    return;
                }
                String string2 = NetworkConfigDialog.access$000();
                String string3 = FileUtils.getWorkDirectoryForUser(string2);
                String string4 = string3 + File.separator + string;
                SharedSecret sharedSecret = null;
                try {
                    sharedSecret = SharedSecret.load(string4);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    TahitiDialog.alert(this.getMainWindow(), "File not found: " + string4).popupAtCenterOfParent();
                    return;
                }
                catch (IOException iOException) {
                    TahitiDialog.alert(this.getMainWindow(), "Cannot read file: " + string4).popupAtCenterOfParent();
                    return;
                }
                if (sharedSecret == null) {
                    TahitiDialog.alert(this.getMainWindow(), "No shared secret: " + string4).popupAtCenterOfParent();
                    return;
                }
                String string5 = sharedSecret.getDomainName();
                SharedSecrets sharedSecrets = SharedSecrets.getSharedSecrets();
                SharedSecret sharedSecret2 = sharedSecrets.getSharedSecret(string5);
                if (sharedSecret2 != null) {
                    TahitiDialog.alert(this.getMainWindow(), "The shared secret for domain '" + string5 + "' already exists").popupAtCenterOfParent();
                    return;
                }
                sharedSecrets.addSharedSecret(sharedSecret);
                sharedSecrets.save();
                TahitiDialog.message(this.getMainWindow(), "Imported", "The shared secret for domain '" + string5 + "' is imported").popupAtCenterOfParent();
                this.dispose();
            }
        }
        ImportSharedSecret importSharedSecret = new ImportSharedSecret(this, this.getMainWindow());
        importSharedSecret.popupAtCenterOfParent();
    }

    private void inform() {
        Resource resource = Resource.getResourceFor("aglets");
        if (Tahiti.enableBox) {
            // empty if block
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateGUIState();
    }

    void makePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.add("Center", gridBagPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagPanel.setConstraints(gridBagConstraints);
        BorderPanel borderPanel = new BorderPanel("Http Tunneling");
        gridBagPanel.add((Component)borderPanel, 0);
        this.setupHttpTunnelingPanel(borderPanel);
        borderPanel = new BorderPanel("Authentication");
        gridBagPanel.add((Component)borderPanel, 0);
        this.setupAuthenticationPanel(borderPanel);
        borderPanel = new BorderPanel("Others");
        gridBagPanel.add((Component)borderPanel, 0);
        this.setupOthersPanel(borderPanel);
        this._updateChoice.addItem("None");
        this._updateChoice.addItem("At most every 15sec");
        this._updateChoice.addItem("At most every 30sec");
        this._updateChoice.addItem("At most every 1 min");
        this._updateChoice.addItem("At most every 5 min");
        this._updateChoice.addItem("At most every 15min");
        this._updateChoice.addItem("At most once an hour");
        this.updateValues();
    }

    protected Panel makeSubscribeButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this._subscribe);
        panel.add(this._unsubscribe);
        this._subscribe.setActionCommand(ACTION_SUBSCRIBE);
        this._subscribe.addActionListener(this);
        this._unsubscribe.setActionCommand(ACTION_UNSUBSCRIBE);
        this._unsubscribe.addActionListener(this);
        return panel;
    }

    private void removeSharedSecret() {
        SharedSecrets sharedSecrets = SharedSecrets.getSharedSecrets();
        if (sharedSecrets == null) {
            TahitiDialog.alert(this.getMainWindow(), "No shared secrets").popupAtCenterOfParent();
            return;
        }
        class RemoveSharedSecret
        extends TahitiDialog
        implements ActionListener {
            List list;
            TextField password;
            SharedSecrets secrets;
            private final /* synthetic */ NetworkConfigDialog this$0;

            RemoveSharedSecret(NetworkConfigDialog networkConfigDialog, Frame frame, SharedSecrets sharedSecrets) {
                super(frame, "Remove a shared secret", true);
                this.this$0 = networkConfigDialog;
                this.secrets = sharedSecrets;
                this.add("North", new Label("Remove a shared secret", 1));
                GridBagPanel gridBagPanel = new GridBagPanel();
                this.add(gridBagPanel);
                this.list = new List(5, false);
                this.password = new TextField(20);
                this.password.setEchoChar('*');
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 0;
                gridBagPanel.setConstraints(gridBagConstraints);
                gridBagPanel.addLabeled("Domain name list", this.list);
                gridBagPanel.addLabeled("Password", this.password);
                this.list.addActionListener(this);
                Enumeration enumeration = this.secrets.getDomainNames();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        this.list.add(string);
                    }
                }
                this.password.addActionListener(this);
                this.addButton("OK", this);
                this.addCloseButton("Cancel");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = this.list.getSelectedItem();
                if (string2 == null || string2.equals("")) {
                    TahitiDialog.alert(this.getMainWindow(), "Select a domain name in list").popupAtCenterOfParent();
                    return;
                }
                SharedSecret sharedSecret = this.secrets.getSharedSecret(string2);
                if (sharedSecret == null) {
                    TahitiDialog.alert(this.getMainWindow(), "Shared secret does not exist").popupAtCenterOfParent();
                    return;
                }
                AgletRuntime agletRuntime = AgletRuntime.getAgletRuntime();
                if (agletRuntime.authenticateOwner(string = agletRuntime.getOwnerName(), this.password.getText()) == null) {
                    TahitiDialog.alert(this.getMainWindow(), "Authentication failed").popupAtCenterOfParent();
                    this.password.setText("");
                    return;
                }
                this.secrets.removeSharedSecret(string2);
                this.secrets.save();
                TahitiDialog.message(this.getMainWindow(), "Removed", "The domain '" + string2 + "' is removed").popupAtCenterOfParent();
                this.dispose();
            }
        }
        RemoveSharedSecret removeSharedSecret = new RemoveSharedSecret(this, this.getMainWindow(), sharedSecrets);
        removeSharedSecret.popupAtCenterOfParent();
    }

    void restoreDefaults() {
        this._updateChoice.select(0);
        this._httpTunneling.setState(false);
        this._httpMessaging.setState(false);
    }

    private boolean save() {
        boolean bl = false;
        Resource resource = Resource.getResourceFor("system");
        Resource resource2 = Resource.getResourceFor("atp");
        boolean bl2 = this._useProxy.getState();
        if (bl2 != resource2.getBoolean("atp.useHttpProxy", false)) {
            bl = true;
        }
        resource2.setResource("atp.useHttpProxy", String.valueOf(bl2));
        String string = this._proxyHost.getText().trim();
        if (!string.equals(resource2.getString("atp.http.proxyHost"))) {
            bl = true;
        }
        resource2.setResource("atp.http.proxyHost", string);
        resource.setResource("proxyHost", bl2 ? string : "");
        resource.setResource("http.proxyHost", bl2 ? string : "");
        string = this._proxyPort.getText().trim();
        if (!string.equals(resource2.getString("atp.http.proxyPort"))) {
            bl = true;
        }
        resource2.setResource("atp.http.proxyPort", string);
        resource.setResource("proxyPort", bl2 ? string : "");
        resource.setResource("http.proxyPort", bl2 ? string : "");
        string = this._noProxy.getText().trim();
        if (!string.equals(resource2.getString("atp.noProxy"))) {
            bl = true;
        }
        resource2.setResource("atp.noProxy", string);
        resource.setResource("http.nonProxyHosts", string);
        resource2.setResource("atp.http.tunneling", String.valueOf(this._httpTunneling.getState()));
        resource2.setResource("atp.http.messaging", String.valueOf(this._httpMessaging.getState()));
        boolean bl3 = this._authenticationMode.getState();
        if (bl3 != resource2.getBoolean("atp.authentication", false)) {
            bl = true;
        }
        resource2.setResource("atp.authentication", String.valueOf(bl3));
        if (bl3) {
            System.out.println("AUTHENTICATION MODE ON.");
        } else {
            System.out.println("AUTHENTICATION MODE OFF.");
        }
        boolean bl4 = this._secureRandomSeed.getState();
        resource2.setResource("atp.secureseed", String.valueOf(bl4));
        if (bl4) {
            System.out.println("USE SECURE RANDOM SEED.");
        } else {
            System.out.println("USE UNSECURE PSEUDO RANDOM SEED.");
        }
        if (bl3) {
            System.out.print("[Generating random seed ... wait for a while ... ");
            if (bl3) {
                // empty if block
            }
            System.out.println("done.]");
        }
        Resource resource3 = Resource.getResourceFor("aglets");
        if (Tahiti.enableBox) {
            resource3.setResource("aglets.box.update.sec", String.valueOf(this.updateValue(this._updateChoice.getSelectedIndex())));
            resource3.setResource("aglets.box.update", String.valueOf(this._updateChoice.getSelectedIndex()));
            resource3.setResource("aglets.box.host", this._boxHost.getText().trim());
            resource3.setResource("aglets.box.passwd", this._boxPasswd.getText().trim());
            resource3.setResource("aglets.box.userid", this._boxUserid.getText().trim());
            resource3.setResource("aglets.box.subscribe", this.setSubscribeStatus(this._boxSubscribe));
        }
        resource3.save("Tahiti");
        resource2.save("Tahiti");
        return bl;
    }

    private String setSubscribeStatus(int n) {
        switch (n) {
            case 1: {
                return "yes";
            }
            case 2: {
                return "no";
            }
            case 0: {
                return "undefined";
            }
        }
        return "undefined";
    }

    void setupAuthenticationPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        gridBagConstraints.fill = 2;
        borderPanel.add((Component)this._authenticationMode, 0, 1.0);
        borderPanel.add((Component)this._secureRandomSeed, 0, 1.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        borderPanel.add(this._createSharedSecret);
        this._createSharedSecret.setActionCommand(CREATE_SHARED_SECRET);
        this._createSharedSecret.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        borderPanel.add(this._removeSharedSecret);
        this._removeSharedSecret.setActionCommand(REMOVE_SHARED_SECRET);
        this._removeSharedSecret.addActionListener(this);
        gridBagConstraints.gridwidth = -1;
        borderPanel.add(this._importSharedSecret);
        this._importSharedSecret.setActionCommand(IMPORT_SHARED_SECRET);
        this._importSharedSecret.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        borderPanel.add(this._exportSharedSecret);
        this._exportSharedSecret.setActionCommand(EXPORT_SHARED_SECRET);
        this._exportSharedSecret.addActionListener(this);
    }

    void setupHttpTunnelingPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        borderPanel.add((Component)this._httpTunneling, 0, 1.0);
        borderPanel.add((Component)this._useProxy, 0, 1.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = borderPanel.bottomInsets();
        borderPanel.add((Component)new Label("ProxyHost:"), 1, 0.1);
        borderPanel.add((Component)this._proxyHost, 1, 1.0);
        borderPanel.add((Component)new Label("Port:"), 1, 0.1);
        borderPanel.add((Component)this._proxyPort, 0, 0.4);
        borderPanel.add((Component)new Label("Do not use the proxy server for domains:"), 0, 1.0);
        borderPanel.add((Component)this._noProxy, 0, 1.0);
        this._useProxy.addItemListener(this);
    }

    void setupOthersPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        borderPanel.setConstraints(gridBagConstraints);
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.add((Component)this._httpMessaging, 0, 1.0);
    }

    void setupSubscriptionPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        gridBagConstraints.fill = 2;
        borderPanel.add((Component)new Label("Server(URL):"), 1, 0.1);
        borderPanel.add((Component)this._boxHost, 0, 1.0);
        gridBagConstraints.insets = borderPanel.bottomInsets();
        this._boxPasswd.setEchoChar('x');
        borderPanel.add((Component)new Label("Password:"), 1, 0.1);
        borderPanel.add((Component)this._boxPasswd, 0, 1.0);
        borderPanel.add((Component)new Label("UserId:"), 1, 0.1);
        borderPanel.add((Component)this._boxUserid, 0, 1.0);
        gridBagConstraints.fill = 0;
        borderPanel.add((Component)new Label("Frequency:"), 1, 0.1);
        borderPanel.add((Component)this._updateChoice, 1, 0.1);
        gridBagConstraints.anchor = 13;
        borderPanel.add((Component)this._subscribe, 0, 1.0);
        borderPanel.add((Component)this._unsubscribe, 0, 1.0);
    }

    void subscribe() {
    }

    void unsubscribe() {
    }

    void updateGUIState() {
        this._boxUserid.setEnabled(false);
        boolean bl = this._useProxy.getState();
        this._proxyHost.setEnabled(bl);
        this._proxyPort.setEnabled(bl);
        this._noProxy.setEnabled(bl);
        this._boxUserid.setEnabled(false);
        this.updateSubscribeGUIState(this._boxSubscribe);
    }

    private int updateIndex(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.boxUpdateValues.length) {
            if (n == this.boxUpdateValues[n3]) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    private void updateSubscribeGUIState(int n) {
        if (!Tahiti.enableBox) {
            this._subscribe.setEnabled(false);
            this._unsubscribe.setEnabled(false);
            this._boxHost.setText("Disabled");
            this._boxUserid.setText("Disabled");
            this._boxHost.setEnabled(false);
            this._boxPasswd.setEnabled(false);
            this._updateChoice.select(0);
            this._updateChoice.setEnabled(false);
            Resource resource = Resource.getResourceFor("aglets");
            resource.setResource("aglets.box.subscribe", this.setSubscribeStatus(2));
            return;
        }
        switch (n) {
            case 1: {
                this._subscribe.setEnabled(false);
                this._unsubscribe.setEnabled(true);
                this._boxHost.setEnabled(false);
                this._boxPasswd.setEnabled(false);
                break;
            }
            case 2: {
                this._subscribe.setEnabled(true);
                this._unsubscribe.setEnabled(false);
                this._boxHost.setEnabled(true);
                this._boxPasswd.setEnabled(true);
                break;
            }
            case 0: {
                this._subscribe.setEnabled(true);
                this._unsubscribe.setEnabled(true);
                this._boxHost.setEnabled(true);
                this._boxPasswd.setEnabled(true);
                break;
            }
        }
        this._boxSubscribe = n;
    }

    private int updateValue(int n) {
        return n < this.boxUpdateValues.length ? this.boxUpdateValues[n] : 0;
    }

    private void updateValues() {
        Resource resource = Resource.getResourceFor("atp");
        this._proxyHost.setText(resource.getString("atp.http.proxyHost", ""));
        this._proxyPort.setText(resource.getString("atp.http.proxyPort", ""));
        this._noProxy.setText(resource.getString("atp.noProxy", ""));
        this._useProxy.setState(resource.getBoolean("atp.useHttpProxy", false));
        Resource resource2 = Resource.getResourceFor("aglets");
        this._httpTunneling.setState(resource.getBoolean("atp.http.tunneling", false));
        this._httpMessaging.setState(resource.getBoolean("atp.http.messaging", false));
        this._authenticationMode.setState(resource.getBoolean("atp.authentication", false));
        this._secureRandomSeed.setState(resource.getBoolean("atp.secureseed", false));
        String string = resource2.getString("aglets.box.userid", "");
        this._boxUserid.setText(resource2.getString("aglets.box.userid", string));
        this._boxPasswd.setText(resource2.getString("aglets.box.passwd"));
        this._updateChoice.select(this.updateIndex(resource2.getInteger("aglets.box.update.sec", 0)));
        this._updateChoice.select(resource2.getInteger("aglets.box.update", 0));
        this._boxHost.setText(resource2.getString("aglets.box.host"));
        String string2 = resource2.getString("aglets.box.subscribe", "undefined");
        this._boxSubscribe = this._boxSubscribe == 0 ? this.getSubscribeStatus(string2) : this._boxSubscribe;
        this.updateGUIState();
    }

    static /* synthetic */ String access$000() {
        return NetworkConfigDialog.getOwnerName();
    }
}

