/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.MyPanel;
import com.ibm.aglets.tahiti.TahitiDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.security.cert.X509Certificate;
import java.util.Date;

final class PropertiesDialog
extends TahitiDialog {
    private Label _identity = new Label("");
    private Label _date = new Label("");
    private Label _name = new Label("");
    private Label _owner = new Label("");
    private Label _codebase = new Label("");
    private Label _version = new Label("");
    private List _from = new List(3, false);

    public PropertiesDialog(MainWindow mainWindow, AgletProxy agletProxy) {
        super(mainWindow, "Aglet Info", false);
        try {
            AgletInfo agletInfo = agletProxy.getAgletInfo();
            this._identity.setText(agletInfo.getAgletID().toString());
            this._date.setText(new Date(agletInfo.getCreationTime()).toString());
            this._name.setText(agletInfo.getAgletClassName());
            this._codebase.setText(agletInfo.getCodeBase() == null ? "Local host" : agletInfo.getCodeBase().toString());
            X509Certificate x509Certificate = (X509Certificate)agletInfo.getAuthorityCertificate();
            String string = x509Certificate == null ? "(Unknown Owner)" : x509Certificate.getSubjectDN().getName();
            this._owner.setText(string);
            this._version.setText(agletInfo.getAPIMajorVersion() + "." + agletInfo.getAPIMinorVersion());
        }
        catch (InvalidAgletException invalidAgletException) {
            this._identity.setText("Invalid Aglet");
        }
        this.makePanel();
        this.addCloseButton(null);
    }

    void makePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.add("Center", gridBagPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        MyPanel myPanel = new MyPanel("Aglet Instance Information:");
        gridBagPanel.add((Component)myPanel, gridBagConstraints);
        myPanel.makeLabeledComponent("Identity", this._identity);
        myPanel.makeLabeledComponent("Owner Id", this._owner);
        myPanel.makeLabeledComponent("Creation Date", this._date);
        myPanel = new MyPanel("Aglet Class Information:");
        gridBagPanel.add((Component)myPanel, gridBagConstraints);
        myPanel.makeLabeledComponent("Class Name", this._name);
        myPanel.makeLabeledComponent("Code Base", this._codebase);
        myPanel.makeLabeledComponent("Version", this._version);
    }
}

