/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.MessageManager;
import com.ibm.aglets.AgletRuntime;
import com.ibm.aglets.AgletThread;
import com.ibm.aglets.ResourceManager;
import com.ibm.aglets.security.PolicyImpl;
import com.ibm.aglets.tahiti.AgletClassLoader;
import com.ibm.aglets.tahiti.AgletsSecurityManager;
import com.ibm.aglets.tahiti.DigestTable;
import com.ibm.aglets.tahiti.JarAgletClassLoader;
import com.ibm.aglets.tahiti.ResourceManagerImpl;
import com.ibm.awb.misc.Archive;
import com.ibm.awb.misc.JarArchive;
import com.ibm.awb.misc.Manifest;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.ClassName;
import com.ibm.maf.MAFAgentSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class ResourceManagerFactory
implements com.ibm.aglets.ResourceManagerFactory {
    private static String[] _agletsClassPath;
    private static Hashtable _manifests;
    private static String _publicRoot;
    private static String _localAddr;
    static Class[] exportedClass;
    static String[] exportedClassName;
    private ResourceManager _appResourceManager;
    private Hashtable _map = new Hashtable();
    static /* synthetic */ Class class$com$ibm$aglets$tahiti$ResourceManagerFactory;

    public ResourceManagerFactory() {
        this._appResourceManager = new AppResourceManager();
    }

    public synchronized void clearCache() {
        this._map = new Hashtable();
    }

    public synchronized void clearCache(URL uRL, Certificate certificate) {
        if (uRL == null) {
            this.clearCache();
        } else {
            CodeSource codeSource = new CodeSource(uRL, new Certificate[]{certificate});
            this._map.remove(codeSource);
        }
    }

    private AgletClassLoader createClassLoader(URL uRL, Certificate certificate) {
        String string = null;
        if (certificate != null) {
            string = ((X509Certificate)certificate).getSubjectDN().getName();
        }
        ResourceManagerFactory.verboseOut("creating AgletClassLoader: for " + uRL + " : " + string);
        Certificate[] certificateArray = certificate != null ? new Certificate[]{certificate} : new Certificate[]{};
        CodeSource codeSource = new CodeSource(uRL, certificateArray);
        Vector<JarAgletClassLoader> vector = (Vector<JarAgletClassLoader>)this._map.get(codeSource);
        if (vector == null) {
            vector = new Vector<JarAgletClassLoader>();
            this._map.put(codeSource, vector);
        }
        AgletClassLoader agletClassLoader = null;
        try {
            if (JarAgletClassLoader.isJarFile(uRL)) {
                agletClassLoader = new JarAgletClassLoader(uRL, certificate);
            } else {
                String string2 = uRL.getFile();
                if (string2 != null && !string2.endsWith("/")) {
                    uRL = new URL(uRL, uRL.getFile() + "/");
                }
                agletClassLoader = new AgletClassLoader(uRL, certificate);
                int n = 0;
                while (n < exportedClass.length) {
                    agletClassLoader.cacheResolvedClass(exportedClass[n]);
                    ++n;
                }
            }
            vector.insertElementAt((JarAgletClassLoader)agletClassLoader, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            agletClassLoader = null;
        }
        return agletClassLoader;
    }

    public synchronized ResourceManager createResourceManager(URL uRL, Certificate certificate, ClassName[] classNameArray) {
        AgletClassLoader agletClassLoader = this.getClassLoaderInCache(uRL, certificate, classNameArray);
        if (agletClassLoader == null) {
            System.out.println("creating loader");
            agletClassLoader = this.createClassLoader(uRL, certificate);
        }
        String string = null;
        if (certificate != null) {
            string = ((X509Certificate)certificate).getSubjectDN().getName();
        }
        return new ResourceManagerImpl(agletClassLoader, string);
    }

    private static String getCanonicalDirectory(String string) throws IOException {
        final File file = new File(string);
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String string = file.getCanonicalPath();
                    if (!file.isAbsolute()) {
                        string = File.separatorChar + string;
                    }
                    if (string.charAt(string.length() - 1) != File.separatorChar) {
                        string = string + File.separatorChar;
                    }
                    return string;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private AgletClassLoader getClassLoaderInCache(URL uRL, Certificate certificate, ClassName[] classNameArray) {
        Object object;
        Object object2;
        Certificate[] certificateArray = certificate != null ? new Certificate[]{certificate} : new Certificate[]{};
        CodeSource codeSource = new CodeSource(uRL, certificateArray);
        Vector vector = (Vector)this._map.get(codeSource);
        if (classNameArray == null & JarAgletClassLoader.isJarFile(uRL)) {
            try {
                object2 = uRL;
                object = (ClassName[])AccessController.doPrivileged(new PrivilegedExceptionAction((URL)object2){
                    private final /* synthetic */ URL val$fCodebase;
                    {
                        this.val$fCodebase = uRL;
                    }

                    public Object run() throws IOException {
                        InputStream inputStream = this.val$fCodebase.openStream();
                        JarArchive jarArchive = new JarArchive(inputStream);
                        Archive.Entry[] entryArray = jarArchive.entries();
                        ClassName[] classNameArray = new ClassName[entryArray.length];
                        int n = 0;
                        while (n < entryArray.length) {
                            classNameArray[n] = new ClassName(entryArray[n].name(), DigestTable.toByteArray(entryArray[n].digest()));
                            ++n;
                        }
                        inputStream.close();
                        return classNameArray;
                    }
                });
                classNameArray = new ClassName[((ClassName[])object).length];
                System.arraycopy(object, 0, classNameArray, 0, classNameArray.length);
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
        }
        if (vector != null) {
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (AgletClassLoader)object2.nextElement();
                if (classNameArray != null && !((AgletClassLoader)object).matchAndImport(classNameArray)) continue;
                return object;
            }
        }
        return null;
    }

    public ResourceManager getCurrentResourceManager() {
        SecurityManager securityManager;
        ResourceManager resourceManager = ResourceManagerImpl.getResourceManagerContext();
        if (resourceManager == null && (securityManager = System.getSecurityManager()) != null && securityManager instanceof AgletsSecurityManager) {
            AgletsSecurityManager agletsSecurityManager = (AgletsSecurityManager)securityManager;
            ClassLoader classLoader = agletsSecurityManager.getCurrentNonSecureClassLoader();
            resourceManager = classLoader instanceof AgletClassLoader ? (AgletClassLoader)classLoader : this._appResourceManager;
        }
        return resourceManager;
    }

    private static boolean isJarFile(String string) {
        return string.endsWith(".jar");
    }

    public URL lookupCodeBaseFor(String string) {
        String string2 = null;
        try {
            string2 = ResourceManagerFactory.lookupCodeBaseInManifest(string);
            if (string2 == null) {
                string2 = ResourceManagerFactory.lookupCodeBaseFrom(string, _agletsClassPath);
            }
            if (string2 == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        string2 = string2.startsWith(_publicRoot) ? _localAddr + File.separatorChar + string2.substring(_publicRoot.length()) : (string2.startsWith("/") ? "file:" + string2 : "file:/" + string2);
        try {
            URL uRL = new URL(string2.replace(File.separatorChar, '/'));
            return uRL;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String lookupCodeBaseFrom(String string, String[] stringArray) throws IOException {
        final String[] stringArray2 = stringArray;
        final String string2 = string.replace('.', File.separatorChar) + ".class";
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    int n = 0;
                    while (n < stringArray2.length) {
                        File file = new File(stringArray2[n] + File.separator + string2);
                        if (file.exists()) {
                            return ResourceManagerFactory.getCanonicalDirectory(stringArray2[n]);
                        }
                        ++n;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private static String lookupCodeBaseInManifest(String string) throws IOException {
        Enumeration enumeration = _manifests.keys();
        while (enumeration.hasMoreElements()) {
            Manifest manifest = (Manifest)enumeration.nextElement();
            if (!manifest.contains(string.replace('.', '/') + ".class")) continue;
            return (String)_manifests.get(manifest);
        }
        return null;
    }

    private static void lookupJarFiles(String string, boolean bl) {
        final File file = new File(string);
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.isDirectory());
            }
        });
        boolean bl3 = bl2;
        if (bl3 && bl) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String[] stringArray = file.list();
                    String string = file.getPath() + File.separator;
                    int n = 0;
                    while (n < stringArray.length) {
                        ResourceManagerFactory.lookupJarFiles(string + stringArray[n], false);
                        ++n;
                    }
                    return null;
                }
            });
        } else if (ResourceManagerFactory.isJarFile(string)) {
            ResourceManagerFactory.readManifest(string);
        }
    }

    private static void readManifest(String string) {
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ResourceManagerFactory.verboseOut("Reading manifest .. " + string);
        try {
            JarArchive jarArchive = new JarArchive(string);
            Manifest manifest = jarArchive.getManifest();
            _manifests.put(manifest, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void verboseOut(String string) {
        AgletRuntime.verboseOut(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        exportedClassName = new String[]{"com.ibm.aglets.AgletProxyImpl", "com.ibm.aglets.DeactivationInfo", "com.ibm.aglets.MessageImpl", "com.ibm.aglets.MessageManagerImpl", "com.ibm.aglets.SystemMessage", "com.ibm.aglets.AgletImageData", "com.ibm.aglets.AgletAudioClip", "com.ibm.aglets.ByteArrayImageSource", "com.ibm.awb.misc.Resource", "com.ibm.awb.weakref.VirtualRef"};
        Resource resource = Resource.getResourceFor("aglets");
        _agletsClassPath = resource.getStringArray("aglets.class.path", File.pathSeparator);
        _publicRoot = resource.getString("aglets.public.root", null);
        if (_publicRoot != null) {
            try {
                _publicRoot = ResourceManagerFactory.getCanonicalDirectory(_publicRoot);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        _localAddr = MAFAgentSystem.getLocalMAFAgentSystem().getAddress();
        Policy policy = Policy.getPolicy();
        if (policy instanceof PolicyImpl) {
            PolicyImpl policyImpl = (PolicyImpl)policy;
            policyImpl.setSystemCodeBase(_localAddr);
            policyImpl.setPublicRoot(_publicRoot);
        }
        _manifests = new Hashtable();
        ResourceManagerFactory.verboseOut("AgletsClassPath: ==========");
        int n = 0;
        while (n < _agletsClassPath.length) {
            ResourceManagerFactory.lookupJarFiles(_agletsClassPath[n], true);
            ResourceManagerFactory.verboseOut(" " + _agletsClassPath[n]);
            ++n;
        }
        ResourceManagerFactory.verboseOut("                 ==========");
        ClassLoader classLoader = (class$com$ibm$aglets$tahiti$ResourceManagerFactory == null ? (class$com$ibm$aglets$tahiti$ResourceManagerFactory = ResourceManagerFactory.class$("com.ibm.aglets.tahiti.ResourceManagerFactory")) : class$com$ibm$aglets$tahiti$ResourceManagerFactory).getClassLoader();
        exportedClass = new Class[exportedClassName.length];
        int n2 = 0;
        while (n2 < exportedClassName.length) {
            try {
                ResourceManagerFactory.exportedClass[n2] = classLoader == null ? Class.forName(exportedClassName[n2]) : classLoader.loadClass(exportedClassName[n2]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            ++n2;
        }
    }

    final class AppResourceManager
    implements ResourceManager {
        AppResourceManager() {
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return Class.forName(string);
        }

        public boolean contains(Class clazz) {
            return clazz != null && clazz.getClassLoader() == null;
        }

        public Archive getArchive(ClassName[] classNameArray) {
            return null;
        }

        public void importArchive(Archive archive) {
        }

        public ClassName[] getClassNames(Class[] classArray) {
            return null;
        }

        public void addResource(Object object) {
        }

        public void disposeAllResources() {
        }

        public AgletThread newAgletThread(MessageManager messageManager) {
            return null;
        }

        public void stopAllThreads() {
        }

        public void stopThreadGroup() {
        }

        public void suspendAllThreads() {
        }

        public void resumeAllThreads() {
        }

        public void setResourceManagerContext() {
        }

        public void unsetResourceManagerContext() {
        }
    }
}

