/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.MessageManager;
import com.ibm.aglets.AgletThread;
import com.ibm.aglets.ResourceManager;
import com.ibm.aglets.tahiti.AgletClassLoader;
import com.ibm.aglets.tahiti.AgletThreadGroup;
import com.ibm.awb.misc.Archive;
import com.ibm.maf.ClassName;
import java.awt.Window;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class ResourceManagerImpl
implements ResourceManager {
    private static ThreadGroup AGLET_GROUPS = new ThreadGroup("AGLET_GROUPS");
    private AgletThreadGroup _group = null;
    private AgletClassLoader _loader = null;
    private Vector _resources = new Vector();
    private String _name = null;
    private static Hashtable rm_contexts;

    public ResourceManagerImpl(AgletClassLoader agletClassLoader, String string) {
        this._loader = agletClassLoader;
        this._name = string;
    }

    public void addResource(Object object) {
        Vector vector = this._resources;
        synchronized (vector) {
            if (!this._resources.contains(object)) {
                this._resources.addElement(object);
            }
        }
    }

    public boolean contains(Class clazz) {
        return this._loader.contains(clazz);
    }

    public void disposeAllResources() {
        Vector vector = this._resources;
        synchronized (vector) {
            Enumeration enumeration = this._resources.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof Window)) continue;
                ((Window)e).dispose();
            }
            this._resources = null;
        }
        this._loader = null;
    }

    public Archive getArchive(ClassName[] classNameArray) {
        return this._loader.getArchive(classNameArray);
    }

    public ClassName[] getClassNames(Class[] classArray) {
        return this._loader.getClassNames(classArray);
    }

    String getName() {
        return this._name;
    }

    static ResourceManagerImpl getResourceManagerContext() {
        ThreadGroup threadGroup;
        ResourceManagerImpl resourceManagerImpl = (ResourceManagerImpl)rm_contexts.get(Thread.currentThread());
        if (resourceManagerImpl == null && (threadGroup = Thread.currentThread().getThreadGroup()) instanceof AgletThreadGroup) {
            resourceManagerImpl = ((AgletThreadGroup)threadGroup)._rm;
        }
        return resourceManagerImpl;
    }

    public synchronized ThreadGroup getThreadGroup() {
        if (this._group == null) {
            try {
                final ResourceManagerImpl resourceManagerImpl = this;
                this._group = (AgletThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new AgletThreadGroup(AGLET_GROUPS, resourceManagerImpl);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._group;
    }

    public void importArchive(Archive archive) {
        this._loader.importArchive(archive);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this._loader.loadClass(string);
    }

    public AgletThread newAgletThread(MessageManager messageManager) {
        try {
            final ThreadGroup threadGroup = this.getThreadGroup();
            final MessageManager messageManager2 = messageManager;
            return (AgletThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new AgletThread(threadGroup, messageManager2);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void resumeAllThreads() {
        try {
            final ThreadGroup threadGroup = this.getThreadGroup();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    threadGroup.resume();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setResourceManagerContext() {
        rm_contexts.put(Thread.currentThread(), this);
    }

    public void stopAllThreads() {
        final AgletThreadGroup agletThreadGroup = (AgletThreadGroup)this.getThreadGroup();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    boolean bl = false;
                    AgletThreadGroup agletThreadGroup2 = agletThreadGroup;
                    synchronized (agletThreadGroup2) {
                        agletThreadGroup.invalidate();
                        agletThreadGroup.setDaemon(true);
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        if (agletThreadGroup.parentOf(threadGroup)) {
                            bl = true;
                            Thread[] threadArray = new Thread[agletThreadGroup.activeCount() + 1];
                            int n = agletThreadGroup.enumerate(threadArray, true);
                            Thread thread = Thread.currentThread();
                            int n2 = 0;
                            while (n2 < n) {
                                if (thread != threadArray[n2]) {
                                    threadArray[n2].resume();
                                    threadArray[n2].stop();
                                    threadArray[n2].interrupt();
                                }
                                ++n2;
                            }
                        } else {
                            agletThreadGroup.stop();
                            agletThreadGroup.resume();
                        }
                    }
                    if (!bl) {
                        agletThreadGroup.destroy();
                    }
                    return null;
                }
            });
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void stopThreadGroup() {
        try {
            final AgletThreadGroup agletThreadGroup = this._group;
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * Loose catch block
                 */
                public Object run() {
                    block8: {
                        agletThreadGroup.stop();
                        Object var3_1 = null;
                        try {
                            agletThreadGroup.destroy();
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {}
                        break block8;
                        {
                            catch (Exception exception) {
                                Object var3_2 = null;
                                try {
                                    agletThreadGroup.destroy();
                                }
                                catch (IllegalThreadStateException illegalThreadStateException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            try {
                                agletThreadGroup.destroy();
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._group = null;
    }

    public void suspendAllThreads() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = this.getThreadGroup();
        synchronized (threadGroup2) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread[] threadArray = new Thread[threadGroup.activeCount()];
                        Thread thread = Thread.currentThread();
                        int n = threadGroup.enumerate(threadArray, true);
                        int n2 = 0;
                        while (n2 < n) {
                            if (thread != threadArray[n2]) {
                                threadArray[n2].suspend();
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void unsetResourceManagerContext() {
        rm_contexts.remove(Thread.currentThread());
    }

    static {
        int n = Thread.currentThread().getPriority();
        AGLET_GROUPS.setMaxPriority(n - 1);
        rm_contexts = new Hashtable();
    }
}

