/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.system.Aglets;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.aglets.tahiti.Util;
import com.ibm.awb.misc.Resource;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;

final class RetractAgletDialog
extends TahitiDialog
implements ActionListener,
ItemListener,
Runnable {
    private static RetractAgletDialog _instance = null;
    private Choice _servers = new Choice();
    private List _agletsList = new List();
    private GridBagLayout grid = new GridBagLayout();
    String currentList = null;
    AgletProxy[] proxies = null;
    Thread handler = null;

    private RetractAgletDialog(MainWindow mainWindow) {
        super(mainWindow, "Retract", true);
        this.add("Center", this.makePanel());
        this.addButton("Retract", this);
        this.addCloseButton("Cancel");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this._agletsList.getSelectedIndex();
        if (n >= 0) {
            this.getMainWindow().retractAglet(this.proxies[n]);
        }
        this.dispose();
    }

    static RetractAgletDialog getInstance(MainWindow mainWindow) {
        if (_instance == null) {
            _instance = new RetractAgletDialog(mainWindow);
        }
        _instance.updateList();
        return _instance;
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        this.updateList();
    }

    protected GridBagPanel makePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagPanel.add((Component)new Label("Remote Aglets List"), 0);
        this._servers = new Choice();
        gridBagPanel.addLabeled("Select Server:", this._servers);
        this._servers.addItemListener(this);
        this._agletsList.addActionListener(this);
        this._agletsList.setBackground(Color.white);
        Util.setFixedFont(this._agletsList);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagPanel.add((Component)this._agletsList, gridBagConstraints);
        return gridBagPanel;
    }

    public void run() {
        String string = (String)this._servers.getSelectedObjects()[0];
        try {
            this.proxies = Aglets.getAgletProxies(string);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this._agletsList.removeAll();
        if (this.proxies == null) {
            return;
        }
        int n = 0;
        while (n < this.proxies.length) {
            try {
                AgletInfo agletInfo = this.proxies[n].getAgletInfo();
                this._agletsList.add(agletInfo.getAgletClassName() + " : " + agletInfo.getAgletID());
            }
            catch (InvalidAgletException invalidAgletException) {
                this._agletsList.add("InvalidAglet");
            }
            ++n;
        }
    }

    void updateChoice() {
        Resource resource = Resource.getResourceFor("aglets");
        String string = resource.getString("aglets.addressbook");
        if (string != null && !string.equals(this.currentList)) {
            this.currentList = string;
            this._servers.removeAll();
            this._servers.addItem("Select Server");
            String[] stringArray = resource.getStringArray("aglets.addressbook", " ");
            int n = 0;
            while (n < stringArray.length) {
                this._servers.addItem(stringArray[n]);
                ++n;
            }
        }
    }

    private void updateList() {
        this.updateChoice();
        if (this.handler != null) {
            this.handler.interrupt();
            this.handler.stop();
        }
        this.handler = new Thread(this);
        this.handler.start();
    }

    public boolean windowClosing(WindowEvent windowEvent) {
        return false;
    }
}

