/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.security.PolicyDB;
import com.ibm.aglets.security.PolicyFileReader;
import com.ibm.aglets.security.PolicyFileWriter;
import com.ibm.aglets.security.PolicyGrant;
import com.ibm.aglets.tahiti.BorderPanel;
import com.ibm.aglets.tahiti.Editor;
import com.ibm.aglets.tahiti.EditorPanel;
import com.ibm.aglets.tahiti.GrantEditPanel;
import com.ibm.aglets.tahiti.GrantEditor;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.SecurityConfigPanel;
import com.ibm.aglets.tahiti.ShutdownDialog;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.awb.misc.Resource;
import com.ibm.awb.misc.URIPattern;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class SecurityConfigDialog
extends TahitiDialog
implements ActionListener,
ItemListener {
    private static final String LABEL_TITLE = "Security Preferences";
    private static final String LABEL_OK = "OK";
    private static final String LABEL_CLOSE = "Close";
    private static final String LABEL_RELOAD = "Reload";
    private static final String LABEL_GRANT_PANEL = "Code Base";
    private static SecurityConfigDialog _instance = null;
    private PolicyDB _db = null;
    private List _grantList = new List(5, false);
    private GrantEditor _grantEditor = new GrantEditor();
    private GrantEditPanel _grantPanel = null;
    GridBagPanel _panel = new GridBagPanel();
    Panel setting_panel = new Panel();
    CardLayout layout = new CardLayout();
    Hashtable privileges = new Hashtable();

    private SecurityConfigDialog(MainWindow mainWindow) {
        super(mainWindow, LABEL_TITLE, true);
        this.loadPolicyFile();
        this.add("Center", this._panel);
        this.makePanel();
        this.addButton(LABEL_OK, this);
        this.addButton(LABEL_CLOSE, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (LABEL_OK.equals(string)) {
            this.save();
            ((Component)this).setVisible(false);
            ShutdownDialog shutdownDialog = new ShutdownDialog((MainWindow)this.getParent(), "To be effective, you need reboot the server.");
            shutdownDialog.popupAtCenterOfParent();
        } else if (LABEL_CLOSE.equals(string)) {
            ((Component)this).setVisible(false);
        }
    }

    private void addGrantPanel(PolicyGrant policyGrant) {
        this.addGrantPanel(SecurityConfigDialog.getGrantName(policyGrant), policyGrant);
    }

    public void addGrantPanel(String string) {
        this.addGrantPanel(string, null);
    }

    private void addGrantPanel(String string, PolicyGrant policyGrant) {
        if (!this.hasGrant(string)) {
            this._grantList.add(string);
            SecurityConfigPanel securityConfigPanel = new SecurityConfigPanel(string, policyGrant);
            this.privileges.put(string, securityConfigPanel);
            this.setting_panel.add(string, securityConfigPanel);
            securityConfigPanel.setupPanels();
        }
    }

    private static String getGrantName(PolicyGrant policyGrant) {
        URIPattern uRIPattern = policyGrant.getCodeBase();
        String string = policyGrant.getSignerNames();
        String string2 = policyGrant.getOwnerNames();
        boolean bl = uRIPattern != null;
        boolean bl2 = string != null && !string.equals("");
        boolean bl3 = string2 != null && !string2.equals("");
        Vector<String> vector = new Vector<String>();
        if (bl || bl2 || bl3) {
            vector.addElement(uRIPattern.toString());
        }
        if (bl2 || bl3) {
            vector.addElement(string);
        }
        if (bl3) {
            vector.addElement(string2);
        }
        return EditorPanel.toText(vector);
    }

    static SecurityConfigDialog getInstance(MainWindow mainWindow) {
        if (_instance == null) {
            _instance = new SecurityConfigDialog(mainWindow);
        }
        _instance.updateValues();
        return _instance;
    }

    private boolean hasGrant(PolicyGrant policyGrant) {
        return this.hasGrant(SecurityConfigDialog.getGrantName(policyGrant));
    }

    private boolean hasGrant(String string) {
        String[] stringArray = this._grantList.getItems();
        int n = 0;
        n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this._grantList.getSelectedItem();
        if (string != null) {
            this.showGrantPanel(string);
        }
    }

    private void loadPolicyFile() {
        String string = PolicyFileReader.getUserPolicyFilename();
        PolicyFileReader policyFileReader = new PolicyFileReader(string);
        this._db = policyFileReader.getPolicyDB();
    }

    void makePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this._panel.setConstraints(gridBagConstraints);
        BorderPanel borderPanel = new BorderPanel(LABEL_GRANT_PANEL);
        this._panel.add((Component)borderPanel, 1, 0.0);
        this.setupGrantPanel(borderPanel);
        gridBagConstraints.fill = 1;
        this._panel.add((Component)this.setting_panel, 0, 1.0);
        this.setting_panel.setLayout(this.layout);
        PolicyGrant policyGrant = null;
        Enumeration enumeration = this._db.getGrants();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof PolicyGrant)) continue;
            PolicyGrant policyGrant2 = (PolicyGrant)e;
            if (policyGrant == null) {
                policyGrant = policyGrant2;
            }
            this.addGrantPanel(policyGrant2);
        }
        this.showGrantPanel(policyGrant);
    }

    public void removeGrantPanel(int n, String string) {
        if (this.hasGrant(string)) {
            this._grantList.remove(n);
            Object v = this.privileges.get(string);
            if (v instanceof SecurityConfigPanel) {
                SecurityConfigPanel securityConfigPanel = (SecurityConfigPanel)v;
                this.privileges.remove(v);
                this.setting_panel.remove(securityConfigPanel);
            }
        }
    }

    public void save() {
        Serializable serializable;
        Object object;
        Object object2;
        String string;
        PolicyDB policyDB = new PolicyDB();
        int n = this._grantList.getItemCount();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            string = this._grantList.getItem(n2);
            object2 = GrantEditor.toGrant(string);
            object = this.privileges.get(string);
            if (object instanceof SecurityConfigPanel) {
                serializable = (SecurityConfigPanel)object;
                ((SecurityConfigPanel)serializable).addPermissions((PolicyGrant)object2);
            }
            policyDB.addGrant((PolicyGrant)object2);
            ++n2;
        }
        try {
            string = PolicyFileReader.getUserPolicyFilename();
            object2 = new File(string);
            if (((File)object2).exists()) {
                object = PolicyFileWriter.getBackupFilename(string);
                serializable = new File((String)object);
                try {
                    ((File)object2).renameTo((File)serializable);
                }
                catch (SecurityException securityException) {
                    System.err.println(securityException.toString());
                    return;
                }
            }
            PolicyFileWriter.writePolicyDB(string, policyDB);
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    void setupGrantPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.insets = borderPanel.topInsets();
        gridBagConstraints.insets.bottom = borderPanel.bottomInsets().bottom;
        borderPanel.setConstraints(gridBagConstraints);
        gridBagConstraints.weighty = 0.1;
        this._grantPanel = new GrantEditPanel(this, this._grantList, (Editor)this._grantEditor);
        borderPanel.add((Component)this._grantPanel, 0, 1.0);
        this._grantList.addItemListener(this);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        borderPanel.add((Component)this._grantEditor, 0, 0.1);
    }

    public void showGrantPanel(PolicyGrant policyGrant) {
        this.showGrantPanel(SecurityConfigDialog.getGrantName(policyGrant));
    }

    public void showGrantPanel(String string) {
        if (this._grantList.getSelectedIndex() < 0) {
            int n = 0;
            while (n < this._grantList.getItemCount()) {
                if (string.equals(this._grantList.getItem(n))) {
                    this._grantList.select(n);
                    break;
                }
                ++n;
            }
        }
        this.layout.show(this.setting_panel, string);
    }

    public void updateValues() {
        Resource resource = Resource.getResourceFor("aglets");
        Enumeration enumeration = this.privileges.elements();
        while (enumeration.hasMoreElements()) {
            ((SecurityConfigPanel)enumeration.nextElement()).updateValues();
        }
    }

    private void writePolicyFile() {
        String string = PolicyFileReader.getUserPolicyFilename();
        try {
            PolicyFileWriter.writePolicyDB(string, this._db);
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }
}

